/*  Motti -- a strategy game
    Copyright (C) 1999 Free Software Foundation

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
*/
#ifndef THREAD_H

#define THREAD_H 1

#ifdef HAVE_LIBX11
extern int global_argc;
extern char **global_argv;

#include "xinit.h"
#endif

#ifdef HAVE_LIBPTHREAD
union conn_info {
#ifdef HAVE_LIBX11
  struct x_info_struct *x_info;
#endif
};
extern union conn_info *global_conn_info;

enum conn_type {
  CONN_X, CONN_CURSES
};
extern enum conn_type *global_conn_type;
#endif

typedef void * thread_func(void *);

/* Number of connections.  */
extern int n_connect;
extern int n_x_connect;

/* Mask array with a bit set for each player playing on corresponding
   display.  */
extern int *connect_mask;

#ifdef HAVE_LIBX11
extern void * x_game_init (void *);
#endif
extern void create_threads (thread_func **, const char **);
#ifdef HAVE_LIBPTHREAD
extern void signal_end_game (const int);
extern void expose_map (const int, const int, const int, const int, const int);
extern void expose_turnwin (const int);
extern void expose_att_but (const int);
extern void get_read_lock (void);
extern void release_read_lock (void);
extern void get_write_lock (void);
extern void release_write_lock (void);
#endif	/* HAVE_LIBPTHREAD */

#endif /* _THREAD_H */
