/*  Motti -- a strategy game
    Copyright (C) 2000 Free Software Foundation

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef COMM_H

#define COMM_H

#ifdef HAVE_LIBX11
#include "xinit.h"
#include "xevent.h"
#endif
#if 0
#ifdef HAVE_LIBCURSES
#include "curses_if.h"
#endif
#endif

#include "map.h"
#include "occupy.h"

enum conn_type {
  CONN_NONE, CONN_X, CONN_CURSES
};

union conn_info {
  struct {
    enum conn_type type;
    int fd, conn_mask;
  } common;
#ifdef HAVE_LIBX11
  struct x_info_struct x_info;
#endif
};

extern int n_connect;

extern void signal_action (Action *act);
extern void signal_mapchange (Coord, Coord);
extern void signal_turnchange (void);
extern void signal_turnwinchange (void);
extern void signal_attackchange (void);

extern void connection_terminated (union conn_info *);

/* Let the fun begin.  */
extern void init_game (const enum conn_type *, const char **, const int *);

#endif		/* COMM_H */
