/*  Motti -- a strategy game
    Copyright (C) 1999-2014 Free Software Foundation

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#pragma once
#include "Case.h"
#include <list>
class MapGenerator
{
public:
	MapGenerator(void);
	~MapGenerator(void);
	
	Case * generateMap(std::list<std::string>,int width,int height);
	void setMessageBox(void (*message)(std::string title,std::string message)){
		writemessage=message;
	};
private:
	Case * generateMapIntern(std::list<std::string>,int width,int height,int smooth=1);

	bool isCaseAlone(Case * ,int width,int height);
	bool isCaseAloner(Case * ret,int width,int height,int x,int y,int noX=-1,int noY=-1);
	bool searchConnectecdPlayer(Case * ret,int nbPlayer,int width,int height);
	int countConnectecdPlayer(Case * ret,Player *a,int width,int height,int x,int y);

	void (*writemessage)(std::string title,std::string message) ;
};

