/*  Motti -- a strategy game
    Copyright (C) 1999-2014 Free Software Foundation

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "StdAfx.h"
#include "MottiRulesManagerTest.h"
#include "MottiRulesManager.h"
#include "MapManager.h"
#include <iostream>
MottiRulesManagerTest::MottiRulesManagerTest(void)
{
	std::cout << "-->MottiRulesManagerTest"<<std::endl;
}


MottiRulesManagerTest::~MottiRulesManagerTest(void)
{
}

int MottiRulesManagerTest::testInitGameForAplayer(){
	std::string myMap="width 32\n";
	myMap+="height 23\n";
	myMap+="warped 0\n";
	myMap+="players 3\n";
	myMap+="active_players 7\n";
	myMap+="remaining_players 7\n";
	myMap+="turn 1\n";
	myMap+="n_att 0\n";
	myMap+="  a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="    a a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="        a a a a a a a a a a a a a a a a a a a a a a   a a a a a \n";
	myMap+="        a a a a a a a a a a a a a a a a a a a   a     a a a a a \n";
	myMap+="        a a a a a a a a a a a a a a a a a a             a a a a \n";
	myMap+="        a a a a a a a a a a a a a a a a a a               b b b \n";
	myMap+="a a a a a a a a   a a     a a a a a a a a       b b       b b b \n";
	myMap+="a a a a a a         a a     a a a a a a   b b b b b b b b b b b \n";
	myMap+="a a a a a           a.a     a a a a a   b b b b b b.b b b b b b \n";
	myMap+="  a a a a             a a     a a a     b b b b b b b b b b b b \n";
	myMap+="  a a a a             a a a     a a       b b b b b b b b b b b \n";
	myMap+="    a               a a   a       a               b b b b b b b \n";
	myMap+="    c             a                                 b b b b b b \n";
	myMap+="  c c c           a a                               b b b b b b \n";
	myMap+="c c c c c c c c c                                   b b b b b b \n";
	myMap+="c c c c c c c c c               c c c               b b b b b b \n";
	myMap+="c c c c c c c c c c c.        c c c c c c       b b b b b b b b \n";
	myMap+="c c c c c c c c c c c c       c c c c c c c c b b b b b b b b b \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c b b   b b b b b b \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c   b   b b b b b b \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c       b b b b b b \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c c     b b b b b b \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c c       b b b b b ";

	MottiRulesManager  mottRuleMan;
	Board bBoard=MapManager::loadStringMap(myMap);


	mottRuleMan.setBoard(&bBoard);

	mottRuleMan.initGame();

	Player *playe=mottRuleMan.getActualPlayer();

	if (playe==NULL)
	{
		std::cout << "ERROR : player not good "<<playe<<std::endl;
		return 1;
		
	}else if (playe->getName()!="a"){
		std::cout << "ERROR : player not good "<<playe->getName()<<std::endl;
		return 1;
	}
	else
	{
		std::cout << "OK : testInitGameForAplayer"<<std::endl;
		return 0;
	}



}

int MottiRulesManagerTest::testActionOneAttack(){
	std::string myMap="width 5\n";
	myMap+="height 5\n";
	myMap+="warped 0\n";
	myMap+="players 3\n";
	myMap+="active_players 7\n";
	myMap+="remaining_players 7\n";
	myMap+="turn 1\n";
	myMap+="n_att 0\n";
	myMap+="a a a.a a \n"; 
	myMap+="a a a a a \n";
	myMap+="a a a b b \n";
	myMap+="b b b b b \n";
	myMap+="b b b. b b ";

	MottiRulesManager  mottRuleMan;
	Board bBoard=MapManager::loadStringMap(myMap);


	mottRuleMan.setBoard(&bBoard);

	mottRuleMan.initGame();

	Player *playe=mottRuleMan.getActualPlayer();

	mottRuleMan.attack(0,2);
	mottRuleMan.attack(1,2);
	mottRuleMan.attack(1,3);
	mottRuleMan.unattack(1,2);

	mottRuleMan.getBoard()->getCaseNoThrow(3,1)->setCaseType(Case::LOCKED);
	mottRuleMan.attack(3,2);
	mottRuleMan.attack(0,4);
	mottRuleMan.attack(4,2);
	mottRuleMan.unattack(4,2);


	if (playe==NULL)
	{
		std::cout << "ERROR : player not good "<<playe<<std::endl;
		return 1;
		
	}else if (playe->getName()!="a"){
		std::cout << "ERROR : player not good "<<playe->getName()<<std::endl;
		return 1;
	}
	else if (mottRuleMan.getBoard()->getNbCoutRestant()!=4){
		std::cout << "ERROR : NBCoup restant insuffisant "<<mottRuleMan.getBoard()->getNbCoutRestant()<<std::endl;
		return 1;
	}
	else if (mottRuleMan.getBoard()->getCaseNoThrow(0,2)->getType()!=Case::SELECTED){
		std::cout << "ERROR : Case not selected "<<std::endl;
		return 1;
	}
	else if (mottRuleMan.getBoard()->getCaseNoThrow(1,2)->getType()!=Case::FREE){
		std::cout << "ERROR : Case not free "<<std::endl;
		return 1;
	}
	else if (mottRuleMan.getBoard()->getCaseNoThrow(1,3)->getType()!=Case::FREE){
		std::cout << "ERROR : Case not free "<<std::endl;
		return 1;
	}
	else if (mottRuleMan.getBoard()->getCaseNoThrow(3,2)->getType()!=Case::SELECTED){
		std::cout << "ERROR : Case not selected "<<std::endl;
		return 1;
	}
	else if (mottRuleMan.getBoard()->getCaseNoThrow(4,2)->getPlayer()->getName()==mottRuleMan.getBoard()->getActualPlayer()->getName()){
		std::cout << "ERROR : bad player selected 4,2 : "<<mottRuleMan.getBoard()->getCaseNoThrow(4,2)->getPlayer()->getName()<<std::endl;
		return 1;
	}
	else if (mottRuleMan.getBoard()->getCaseNoThrow(4,2)->getType()!=Case::FREE){
		std::cout << "ERROR : Case not free 4,2 "<<std::endl;
		return 1;
	}
	else if (mottRuleMan.getBoard()->getCaseNoThrow(3,2)->getPlayer()->getName()!=mottRuleMan.getBoard()->getActualPlayer()->getName()){
		std::cout << "ERROR : bad player selected "<<std::endl;
		return 1;
	}
	else if (mottRuleMan.getBoard()->getCaseNoThrow(0,4)->getType()!=Case::FREE){
		std::cout << "ERROR : Case not free "<<std::endl;
		return 1;
	}
	else
	{
		std::cout << "OK : testActionOneAttack"<<std::endl;
		return 0;
	}



}


int MottiRulesManagerTest::testAttackInTacking2Cases(){
	std::string myMap="width 5\n";
	myMap+="height 5\n";
	myMap+="warped 0\n";
	myMap+="players 3\n";
	myMap+="active_players 7\n";
	myMap+="remaining_players 7\n";
	myMap+="turn 1\n";
	myMap+="n_att 0\n";
	myMap+="a a a.a a \n"; 
	myMap+="a a b a a \n";
	myMap+="a a b a b \n";
	myMap+="b a b a b \n";
	myMap+="b a a a b.";

	MottiRulesManager  mottRuleMan;
	Board bBoard=MapManager::loadStringMap(myMap);


	mottRuleMan.setBoard(&bBoard);

	mottRuleMan.initGame();

	Player *playe=mottRuleMan.getActualPlayer();
	mottRuleMan.getBoard()->setNbCoutRestant(12);
	mottRuleMan.getBoard()->setNbCoupperTurnAttack(13);
	mottRuleMan.getBoard()->getCaseNoThrow(0,2)->setCaseType(Case::LOCKED);
	mottRuleMan.attack(1,0);
	mottRuleMan.attack(1,1);
	mottRuleMan.attack(1,2);
	mottRuleMan.attack(1,3);
	mottRuleMan.attack(1,4);
	mottRuleMan.attack(2,4);
	mottRuleMan.attack(2,0);
	mottRuleMan.attack(3,0);
	mottRuleMan.attack(3,1);
	mottRuleMan.attack(3,2);
	mottRuleMan.attack(3,3);
	mottRuleMan.attack(3,4);
	mottRuleMan.attack(0,3);
	mottRuleMan.getRandomGenerator().setIsFake(true);
	mottRuleMan.getRandomGenerator().setBool(true);
	mottRuleMan.endTurn();
	//std::cout <<mottRuleMan.getBoard()->toString()<<std::endl;
	

	if (playe==NULL)
	{
		std::cout << "ERROR : player not good "<<playe<<std::endl;
		return 1;
		
	}else if (playe->getName()!="a"){
		std::cout << "ERROR : player not good "<<playe->getName()<<std::endl;
		return 1;
	}
	else if (mottRuleMan.getBoard()->getCaseNoThrow(2,2)->getPlayer()->getName()!="a"){
		std::cout << "ERROR : Player 2,2 not chenged "<< mottRuleMan.getBoard()->getCaseNoThrow(2,2)->getPlayer()->getName()<< std::endl;
		return 1;
	}
	else if (mottRuleMan.getBoard()->getCaseNoThrow(2,3)->getPlayer()->getName()!="a"){
		std::cout << "ERROR : Player 2,3 not chenged "<< mottRuleMan.getBoard()->getCaseNoThrow(2,2)->getPlayer()->getName()<< std::endl;
		return 1;
	}
	else if (mottRuleMan.getBoard()->getNbCoutRestant()!=0){
		std::cout << "ERROR : NBCoup restant insuffisant "<<mottRuleMan.getBoard()->getNbCoutRestant()<<std::endl;
		//std::cout << mottRuleMan.getBoard()->toString()<<std::endl;
		return 1;
	}
	
	else
	{
		std::cout << "OK : testAttackInTackingACase"<<std::endl;
		return 0;
	}



}

int MottiRulesManagerTest::testChangeActionMode(){
	std::string myMap="width 5\n";
	myMap+="height 5\n";
	myMap+="warped 0\n";
	myMap+="players 3\n";
	myMap+="active_players 7\n";
	myMap+="remaining_players 7\n";
	myMap+="turn 1\n";
	myMap+="n_att 0\n";
	myMap+="a a a.a a \n"; 
	myMap+="a a   a a \n";
	myMap+="a a b a b \n";
	myMap+="b a b a b \n";
	myMap+="b a a a b.";

	MottiRulesManager  mottRuleMan;
	Board bBoard=MapManager::loadStringMap(myMap);


	mottRuleMan.setBoard(&bBoard);

	mottRuleMan.initGame();

	Player *playe=mottRuleMan.getActualPlayer();
	bool noerrorDet=true;
	mottRuleMan.attack(1,0);
	mottRuleMan.defend(1,0);
	if (mottRuleMan.getBoard()->getActionMode()!=Board::ATTACK){
		std::cout << "ERROR : Bad Action mode normally ATTACK "<< mottRuleMan.getBoard()->getActionMode()<<std::endl;
		noerrorDet=false;
	}
	mottRuleMan.unattack(1,0);
	if (mottRuleMan.getBoard()->getActionMode()!=Board::NOTCHOOSE){
		std::cout << "ERROR : Bad Action mode normally NOTCHOOSE "<< mottRuleMan.getBoard()->getActionMode()<<std::endl;
		std::cout << "NBATTACK "<< mottRuleMan.getBoard()->getNbCoupperTurnAttack()<<std::endl;
		std::cout << "COUPREST "<< mottRuleMan.getBoard()->getNbCoutRestant()<<std::endl;
		noerrorDet=false;
	}
	mottRuleMan.defend(1,0);
	mottRuleMan.guerilla(1,0);
	if (mottRuleMan.getBoard()->getActionMode()!=Board::DEFEND){
		std::cout << "ERROR : Bad Action mode normally DEFEND "<< mottRuleMan.getBoard()->getActionMode()<<std::endl;
		noerrorDet=false;
	}
	mottRuleMan.undefend(1,0);
	if (mottRuleMan.getBoard()->getActionMode()!=Board::NOTCHOOSE){
		std::cout << "ERROR : Bad Action mode normally NOTCHOOSE "<< mottRuleMan.getBoard()->getActionMode()<<std::endl;
		noerrorDet=false;
	}
	mottRuleMan.guerilla(1,0);
	if (mottRuleMan.getBoard()->getActionMode()!=Board::GUERILLA){
		std::cout << "ERROR : Bad Action mode normally GUERILLA "<< mottRuleMan.getBoard()->getActionMode()<<std::endl;
		noerrorDet=false;
	}

	if (noerrorDet)
	{
		std::cout << "OK : testChangeActionMode"<<std::endl;
		return 0;
	}
	else 
	return 1;

}

int MottiRulesManagerTest::testDefend10Nodes()
{
	std::string myMap="width 5\n";
	myMap+="height 5\n";
	myMap+="warped 0\n";
	myMap+="players 3\n";
	myMap+="active_players 7\n";
	myMap+="remaining_players 7\n";
	myMap+="turn 1\n";
	myMap+="n_att 0\n";
	myMap+="a a a.a a \n"; 
	myMap+="a a   a a \n";
	myMap+="a a b a b \n";
	myMap+="b a b a b \n";
	myMap+="b a a a b.";

	MottiRulesManager  mottRuleMan;
	Board bBoard=MapManager::loadStringMap(myMap);


	mottRuleMan.setBoard(&bBoard);

	mottRuleMan.initGame();

	Player *playe=mottRuleMan.getActualPlayer();
	bool noerrorDet=true;
	mottRuleMan.getBoard()->setNbCoupperTurnDefend(12);
	mottRuleMan.defend(0,0);
	mottRuleMan.defend(1,0);
	mottRuleMan.defend(2,0);
	mottRuleMan.defend(3,0);
	mottRuleMan.defend(4,0);
	mottRuleMan.defend(0,1);
	mottRuleMan.defend(1,1);
	mottRuleMan.defend(2,1);
	mottRuleMan.defend(3,1);
	mottRuleMan.defend(4,1);
	mottRuleMan.defend(0,2);
	mottRuleMan.defend(0,3);
	mottRuleMan.endTurn();

	
	if ( mottRuleMan.getBoard()->getCaseNoThrow(0,0)->getType()!=Case::LOCKED){
		std::cout << "ERROR : Case (0,0) not locked "<<std::endl;
		noerrorDet=false;
	}
	if ( mottRuleMan.getBoard()->getCaseNoThrow(1,0)->getType()!=Case::LOCKED){
		std::cout << "ERROR : Case (1,0) not locked "<<std::endl;
		noerrorDet=false;
	}
	if ( mottRuleMan.getBoard()->getCaseNoThrow(2,0)->getType()!=Case::LOCKED){
		std::cout << "ERROR : Case (2,0) not locked "<<std::endl;
		noerrorDet=false;
	}
	if ( mottRuleMan.getBoard()->getCaseNoThrow(3,0)->getType()!=Case::LOCKED){
		std::cout << "ERROR : Case (3,0) not locked "<<std::endl;
		noerrorDet=false;
	}
	if ( mottRuleMan.getBoard()->getCaseNoThrow(4,0)->getType()!=Case::LOCKED){
		std::cout << "ERROR : Case (4,0) not locked "<<std::endl;
		noerrorDet=false;
	}
	if ( mottRuleMan.getBoard()->getCaseNoThrow(0,1)->getType()!=Case::LOCKED){
		std::cout << "ERROR : Case (0,1) not locked "<<std::endl;
		noerrorDet=false;
	}
	if ( mottRuleMan.getBoard()->getCaseNoThrow(1,1)->getType()!=Case::LOCKED){
		std::cout << "ERROR : Case (1,1) not locked "<<std::endl;
		noerrorDet=false;
	}
	if ( mottRuleMan.getBoard()->getCaseNoThrow(2,1)->getType()!=Case::NOTUSED){
		std::cout << "ERROR : Case (2,1) not not used "<<std::endl;
		noerrorDet=false;
	}
	if ( mottRuleMan.getBoard()->getCaseNoThrow(3,1)->getType()!=Case::LOCKED){
		std::cout << "ERROR : Case (3,1) not locked "<<std::endl;
		noerrorDet=false;
	}
	if ( mottRuleMan.getBoard()->getCaseNoThrow(4,1)->getType()!=Case::LOCKED){
		std::cout << "ERROR : Case (4,1) not locked "<<std::endl;
		noerrorDet=false;
	}
	if ( mottRuleMan.getBoard()->getCaseNoThrow(0,2)->getType()!=Case::LOCKED){
		std::cout << "ERROR : Case (0,2) not locked "<<std::endl;
		noerrorDet=false;
	}
	if ( mottRuleMan.getBoard()->getCaseNoThrow(0,3)->getType()!=Case::FREE){
		std::cout << "ERROR : Case (0,3) not free "<<std::endl;
		noerrorDet=false;
	}

	if (noerrorDet)
	{
		std::cout << "OK : testDefend10Nodes"<<std::endl;
		return 0;
	}
	else
	return 1;

}

int MottiRulesManagerTest::testGuerilla(){
	std::string myMap="width 5\n";
	myMap+="height 5\n";
	myMap+="warped 0\n";
	myMap+="players 3\n";
	myMap+="active_players 7\n";
	myMap+="remaining_players 7\n";
	myMap+="turn 1\n";
	myMap+="n_att 0\n";
	myMap+="a a a.a a \n"; 
	myMap+="a a   a a \n";
	myMap+="a a b a b \n";
	myMap+="b a b a b \n";
	myMap+="b a a a b.";

	MottiRulesManager  mottRuleMan;
	Board bBoard=MapManager::loadStringMap(myMap);


	mottRuleMan.setBoard(&bBoard);

	mottRuleMan.initGame();

	Player *playe=mottRuleMan.getActualPlayer();
	bool noerrorDet=true;
	mottRuleMan.getBoard()->getCaseNoThrow(1,2)->setCaseType(Case::LOCKED);
	mottRuleMan.guerilla(2,2);
	
	mottRuleMan.endTurn();
	if ( mottRuleMan.getBoard()->getCaseNoThrow(2,2)->getType()!=Case::LOCKED){
		std::cout << "ERROR : Case (2,2) not locked "<<std::endl;
		
		noerrorDet=false;
	}
	if ( mottRuleMan.getBoard()->getCaseNoThrow(2,2)->getPlayer()->getName()!="a"){
		std::cout << "ERROR : Case (2,2) bad player  "<<mottRuleMan.getBoard()->getCaseNoThrow(2,2)->getPlayer()->getName()<<std::endl;
		noerrorDet=false;
	}

	if (noerrorDet)
	{
		std::cout << "OK : testGuerilla"<<std::endl;
		return 0;
	}
	else
	return 1;
}

int MottiRulesManagerTest::testWinner(){
	std::string myMap="width 5\n";
	myMap+="height 5\n";
	myMap+="warped 0\n";
	myMap+="players 3\n";
	myMap+="active_players 7\n";
	myMap+="remaining_players 7\n";
	myMap+="turn 1\n";
	myMap+="n_att 0\n";
	myMap+="a a a.a a \n"; 
	myMap+="a a   a a \n";
	myMap+="a a b a b \n";
	myMap+="b a b a a \n";
	myMap+="b a a a b.";

	MottiRulesManager  mottRuleMan;
	Board bBoard=MapManager::loadStringMap(myMap);


	mottRuleMan.setBoard(&bBoard);

	mottRuleMan.initGame();

	Player *playe=mottRuleMan.getActualPlayer();
	bool noerrorDet=true;
	mottRuleMan.getBoard()->getCaseNoThrow(3,3)->setCaseType(Case::LOCKED);
	mottRuleMan.getBoard()->getCaseNoThrow(4,3)->setCaseType(Case::LOCKED);
	mottRuleMan.getBoard()->getCaseNoThrow(3,4)->setCaseType(Case::LOCKED);
	mottRuleMan.guerilla(4,4);
	
	mottRuleMan.endTurn();
	if ( mottRuleMan.getBoard()->getWinner()==NULL){
		std::cout << "ERROR : Winner not found "<<std::endl;
		
		noerrorDet=false;
	}
	
	if (noerrorDet)
	{
		std::cout << "OK : testWinner"<<std::endl;
		return 0;
	}
	else
	return 1;
}

int MottiRulesManagerTest::testBug1(){
	std::string myMap="width 5\n";
	myMap+="height 5\n";
	myMap+="warped 0\n";
	myMap+="players 3\n";
	myMap+="active_players 7\n";
	myMap+="remaining_players 7\n";
	myMap+="turn 1\n";
	myMap+="n_att 0\n";
	myMap+="a a a.a a \n"; 
	myMap+="a a   a a \n";
	myMap+="a a b a b \n";
	myMap+="b a b a a \n";
	myMap+="b a a a b.";

	MottiRulesManager  mottRuleMan;
	Board bBoard=MapManager::loadStringMap(myMap);


	mottRuleMan.setBoard(&bBoard);

	mottRuleMan.initGame();

	Player *playe=mottRuleMan.getActualPlayer();
	bool noerrorDet=true;
	mottRuleMan.getBoard()->getCaseNoThrow(3,3)->setCaseType(Case::LOCKED);
	mottRuleMan.getBoard()->getCaseNoThrow(4,3)->setCaseType(Case::LOCKED);
	mottRuleMan.getBoard()->getCaseNoThrow(3,4)->setCaseType(Case::LOCKED);
	//mottRuleMan.attack(4,4);
	
	mottRuleMan.endTurn();
	if ( mottRuleMan.getBoard()->getWinner()!=NULL){
		std::cout << "ERROR : Winner  found "<<std::endl;
		
		noerrorDet=false;
	}
	
	if (noerrorDet)
	{
		std::cout << "OK : testWinner"<<std::endl;
		return 0;
	}
	else
	return 1;
}