/* mpfr_set_flt -- convert a machine single precision float to mpfr_t

Copyright 2009, 2010, 2011 Free Software Foundation, Inc.
Contributed by the Arenaire and Caramel projects, INRIA.

This file is part of the GNU MPFR Library.

The GNU MPFR Library is free software; you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation; either version 3 of the License, or (at your
option) any later version.

The GNU MPFR Library is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
License for more details.

You should have received a copy of the GNU Lesser General Public License
along with the GNU MPFR Library; see the file COPYING.LESSER.  If not, see
http://www.gnu.org/licenses/ or write to the Free Software Foundation, Inc.,
51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA. */

#include "mpfr-impl.h"

int
mpfr_set_flt (mpfr_ptr r, float f, mpfr_rnd_t rnd_mode)
{
  /* we convert f to double precision and use mpfr_set_d;
     NaN and infinities should be preserved, and all single precision
     numbers are exactly representable in the double format, thus the
     conversion is always exact */
  return mpfr_set_d (r, (double) f, rnd_mode);
}

