#!/usr/local/bin/perl
#  duration statistics for telnet portions of CAPA
#  Copyright (C) 1992-2000 Michigan State University
#
#  The CAPA system is free software; you can redistribute it and/or
#  modify it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 2 of the
#  License, or (at your option) any later version.
#
#  The CAPA system is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with the CAPA system; see the file COPYING.  If not,
#  write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
#  Boston, MA 02111-1307, USA.
#
#  As a special exception, you have permission to link this program
#  with the TtH/TtM library and distribute executables, as long as you
#  follow the requirements of the GNU GPL in regard to all of the
#  software in the executable aside from TtH/TtM.


 require('getopts.pl');
 
 sub  S_Enterpath {
    local($notdone,$path);
    
    $notdone = 1;
    while ($notdone) {
      print "Please enter the CLASS absolute path:\n";
      $path = <>; chomp($path);
      if( $path =~ /\/$/ ) {
        $Rfullpath = "$path" . "records";
        $Dfullpath = "$path" . "records/duration.db";
       
      } else {
        $Rfullpath = "$path" . "/records";
        $Dfullpath = "$path" . "/records/duration.db";
        
      }
      if( -d $path ) {
        if( -d $Rfullpath ) {
          if( -f $Dfullpath ) {
            $notdone = 0;
          } else {
            print "File [$Dfullpath] does not exist!\n";
          }
        } else {
          print "Directory [$Rfullpath] does not exist!\n";
        }
      } else {
        print "Directory [$path] does not exist!\n";
      }
    
    }
    return ($path);
  }
  
  sub S_ScanDB  {
    local($filename)=@_;
    local($line_cnt)=0;
    local($s_num,$tty,$b_date,$e_date);
    local($hr,$mm,$ss,$ss_cnt);
    local($i, $j, @S_cnt);
    local($ylow, $yavg, $yhigh);
    open(IN, "<$filename") || die "Cannot open $filename file!";
    open(OUT, ">$Out_file") || die "Cannot open $Out_file file!";
    $min_sec = 1000;
    while (<IN>) {
      $line_cnt++;
      chomp();
      ($s_num,$tty,$b_date,$e_date) = split(/\t/);
      if( $line_cnt == 1 ) {
        $start_time = $b_date;
      }
      ($hr,$mm,$ss,$ylow)  = S_DiffDate($start_time,$b_date);
      ($hr,$mm,$ss,$yhigh) = S_DiffDate($start_time,$e_date);
      $yavg = ($ylow + $yhigh) / 2;
      $ss_cnt = $yhigh - $ylow;
      $min_sec = ($min_sec < $ss_cnt ?  $min_sec : $ss_cnt);
      $s_idx = int($ss_cnt / 100);
      $S_cnt[$s_idx]++;
      print OUT "$line_cnt\t$yavg\t$ylow\t$yhigh\n";
      # print "$s_num,($hr:$mm:$ss,$ss_cnt)\n";

     }
     close(IN) || die "Cannot close $filename file!";
     close(OUT) || die "Cannot close $Out_file file!";
     
     print "minimal number of seconds = $min_sec\n";
     for($i=0;$i<=$#S_cnt;$i++) {
       $j= $i * 100;
       print "$j\t$S_cnt[$i]\n" if $S_cnt[$i] > 0;
     }
     print "minimal number of seconds = $min_sec\n";
  }
  ## 012345678901
  ## Wed Jan  8 14:38:06 1997
  ## Fri Jan 17 00:34:30 1997,Fri Jan 17 00:36:25 1997
  %Mon = ( 'Jan' => 0, 'Feb' => 1, 'Mar' => 2, 'Apr' => 3,  'May' => 4,  'Jun' => 5, 
           'Jul' => 6, 'Aug' => 7, 'Sep' => 8, 'Oct' => 9,  'Nov' => 10, 'Dec' => 11 );
  @mdoy = ( 0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334, 365);
  
  sub  S_DiffDate  {
    local($a_str,$b_str)=@_;
    local($hrmmss_astr,$hrmmss_bstr);
    local($modd_astr,$modd_bstr);
    local($mo_a,$dd_a,$hr_a,$mm_a,$ss_a);
    local($mo_b,$dd_b,$hr_b,$mm_b,$ss_b);
    local($sec_cnt);
    local($dsec,$dmm,$dmm_cnt,$dhr_cnt);
    
    $modd_astr = substr($a_str,4,6);
    $hrmmss_astr = substr($a_str,11,8);
    $modd_bstr = substr($b_str,4,6);
    $hrmmss_bstr = substr($b_str,11,8);
    $mo_a = substr($modd_astr,0,3); $dd_a = substr($modd_astr,4,2);
    $mo_b = substr($modd_bstr,0,3); $dd_b = substr($modd_bstr,4,2);
    ($hr_a,$mm_a,$ss_a) = split(/:/, $hrmmss_astr);
    ($hr_b,$mm_b,$ss_b) = split(/:/, $hrmmss_bstr);
    $adoy = $mdoy[$Mon{$mo_a}] + $dd_a;
    $bdoy = $mdoy[$Mon{$mo_b}] + $dd_b;
    $sec_cnt = ($bdoy - $adoy)*24*60*60 + ($hr_b - $hr_a)*60*60 + ($mm_b - $mm_a)*60 + ($ss_b-$ss_a);
    $dsec = $sec_cnt % 60;
    $dmm_cnt = ($sec_cnt - $dsec) / 60;
    $dmm = $dmm_cnt % 60;
    $dhr_cnt = ($dmm_cnt - $dmm) / 60;
    
    return ($dhr_cnt,$dmm,$dsec,$sec_cnt);
  }
  
  
  $Out_file = '/usr/user1/capadvt/CAPA_SRC/4.5/pProj/dur.out';
  
  
  S_Enterpath();
  
  S_ScanDB("$Dfullpath");
