## Copyright (C) 2008 Sylvain Pelissier <sylvain.pelissier@gmail.com>
##
## This program is free software; you can redistribute it and/or modify it under
## the terms of the GNU General Public License as published by the Free Software
## Foundation; either version 3 of the License, or (at your option) any later
## version.
##
## This program is distributed in the hope that it will be useful, but WITHOUT
## ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
## FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
## details.
##
## You should have received a copy of the GNU General Public License along with
## this program; if not, see <http://www.gnu.org/licenses/>.

## -*- texinfo -*-
## @deftypefn {Function File} {@var{y} =} wrev (@var{x})
## Reverse the order of the element of the vector @var{x}.
## @seealso{flipud, fliplr}
## @end deftypefn

function y = wrev(x)

  if (nargin < 1|| nargin > 1); print_usage; endif
  if(~isvector(x))
    error('x must be a vector');
  endif
  l = length(x);
  k = 0:l-1;
  y = x(l-k);

endfunction
