# See supported GPUs on Wikipedia
# https://en.wikipedia.org/wiki/CUDA#GPUs_supported

# Initial set based on CUDA 7.0.
set(CMAKE_CUDA_ARCHITECTURES_ALL 20 21 30 35 37 50 52 53)
set(CMAKE_CUDA_ARCHITECTURES_ALL_MAJOR 20 30 35 50)

if(CMAKE_CUDA_COMPILER_TOOLKIT_VERSION VERSION_GREATER_EQUAL 8.0)
  list(APPEND CMAKE_CUDA_ARCHITECTURES_ALL 60 61 62)
  list(APPEND CMAKE_CUDA_ARCHITECTURES_ALL_MAJOR 60)
endif()

if(CMAKE_CUDA_COMPILER_TOOLKIT_VERSION VERSION_GREATER_EQUAL 9.0)
  if(NOT CMAKE_CUDA_COMPILER_ID STREQUAL "Clang" OR CMAKE_CUDA_COMPILER_VERSION VERSION_GREATER_EQUAL 6.0)
    list(APPEND CMAKE_CUDA_ARCHITECTURES_ALL 70 72)
    list(APPEND CMAKE_CUDA_ARCHITECTURES_ALL_MAJOR 70)
  endif()

  list(REMOVE_ITEM CMAKE_CUDA_ARCHITECTURES_ALL 20 21)
  list(REMOVE_ITEM CMAKE_CUDA_ARCHITECTURES_ALL_MAJOR 20 21)
endif()

if(CMAKE_CUDA_COMPILER_TOOLKIT_VERSION VERSION_GREATER_EQUAL 10.0
   AND (NOT CMAKE_CUDA_COMPILER_ID STREQUAL "Clang" OR CMAKE_CUDA_COMPILER_VERSION VERSION_GREATER_EQUAL 8.0))
  list(APPEND CMAKE_CUDA_ARCHITECTURES_ALL 75)
endif()

if(CMAKE_CUDA_COMPILER_TOOLKIT_VERSION VERSION_GREATER_EQUAL 11.0)
  if(NOT CMAKE_CUDA_COMPILER_ID STREQUAL "Clang" OR CMAKE_CUDA_COMPILER_VERSION VERSION_GREATER_EQUAL 11.0)
    list(APPEND CMAKE_CUDA_ARCHITECTURES_ALL 80)
    list(APPEND CMAKE_CUDA_ARCHITECTURES_ALL_MAJOR 80)
  endif()

  list(REMOVE_ITEM CMAKE_CUDA_ARCHITECTURES_ALL 30)
  list(REMOVE_ITEM CMAKE_CUDA_ARCHITECTURES_ALL_MAJOR 30)
endif()

if(CMAKE_CUDA_COMPILER_TOOLKIT_VERSION VERSION_GREATER_EQUAL 11.1
   AND (NOT CMAKE_CUDA_COMPILER_ID STREQUAL "Clang" OR CMAKE_CUDA_COMPILER_VERSION VERSION_GREATER_EQUAL 13.0))
  list(APPEND CMAKE_CUDA_ARCHITECTURES_ALL 86)
endif()

if(CMAKE_CUDA_COMPILER_TOOLKIT_VERSION VERSION_GREATER_EQUAL 11.4
   AND (NOT CMAKE_CUDA_COMPILER_ID STREQUAL "Clang"))
  list(APPEND CMAKE_CUDA_ARCHITECTURES_ALL 87)
endif()
