#!/bin/sh

# This program tests that the QR decomposition used by the REGRESSION command works.

TEMPDIR=/tmp/pspp-tst-$$
TESTFILE=$TEMPDIR/`basename $0`.sps

# ensure that top_builddir  are absolute
if [ -z "$top_builddir" ] ; then top_builddir=. ; fi
if [ -z "$top_srcdir" ] ; then top_srcdir=. ; fi
top_builddir=`cd $top_builddir; pwd`
PSPP=$top_builddir/src/ui/terminal/pspp

# ensure that top_srcdir is absolute
top_srcdir=`cd $top_srcdir; pwd`

STAT_CONFIG_PATH=$top_srcdir/config
export STAT_CONFIG_PATH


cleanup()
{
    if [ x"$PSPP_TEST_NO_CLEANUP" != x ] ; then 
	echo Not cleaning $TEMPDIR;
	return ; 
    fi
    cd /
    rm -rf $TEMPDIR
}


fail()
{
    echo $activity
    echo FAILED
    cleanup;
    exit 1;
}


no_result()
{
    echo $activity
    echo NO RESULT;
    cleanup;
    exit 2;
}

pass()
{
    cleanup;
    exit 0;
}

mkdir -p $TEMPDIR

cd $TEMPDIR

activity="create program"
cat > $TESTFILE <<EOF
data list list / v0 to v1.
begin data
-12.84099361 0.873270778
 16.64932538 0.371315664
 -1.88061907 0.505503722
 -6.20952354 0.734698282
  0.33272576 0.891224610
 -5.54912717 0.052318165
  6.11832417 0.448853404
 11.78124974 0.470447593
  0.75960353 0.565082303
  6.06432768 0.149316743
 -2.64919436 0.752532411
-10.32250712 0.798263603
  2.06355038 0.469129797
 -9.71851742 0.927162270
  4.65582553 0.250629262
  9.54574474 0.847032310
  7.35544368 0.197028541
 -2.09609740 0.400584261
 10.30101161 0.671546480
 -5.24501039 0.929962876
  1.73412473 0.758161354
 -3.12732732 0.569785505
 12.66261501 0.630640223
 -2.90956805 0.576067804
  4.89649177 0.624483995
 13.64613114 0.591089881
 14.03198397 0.544587572
  2.23566810 0.967898139
  5.37367760 0.916246929
  9.01346888 0.451702743
  0.75378683 0.235544137
 -3.47470624 0.742668194
 -1.02063266 0.860311687
 -2.67132813 0.082460702
 23.67661680 0.932553932
  7.95061359 0.430161125
  2.05300558 0.066331375
 -2.01332644 0.163705417
 20.00663784 0.587292630
  3.06099417 0.161411889
 -3.46115358 0.216684625
 -6.85287183 0.548714855
 -4.27923809 0.630997663
 -0.94863395 0.880612945
  4.47481747 0.359885215
-12.80962955 0.886070341
  9.35753086 0.187176558
  2.81002235 0.063035095
  0.01532424 0.964327101
  0.29867732 0.866408063
 -2.89035649 0.812135868
  4.17352811 0.608884061
 18.15502183 0.920568258
 -2.92662792 0.550792959
 -6.08090449 0.965036595
 -1.09135397 0.862548019
  7.02816784 0.042277017
-21.20245068 0.430673493
 -8.83397584 0.724976162
 -0.89055843 0.017934904
  7.03871587 0.308829557
  3.84286316 0.685105924
  4.50280692 0.447635420
 11.39207346 0.875177896
 10.86673874 0.518530912
  7.09853081 0.588367569
-12.82864915 0.184667098
 13.74888760 0.610891139
  0.37379146 0.557720134
 -9.79020267 0.942839981
  0.71574466 0.564570338
-17.56040637 0.182061777
  2.52620466 0.306875011
  5.37718673 0.366807049
 -1.83964300 0.465772898
  6.04848363 0.644501799
  4.57402403 0.121419591
  8.55606848 0.373011464
 -8.46827907 0.491176571
 -1.77989798 0.734722847
 -0.68661121 0.540984182
  1.55798880 0.822587656
  5.22810831 0.333747878
  9.50280477 0.068100934
 -3.74521465 0.248537644
  1.36045068 0.851827791
  4.41604088 0.197207162
 -3.72568327 0.726916693
 -5.36123334 0.906513529
  3.61594583 0.414340595
-10.01952852 0.140372658
 25.48681482 0.354309660
 -3.34529093 0.090075388
-18.00437582 0.461438059
 -5.29782460 0.004362856
  2.79608522 0.861294398
 -1.64076209 0.345775481
  6.82802334 0.137933862
 -0.45416818 0.404379208
 -1.66868582 0.797685201
-10.02820292 0.075876582
  5.68232031 0.404815042
  8.25113850 0.769173748
 -2.83544237 0.076583474
  0.87659945 0.092751009
  6.60270870 0.530444351
-12.63924989 0.362099960
 -6.24451253 0.641993458
  3.53339015 0.461991892
 -0.74012232 0.437409755
 15.37311996 0.974913038
 -8.09464797 0.543308711
 -9.61320222 0.221564578
  0.21843662 0.856512540
 -1.56958954 0.610709221
  6.44977372 0.200382138
-13.29136274 0.093222309
  6.46257214 0.024135196
 -3.82727990 0.601335801
  0.43081953 0.268230667
 19.06654416 0.219972815
 17.02906651 0.996849502
-10.18073139 0.012543080
 12.72088788 0.910600764
 10.45328185 0.331285901
  7.14370922 0.896312020
 -2.81754334 0.048741266
  6.40217095 0.075796756
 -3.18030478 0.666325307
  8.64585957 0.120549153
  1.37952764 0.899991932
-11.81143886 0.601949630
  0.03899706 0.363808260
-10.63828243 0.031092967
 -6.66940972 0.246204205
 -5.07374962 0.951272057
  4.82281566 0.063928187
-21.93693564 0.050972680
 -4.54569883 0.225839693
 -0.92422779 0.437796785
 -1.11683029 0.740215139
 16.77765554 0.851072372
  9.73614597 0.388180586
 14.05345168 0.063760129
  1.20512012 0.665964184
  8.00307080 0.102447114
  8.01252623 0.580929209
-13.54924183 0.438420739
  9.87164361 0.970859344
 17.63437095 0.250501797
 -3.42503574 0.873290220
 -2.45873197 0.847756049
 17.29212092 0.411683187
  1.15496098 0.530658504
 -2.14438907 0.592255367
 -1.79942021 0.517773009
 -1.30677990 0.830860762
  1.70233874 0.291826660
 -3.05532536 0.801767829
 -4.06732625 0.092294501
  6.34665476 0.270426235
  9.46946411 0.196915311
 14.50919907 0.480357167
  8.93767237 0.778228613
  1.90298854 0.903146151
 18.50500507 0.598561307
  4.45123027 0.555898218
 11.37344114 0.616557707
-12.14693218 0.409187285
 18.27198688 0.141619222
 -5.75939569 0.056989619
 -4.05515382 0.369281201
 16.69882098 0.946885257
  6.39050536 0.679704228
  4.04213339 0.662792380
  6.89608366 0.419877433
  1.56496633 0.358227958
  5.16679947 0.095144366
 -3.06280456 0.883265975
  2.76279175 0.866571973
  1.84969249 0.264869828
 21.79840498 0.702650979
  1.42450528 0.719308635
  0.96797046 0.111937435
 18.26840323 0.075621738
 13.38288377 0.573399086
  2.41101500 0.766238677
  3.83866337 0.499888953
 -1.56577367 0.695244089
 -0.90342790 0.671654151
 10.83775583 0.026041124
 -9.89767935 0.745297991
 11.74840150 0.309144074
  1.73069359 0.814063985
 -5.27966183 0.591005828
  3.33030043 0.559401806
  1.31427975 0.520950237
-10.04588558 0.507008362
 10.41228345 0.425867272
  1.71961097 0.595783108
-17.54904427 0.328788939
 -2.23545419 0.223377350
 -8.68774333 0.980964240
 -3.48048220 0.008877675
 -3.69635326 0.090236718
  9.76114237 0.769375983
-10.25662038 0.508137553
  0.11155446 0.468504431
 -8.06824580 0.414098962
  3.10031660 0.327130207
 -3.33393146 0.756896774
 -3.96276749 0.530956360
 14.53610268 0.846474699
  1.70505918 0.754662464
 -1.93495001 0.656650411
  5.01974522 0.745337633
 13.41249973 0.489362476
 11.49288744 0.335924476
 12.59019763 0.155560469
-10.17947298 0.677318449
  0.05556115 0.655090105
  3.82092860 0.051838719
  8.23041456 0.918272190
 -0.50314649 0.772015826
 20.05162157 0.880265258
  8.98816884 0.666646668
 -6.28312120 0.138534416
  3.68589909 0.274559458
  0.59699510 0.253180863
 -2.74783135 0.983525221
  0.32515065 0.839969577
 -3.60606166 0.330646732
 -0.82037740 0.129591173
  6.12444860 0.098536516
 10.95671074 0.033546728
 -2.84911174 0.720288722
  6.04597572 0.577061422
 -0.60147150 0.674096868
 -5.30458364 0.291468008
  2.68044943 0.379853840
  0.85986585 0.984214339
-12.77906359 0.882390290
  7.21420144 0.550884826
  2.31817022 0.231021556
 11.60161950 0.888496654
 -0.19346228 0.242609713
  5.07478120 0.759161318
 14.54155003 0.040387654
  3.81039636 0.874572741
  2.23233049 0.448317248
  0.19481869 0.201906051
  2.81530451 0.132131690
 12.39893259 0.674693704
  0.47054642 0.632959494
  2.16152913 0.734480632
  0.33398836 0.315024718
  7.35509037 0.304570986
 -2.92336559 0.539062343
  5.79622573 0.392393310
 -2.37607425 0.403380474
  0.04498550 0.756875541
 -1.63674414 0.613789514
 11.80310547 0.832651469
  6.30630243 0.850689403
  1.48394652 0.096243229
  4.03361865 0.799660045
  3.54707273 0.408520520
  2.00327040 0.702944912
 17.30761707 0.380542812
  5.72738968 0.105447516
-13.64604891 0.328506659
  8.35976334 0.702173924
 -7.41197443 0.134396488
-15.95683040 0.618526462
  8.76889573 0.950243069
 -1.13482624 0.113477080
 -0.60311407 0.090444247
  4.95508365 0.612511543
  5.36934491 0.979213258
 -0.03554882 0.807185690
-11.58131144 0.183341373
  4.46809041 0.796330582
 12.49741067 0.346860912
  8.63824488 0.073684997
  0.49990913 0.732519306
 12.82688360 0.109400213
 13.20375065 0.850369092
 -8.41110869 0.177717087
 16.31959963 0.727704840
 17.59203613 0.235311681
  0.32148420 0.842195936
  5.43148331 0.670904647
  7.14649727 0.028190029
  0.25410683 0.421535783
-12.41047826 0.086404379
-10.64180909 0.229659236
 -6.40185653 0.876365242
 15.63063324 0.667672536
  1.94280423 0.799266628
 -5.76507450 0.367344192
  8.60895533 0.154109357
  9.38306751 0.788742770
  3.43573528 0.284535277
  4.81848966 0.872283177
 11.65839314 0.234109111
 -5.57884822 0.030363060
 -3.94238060 0.325320686
  9.38133340 0.201141788
 -7.65003459 0.647734396
 11.23091019 0.084927159
 -6.07705432 0.037273791
  7.46380750 0.506897136
  7.42034855 0.869351148
 -4.43031973 0.231191152
 -1.07351537 0.480234836
 -1.40653281 0.690620421
 -3.82710168 0.990191328
  5.04583490 0.543427375
-11.54265099 0.270542185
  0.49059479 0.991447248
 -1.40871469 0.555998766
  3.64241437 0.743840673
-18.30031589 0.357478210
  4.27487959 0.770619738
  1.28805821 0.654787106
 -3.19542768 0.218110139
 12.53375654 0.011857644
 11.78889419 0.054127726
 -5.38392310 0.839309080
 16.38024181 0.228801038
 -0.59622631 0.134381782
 -0.74107258 0.258146632
-12.31429450 0.020524447
 -0.79785028 0.968028764
  6.39899711 0.038162566
  7.42024044 0.716163692
 -3.62470664 0.018201813
 -2.55049724 0.162446610
-10.79888854 0.683070478
 10.18490144 0.546461234
 -2.76979044 0.198830067
  4.85164813 0.094100357
  0.96477200 0.381801756
  8.13344336 0.639730450
  9.04684412 0.786084368
 10.41746272 0.828304181
  0.94334368 0.798419831
 10.13116556 0.191715972
 -4.12728628 0.575178239
 -9.59222379 0.876405375
  1.64680258 0.391003085
 -4.58897613 0.039176486
  0.38394379 0.511577564
 -4.80428215 0.222785463
  0.35363661 0.681658725
 -9.63685708 0.183035382
  3.54363414 0.766127414
  6.89610808 0.967514568
 -2.03781105 0.464416752
  8.67956196 0.421424078
 -1.09959038 0.061231448
  7.12587456 0.028601318
 -6.93064672 0.402561175
  8.57989199 0.925089270
 -9.55071810 0.454993099
 -8.11914736 0.509644286
 -5.41909698 0.077813151
-17.03336572 0.875713545
 -1.27438609 0.602163625
  3.09834374 0.105599007
 -1.59865741 0.439939102
 11.82272089 0.754984309
  4.30969696 0.483834579
-10.76886192 0.222486992
  7.05419803 0.903020271
  7.36096847 0.440357053
 -2.05864869 0.581170147
 -9.08366913 0.318677911
  8.57119930 0.605668919
  7.87702340 0.570206991
  5.22035786 0.542344385
  2.37238850 0.595969470
 -4.29809941 0.634313781
  4.51647479 0.796663089
 -0.62478780 0.562099444
  8.50866078 0.490014249
  3.46694991 0.122890089
 -7.31956453 0.885170890
  2.20259268 0.167180856
 -1.81003626 0.702563515
  8.44526939 0.973495019
  8.19767069 0.881261264
 -5.92422578 0.686557351
 -0.11826129 0.712798344
  5.66132869 0.922826429
 -5.40845018 0.642183516
  6.67839036 0.680978989
 11.88962825 0.487904896
  3.32266332 0.931709581
  0.24234019 0.405641313
-12.79023339 0.361005489
-13.57875491 0.266289733
  1.81304596 0.775093821
  0.36755600 0.400225605
 -9.15574205 0.518040748
 -3.90436548 0.396869908
  9.24764042 0.669374848
  0.74869385 0.609881390
 -3.62958907 0.928867495
 -0.02527232 0.557679930
  0.04433418 0.152565816
 11.76152632 0.865663501
 -4.62181124 0.007000650
  5.82271403 0.389678502
  0.33289002 0.532940826
 -7.65647076 0.681574524
 11.81023732 0.107165912
 11.42121999 0.989580324
 -5.47120641 0.762285550
  3.82311561 0.388755074
 16.91059711 0.461236022
  4.14012105 0.802420151
 -1.35278659 0.036646959
-12.81733350 0.179096148
 -0.94395134 0.450959878
 -5.39002376 0.264783062
  4.16227017 0.780743762
  7.26179625 0.821382454
 15.10062276 0.469253936
  1.45877225 0.685434405
 -9.87966760 0.767201511
  7.03156071 0.195142483
-11.71327419 0.774014869
 -4.55518706 0.973103604
 -1.75221406 0.175172193
 10.35631400 0.080670414
  4.97650495 0.597478189
  2.25703939 0.585949751
 10.72500409 0.339720931
 -5.02901029 0.997874377
  6.24398637 0.655067479
 -5.83880059 0.184948259
  2.17256077 0.746741866
 -5.59809380 0.277523381
  8.19384177 0.334565607
  3.35250431 0.952057263
 16.20874892 0.901400446
  1.63205839 0.235388475
 -1.07921163 0.608376332
  0.24315118 0.862639830
 15.61923078 0.050955422
  1.99639207 0.358905687
  8.14825538 0.190069662
  4.55210835 0.784025901
 13.51582298 0.973572910
 15.42415796 0.969080992
  2.23978124 0.551857514
  1.00858991 0.919566804
 -2.77293574 0.906998180
  7.10750420 0.934792213
 -8.01377290 0.682306063
  9.67873875 0.239576806
  7.54867950 0.065860266
 13.85701962 0.733823443
  8.48212853 0.285731085
  3.55278843 0.998255904
 21.94592206 0.205463912
 -2.07957143 0.948665109
  1.54169997 0.200109744
-11.36934275 0.447122472
  3.07094572 0.815147945
  6.45818709 0.007849948
  1.85594578 0.818796540
 -2.43799564 0.962013689
-17.96539549 0.654190963
 -0.93433746 0.454930236
-11.06904368 0.898560975
 14.89733742 0.479152492
 -5.72390675 0.136197255
  9.46781102 0.669006610
  5.35954546 0.259381138
  3.78388994 0.933778797
  1.95373423 0.517555994
 10.96772341 0.666138826
  9.40585102 0.779906833
  0.75347502 0.142656741
  7.64803672 0.734297119
 -0.40051164 0.362230232
 10.00747057 0.660820381
-12.86024975 0.072988046
  1.43515528 0.229672223
 -6.75981709 0.658534537
 -5.61355474 0.795897133
 -4.40596595 0.038787666
 -1.37033650 0.371835229
  6.66666573 0.560963737
  8.18430044 0.284787698
 -0.55742330 0.622783662
 -0.39757686 0.673551753
-12.68628005 0.373038561
  4.06416215 0.760546238
  4.65859855 0.516761886
  3.55304076 0.266856843
 -7.35294817 0.615783196
  1.01222898 0.158266779
  9.91052610 0.285619547
 -6.42966726 0.573689954
 10.97425098 0.985095061
  5.79394599 0.404333309
 10.09106608 0.441037857
 -1.47295537 0.577661077
 -2.07959719 0.547176133
 -8.76910940 0.498979558
-11.15658312 0.135862745
 -0.88456783 0.326480064
  9.71607440 0.998076370
 -8.76072622 0.386244511
-19.26823092 0.461833959
 -0.11280313 0.064155908
  0.64625887 0.172078148
 -5.35323428 0.331153163
 -1.71034509 0.330955888
  4.27104744 0.590544244
  7.33843789 0.263171531
 -5.38121637 0.539675802
 -6.87566548 0.127313096
 -2.50161298 0.269417630
 10.99076986 0.097362729
  6.34017269 0.318528587
 -4.63672382 0.451038055
-11.55122495 0.987073278
  4.78618612 0.297342215
  2.97547390 0.197312152
 -5.54495280 0.499701114
 17.67606173 0.810316588
 16.01578815 0.643667608
 -0.16258467 0.228284761
  7.92123340 0.784289369
 -2.26303900 0.270764770
  5.84136933 0.437763291
  4.96955217 0.389720490
 -8.09516710 0.829068548
 14.59207207 0.513593803
  2.80954688 0.650799867
  4.53653552 0.672326278
  4.49116737 0.807447691
 18.87549709 0.647303378
  9.80118464 0.932576117
-13.02124969 0.038651904
 -6.15189291 0.697593318
 15.81920283 0.249825051
 10.81503188 0.152372300
-23.58738366 0.593560367
  8.15716338 0.411680007
  3.45349379 0.351061414
 -6.39345334 0.374926213
  8.72924585 0.165759028
 22.17948804 0.003736780
 -4.73053410 0.582425257
 16.88289626 0.484899167
 -1.78826142 0.663273340
 -0.78106025 0.337039969
 -2.92461669 0.810174719
-13.89224399 0.177428986
  4.56809819 0.025010350
 -1.07452825 0.649632933
  0.58148751 0.829606422
 12.13329525 0.354819526
 17.35605568 0.284862590
-12.43678107 0.827661083
 -1.89492796 0.574929572
  2.18520382 0.846299917
 18.11449649 0.603173531
  4.34508582 0.484049042
 17.49394569 0.094811656
 10.67752350 0.166176400
 17.13374502 0.547208197
  4.42138123 0.768691494
  5.38445574 0.788597361
  0.79946671 0.851883720
 -4.67547904 0.995621191
 -5.61496422 0.523793593
-20.52093126 0.881207308
 -8.95996814 0.851078124
 -7.63483710 0.739657373
 11.02131097 0.678060014
-10.56228517 0.202393048
  6.48841788 0.143946271
  3.44853632 0.913249620
 -0.02080024 0.070765134
  2.08654297 0.032468089
  8.13415912 0.439470874
 11.19028936 0.944954026
  0.26670866 0.492724593
 -9.33692734 0.982611921
 17.23967092 0.313428994
  0.36906670 0.660669528
  7.89735684 0.977628886
 -4.00171487 0.379327632
  5.01615432 0.735627296
  0.42214214 0.092461754
 13.60634772 0.218359635
  6.57431413 0.067653525
 -1.77668341 0.717799276
  5.16227422 0.325502093
-15.29091550 0.332815338
  3.33602480 0.594168551
 13.80131443 0.817724470
  5.92111679 0.947854666
  3.59747624 0.330860216
 -6.79722403 0.093518715
 -1.86606213 0.824179728
 17.05226458 0.466573672
 10.39712467 0.409067778
 -4.78536386 0.891470739
 11.92963128 0.719633060
 -1.44230992 0.232628002
-12.31860616 0.834134222
  2.93439660 0.957842480
 14.27963295 0.546264646
  2.17488820 0.701170328
 10.78772417 0.612332448
 -0.47049341 0.378564293
 -0.35140634 0.034337429
  5.04887868 0.211697132
 -3.51562580 0.663243607
 -0.82013387 0.602497174
  2.78954743 0.325294790
  8.67905777 0.820296625
-12.70343389 0.315467361
 -2.59373236 0.015571904
 -4.60369241 0.293737716
  1.58669084 0.671091860
-10.44245103 0.501340276
  4.85215578 0.141572007
 10.46303284 0.801814632
  1.27898298 0.236929983
 -1.72225479 0.608500539
 20.18685735 0.827124630
  3.27308817 0.542065179
  1.01596956 0.254672115
 -8.88872881 0.460876757
-11.31397349 0.636168639
  0.85294367 0.816417328
  3.54262337 0.944147626
-10.53603202 0.675775741
  4.34832198 0.121988381
 11.56451662 0.283063133
 -7.36454369 0.500596540
 -8.23701113 0.379483261
 -8.36081323 0.219730782
 -6.39158860 0.739171315
 -1.40518544 0.478709398
 -4.01314821 0.460476388
 -7.34814047 0.406242873
 -7.80836711 0.730648091
 -0.57729135 0.152336258
  4.98352832 0.026424939
 -3.78181635 0.453598432
 20.16821827 0.845273124
  5.20758271 0.573569671
 -3.05534245 0.286828574
 -5.31306254 0.961990401
  1.09307567 0.006478724
 -3.75412572 0.598277695
 -2.38444245 0.777900122
  2.46837742 0.280363751
  9.72195519 0.041094463
  3.96271247 0.604775284
  2.14105354 0.400315328
  7.88645912 0.404573389
 -4.03565076 0.798377309
 10.80180959 0.932152434
-10.89359212 0.446813857
  1.43144578 0.310194540
  4.79825196 0.504826858
 10.73201365 0.384306369
 -4.07526187 0.893893643
 -2.84330198 0.390202663
  5.81825057 0.830581384
 -2.77842745 0.382966910
 -7.70333673 0.157692966
 -3.25753058 0.726303603
  8.50032387 0.556524444
  2.35027236 0.857076526
 -1.70740565 0.194760923
 -3.40693880 0.696420946
 -8.03983352 0.514393263
 -1.85105344 0.609459979
 -9.01148029 0.526019631
 18.37344635 0.690793045
 16.46079416 0.811535334
  4.10224315 0.043403618
  7.06657672 0.831274577
 15.31421824 0.434558881
-12.36760970 0.004215634
  1.95473415 0.277788662
 -0.93207006 0.368433415
 15.39919341 0.843189783
  5.23452387 0.626226925
 11.40805770 0.002417288
 -1.30282837 0.072493756
  3.92130690 0.675355182
  2.53148399 0.027222295
  4.92705318 0.934429364
  5.54978818 0.042268708
 -2.19608977 0.246743834
 -0.62565550 0.858214200
 -8.98329365 0.646827226
 12.78468146 0.533966352
  2.01061290 0.418710227
  1.03689579 0.019241741
  8.01166696 0.992268130
 -4.49786437 0.694127903
 -8.15387184 0.066275002
  2.22256207 0.083301613
-12.27145086 0.535369809
  9.95709112 0.227692557
 14.58198717 0.667298058
  5.98046083 0.922503625
  1.25640725 0.632933575
  9.77623752 0.136171032
  5.57068426 0.374916651
-10.07048336 0.470411379
  3.69267954 0.897278365
  2.22185354 0.212539549
  7.96155623 0.720525208
 -6.21272358 0.771491819
  2.63054735 0.474989115
 -2.81488890 0.675381020
  4.52747191 0.118615879
 -3.22975936 0.783991133
 11.42834761 0.423344824
  0.26512464 0.617515445
 -5.84322807 0.210915613
  9.61073028 0.988117333
 -6.11878012 0.492318959
  5.30581443 0.339379499
 -6.40132703 0.903540026
  1.22921808 0.122161655
  8.08547837 0.197296588
 -0.77943801 0.935963718
 11.43194858 0.828270943
 -5.41689395 0.556863468
 15.14667847 0.565186375
 -5.15327419 0.542802437
 -3.95903082 0.643379366
  5.78847793 0.391369361
 11.54430873 0.158789330
  1.90340148 0.841316129
 14.69680285 0.532022770
  0.68552840 0.367073827
 -8.72287967 0.250127491
  9.35401445 0.836083158
  5.32139524 0.996712598
-14.53387897 0.825434481
 -2.93925146 0.513153861
 12.54386493 0.713306793
  2.04842442 0.993893406
  2.87461954 0.049843312
  4.89765230 0.376710062
 -6.23945314 0.321108142
 -3.45840168 0.854710947
  9.05807160 0.199992188
  3.33815006 0.787302467
  4.22244242 0.351841910
 15.75879160 0.268699469
  2.78549859 0.920299974
 -4.46643118 0.727283862
  0.48021298 0.428672083
  2.55814938 0.130915212
  5.00692968 0.062266047
  4.78801127 0.325124688
  6.39524485 0.693406744
-10.46792584 0.458128441
 10.14111908 0.353412759
-10.56424183 0.821588957
  7.60967746 0.267669137
 -2.34956688 0.434855697
 23.82269027 0.802311880
  8.37170447 0.445185000
 10.05024769 0.778687843
 -9.15753018 0.957292819
 12.17438228 0.774769426
  1.57960028 0.783591989
  0.06719501 0.849073924
 16.21114558 0.243444943
 -3.79808298 0.842994720
  8.98927715 0.020537113
  7.72362992 0.984168340
 11.25158442 0.152385348
-21.23936903 0.909204114
  7.34995949 0.987249305
 -7.99435203 0.335456401
 -2.78218185 0.768517548
 11.59547596 0.466617637
 15.90870706 0.071892573
  5.58160897 0.554485703
 16.05253351 0.815206562
 -3.23103465 0.280495460
 -4.61108636 0.035757819
  5.41596511 0.746146856
  2.92445613 0.136743821
 11.23628254 0.681316365
-12.93714705 0.838791576
  9.94668264 0.084457395
 -4.56061529 0.983605894
 -4.24795688 0.601732731
 -2.83740044 0.375102341
 -0.43078317 0.403870303
 15.19689584 0.114826374
-10.29920266 0.731582141
  6.01686515 0.641655876
  6.69431335 0.496723697
  4.62223602 0.328118236
 -1.74309026 0.072604771
 14.31971261 0.827101483
 -1.86629155 0.613346722
  8.30971428 0.274948560
  8.50080711 0.059822908
 -7.94061422 0.121069240
 -2.72096492 0.710791774
  3.33259421 0.398621625
  1.73248470 0.488581205
  9.56008489 0.011104565
 12.71499762 0.038568985
  4.11512127 0.219846314
 -0.96707584 0.822646857
  4.98621667 0.633779997
  4.69384821 0.295708955
 10.16008645 0.778287787
 -7.72973800 0.097096969
  2.87264210 0.796538177
  4.56095440 0.862952770
  5.02621658 0.934628629
  3.18138681 0.805600816
 -1.02245780 0.317640678
 18.16001652 0.992503640
  4.13729026 0.941910149
  1.61211303 0.377271914
  1.71520009 0.735196094
  3.26325421 0.514432564
 12.94663819 0.591190711
 10.53239931 0.005877708
  8.06705056 0.340779884
 -5.09007267 0.332516161
 12.31973355 0.323119296
 -2.69957650 0.633232996
 12.51207803 0.377641090
  8.02081444 0.859293157
 -0.13098726 0.099370804
 -0.97757546 0.852873609
 16.73605399 0.595854575
  3.63219184 0.329310613
 -4.79105630 0.247760146
 -4.77209495 0.708235587
  0.92107647 0.924567254
 12.12724271 0.433550712
 -5.07731478 0.200109463
  9.16019579 0.897456586
 18.33260560 0.649877409
  1.93596773 0.584401505
  8.51254631 0.283154523
 11.41092928 0.698703314
 10.85035748 0.351078210
 12.62749979 0.570101319
 -2.32028296 0.313842122
 -2.45778301 0.007943144
  6.93102526 0.108737491
 -0.67304654 0.245399613
  9.27294774 0.204010286
 14.29292826 0.396294626
 14.05843185 0.864613328
 -3.73515954 0.305862948
  0.36606339 0.116802407
 -5.79235478 0.457308058
  8.70346900 0.858244380
 -8.91321043 0.077001581
  0.58499566 0.503209780
  0.39160153 0.324883353
  7.46715326 0.343451039
 12.36256009 0.679483638
  8.84283689 0.687359177
 -6.39396909 0.113065562
 -3.67844896 0.667335667
  9.36904962 0.009815419
 -3.25244888 0.213105120
 19.09389976 0.593130536
  7.28826611 0.829483570
 -5.44565944 0.956490203
  7.96993416 0.770961635
  0.20683778 0.006497153
 -3.73273760 0.037042812
-10.64745846 0.813594448
  5.70578906 0.157678242
  4.05282218 0.224663656
 14.77711159 0.577586777
  0.89685942 0.297213941
  3.92600687 0.672347849
-12.29347477 0.367072171
 -9.33603480 0.456544225
 -0.86683190 0.088696811
  4.65685745 0.779783359
  1.24438030 0.712958633
 11.43533814 0.920345548
-10.18380242 0.044456697
 -1.20684029 0.992051648
 -9.78059038 0.611477837
  3.05588762 0.581933667
  3.47419279 0.769325101
  0.87528245 0.455214184
 -3.13185655 0.805887381
 -0.82283965 0.707668384
 -1.86717272 0.984060013
 16.56357048 0.217369677
 -2.11052646 0.474156371
 -1.39795364 0.958554209
  4.87468692 0.328779186
  2.69163553 0.401633221
  6.08640626 0.599963560
  7.41420081 0.240202007
  5.73729928 0.696034193
  7.31747120 0.569520861
 -6.20465547 0.214005920
 17.52477873 0.667125450
 12.97855692 0.796977778
 -3.35883428 0.379721403
 -2.90306972 0.552454626
  5.31617371 0.401625473
 -3.86414389 0.830986352
-14.94107832 0.702705123
 -5.74060402 0.833328045
 -8.10116203 0.078855027
 23.48247017 0.568666620
 20.22005082 0.357069809
 -2.53387193 0.637455425
 15.72048831 0.845354124
 -4.41494567 0.934471473
 -8.02254420 0.378467959
 -0.13398716 0.489382793
  0.95967155 0.813667919
  0.14835664 0.215786848
 14.31875579 0.675145039
 -6.36589196 0.822037848
  8.25942906 0.156787526
 -7.33597529 0.051076292
 12.58936771 0.666507807
  2.34653798 0.626196518
 -0.69351398 0.050664564
  7.08738260 0.808776877
  5.19653521 0.779008623
  3.20900427 0.197212774
  7.81171331 0.744975548
  6.49008186 0.991318119
  7.27471854 0.839642650
 -7.68367290 0.880500743
 12.04846713 0.797754890
 14.93435279 0.190527791
 -3.83641079 0.075995951
  2.15090497 0.426560973
 -3.61166623 0.777188818
  8.49333248 0.891445999
 -7.46936100 0.148607446
 13.85406193 0.983656455
 12.20477754 0.499345090
 10.09415710 0.638127733
  5.37134772 0.110929011
  8.17660840 0.879411588
 -4.38804367 0.608933700
-11.78145902 0.265134740
  6.18940186 0.970982743
-16.24831477 0.844983635
  9.52790402 0.578152651
 16.44372225 0.264144422
 -2.48286428 0.893865621
  5.33297280 0.512990215
 -2.68912507 0.851636020
  9.94607707 0.644483197
 -1.93526852 0.550759844
  2.34310539 0.787853650
 11.79131608 0.983668283
  3.16689104 0.605394987
 10.47759320 0.919442774
  2.86973133 0.557835916
 10.30674302 0.442504870
 10.92820575 0.976183635
  7.98050212 0.139334994
 -0.64719705 0.981199028
 -2.63625596 0.341524563
 11.38799583 0.858987904
  1.37321916 0.202373294
 12.66698520 0.142127091
  5.83599540 0.864497670
  4.88659560 0.472598564
 13.00108599 0.961629827
  5.79514791 0.408377170
 -1.47807631 0.536772872
 -3.38142805 0.288956265
  6.25154986 0.828695103
  2.40919373 0.478123848
  3.72990486 0.056539500
 -9.90915815 0.603356617
  0.21737084 0.737251896
  5.36929388 0.026920178
 -1.05027354 0.034992509
 -4.97887624 0.506301429
 -6.40058435 0.014061876
 -0.14610837 0.619699963
  3.78483619 0.653952701
  3.84143365 0.162122572
  2.66030676 0.196542503
-10.56809462 0.386200215
 -5.01140125 0.711703654
 -3.09809005 0.118120179
 -2.76110171 0.118809515
  2.85825107 0.129646974
  2.75993661 0.171779333
 11.55931169 0.372165133
  9.21211486 0.969079819
  6.02207148 0.498965865
 -3.52883224 0.954619249
 -2.60190803 0.069405278
  1.34183694 0.569402487
-11.35155228 0.766344735
  1.04661568 0.023673810
 -1.90461932 0.179728300
 13.72465582 0.467775796
 19.14882438 0.476924297
 -1.07480326 0.944407858
 -8.44289331 0.059804028
  1.89732882 0.743225795
 -7.87832463 0.672539050
-12.24163608 0.916803014
-12.77212790 0.648129714
  6.39197262 0.622954436
  5.26261666 0.494421400
-10.65239640 0.695527931
  4.63841458 0.499519163
 -2.94276544 0.429201572
  4.68788953 0.639613685
 -1.03031400 0.349342009
 -2.69946354 0.221796918
-15.32237714 0.631289988
 -8.31962698 0.925363812
 -5.80897714 0.833536878
  7.16070989 0.832098478
-10.99679727 0.794048223
  0.84514458 0.748014415
  2.23308495 0.111176288
  3.56351018 0.599805508
  0.88336430 0.746908710
-14.63461670 0.314391808
  4.39039715 0.079604833
 -7.07001439 0.633705345
  2.11252583 0.461468123
  7.60219364 0.497389476
 -4.87713428 0.039952736
  2.17515292 0.421830084
  0.64302362 0.267982804
-22.29371533 0.646257366
  0.31652779 0.060548371
  7.93445046 0.343570449
  0.28292029 0.651909785
  2.77775640 0.637679287
  6.22941586 0.291132945
 23.68567532 0.708513840
  9.49503014 0.645200206
  0.87405420 0.063154289
 -4.04931224 0.110797498
  8.91607239 0.732917195
 -5.77728018 0.635435595
-16.37296319 0.343727613
  9.87409940 0.774177478
 -8.11360210 0.377765616
 14.54242540 0.204343527
  0.36239636 0.115528352
 19.51009176 0.181365423
  1.23592729 0.011676577
-15.81877035 0.767155028
 -0.05911251 0.737944231
 -6.55395965 0.214062137
 -7.85591487 0.539865054
 -9.73010882 0.730924287
 11.79433862 0.267116856
 -8.84308360 0.088069165
 -5.56689174 0.405987947
  7.59010135 0.655631611
 10.07629305 0.031106157
 -6.19331485 0.052350502
 -4.58626710 0.326901540
 -5.19431549 0.125740555
 -2.08129025 0.034657174
-10.48798034 0.153632237
 13.04657686 0.317295703
  1.94142067 0.731437668
 -1.62470735 0.701070475
-12.27046912 0.505781742
 -2.96095228 0.122808075
 -2.91847765 0.372668438
-14.83230131 0.100749725
 16.57350659 0.707854947
 10.05473238 0.244046174
  5.50858969 0.070691273
  7.65309196 0.245393047
  7.16359996 0.056261015
  4.33026356 0.318855549
 -4.65721575 0.271249938
  2.85909691 0.309377566
  3.02736080 0.553944209
  6.22796768 0.763945813
 -4.47036396 0.197721195
  2.78901176 0.441166128
 -9.94574794 0.964660659
  1.86451969 0.704635530
-10.38926659 0.772304221
 -5.36565800 0.029527218
  1.99230152 0.578448308
 13.65547415 0.936050102
 -2.05229879 0.851521142
  0.99504588 0.974891334
 -1.46027404 0.320227281
 -8.45614275 0.727910071
 -0.95201934 0.199101032
 -2.46642929 0.462252060
 -6.44060430 0.703637604
 -2.58115910 0.084948525
  0.76248197 0.125769097
 12.00603845 0.675927328
  1.97538215 0.782502470
  2.23331320 0.870228155
 -3.10226060 0.485056198
 12.59337170 0.584729095
 -2.42247402 0.387588168
  9.41981063 0.374604221
  6.26806243 0.727453335
 -5.30630356 0.427294265
 13.81542647 0.394246994
  1.05647858 0.646684666
-12.25005208 0.010531726
 -4.58162076 0.077133994
  0.58094190 0.400275636
  5.79443858 0.641731247
  8.87635216 0.913593476
  9.71048520 0.955285711
 13.10563373 0.908471848
  4.99194220 0.967014095
 15.88178853 0.041518216
  9.35962068 0.864770023
 -7.53095731 0.300106124
 12.18427585 0.248876997
  9.22034502 0.450149366
 -1.02861237 0.684246939
 -2.98140404 0.326901490
 -4.64316598 0.425381055
 15.35233259 0.630774937
 -1.85655250 0.226889991
 15.43748330 0.584219351
 10.39060893 0.387854461
  2.80705696 0.564024865
  3.48201221 0.787103673
  7.03787977 0.112019552
  8.41853061 0.798376796
 15.63925527 0.873984550
 -4.05742183 0.699131238
  6.56954685 0.720018710
  2.44007265 0.232697343
  3.75597926 0.975133449
  2.92362149 0.290975435
 -4.74372257 0.003738451
  1.28365940 0.987536495
 15.65288265 0.179629701
-11.76385004 0.850614822
  1.56331228 0.592017435
 -9.64774741 0.024951969
 -9.44879860 0.993960270
 29.33340056 0.913358233
  7.97233120 0.021820585
-12.10837953 0.401535846
 -1.20729618 0.984977268
  3.63219301 0.491142613
  2.79853507 0.663823888
  3.19584583 0.612511282
 -0.81790885 0.908769330
 -1.67795944 0.611690031
  2.55137163 0.109447998
  4.36572889 0.382049700
 -6.35667866 0.162787163
 -0.76239101 0.892383562
 -3.99558996 0.466572017
 -0.47513018 0.457760464
-10.69568261 0.544872910
  4.30943512 0.982456072
  2.91825703 0.823403368
  0.10753188 0.945676881
 -8.38623073 0.923085521
  4.95690232 0.188128654
  5.39956649 0.331692462
 -1.47421789 0.327711090
 -1.81689665 0.713285385
  5.15137860 0.414906436
  5.68897151 0.110799415
  0.78825159 0.396824099
 -1.78376652 0.929264595
  0.76991060 0.950124414
 15.81469073 0.951245195
 -4.33820920 0.009896093
  1.67174323 0.821983745
  0.38997945 0.928857784
  1.97848484 0.175680230
 -5.81067801 0.772580245
-10.45208478 0.418845035
 13.34024524 0.905645046
 -8.79585122 0.906516178
  2.89093397 0.113010960
  2.22324289 0.799940482
  8.95497981 0.984663669
  0.93288527 0.277914575
-17.35306978 0.455587022
 -3.26914604 0.406757639
  8.75871227 0.067059659
  1.79914932 0.784879863
 -0.67305388 0.006393497
  1.66805704 0.039614073
  9.03868439 0.601066847
  4.29458670 0.015772820
 -8.15564320 0.939633197
 12.50538902 0.766347628
 -0.45547258 0.464314122
 -9.47180656 0.640114882
-13.25567198 0.125841930
  2.87660101 0.381931128
  7.37834152 0.648958712
 -0.45874073 0.303139498
  4.87941450 0.500090729
  4.50344891 0.311329309
 -6.14257896 0.061368838
  5.98243271 0.873804882
 -2.64694079 0.080493398
-17.79727796 0.188420116
-13.52552336 0.798403568
  2.29086373 0.518700767
  5.21493652 0.788828533
 -8.09641615 0.775041349
  5.87005782 0.079447757
 10.74795720 0.955691540
 -8.01115709 0.004508053
 -7.53735064 0.054195934
 -6.79130165 0.877193354
 -1.26419539 0.837772170
  8.31082852 0.967509866
 21.83090247 0.261529880
 11.20453234 0.913858875
  7.19128396 0.541942489
 -2.93623595 0.860095891
 -3.61446403 0.022418065
 -6.59997709 0.532998307
  3.71486934 0.522669434
 18.03420874 0.295064126
 -8.75452291 0.390175021
 -7.83680812 0.263760724
 -1.10263921 0.501819826
  2.05633484 0.338684642
  5.25636848 0.558667384
 -7.33260497 0.457327559
  3.86721296 0.612182242
-15.94331373 0.478329365
  3.71501899 0.264241588
 18.26175822 0.023212661
 -5.21093378 0.184378036
 -2.44074986 0.297114134
-11.88339919 0.875956945
  7.52127093 0.927322099
  5.31597834 0.416344968
 11.42012314 0.952491078
 13.64950955 0.794183413
 12.50861255 0.390723282
 -3.48142207 0.538708662
 14.32910902 0.085221990
  5.76196699 0.313860477
  2.63751452 0.917424732
  2.99975231 0.208662214
  7.09852825 0.798246964
 -1.95742636 0.352166210
  7.80534904 0.386523123
 -4.47229047 0.290188493
 -4.35535158 0.761527294
  1.47083860 0.447897289
  3.09504296 0.048513534
  3.50446804 0.925072429
 12.00487617 0.574499971
 10.35171466 0.934193962
 -5.63256003 0.968833982
  7.15625220 0.467160468
 -7.81378393 0.790220187
  4.52101003 0.014459969
 12.90773453 0.990835752
  7.70737851 0.785329264
 -3.37196794 0.066025357
 -5.12793918 0.347459322
 -7.96083724 0.216608294
 12.81247279 0.287880308
  4.63872463 0.426881173
 -3.85439309 0.336532356
  4.55633320 0.108001536
 -2.40824634 0.135247519
  1.65932541 0.005108006
  3.26129578 0.093163961
 -3.52114597 0.544041275
 -9.08479260 0.111212700
  7.75150456 0.942726234
  7.44829768 0.396996218
 14.44430576 0.525470762
 -2.13457508 0.207577358
  9.74871681 0.537177845
 -4.53338693 0.625854028
 16.15962824 0.947933141
 -0.17711664 0.480940902
 -7.21470818 0.006952612
 -6.27644212 0.737909602
 -0.81648165 0.230003567
 -2.10429152 0.209671398
  7.69291241 0.987903443
 -0.32284504 0.183904658
 -0.90833921 0.782169770
 10.35542238 0.201758865
 10.40788689 0.540802365
 10.80011849 0.298263948
  7.39943598 0.785716539
-12.71674257 0.154135834
 16.67139866 0.116794235
 12.47832985 0.998179468
  3.24041348 0.653080096
 -5.50381593 0.995396942
-10.41952811 0.576472768
  4.33514092 0.146434686
  4.41294276 0.507165968
 -0.14746982 0.698144836
 -1.33323051 0.466481571
 -7.01201350 0.797150114
  6.58669848 0.942287809
  7.19444974 0.053569397
 -5.66046997 0.435728340
 -5.07828702 0.497727572
 13.72045272 0.324222944
  9.99111984 0.355713969
 -4.42363728 0.071790181
 -2.34300923 0.618434528
  4.98594041 0.605667438
 -2.45307721 0.894546647
 -3.52276424 0.760086779
 -3.69489441 0.960758209
 13.04792817 0.511273320
 21.61433486 0.236270637
 -9.57303968 0.964235539
 11.70400744 0.391045695
  4.25170422 0.411577090
  7.87516537 0.952858161
  9.89202673 0.971106687
  7.51554467 0.505791978
  2.17944879 0.893835908
  0.82420351 0.213912155
  2.47121932 0.688019842
-14.88503628 0.640950883
  8.16032283 0.277742858
 -4.65776244 0.129415853
  7.48274838 0.074213153
  7.70537066 0.476778957
  5.88202944 0.351838898
  1.95618325 0.106331699
  7.22064623 0.511434587
-18.64632081 0.009314188
 -6.16794611 0.526204245
  2.14042033 0.675800465
 -1.89535048 0.916845690
 -7.77156605 0.069742819
 -6.84078801 0.865082345
  8.17539904 0.095895629
 10.75170309 0.821383078
 14.31498805 0.117893208
 -2.82264467 0.809086411
  0.11117380 0.400587471
  6.43898314 0.333163663
  9.48110784 0.465173316
  5.39395511 0.695273081
 -2.05636570 0.508060862
  0.68666117 0.647109494
 -6.41880322 0.267530762
 -0.12096589 0.986901165
  6.46062643 0.588580914
 -4.20926136 0.550783675
  4.07354300 0.907963701
 10.84045143 0.900920521
  2.64504664 0.767700269
 10.34578229 0.197810342
 -0.19222273 0.281932395
  3.47400952 0.977555902
 11.04549389 0.694010579
  6.79729856 0.056652433
  9.28300628 0.598930531
 -3.53453282 0.183412212
  8.04028248 0.250746943
  5.75964045 0.424692336
 -4.98252741 0.867446071
 12.00352175 0.289615080
  7.53497791 0.350915526
  2.54579776 0.655113837
 -9.29572208 0.900136667
  6.41659249 0.100570650
  7.37095646 0.907179211
-12.78417775 0.262214556
  0.87962107 0.624657444
 -5.96939907 0.296725805
 -2.56857339 0.604065931
  4.27131811 0.962952479
 21.72603838 0.442485270
  6.10056565 0.418383130
 10.48099521 0.333593221
 19.28363092 0.382408442
  2.12080726 0.601206970
 -6.82450704 0.740158518
 11.32395692 0.627015570
  5.00040701 0.476274658
-11.64750733 0.105099095
  5.77442654 0.576560214
  0.31340364 0.516479036
 -2.09881449 0.146089191
  5.12411327 0.368130477
  1.70530391 0.621828438
-12.95649749 0.355726301
  8.43735652 0.275383759
-15.56161079 0.413160084
  5.28942694 0.069125495
  5.96040877 0.438716686
 -2.59318107 0.571116303
  6.95988992 0.650760909
 14.00074797 0.623645969
  1.66101456 0.558763985
 -2.57968349 0.648185379
 -5.47584253 0.716901151
  6.37222581 0.060563130
  2.83664864 0.842419730
  1.48926558 0.620280308
  0.33471689 0.170312461
  5.21648412 0.317639631
  0.51733642 0.843867329
  9.86005834 0.306036746
 -5.81145791 0.975655452
 -5.43219061 0.303385368
  5.87157118 0.677369776
  2.08889926 0.310200439
 -2.53433085 0.194730908
  7.01359575 0.674259533
 -2.00936260 0.682056466
 -2.98240739 0.787899917
 -7.43289210 0.357483044
-12.58905988 0.981387385
  5.78095517 0.533526274
 -1.23065889 0.687266774
 -6.82309960 0.293249774
  8.47000829 0.842056399
 -5.81624772 0.303700280
-14.83571031 0.311387926
  4.66808472 0.091222946
 -2.90144463 0.438301785
 10.62458662 0.828335698
  7.88002491 0.990156110
 10.27680283 0.251087079
 -9.42498970 0.292462244
  6.73027640 0.213065205
  1.28169895 0.353152789
-14.29203733 0.264563048
 20.35772711 0.265208837
  3.55095071 0.242905653
-17.97067670 0.373951756
 10.53141139 0.247520698
  0.05293205 0.579940423
 12.79674707 0.288031751
 -5.44235185 0.075899079
 14.29464811 0.960707538
 -1.36753291 0.124265178
 -4.25946974 0.521720352
-12.46519252 0.385503339
 -6.65343143 0.540942219
  5.55949184 0.143194404
 -1.20480594 0.515905644
 -4.13839908 0.164461445
 -2.21345425 0.812969725
  3.94223380 0.229238952
-10.78661097 0.395049514
  3.06997341 0.791234255
 24.82205477 0.110859039
  6.28791249 0.867125744
 -2.80296119 0.703583849
 13.24274039 0.425951975
 -0.19577471 0.361568727
 -2.34894781 0.954814545
 19.76339577 0.635462177
 -1.87591480 0.149121567
 -7.70962391 0.711708342
 -2.46291902 0.390902746
end data
regression /variables=v0 v1 /statistics defaults /dependent=v0 /method=enter.
EOF
if [ $? -ne 0 ] ; then no_result ; fi

activity="run program"
$SUPERVISOR $PSPP --testing-mode $TESTFILE
if [ $? -ne 0 ] ; then no_result ; fi

perl -pi -e 's/^\s*$//g' $TEMPDIR/pspp.list
diff -b  $TEMPDIR/pspp.list - << EOF
1.1 DATA LIST.  Reading free-form data from INLINE.
+--------+------+
|Variable|Format|
#========#======#
|v0      |F8.0  |
|v1      |F8.0  |
+--------+------+
2.1 REGRESSION.  Model Summary
#============#========#=================#==========================#
#          R #R Square|Adjusted R Square|Std. Error of the Estimate#
#========#===#========#=================#==========================#
#        |.05#     .00|              .00|                       .00#
#========#===#========#=================#==========================#
2.2 REGRESSION.  ANOVA
#===================#==============#====#===========#=====#============#
#                   #Sum of Squares| df |Mean Square|  F  |Significance#
#========#==========#==============#====#===========#=====#============#
#        |Regression#        235.23|   1|    235.232|3.580|        .059#
#        |Residual  #      98438.40|1498|     65.713|     |            #
#        |Total     #      98673.63|1499|           |     |            #
#========#==========#==============#====#===========#=====#============#
2.3 REGRESSION.  Coefficients
#===================#====#==========#====#====#============#
#                   #  B |Std. Error|Beta|  t |Significance#
#========#==========#====#==========#====#====#============#
#        |(Constant)#1.24|       .42| .00|2.95|         .21#
#        |    v1    #1.37|       .72| .05|1.89|         .06#
#        |          #    |          |    |    |            #
#========#==========#====#==========#====#====#============#
EOF
if [ $? -ne 0 ] ; then fail ; fi

pass
