/* This file is part of GNU RADIUS.
 * Copyright (C) 2000, Sergey Poznyakoff
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

#ifndef lint
static char rcsid[] = 
"$Id: fixalloc.c,v 1.3 2001/02/15 10:02:30 gray Exp $";
#endif

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include <stdio.h>
#include <sys/types.h>
#include "radiusd.h"

AUTH_REQ *
alloc_request()
{
	return Alloc_entry(AUTH_REQ);
}

VALUE_PAIR *
alloc_pair()
{
	return Alloc_entry(VALUE_PAIR);
}

void
free_pair(p)	
	VALUE_PAIR *p;
{
	if (p->type == PW_TYPE_STRING) {
		free_string(p->strvalue);
	}
	free_entry(p);
}
