/* C code produced by gperf version 2.7.2 */
/* Command-line: /usr/local/bin/gperf -k'1,2,6,7,11,13,$' -t /home/gray/radius-0.96/radiusd/./config.kw  */
/* This file is part of GNU RADIUS.
   Copyright (C) 2000,2001, Sergey Poznyakoff
  
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
  
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
  
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
#ifdef HAVE_CONFIG_H
# include <config.h>
#endif
#include <syslog.h>
#include <radiusd.h>
#include <log.h>
#include <config_tok.h>
#define _Y(x) (int)(x)

struct conf_tok {
	char *name;
	int token;
	YYSTYPE lval;
};

#define TOTAL_KEYWORDS 88
#define MIN_WORD_LENGTH 2
#define MAX_WORD_LENGTH 23
#define MIN_HASH_VALUE 2
#define MAX_HASH_VALUE 252
/* maximum key range = 251, duplicates = 0 */

#ifdef __GNUC__
__inline
#else
#ifdef __cplusplus
inline
#endif
#endif
static unsigned int
hash (str, len)
     register const char *str;
     register unsigned int len;
{
  static unsigned char asso_values[] =
    {
      253, 253, 253, 253, 253, 253, 253, 253, 253, 253,
      253, 253, 253, 253, 253, 253, 253, 253, 253, 253,
      253, 253, 253, 253, 253, 253, 253, 253, 253, 253,
      253, 253, 253, 253, 253, 253, 253, 253, 253, 253,
      253, 253, 253, 253, 253,   0, 253, 253,  55,  10,
       60,  20,  50,  30,  35,  45, 253, 253, 253, 253,
      253, 253, 253, 253, 253, 253, 253, 253, 253, 253,
      253, 253, 253, 253, 253, 253, 253, 253, 253, 253,
      253, 253, 253, 253, 253, 253, 253, 253, 253, 253,
      253, 253, 253, 253, 253, 253, 253,   5, 253,  80,
       20,   0,  10,  15,  95,   0, 253,   0,  35,  10,
      100,   0,  30,   0,   0,   0,  10,  25,  15,   5,
        0,  55, 253, 253, 253, 253, 253, 253, 253, 253,
      253, 253, 253, 253, 253, 253, 253, 253, 253, 253,
      253, 253, 253, 253, 253, 253, 253, 253, 253, 253,
      253, 253, 253, 253, 253, 253, 253, 253, 253, 253,
      253, 253, 253, 253, 253, 253, 253, 253, 253, 253,
      253, 253, 253, 253, 253, 253, 253, 253, 253, 253,
      253, 253, 253, 253, 253, 253, 253, 253, 253, 253,
      253, 253, 253, 253, 253, 253, 253, 253, 253, 253,
      253, 253, 253, 253, 253, 253, 253, 253, 253, 253,
      253, 253, 253, 253, 253, 253, 253, 253, 253, 253,
      253, 253, 253, 253, 253, 253, 253, 253, 253, 253,
      253, 253, 253, 253, 253, 253, 253, 253, 253, 253,
      253, 253, 253, 253, 253, 253, 253, 253, 253, 253,
      253, 253, 253, 253, 253, 253
    };
  register int hval = len;

  switch (hval)
    {
      default:
      case 13:
        hval += asso_values[(unsigned char)str[12]];
      case 12:
      case 11:
        hval += asso_values[(unsigned char)str[10]];
      case 10:
      case 9:
      case 8:
      case 7:
        hval += asso_values[(unsigned char)str[6]];
      case 6:
        hval += asso_values[(unsigned char)str[5]];
      case 5:
      case 4:
      case 3:
      case 2:
        hval += asso_values[(unsigned char)str[1]];
      case 1:
        hval += asso_values[(unsigned char)str[0]];
        break;
    }
  return hval + asso_values[(unsigned char)str[len - 1]];
}

#ifdef __GNUC__
__inline
#endif
struct conf_tok *
in_word_set (str, len)
     register const char *str;
     register unsigned int len;
{
  static struct conf_tok wordlist[] =
    {
      {""}, {""},
      {"ro", T_SNMP_ACCESS, _Y(SNMP_RO)},
      {"err", T_SEVERITY, _Y(L_ERR)},
      {""},
      {"error", T_SEVERITY, _Y(L_ERR)},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"rw", T_SNMP_ACCESS, _Y(SNMP_RW)},
      {""},
      {"file", T_FILE,},
      {"read_write", T_SNMP_ACCESS, _Y(SNMP_RW)},
      {""}, {""}, {""}, {""}, {""},
      {"realm-quota", T_MESGDEF, _Y(MSG_REALM_QUOTA)},
      {""},
      {"off", T_BOOL, _Y(0)},
      {""}, {""}, {""}, {""}, {""},
      {"user", T_FACILITY, _Y(LOG_USER)},
      {"emerg", T_SEVERITY, _Y(L_EMERG),},
      {""},
      {"message", T_MESSAGE},
      {""}, {""},
      {"ident", T_IDENT},
      {""},
      {"max-requests", T_MAX_REQUESTS},
      {""},
      {"source-ip", T_SOURCE_IP},
      {"debug", T_SEVERITY, _Y(L_DEBUG)},
      {""},
      {"log-dir", T_LOG_DIR},
      {""},
      {"port", T_PORT},
      {"guile", T_GUILE,},
      {""},
      {"time-to-live", T_TTL},
      {""}, {""},
      {"allow", T_ALLOW,},
      {"usedbm", T_USEDBM},
      {"exec-program-user", T_EXEC_PROGRAM_USER},
      {"log", T_LOGGING},
      {""},
      {"alert", T_SEVERITY, _Y(L_ALERT)},
      {""},
      {"print-failed-pass", T_LOGLEVEL, _Y(RLOG_FAILED_PASS)},
      {"yes", T_BOOL, _Y(1)},
      {"load", T_LOAD,},
      {"retry", T_RETRY},
      {"local1", T_FACILITY, _Y(LOG_LOCAL1)},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"print-pass", T_LOGLEVEL, _Y(RLOG_AUTH_PASS)},
      {"password-expired", T_MESGDEF, _Y(MSG_PASSWORD_EXPIRED)},
      {""},
      {"password-expire-warning", T_EXPWARNING},
      {""},
      {"level", T_LEVEL,},
      {""}, {""}, {""},
      {"deny", T_DENY,},
      {"delay", T_DELAY },
      {"local3", T_FACILITY, _Y(LOG_LOCAL3)},
      {""},
      {"exec-program-group", T_EXEC_PROGRAM_GROUP},
      {""}, {""}, {""}, {""}, {""},
      {"print-pid", T_LOGOPT, _Y(LO_PID)},
      {"proxy", T_PROXY},
      {"syslog", T_SYSLOG},
      {""}, {""},
      {"crit", T_SEVERITY, _Y(L_CRIT)},
      {""},
      {"detail", T_DETAIL},
      {""}, {""},
      {"acct", T_ACCT},
      {""},
      {"local5", T_FACILITY, _Y(LOG_LOCAL5)},
      {"no", T_BOOL, _Y(0),},
      {""},
      {"info", T_SEVERITY, _Y(L_INFO),},
      {""},
      {"notice", T_SEVERITY, _Y(L_NOTICE)},
      {"network", T_NETWORK,},
      {""},
      {"host", T_HOST},
      {""},
      {"local6", T_FACILITY, _Y(LOG_LOCAL6)},
      {""},
      {"acct-dir", T_ACCT_DIR},
      {""}, {""}, {""}, {""}, {""},
      {"main", T_MAIN,},
      {"print-cons", T_LOGOPT, _Y(LO_CONS)},
      {"strip-names", T_STRIP_NAMES},
      {""},
      {"acl", T_ACL},
      {"usr2delay", T_USR2DELAY},
      {""}, {""}, {""}, {""},
      {"auth", T_AUTH,},
      {""},
      {"local7", T_FACILITY, _Y(LOG_LOCAL7)},
      {"second-login", T_MESGDEF, _Y(MSG_SECOND_LOGIN)},
      {""},
      {"snmp", T_SNMP},
      {"spawn", T_SPAWN},
      {""}, {""},
      {"access-denied", T_MESGDEF, _Y(MSG_ACCESS_DENIED)},
      {"print-priority", T_LOGOPT, _Y(LO_PRI)},
      {"print-auth", T_LOGLEVEL, _Y(RLOG_AUTH)},
      {"local4", T_FACILITY, _Y(LOG_LOCAL4)},
      {""}, {""}, {""}, {""},
      {"print-level", T_LOGOPT, _Y(LO_PRI),},
      {"warning", T_SEVERITY, _Y(L_WARN)},
      {"category", T_CATEGORY,},
      {"username-chars", T_USERNAME_CHARS},
      {""},
      {"local0", T_FACILITY, _Y(LOG_LOCAL0)},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"local2", T_FACILITY, _Y(LOG_LOCAL2)},
      {""}, {""},
      {"read_only", T_SNMP_ACCESS, _Y(SNMP_RO)},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"logging", T_LOGGING, },
      {""},
      {"load-path", T_LOAD_PATH,},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""},
      {"request-cleanup-delay", T_REQUEST_CLEANUP_DELAY},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"print-category", T_LOGOPT, _Y(LO_CAT)},
      {""}, {""}, {""},
      {"timespan-violation", T_MESGDEF, _Y(MSG_TIMESPAN_VIOLATION)},
      {""}, {""}, {""},
      {"on", T_BOOL, _Y(1)},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""},
      {"multiple-login", T_MESGDEF, _Y(MSG_MULTIPLE_LOGIN)},
      {""},
      {"notify", T_NOTIFY},
      {""}, {""},
      {"cntl", T_CNTL},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"account-closed", T_MESGDEF, _Y(MSG_ACCOUNT_CLOSED)},
      {""},
      {"daemon", T_FACILITY, _Y(LOG_DAEMON),},
      {""}, {""}, {""}, {""},
      {"option", T_OPTION},
      {""}, {""}, {""}, {""},
      {"listen", T_LISTEN,},
      {""}, {""},
      {"community", T_COMMUNITY},
      {""}, {""},
      {"checkrad-assume-logged", T_CHECKRAD_ASSUME_LOGGED},
      {""}, {""}, {""}, {""},
      {"channel", T_CHANNEL}
    };

  if (len <= MAX_WORD_LENGTH && len >= MIN_WORD_LENGTH)
    {
      register int key = hash (str, len);

      if (key <= MAX_HASH_VALUE && key >= 0)
        {
          register const char *s = wordlist[key].name;

          if (*str == *s && !strcmp (str + 1, s + 1))
            return &wordlist[key];
        }
    }
  return 0;
}

int
keyword()
{
	struct conf_tok *p = in_word_set(cclval.string,
					 strlen(cclval.string));
	if (p) {
		cclval = p->lval;
		return p->token;
	}
	return T_STRING;
}
