/*
	Runtime Engine
		By Craig Kadziolka ( Nov 1999 - Dec 2000 )

	Modifications and copying is permitted providing this header
	is retained
*/

#include "Synchronization.h"
#include "Types.h"

void disable_interrupts()
{
#ifndef NO_LOCKS  
  sigset_t set;
  
  sigfillset( &set );
  sigprocmask( SIG_BLOCK, &set, 0);
#endif
}

void enable_interrupts()
{
#ifndef NO_LOCKS
  sigset_t set;
  sigfillset ( &set );
  sigprocmask( SIG_UNBLOCK, &set, 0);
#endif
}

void	ATOMICSTORE(UInt32 *r3, UInt32	r4)
{

  disable_interrupts();
  *r3 = r4;
  enable_interrupts();

}

UInt32 LOADMOSTRECENT(UInt32 *r3)
{

  return *r3;

}

