# Copyright (c) 2008, 2009 David Sugar, Tycho Softworks.
# This file is free software; as a special exception the author gives
# unlimited permission to copy and/or distribute it, with or without
# modifications, as long as this notice is preserved.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY, to the extent permitted by law; without
# even the implied warranty of MERCHANTABILITY or FITNESS FOR A
# PARTICULAR PURPOSE.

%{!?python_sitelib: %global python_sitelib %(%{__python} -c "from distutils.sysconfig import get_python_lib; print get_python_lib()")}
%{!?python_sitearch: %global python_sitearch %(%{__python} -c "from distutils.sysconfig import get_python_lib; print get_python_lib(1)")}
%{!?php_extdir: %global %(php-config --extension-dir)}

Name: sipwitch
Summary: SIP telephony server for secure phone systems
Version: 0.5.6
Release: 0%{?dist}
License: GPLv3+
URL: http://www.gnu.org/software/sipwitch
Group: Applications/Communications
Source: http://www.gnutelephony.org/dist/tarballs/sipwitch-%{version}.tar.gz
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root
BuildRequires: ucommon-devel >= 2.0.0
BuildRequires: libeXosip2-devel >= 3.0.0
BuildRequires: swig >= 1.3.30
BuildRequires: python-devel
BuildRequires: php-devel >= 5.0.0
BuildRequires: avahi-devel
BuildRequires: libgcrypt-devel
Requires(post): chkconfig
Requires(preun): chkconfig
Requires(preun): initscripts
Requires(postun): initscripts

%package devel
Requires: ucommon-devel >= 2.0.0
Requires: %{name} = %{version}-%{release}
Group: Development/Libraries
Summary: Headers for building sipwitch plugins

%package snmp
Requires: net-snmp
Group: Applications/Internet
Summary: Standard MIB for GNU Telephony

%package plugin-zeroconf
Requires: %{name} = %{version}-%{release}
Summary: Zeroconf plugin for sipwitch

%package python-swig
Requires: python
Requires: %{name} = %{version}-%{release}
Summary: Python package to control sipwitch server

%package php-swig
Requires: php
Requires: %{name} = %{version}-%{release}
Summary: PHP package to control sipwitch server

%package plugin-scripting
Requires: %{name} = %{version}-%{release}
Summary: Scripting plugin for sipwitch

%package plugin-forward
Requires: %{name} = %{version}-%{release}
Summary: Forward registration and routing plugin

%package plugin-subscriber
Requires: %{name} = %{version}-%{release}
Summary: Subscriber gateway plugin for sipwitch

%description
GNU SIP Witch is a pure SIP-based office telephone call server that supports
generic phone system features like call forwarding, hunt groups and call
distribution, call coverage and ring groups, holding, and call transfer, as
well as offering SIP specific capabilities such as presence and messaging. It
supports secure telephone extensions for making calls over the Internet, and
intercept/decrypt-free peer-to-peer audio and video extensions. It is not a 
SIP proxy, a multi-protocol telephone server, or an IP-PBX, and does not try 
to emulate Asterisk, FreeSWITCH, or Yate. 

%description devel
Header files for building plugins that interface with sipwitch. This might be 
used for externally creating sipwitch modules, though normally modules are 
found or added to the core distribution directly.  This may also be for 
developing external application services which need to communicate with a 
running sipwitch daemon instance.

%description snmp
This is the standard GNU Telephony MIB.  It can be used to monitor sipwitch
servers from a snmp management station when we add snmp support.

%description plugin-zeroconf
This plugin activates zeroconf network services for sipwitch and publishes
sipwitch as a sip server.

%description python-swig
This module allows one to interact with and control a locally running 
instance of the GNU SIP Witch daemon using python.  This can be used to
create sipwitch admininstration scripts or python web services that
interact with the locally running instance of sipwitch.

%description php-swig
This extension allows one to interact with and control a locally running 
instance of the GNU SIP Witch daemon using php.  This can be used to
create sipwitch admininstration scripts or php web services that
interact with the locally running instance of sipwitch.

%description plugin-scripting
This plugin enables shell scripting in connection with specific sipwitch 
events.

%description plugin-forward
This plugin enables forwarding of registration requests and destination routes
for unknown numbers so that one can create a "secure" peer to peer media
domain managed by sipwitch and still access an "insecure" b2bua based ip-pbx.

%description plugin-subscriber
This module is meant to eventually offer generic support for premise 
routers when used by providers to offer sip/voip service to a subscriber.
It offers rtp proxying and routing based on the assumption that all calls
will be handed off to an external voip provider and automatic rtp
proxy bridging between a subscribers local subnet and an isp.  In theory
this would be deployed in an isp supplied premise router to enable a 
local user to subscribe a series of local softphone/sip devices with a 
remote voip service provider.

%prep
%setup -q
%build
%configure --with-pkg-config --disable-static \
	--with-initrddir=%{_initrddir} \
	--with-python=%{__python} \
	--with-python-sitearch=%{python_sitearch} \
	--with-python-sitelib=%{python_sitelib} \
	--with-php-extdir=%{php_extdir}

%{__make} %{?_smp_mflags} 

%install
%{__rm} -rf %{buildroot}
%{__make} DESTDIR=%{buildroot} INSTALL="install -p" install
%{__make} DESTDIR=%{buildroot} INSTALL="install -p" swig-python
%{__make} DESTDIR=%{buildroot} INSTALL="install -p" swig-php5
%{__rm} -f %{buildroot}/%{_libdir}/*.la
%{__rm} -f %{buildroot}/%{_libdir}/sipwitch/*.la

%clean
%{__rm} -rf %{buildroot}

%files 
%defattr(-,root,root,-)
%doc README COPYING NEWS FEATURES SUPPORT TODO NOTES AUTHORS MODULES ChangeLog
%{_mandir}/man8/*.8*
%{_sbindir}/*
%{_bindir}/*
%{_libdir}/*.so.*
%dir %{_libdir}/sipwitch
%config(noreplace) %{_sysconfdir}/logrotate.d/sipwitch
%attr(0755,root,root) %{_initrddir}/sipwitch
%attr(0755,root,root) %{_sysconfdir}/cron.hourly/sipwitch
%attr(0770,root,root) %dir %{_sysconfdir}/sipwitch.d
%attr(0660,root,root) %config(noreplace) %{_sysconfdir}/sipwitch.conf
%attr(0660,root,root) %config(noreplace) %{_sysconfdir}/sysconfig/sipwitch
%attr(0660,root,root) %config(noreplace) %{_sysconfdir}/sipwitch.d/*.xml

%files snmp
%defattr(-,root,root,-)
%{_datadir}/snmp/mibs/GNUTelephony-MIB.txt

%files plugin-zeroconf
%defattr(-,root,root,-)
%{_libdir}/sipwitch/zeroconf.so

%files python-swig
%defattr(-,root,root,-)
%{python_sitelib}/sipwitch.py*
%{python_sitearch}/_sipwitch.so

%files php-swig
%defattr(-,root,root,-)
%{php_extdir}/sipwitch.so

%files plugin-forward
%defattr(-,root,root,-)
%{_libdir}/sipwitch/forward.so

%files plugin-scripting
%defattr(-,root,root,-)
%{_libdir}/sipwitch/scripting.so

%files plugin-subscriber
%defattr(-,root,root,-)
%{_libdir}/sipwitch/subscriber.so

%files devel
%defattr(-,root,root,-)
%{_libdir}/*.so
%{_includedir}/sipwitch/
%{_libdir}/pkgconfig/*.pc

%post
/sbin/ldconfig
/sbin/chkconfig --add sipwitch

%preun
if [ $1 = 0 ] ; then
    /sbin/service sipwitch stop >/dev/null 2>&1
    /sbin/chkconfig --del sipwitch
fi

%postun 
if [ "$1" -ge "1" ] ; then
    /sbin/service sipwitch condrestart >/dev/null 2>&1 || :
fi
/sbin/ldconfig

%changelog
* Fri May 08 2009 - David Sugar <dyfet@gnutelephony.org> - 0.5.4-2
- some fixups until upstream is changed, and new init scriptlets.

* Wed May 06 2009 - David Sugar <dyfet@gnutelephony.org> - 0.5.4-1
- temporary patch file added until upstream catches up, other cleanup.

* Sat May 02 2009 - David Sugar <dyfet@gnutelephony.org> - 0.5.4-0
- spec file updated for redhat/fedora submission.

* Fri Jul 25 2008 - David Sugar <dyfet@gnutelephony.org> - 0.2.0-0
- spec file updated for plugins and new library naming.

* Mon Jul 21 2008 - David Sugar <dyfet@gnutelephony.org> - 0.1.0-0
- initial spec file distribution.

