"======================================================================
|
|   IdentitySet Method Definitions
|
|
 ======================================================================"


"======================================================================
|
| Copyright 1999, 2000, 2001 Free Software Foundation, Inc.
| Written by Paolo Bonzini.
|
| This file is part of the GNU Smalltalk class library.
|
| The GNU Smalltalk class library is free software; you can redistribute it
| and/or modify it under the terms of the GNU Lesser General Public License
| as published by the Free Software Foundation; either version 2.1, or (at
| your option) any later version.
| 
| The GNU Smalltalk class library is distributed in the hope that it will be
| useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
| General Public License for more details.
| 
| You should have received a copy of the GNU Lesser General Public License
| along with the GNU Smalltalk class library; see the file COPYING.LIB.
| If not, write to the Free Software Foundation, 59 Temple Place - Suite
| 330, Boston, MA 02111-1307, USA.  
|
 ======================================================================"


Set variableSubclass: #IdentitySet
    instanceVariableNames: ''
    classVariableNames: ''
    poolDictionaries: ''
    category: 'Collections-Unordered'
!

IdentitySet comment:
'I am the typical set object; I can store any objects uniquely.  I
use the == operator to determine duplication of objects.' !


!IdentitySet methodsFor: 'testing'!

identityIncludes: anObject
    "Answer whether we include the anObject object; for IdentitySets
     this is identical to #includes:"
    ^self includes: anObject
! !


!IdentitySet methodsFor: 'private methods'!

hashFor: anElement

    "Answer the hash value for anElement"

    ^anElement identityHash
!

is: anElement sameAs: searchedObject

    "Answer whether findIndex: should stop scanning the receiver: anElement has
     been found and findIndex:'s parameter was searchedObject"

    ^anElement == searchedObject
! !
