"======================================================================
|
|   Array Method Definitions
|
|
 ======================================================================"

"======================================================================
|
| Copyright 1988,92,94,95,99,2000,2001,2008
| Free Software Foundation, Inc.
| Written by Steve Byrne.
|
| This file is part of the GNU Smalltalk class library.
|
| The GNU Smalltalk class library is free software; you can redistribute it
| and/or modify it under the terms of the GNU Lesser General Public License
| as published by the Free Software Foundation; either version 2.1, or (at
| your option) any later version.
| 
| The GNU Smalltalk class library is distributed in the hope that it will be
| useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
| General Public License for more details.
| 
| You should have received a copy of the GNU Lesser General Public License
| along with the GNU Smalltalk class library; see the file COPYING.LIB.
| If not, write to the Free Software Foundation, 59 Temple Place - Suite
| 330, Boston, MA 02110-1301, USA.  
|
 ======================================================================"



ArrayedCollection subclass: Array [
    
    <shape: #pointer>
    <category: 'Collections-Sequenceable'>
    <comment: 'My instances are objects that have array-like properties: they are directly 
indexable by integers starting at 1, and they are fixed in size.  I inherit
object creation behavior messages such as #with:, as well as iteration
and general access behavior from SequenceableCollection.'>

    Array class >> from: anArray [
	"Answer anArray, which is expected to be an array specified with a
	 brace-syntax expression per my inherited protocol."

	<category: 'instance creation'>
	^anArray
    ]

    printOn: aStream [
	"Print a representation for the receiver on aStream"

	<category: 'printing'>
	aStream nextPut: $(.
	self do: 
		[:elt | 
		elt printOn: aStream.
		aStream space].
	aStream nextPut: $)
    ]

    isLiteralObject [
	"Answer whether the receiver is expressible as a Smalltalk literal."

	<category: 'printing'>
	^self isReadOnly not
    ]

    storeLiteralOn: aStream [
	"Store a Smalltalk literal compiling to the receiver on aStream"

	<category: 'printing'>
	self class == Array ifFalse: [ ^super storeLiteralOn: aStream ].
	aStream nextPut: $#.
	aStream nextPut: $(.
	self do: 
		[:elt | 
		elt storeLiteralOn: aStream.
		aStream space].
	aStream nextPut: $)
    ]

    storeOn: aStream [
	"Store Smalltalk code compiling to the receiver on aStream"

	<category: 'printing'>
	self class == Array ifFalse: [ ^super storeOn: aStream ].
	aStream nextPut: $#.
	aStream nextPut: $(.
	self do: 
		[:elt | 
		elt isLiteralObject 
		    ifTrue: [elt storeLiteralOn: aStream]
		    ifFalse: 
			[aStream
			    nextPutAll: '##(';
			    store: elt;
			    nextPut: $)].
		aStream space].
	aStream nextPut: $).
	self isReadOnly ifFalse: [aStream nextPutAll: ' copy']
    ]

    multiBecome: anArray [
	"Transform every object in the receiver in each corresponding
	 object in anArray. anArray and the receiver must have the same
	 size"

	<category: 'mutating objects'>
	| index |
	index := 0.
	^self collect: 
		[:object | 
		index := index + 1.
		object become: (anArray at: index)]
    ]

    isArray [
	<category: 'testing'>
	^true
    ]
]

