# GNU Solfege - ear training for GNOME
# Copyright (C) 2000, 2001, 2002, 2003, 2004  Tom Cato Amundsen
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import gettext
import locale
import os
import configureoutput

def _i(s):
    """
    used for translated strings with a prefix, like these:
    _("interall|m3")
    _("View-menu|_Toolbar")
    This function is required because if a entry is not translated, then
    only the string after | should be returned. 
    """
    ns = _(s)
    if ns == s:
        return s.split('|')[-1]
    else:
        return ns

def langs():
    ret = []
    for k in ('LANGUAGE', 'LC_ALL', 'LC_MESSAGES', 'LANG'):
        if k in os.environ:
            v = os.environ.get(k)
            if v:
                ret = v.split(':')
            break
    if 'C' not in ret:
        ret.append('C')
    retval = []
    for l in ret:
        s = locale.normalize(l)
        if len(s) >= 5 and s[2] == '_':
            retval.append(s[:5])
            retval.append(s[:2])
        else:
            retval.append(s)
    return retval

def setup():
    gettext.install('solfege', os.path.join(configureoutput.prefix, 'share/locale'), unicode=1)
    __builtins__['_i'] = _i

def setup_srcdir():
    gettext.install('solfege', 'share/locale', unicode=1)
    __builtins__['_i'] = _i


