#!@PYTHON@
# @configure_input@

import urllib2

wiki_url = "http://www.solfege.org"
def get_page(name):
    print "downloading:", name
    u = urllib2.urlopen(wiki_url + "/" + name + "?skin=solfegedoc")
    s = u.read()
    if s.find("Describe %s here" % upper(name.split("/")[1])) != -1:
        print "Page did not exist on the wiki."
        return None
    return s

pages = (
    'Bug-reporting',
    'Chord-help',
    'Chord-names',
    'Chord-voicing-help',
    'Compare-intervals-help',
    'Copyright',
    'Dictation-help',
    'Harmonic-interval-help',
    'Harmonic-progression-dictation-help',
    'Helpfile-format',
    'Id-by-name-help',
    'Id-tone-help',
    'Identify-bpm-help',
    'Identify-scale-help',
    'Lessonfiles',
    'Melodic-interval-help',
    'Missing-helpfile',
    'Music-format',
    'Online-resources',
    'Preferences-window',
    'Rhythm-help',
    'Sing-chord-help',
    'Sing-interval-help',
    'Singanswer-help',
    'Theory-intervals',
    'Translating-solfege',
    'Twelve-tone-help',
    'Ui',
    'Welcome'
    )

casedict = {'es_MX': 'Es_MX', 'C': 'C'}
def groupcase(s):
    if len(s) == 2:
        return s[0].upper() + s[1]
    return casedict[s]

def upper(s):
    return s[0].upper() + s[1:]

import sys
import optparse
opt_parser = optparse.OptionParser()
opt_parser.add_option("--lang", dest="language")
opt_parser.add_option("--page", dest="page", default=None)
options, args = opt_parser.parse_args()

if options.page:
    s = get_page("SolfegeDocs%s/%s" % (groupcase(options.language), options.page.lower()))
    if s:
        outfile = file('online-docs/%s/%s.html' % (options.language, options.page.lower()), 'w')
        outfile.write(s)
        outfile.close()
    sys.exit()

for page in pages:
    s = get_page("SolfegeDocs%s/%s" % (groupcase(options.language), page))
    if s:
        outfile = file('online-docs/%s/%s.html' % (options.language, page.lower()), 'w')
        outfile.write(s)
        outfile.close()
