%{
/*
 * Copyright (C) 2004  Jan Tatarik <tatarik@planet.nl>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */                         

static  int lineno = 1 ; /* number of scanned lines */

/*
symbol [\~\!\%\^\*\(\)\-\+\=\[\]\|\\\:\;\,\.\/\?\&\<\>]

FILENAME (([a-zA-Z0-9_/\\])*)("."([a-zA-Z0-9_/\\])*)*
*/

#include "genfun.h"
%}

%option noyywrap
%option prefix="syslog_scanner_"

%x SYSLOG APACHE_ACCESS APACHE_ERROR hostname app iptables ipt_string ipt_number port uri

D		[0-9]
D2		{D}{2}
IP_ADDR		{D}{1,3}"."{D}{1,3}"."{D}{1,3}"."{D}{1,3}
DATE		[[:alpha:]]{3}" "{1,2}{D}{1,2}
TIME		{D2}:{D2}:{D2}
YEAR		{D}{4}
TIMEZONE	[+-]{D}{4}

HTTP_METHOD	(OPTIONS|GET|HEAD|POST|PUT|DELETE|TRACE|CONNECT)
WEBDAV_METHOD	(PROPFIND|MKCOL|COPY|MOVE|LOCK|UNLOCK)

TIMESTAMP	{DATE}" "{TIME}
L_TIMESTAMP	[[:alpha:]]{3}" "{TIMESTAMP}" "{YEAR}
AA_DATE		{D2}"/"[[:alpha:]]{3}"/"{YEAR}

WS          [[:blank:]]

%%

^{DATE}/" "{TIME}	BEGIN(SYSLOG); generateKeyWord(yytext);
^{IP_ADDR}		BEGIN(APACHE_ACCESS); generateBaseType(yytext);
^\[/{L_TIMESTAMP}\]	BEGIN(APACHE_ERROR); generateKeyWord(yytext);

<SYSLOG>{TIME}		BEGIN(hostname); generatePreProc(yytext);
<hostname>[^ ]+		BEGIN(app); generateSymbol(yytext);
<app>{
	:			BEGIN(0); generate_normal(yytext);
	[^:([]+			generateFunction(yytext);
	(\[|\()[^\]\)]*(\]|\))	generateNumber(yytext);
}

[[:space:]]/IN=[[:alnum:]]*[[:space:]]OUT=[[:alnum:]]*	BEGIN(iptables); generate_normal(yytext);

<iptables>{
	(SPT|DPT|TYPE|SEQ)=/[^ ]+	BEGIN(ipt_number); generate_normal(yytext);
	(IN|OUT|PROTO)=/[^ ]+		BEGIN(ipt_string); generate_normal(yytext);
	(CWR|ECE|URG|ACK|PSH|RST|SYN|FIN)/[^[:alpha:]]		generateNumber(yytext);
}
<ipt_number>[^ ]+	BEGIN(iptables); generateCBracket(yytext);
<ipt_string>[^ ]+	BEGIN(iptables); generateString(yytext);

<APACHE_ACCESS>{
	[[:alnum:]]+/" "\[{AA_DATE}		generateString(yytext);
	{AA_DATE}/:{TIME}			generateKeyWord(yytext);
	{TIME}" "{TIMEZONE}			generatePreProc(yytext);
	[1-5]{D2}" "[-0-9]+			generateCBracket(yytext);
	{HTTP_METHOD}|{WEBDAV_METHOD}		BEGIN(uri); generateComment(yytext);
}
<uri>[^ ]+	BEGIN(APACHE_ACCESS); generateString(yytext);

<APACHE_ERROR>{
	[[:alpha:]]{3}" "{DATE}" "/{TIME}	generateKeyWord(yytext);
	{TIME}" "/{YEAR}			generatePreProc(yytext);
	{YEAR}/\]				generateKeyWord(yytext);
	\[error\]				generateString(yytext);
	\[notice\]				generateComment(yytext);
}

<*>port" "/{D}+	BEGIN(port); generate_normal(yytext);
<*>pid" "/{D}+	BEGIN(port); generate_normal(yytext);
<port>{D}+	BEGIN(0); generateCBracket(yytext);

<*>(root|failure)	generateString(yytext);
<*>{IP_ADDR}		generateBaseType(yytext);
<*>"\n"			BEGIN(0); ++lineno; generateNewLine();
<*>{WS}+		generate_normal(yytext);

<*>[a-zA-Z_\.]([a-zA-Z0-9_\.])* 	{ generate_normal( yytext ) ; }

<*>.           generate_normal(yytext);

%%
