/*
 * Copyright (C) 1999, 2000, 2001, 2002  Lorenzo Bettini, bettini@gnu.org
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <iostream.h>

#include "cssdecorator.h"

// for globals
#include "globalostream.h"

SpanDecorator::SpanDecorator( TextGenerator *t, CharTranslator *tr, char *ta) :
  TextDecorator( t, tr ), span(ta)
{
}

void
SpanDecorator::startDecorate()
{
  startTAG( span ) ;
}

void
SpanDecorator::endDecorate()
{
  endTAG( ) ;
}

void
SpanDecorator::startTAG( char *span ) const
{
  (*sout) << "<span class=\"" << span << "\">" ;
}

void
SpanDecorator::endTAG( ) const
{
  (*sout) << "</span>" ;
}
