/*
** Copyright (C) 1999, 2000, 2001, 2002, 2003 Lorenzo Bettini <bettini@gnu.org>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
*/

// docgenerator.h : Document generator class

// for preable, header, footer, etc.

#ifndef DOCGENERATOR_H
#define DOCGENERATOR_H

#include <string>

using std::string;

class DocGenerator
{
 protected:
  string title;
  bool gen_source_highlight_version;

 public:
  DocGenerator(const string &s) : title (s),
    gen_source_highlight_version (true) {}
  virtual ~DocGenerator() {}

  virtual void generate_top() {}
  virtual void generate_bottom() {}

  virtual void generate_start_doc() {}
  virtual void generate_end_doc() {}

  virtual void generate(const string &);
  virtual void generateln(const string &);

  void set_gen_version(bool b) { gen_source_highlight_version = b; } 
};

#endif // DOCGENERATOR_H
