//
// C++ Interface: statestartlangelem
//
// Description: 
//
//
// Author: Lorenzo Bettini <bettini@gnu.org>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef STATESTARTLANGELEM_H
#define STATESTARTLANGELEM_H

#include "langelem.h"

class StringDef;

/**
A language element that may start a new state/environment

@author Lorenzo Bettini
*/
// doublecpp: forward declarations, DO NOT MODIFY
class RegExpStateBuilder; // file: regexpstatebuilder.h
class RegExpStatePointer; // file: regexpstatebuilder.h
// doublecpp: end, DO NOT MODIFY

class StateStartLangElem : public LangElem
{
  private:
    bool exit;
    bool exit_all;
    
public:
    StateStartLangElem(const std::string &n, bool exit = false, bool all = false);

    virtual ~StateStartLangElem();
    
    virtual const std::string toString() const;
    
    void set_exit() { exit = true; }
    void set_exitall() { exit_all = true; }
    
    bool exitAll() const { return exit_all; }
    bool doExit() const { return exit; }
// doublecpp: dispatch methods, DO NOT MODIFY
public:
virtual void dispatch_build(RegExpStateBuilder *, RegExpStatePointer state);
// doublecpp: end, DO NOT MODIFY
};

#endif
