# swanalysis_lib.c - Shell library for analysis phase.   
# $Id: swalib.sh,v 1.3 2004/07/09 01:25:39 jhl Exp jhl $
#
#  Copyright (C) 2004  James H. Lowe, Jr.
#  All Rights Reserved.
# 
#  COPYING TERMS AND CONDITIONS
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2, or (at your option)
#  any later version.
# 
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
# 
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


swanlib_ret_dig()
{
	rem="$1"
	gg_dig_ret=""
	doit=""
	case "$rem" in
	"") gg_dig_ret=""; ;;
	?) num="${rem}"; rem=""; doit="x"; ;;
	??) num="${rem%%?}"; doit="x"; ;;
	???) num="${rem%%??}"; doit="x"; ;;
	????) num="${rem%%???}"; doit="x"; ;;
	?????) num="${rem%%????}"; doit="x"; ;;
	??????) num="${rem%%?????}"; doit="x"; ;;
	???????) num="${rem%%??????}"; doit="x"; ;;
	????????) num="${rem%%???????}"; doit="x"; ;;
	?????????) num="${rem%%????????}"; doit="x"; ;;
	??????????) num="${rem%%?????????}"; doit="x"; ;;
	???????????) num="${rem%%??????????}"; doit="x"; ;;
	????????????) num="${rem%%???????????}"; doit="x"; ;;
	*) echo "number too large"; doit=""; rem="";;
	esac

	case "$doit" in
		"")
			gg_dig_ver=""
			gg_dig_ret=""
			;;
		*)
		case "$rem" in
			*)
			rem="${rem#?}"
			;;
			"")
			rem=""
			;;
		esac
		gg_dig_ver="$rem"
		gg_dig_ret="$num"
		;;
	esac
}

swanlib_ret_ver()
{
	rem="$1"
	gg_ret=""
	case "$rem" in
	"")
		gg_ret=""
		;;
	*)
		num="${rem%%.*}"
		case "$rem" in
			*.*)
			rem="${rem#*.}"
			;;
			*)
			rem=""
			;;
			"")
			rem=""
			;;
		esac
		gg_ver="$rem"
		gg_ret="$num"
		;;
	esac
}

component_compare()
{
	cc_old=$1
	cc_new=$2

	gg_dig_ver=$cc_old
	gg_dig_old=$cc_old
	gg_dig_new=$cc_new

	ans_old=0
	ans_new=0

	ans_suf_old=""
	ans_suf_new=""
	#echo ans_old="$ans_old" ans_new="$ans_new"

	while [ "$gg_dig_new" -o "$gg_dig_old" ]; do

		case "$gg_dig_old" in
			"") 
				dig_old=""
				;;
			*)
				swanlib_ret_dig $gg_dig_old; gg_dig_old=$gg_dig_ver
				dig_old="$gg_dig_ret"
			;;
		esac
		case "$gg_dig_new" in
			"") 
				dig_new=""
				;;
			*)
				swanlib_ret_dig $gg_dig_new; gg_dig_new=$gg_dig_ver
				dig_new="$gg_dig_ret"
			;;
		esac
		#echo dig_new=$dig_new dig_old=$dig_old
	
		case "$dig_old" in 
			[0-9]) 
				ans_old=$(($ans_old * 10 + $dig_old));
				;;
			[a-z]|[A-Z])
				ans_suf_old="${ans_suf_old}${dig_old}"
				;;
			"")
				;;
		esac

		case "$dig_new" in 
			[0-9])
				ans_new=$(($ans_new * 10 + $dig_new));
				;;
			[a-z]|[A-Z])
				ans_suf_new="${ans_suf_new}${dig_new}"
				;;
			"")
				;;
		esac
	done

	#echo ans_old="$ans_old" ans_new="$ans_new"

	if [ "$ans_new" -a ! "$ans_old" ]; then
		return 2
	elif [ ! "$ans_new" -a "$ans_old" ]; then
		return 1
	elif [ ! "$ans_new" -a ! "$ans_old" ]; then
		return 0
	fi

	cc_is_eq=$(($ans_new == $ans_old))
	case "$cc_is_eq" in
		0)
			if [ "${ans_new}" -gt "${ans_old}" ]; then
				return 2
			elif [ "${ans_new}" -lt "${ans_old}" ]; then
				return 1
			else
				return 0
			fi	
			;;
		1)
			if test "${ans_suf_new}" ">" "${ans_suf_old}" ; then
				return 2
			elif test "${ans_suf_new}" "<" "${ans_suf_old}" ; then
				return 1
			else
				return 0
			fi
			;;
	esac
}

ver_compare()
{
	old="$1"
	new="$2"

	gg_ver="$old"
	gg_old="$old"
	gg_new="$new"

	while [ "$gg_new" -o "$gg_old" ]; do
		swanlib_ret_ver "$gg_old"; gg_old="$gg_ver"
		old_comp="$gg_ret"
		swanlib_ret_ver "$gg_new"; gg_new="$gg_ver"
		new_comp="$gg_ret"
		#echo "$old_comp" "$new_comp"
		component_compare "$old_comp" "$new_comp"
		ret=$?
		case "$ret" in
			0)
				;;
			*)
				return "$ret"
				;;
		esac
	done

	# return codes:
	#
	# 0 if old and new are equal
	# 1 if old > (later) than new
	# 2 if old < (older) than new
}

sh_brk_split() {
	# Global prefix: ab
	ab_s_source="$1"
	ab_s_delim="$2"
	case "$ab_s_source" in
		*[$ab_s_delim]*)
			gg_ab_fir="${ab_s_source%%[${ab_s_delim}]*}"
			gg_ab_sec="${ab_s_source#*[${ab_s_delim}]}"
			;;
		*)
			gg_ab_fir="${ab_s_source}"
			gg_ab_sec=""
			;;	
	esac	
}

id_cur_token()
{
	# Global Prefix: id
	id_current_tok="$1"
	id_spec_rem="$1"
	gg_id_cur_sep=""
	# echo "dddddddddddddd $id_spec_rem" 1>&2
	case "$gg_id_cur_token" in
	*)
	case "$id_spec_rem" in
		[avlq]=*)
			# echo "CASE 1" 1>&2
			gg_id_cur_token=SX_ver_item
			gg_id_cur_sep=",|"
			;;
		r=*)
			# echo "CASE 2" 1>&2
			gg_id_cur_token=SX_ver_item
			gg_id_cur_sep=",|"
			;;
		r[=\!\>\<]*)
			# echo "CASE 2" 1>&2
			gg_id_cur_token=SX_ver_item
			gg_id_cur_sep=",|"
			;;
		*)
			# echo "CASE 3" 1>&2
			case "$gg_id_cur_token" in
				SX_ver_item)
					gg_id_cur_token="SX_newspec"
					;;
				*)
					gg_id_cur_token="SX_tag"
					;;
			esac
			gg_id_cur_sep=",|."
			;;
	esac
	;;
	esac
}

swspec_init()
{
	# Global prefix: ifa

	SWSPEC_STATE=""  # one of SX_tag, SX_ver_item_arg, SX_relop, SX_pattern SX_swspec
	SWSPEC_bundle_qualifier=""
	SWSPEC_product_qualifier=""
	SWSPEC_subproduct_qualifier=""
	SWSPEC_fileset_qualifier=""
	SWSPEC_ver_id_r=""
	SWSPEC_ver_id_r_relop=""
	SWSPEC_ver_id_a=""
	SWSPEC_ver_id_v=""
	SWSPEC_ver_id_l=""
	SWSPEC_ver_id_q=""
	SWSPEC_pat_sw=""
	for ifa_id in r a v l q; do
		for ifa_q in b f p; do
			eval SWSPEC_ver_id_${ifa_id}${ifa_q}=""
		done
	done

}

swspec_show()
{
	# Global prefix: ifa
	echo SWSPEC_bundle_qualifier=""
	echo SWSPEC_product_qualifier=""
	echo SWSPEC_subproduct_qualifier=""
	echo SWSPEC_fileset_qualifier=""
	echo SWSPEC_ver_id_r=""
	echo SWSPEC_ver_id_r_relop=""
	echo SWSPEC_ver_id_a=""
	echo SWSPEC_ver_id_v=""
	echo SWSPEC_ver_id_l=""
	echo SWSPEC_ver_id_q=""
	echo SWSPEC_pat_sw=""

	for ifa_id in r a v l q; do
		for ifa_q in b f p; do
			eval SWSPEC_ver_id_${ifa_id}${ifa_q}=""
		done
	done
}

swspec_set_item()
{
	# Global prefix: if

	if_state="$1"
	if_item="$2"
	if_value="$3"

	case "$if_state" in
		SX_tag)
			;;
		SX_ver_item)
			if_ok=no
			case "$if_item" in
			[bpf]a|a)
				if_ok=yes
				;;
			[bpf]r|r)
				if_ok=yes
				;;
			[bpf]v|v)
				if_ok=yes
				;;
			[bpf]l|l)
				if_ok=yes
				;;
			[bpf]q|q)
				if_ok=yes
				;;
			rpmflag)
				if_ok=yes
				;;
			*)	
				echo "error: unrecognized ver_id [$if_item]" 1>&2
				;;
			esac
			case "$if_ok" in
				yes)
					eval SWSPEC_ver_id_"$if_item"="$if_value"
					;;
			esac
			;;
		SX_relop)
			SWSPEC_ver_id_r_relop="$if_value"
			;;
	esac
}

swspec_parse_verid()
{
	# Global Prefix: ie
	ie_current_tok="$1"
	ie_verid="${ie_current_tok%%[=<>!]*}"
	ie_value="${ie_current_tok##*[=<>!]}"
	ie_relop="${ie_current_tok%$ie_value}"
	ie_relop="${ie_relop#$ie_verid}"
	gg_ie_verid="${ie_verid}"
	gg_ie_value="${ie_value}"
	gg_ie_relop="${ie_relop}"
}


