# Taler Directory

This is the Taler Directory (TalDir) implementation.
The API can be found here: https://docs.taler.net/core/api-taldir.html

# Build and Run

Compile and run:

```
$ ./bootstrap
$ ./configure --prefix=PREFIX
$ make && make install
(You may have to set your $PATH to include the go/bin folder accordingly)
$ cp config/taldir-example.conf taldir.conf
(Edit taldir.conf to fit your needs)
$ ./taldir-server
```

# Test

```
$ go test -v ./cmd/talidir-server
```

# Configuration

The configuration file of taldir is `taldir.conf`.
You may copy the example configuration `config/taldir-example.conf` to your
runtime directory and modify it according to your needs.

The following configuration variables exist:

For the `[taldir]` section:

  * "production" (boolean): true for a production deployment. Causes verbose log messages to be inhibited.
  * "db_backend" (string): "sqlite" for the SQLite database backend to be used.
  * "validators" (array): An array of strings for the validators/identity types that can be used. Currently supported values: "email"
  * "email_sender" (string): For email validations, what should the sender address be.
  * "host" (string): For the validation link, which hostname should be used (useful if behind proxy).
  * "bind_to" (string): Where to bind and listen (HTTP server).
  * "salt" (string): The salt to use for identity key hashes in the database may alternatively be an environment variable `TALDIR_SALT`.
  * "monthly_fee" (string): The monthly fee for a registration (Default: "KUDOS:1")
  * "default_doc_filetype" (string): The default file type for the terms of service and privacy policy documents (Default: "text/markdown")
  * "default_doc_lang" (string): The default language for the terms of service and privacy policy documents (Default: "en-US")
  * "default_tos_path" (string): The path for the terms of service documents. Taldir will look for `<lang>.<extension>` depending on the requested file type ("Accept"-header) and locale ("Accept-Language"-header) (Default: "terms/")
  * "default_pp_path" (string): See `default_tos_path` (Default: "privacy/")
  * "challenge_bytes" (number): The number of bytes (entropy) of the generated challenge (Default: 16)
  * "validation_initiation_max" (number): How many challenges can be requested to validate an address (Default: 3)
  * "validation_timeframe" (string): The timeframe in which challenges can be requested up to `validation_initiation_max` times (Default: 10m)
  * "solution_attempt_max" (number): How often can the solution be attempted for a challenge in the `solution_attempt_timeframe` (Default: 3)
  * "solution_attempt_timeframe" (string): The timeframe in which the solution can be attempted `solution_attempt_max` times (Default: "1h")
  * "merchant_baseurl_privat" (string): The base URL for the merchant API to use (Default: "http://merchant.taldir/instances/myInstance")
  * "merchant_token" (string): The access token for the merchant API (Default: "superSecretToken")
  * "validation_landing" (string): The location of the HTML template to use for the validation landing displaying a QR code. (Default: "templates/validation_landing.html"
  * "validation_expiration" (string): The duration for which incomplete registration requests are kept. (Default: "24h")

For the `[taldir-pq]` section:

  * "host" (string): The host of the Postgres database to use (Default: "localhost")
  * "port" (number): The port of the Postres database to use (Default: 5432)
  * "user" (string): The database user (Default: "taldir")
  * "password" (string): The database user password (Default: "secret")
  * "db_name" (string): The database name (Default: "taldir")

Examples and defaults for the configuration can be found in the `taldir.conf` file shipped with this software.

# Validators

Taldir validators are executable programs which are used to transfer a validation
code out of band to the client.
A Taldir validator is uniquely identified by a name.
In order to enable a validator, its `<name>` must be present in the `validators` field
in the `taldir` section in the Taldir configuration file.
Further, a `taldir-<name>` section must exists which contains the following
variables:

  * "challenge_fee" (amount): The cost of a single challenge using this validation method.
  * "command" (string): The program to use to trigger the out of band transfer of the validation code.

## Validator command

The validator command is an executable program which takes exactly two arguments:
For example:

```
$ validator-test <address> <code>
```

The first argument of the validator command is the address in a validation method-specific format.
For example, the email validation expects an email address, the Twitter validator expects a Twitter handle, etc.
The second argument is the activation code generated by Taldir and which is expected to be transferred using the validation method to the user.

# Terms of Service and Privacy Policy

You may edit the document templates under `contrib/pp` and `contrib/tos`
to your needs.
You can build the documents using:

```
$ make update-tos
$ make update-pp
```

And configure/copy the built localized documents into your configured
paths, e.g.:

```
$ cp -r contrib/tos/en terms/
$ cp -r contrib/pp/en terms/
```

