--
-- This file is part of TALER
-- Copyright (C) 2014--2022 Taler Systems SA
--
-- TALER is free software; you can redistribute it and/or modify it under the
-- terms of the GNU General Public License as published by the Free Software
-- Foundation; either version 3, or (at your option) any later version.
--
-- TALER is distributed in the hope that it will be useful, but WITHOUT ANY
-- WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
-- A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License along with
-- TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
--

-- @author: Özgür Kesim

CREATE FUNCTION create_table_policy_fulfillments(
  IN partition_suffix TEXT DEFAULT NULL
)
RETURNS VOID
LANGUAGE plpgsql
AS $$
DECLARE
  table_name TEXT DEFAULT 'policy_fulfillments';
BEGIN
  PERFORM create_partitioned_table(
    'CREATE TABLE %I '
      '(h_fulfillment_proof gnunet_hashcode PRIMARY KEY'
      ',fulfillment_id BIGINT GENERATED BY DEFAULT AS IDENTITY'
      ',fulfillment_timestamp INT8 NOT NULL'
      ',fulfillment_proof TEXT'
      ',policy_hash_codes gnunet_hashcode[] NOT NULL'
      ') %s ;'
    ,table_name
    ,'PARTITION BY HASH (h_fulfillment_proof)'
    ,partition_suffix
  );
  PERFORM comment_partitioned_table(
    'Proofs of fulfillment of policies that were set in deposits'
    ,table_name
    ,partition_suffix
  );
  PERFORM comment_partitioned_column(
    'Timestamp of the arrival of a proof of fulfillment'
    ,'fulfillment_timestamp'
    ,table_name
    ,partition_suffix
  );
  PERFORM comment_partitioned_column(
    'JSON object with a proof of the fulfillment of a policy. Supported details depend on the policy extensions supported by the exchange.'
    ,'fulfillment_proof'
    ,table_name
    ,partition_suffix
  );
  PERFORM comment_partitioned_column(
    'Hash of the fulfillment_proof'
    ,'h_fulfillment_proof'
    ,table_name
    ,partition_suffix
  );
  PERFORM comment_partitioned_column(
    'Array of the policy_hash_code''s of all policy_details that are fulfilled by this proof'
    ,'policy_hash_codes'
    ,table_name
    ,partition_suffix
  );
END
$$;

COMMENT ON FUNCTION create_table_policy_fulfillments
  IS 'Creates the policy_fulfillments table';

CREATE FUNCTION constrain_table_policy_fulfillments(
  IN partition_suffix TEXT
)
RETURNS VOID
LANGUAGE plpgsql
AS $$
DECLARE
  partition_name TEXT;
BEGIN
  partition_name = concat_ws('_', 'policy_fulfillments', partition_suffix);

  EXECUTE FORMAT (
    'ALTER TABLE ' || partition_name ||
    ' ADD CONSTRAINT ' || partition_name || '_serial_id '
    ' UNIQUE (h_fulfillment_proof, fulfillment_id)'
  );
END
$$;
INSERT INTO exchange_tables
  (name
  ,version
  ,action
  ,partitioned
  ,by_range)
VALUES
  ('policy_fulfillments', 'exchange-0002', 'create',    TRUE ,FALSE),
  ('policy_fulfillments', 'exchange-0002', 'constrain', TRUE ,FALSE);
