/*
 This file is part of GNU Taler
 (C) 2019 GNUnet e.V.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

import test from "ava";

import { PaytoString, addPaytoQueryParams, parsePaytoUri, stringifyPaytoUri } from "./payto.js";

test("basic payto parsing", (t) => {
  const r1 = parsePaytoUri("https://example.com/");
  t.is(r1, undefined);

  const r2 = parsePaytoUri("payto:blabla");
  t.is(r2, undefined);

  const r3 = parsePaytoUri("payto://x-taler-bank/123");
  t.is(r3?.targetType, "x-taler-bank");
  t.is(r3?.targetPath, "123");
});

test("parsing payto and stringify again", (t) => {
  const payto1 =
    "payto://iban/DE1231231231?reciever-name=John%20Doe" as PaytoString;

  t.is(stringifyPaytoUri(parsePaytoUri(payto1)!), payto1);
});
test("parsing payto with % carh", (t) => {
  const payto1 =
    "payto://iban/DE7763544441436?receiver-name=Test%20123%2B-%24%25%5E%3Cem%3Ehi%3C%2Fem%3E" as PaytoString;

  t.is(stringifyPaytoUri(parsePaytoUri(payto1)!), payto1);
});

test("adding payto query params", (t) => {
  const payto1 =
    "payto://iban/DE1231231231?receiver-name=John%20Doe" as PaytoString;
  const out1 = addPaytoQueryParams(payto1, {});
  t.deepEqual(payto1, out1);

  const out2 = addPaytoQueryParams(payto1, {
    foo: "42",
  });
  t.deepEqual(out2, "payto://iban/DE1231231231?receiver-name=John%20Doe&foo=42");
});
