# Hungarian (hu) locale

## `format` and `parse`

| Title                           | Token string | Date                     | `format` result                              | `parse` result           |
| ------------------------------- | ------------ | ------------------------ | -------------------------------------------- | ------------------------ |
| Calendar year                   | yo           | 1987-02-11T12:13:14.015Z | 1987.                                        | 1987-01-01T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5.                                           | 0005-01-01T00:00:00.000Z |
| Local week-numbering year       | Yo           | 1987-02-11T12:13:14.015Z | 1987.                                        | 1986-12-29T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 4.                                           | 0003-12-29T00:00:00.000Z |
| Quarter (formatting)            | Qo           | 2019-01-01T12:13:14.015Z | 1.                                           | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2.                                           | 2019-04-01T00:00:00.000Z |
|                                 | QQQ          | 2019-01-01T12:13:14.015Z | I. n.év                                      | Invalid Date             |
|                                 |              | 2019-04-01T12:13:14.015Z | II. n.év                                     | Invalid Date             |
|                                 | QQQQ         | 2019-01-01T12:13:14.015Z | I. negyedév                                  | Invalid Date             |
|                                 |              | 2019-04-01T12:13:14.015Z | II. negyedév                                 | Invalid Date             |
|                                 | QQQQQ        | 2019-01-01T12:13:14.015Z | I.                                           | Invalid Date             |
|                                 |              | 2019-04-01T12:13:14.015Z | II.                                          | Invalid Date             |
| Quarter (stand-alone)           | qo           | 2019-01-01T12:13:14.015Z | 1.                                           | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2.                                           | 2019-04-01T00:00:00.000Z |
|                                 | qqq          | 2019-01-01T12:13:14.015Z | 1. n.év                                      | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2. n.év                                      | 2019-04-01T00:00:00.000Z |
|                                 | qqqq         | 2019-01-01T12:13:14.015Z | 1. negyedév                                  | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2. negyedév                                  | 2019-04-01T00:00:00.000Z |
| Month (formatting)              | Mo           | 2019-02-11T12:13:14.015Z | 2.                                           | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7.                                           | 2019-07-01T00:00:00.000Z |
|                                 | MMM          | 2019-02-11T12:13:14.015Z | febr.                                        | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | júl.                                         | 2019-07-01T00:00:00.000Z |
|                                 | MMMM         | 2019-02-11T12:13:14.015Z | február                                      | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | július                                       | 2019-07-01T00:00:00.000Z |
|                                 | MMMMM        | 2019-02-11T12:13:14.015Z | F                                            | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | J                                            | 2019-01-01T00:00:00.000Z |
| Month (stand-alone)             | Lo           | 2019-02-11T12:13:14.015Z | 2.                                           | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7.                                           | 2019-07-01T00:00:00.000Z |
|                                 | LLL          | 2019-02-11T12:13:14.015Z | febr.                                        | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | júl.                                         | 2019-07-01T00:00:00.000Z |
|                                 | LLLL         | 2019-02-11T12:13:14.015Z | február                                      | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | július                                       | 2019-07-01T00:00:00.000Z |
|                                 | LLLLL        | 2019-02-11T12:13:14.015Z | F                                            | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | J                                            | 2019-01-01T00:00:00.000Z |
| Local week of year              | wo           | 2019-01-01T12:13:14.015Z | 1.                                           | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48.                                          | 2019-11-25T00:00:00.000Z |
| ISO week of year                | Io           | 2019-01-01T12:13:14.015Z | 1.                                           | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48.                                          | 2019-11-25T00:00:00.000Z |
| Day of month                    | do           | 2019-02-11T12:13:14.015Z | 11.                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28.                                          | 2019-02-28T00:00:00.000Z |
| Day of year                     | Do           | 2019-02-11T12:13:14.015Z | 42.                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-12-31T12:13:14.015Z | 365.                                         | 2019-12-31T00:00:00.000Z |
| Day of week (formatting)        | E            | 2019-02-11T12:13:14.015Z | H                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | P                                            | 2019-02-15T00:00:00.000Z |
|                                 | EE           | 2019-02-11T12:13:14.015Z | H                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | P                                            | 2019-02-15T00:00:00.000Z |
|                                 | EEE          | 2019-02-11T12:13:14.015Z | H                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | P                                            | 2019-02-15T00:00:00.000Z |
|                                 | EEEE         | 2019-02-11T12:13:14.015Z | hétfő                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | péntek                                       | 2019-02-15T00:00:00.000Z |
|                                 | EEEEE        | 2019-02-11T12:13:14.015Z | H                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | P                                            | 2019-02-15T00:00:00.000Z |
|                                 | EEEEEE       | 2019-02-11T12:13:14.015Z | H                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | P                                            | 2019-02-15T00:00:00.000Z |
| ISO day of week (formatting)    | io           | 2019-02-11T12:13:14.015Z | 1.                                           | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5.                                           | 2019-02-15T00:00:00.000Z |
|                                 | iii          | 2019-02-11T12:13:14.015Z | H                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | P                                            | 2019-02-15T00:00:00.000Z |
|                                 | iiii         | 2019-02-11T12:13:14.015Z | hétfő                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | péntek                                       | 2019-02-15T00:00:00.000Z |
|                                 | iiiii        | 2019-02-11T12:13:14.015Z | H                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | P                                            | 2019-02-15T00:00:00.000Z |
|                                 | iiiiii       | 2019-02-11T12:13:14.015Z | H                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | P                                            | 2019-02-15T00:00:00.000Z |
| Local day of week (formatting)  | eo           | 2019-02-11T12:13:14.015Z | 1.                                           | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5.                                           | 2019-02-15T00:00:00.000Z |
|                                 | eee          | 2019-02-11T12:13:14.015Z | H                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | P                                            | 2019-02-15T00:00:00.000Z |
|                                 | eeee         | 2019-02-11T12:13:14.015Z | hétfő                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | péntek                                       | 2019-02-15T00:00:00.000Z |
|                                 | eeeee        | 2019-02-11T12:13:14.015Z | H                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | P                                            | 2019-02-15T00:00:00.000Z |
|                                 | eeeeee       | 2019-02-11T12:13:14.015Z | H                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | P                                            | 2019-02-15T00:00:00.000Z |
| Local day of week (stand-alone) | co           | 2019-02-11T12:13:14.015Z | 1.                                           | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5.                                           | 2019-02-15T00:00:00.000Z |
|                                 | ccc          | 2019-02-11T12:13:14.015Z | H                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | P                                            | 2019-02-15T00:00:00.000Z |
|                                 | cccc         | 2019-02-11T12:13:14.015Z | hétfő                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | péntek                                       | 2019-02-15T00:00:00.000Z |
|                                 | ccccc        | 2019-02-11T12:13:14.015Z | H                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | P                                            | 2019-02-15T00:00:00.000Z |
|                                 | cccccc       | 2019-02-11T12:13:14.015Z | H                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | P                                            | 2019-02-15T00:00:00.000Z |
| AM, PM                          | a            | 2019-02-11T11:13:14.015Z | de.                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | du.                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | du.                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | de.                                          | 2019-02-11T00:00:00.000Z |
|                                 | aa           | 2019-02-11T11:13:14.015Z | de.                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | du.                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | du.                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | de.                                          | 2019-02-11T00:00:00.000Z |
|                                 | aaa          | 2019-02-11T11:13:14.015Z | de.                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | du.                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | du.                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | de.                                          | 2019-02-11T00:00:00.000Z |
|                                 | aaaa         | 2019-02-11T11:13:14.015Z | de.                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | du.                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | du.                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | de.                                          | 2019-02-11T00:00:00.000Z |
|                                 | aaaaa        | 2019-02-11T11:13:14.015Z | de.                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | du.                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | du.                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | de.                                          | 2019-02-11T00:00:00.000Z |
| AM, PM, noon, midnight          | b            | 2019-02-11T11:13:14.015Z | de.                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | du.                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | du.                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | de.                                          | 2019-02-11T00:00:00.000Z |
|                                 | bb           | 2019-02-11T11:13:14.015Z | de.                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | du.                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | du.                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | de.                                          | 2019-02-11T00:00:00.000Z |
|                                 | bbb          | 2019-02-11T11:13:14.015Z | de.                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | du.                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | du.                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | de.                                          | 2019-02-11T00:00:00.000Z |
|                                 | bbbb         | 2019-02-11T11:13:14.015Z | de.                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | du.                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | du.                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | de.                                          | 2019-02-11T00:00:00.000Z |
|                                 | bbbbb        | 2019-02-11T11:13:14.015Z | de.                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | du.                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | du.                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | de.                                          | 2019-02-11T00:00:00.000Z |
| Flexible day period             | B            | 2019-02-11T11:13:14.015Z | reggel                                       | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | du.                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | este                                         | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | éjjel                                        | 2019-02-11T00:00:00.000Z |
|                                 | BB           | 2019-02-11T11:13:14.015Z | reggel                                       | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | du.                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | este                                         | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | éjjel                                        | 2019-02-11T00:00:00.000Z |
|                                 | BBB          | 2019-02-11T11:13:14.015Z | reggel                                       | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | du.                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | este                                         | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | éjjel                                        | 2019-02-11T00:00:00.000Z |
|                                 | BBBB         | 2019-02-11T11:13:14.015Z | reggel                                       | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | délután                                      | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | este                                         | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | éjjel                                        | 2019-02-11T00:00:00.000Z |
|                                 | BBBBB        | 2019-02-11T11:13:14.015Z | reggel                                       | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | du.                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | este                                         | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | éjjel                                        | 2019-02-11T00:00:00.000Z |
| Hour [1-12]                     | ho           | 2019-02-11T11:13:14.015Z | 11.                                          | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11.                                          | 2019-02-11T23:00:00.000Z |
| Hour [0-23]                     | Ho           | 2019-02-11T11:13:14.015Z | 11.                                          | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23.                                          | 2019-02-11T23:00:00.000Z |
| Hour [0-11]                     | Ko           | 2019-02-11T11:13:14.015Z | 11.                                          | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11.                                          | 2019-02-11T23:00:00.000Z |
| Hour [1-24]                     | ko           | 2019-02-11T11:13:14.015Z | 11.                                          | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23.                                          | 2019-02-11T23:00:00.000Z |
| Minute                          | mo           | 2019-01-01T12:01:14.015Z | 1.                                           | 2019-01-01T12:01:00.000Z |
|                                 |              | 2019-04-01T12:55:14.015Z | 55.                                          | 2019-04-01T12:55:00.000Z |
| Second                          | so           | 2019-01-01T12:13:01.015Z | 1.                                           | 2019-01-01T12:13:01.000Z |
|                                 |              | 2019-04-01T12:13:55.015Z | 55.                                          | 2019-04-01T12:13:55.000Z |
| Long localized date             | P            | 1987-02-11T12:13:14.015Z | 1987. 02. 11.                                | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 1453. 05. 29.                                | 1453-05-29T00:00:00.000Z |
|                                 | PP           | 1987-02-11T12:13:14.015Z | 1987. febr. 11.                              | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 1453. máj. 29.                               | 1453-05-29T00:00:00.000Z |
|                                 | PPP          | 1987-02-11T12:13:14.015Z | 1987. február 11.                            | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 1453. május 29.                              | 1453-05-29T00:00:00.000Z |
|                                 | PPPP         | 1987-02-11T12:13:14.015Z | 1987. február 11., szerda                    | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 1453. május 29., vasárnap                    | 1453-05-29T00:00:00.000Z |
| Long localized time             | p            | 1987-02-11T12:13:14.015Z | 12:13                                        | 1987-02-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59                                        | 1453-05-29T23:59:00.000Z |
|                                 | pp           | 1987-02-11T12:13:14.015Z | 12:13:14                                     | 1987-02-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59                                     | 1453-05-29T23:59:59.000Z |
|                                 | ppp          | 1987-02-11T12:13:14.015Z | 12:13:14 GMT+0                               | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59 GMT+0                               | Errored                  |
|                                 | pppp         | 1987-02-11T12:13:14.015Z | 12:13:14 GMT+00:00                           | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59 GMT+00:00                           | Errored                  |
| Combination of date and time    | Pp           | 1987-02-11T12:13:14.015Z | 1987. 02. 11. 12:13                          | 1987-02-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 1453. 05. 29. 23:59                          | 1453-05-29T23:59:00.000Z |
|                                 | PPpp         | 1987-02-11T12:13:14.015Z | 1987. febr. 11. 12:13:14                     | 1987-02-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 1453. máj. 29. 23:59:59                      | 1453-05-29T23:59:59.000Z |
|                                 | PPPppp       | 1987-02-11T12:13:14.015Z | 1987. február 11. 12:13:14 GMT+0             | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 1453. május 29. 23:59:59 GMT+0               | Errored                  |
|                                 | PPPPpppp     | 1987-02-11T12:13:14.015Z | 1987. február 11., szerda 12:13:14 GMT+00:00 | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 1453. május 29., vasárnap 23:59:59 GMT+00:00 | Errored                  |

## `formatDistance`

If now is January 1st, 2000, 00:00.

| Date                     | Result               | `includeSeconds: true`     | `addSuffix: true`               |
| ------------------------ | -------------------- | -------------------------- | ------------------------------- |
| 2006-01-01T00:00:00.000Z | körülbelül 6 év      | körülbelül 6 év            | körülbelül 6 év múlva           |
| 2005-01-01T00:00:00.000Z | körülbelül 5 év      | körülbelül 5 év            | körülbelül 5 év múlva           |
| 2004-01-01T00:00:00.000Z | körülbelül 4 év      | körülbelül 4 év            | körülbelül 4 év múlva           |
| 2003-01-01T00:00:00.000Z | körülbelül 3 év      | körülbelül 3 év            | körülbelül 3 év múlva           |
| 2002-01-01T00:00:00.000Z | körülbelül 2 év      | körülbelül 2 év            | körülbelül 2 év múlva           |
| 2001-06-01T00:00:00.000Z | több mint 1 év       | több mint 1 év             | több mint 1 év múlva            |
| 2001-02-01T00:00:00.000Z | körülbelül 1 év      | körülbelül 1 év            | körülbelül 1 év múlva           |
| 2001-01-01T00:00:00.000Z | körülbelül 1 év      | körülbelül 1 év            | körülbelül 1 év múlva           |
| 2000-06-01T00:00:00.000Z | 5 hónap              | 5 hónap                    | 5 hónap múlva                   |
| 2000-03-01T00:00:00.000Z | 2 hónap              | 2 hónap                    | 2 hónap múlva                   |
| 2000-02-01T00:00:00.000Z | körülbelül 1 hónap   | körülbelül 1 hónap         | körülbelül 1 hónap múlva        |
| 2000-01-15T00:00:00.000Z | 14 nap               | 14 nap                     | 14 nap múlva                    |
| 2000-01-02T00:00:00.000Z | 1 nap                | 1 nap                      | 1 nap múlva                     |
| 2000-01-01T06:00:00.000Z | körülbelül 6 óra     | körülbelül 6 óra           | körülbelül 6 óra múlva          |
| 2000-01-01T01:00:00.000Z | körülbelül 1 óra     | körülbelül 1 óra           | körülbelül 1 óra múlva          |
| 2000-01-01T00:45:00.000Z | körülbelül 1 óra     | körülbelül 1 óra           | körülbelül 1 óra múlva          |
| 2000-01-01T00:30:00.000Z | 30 perc              | 30 perc                    | 30 perc múlva                   |
| 2000-01-01T00:15:00.000Z | 15 perc              | 15 perc                    | 15 perc múlva                   |
| 2000-01-01T00:01:00.000Z | 1 perc               | 1 perc                     | 1 perc múlva                    |
| 2000-01-01T00:00:25.000Z | kevesebb mint 1 perc | fél perc                   | kevesebb mint 1 perc múlva      |
| 2000-01-01T00:00:15.000Z | kevesebb mint 1 perc | kevesebb mint 20 másodperc | kevesebb mint 1 perc múlva      |
| 2000-01-01T00:00:05.000Z | kevesebb mint 1 perc | kevesebb mint 10 másodperc | kevesebb mint 1 perc múlva      |
| 2000-01-01T00:00:00.000Z | kevesebb mint 1 perc | kevesebb mint 5 másodperc  | kevesebb mint 1 perce           |
| 1999-12-31T23:59:55.000Z | kevesebb mint 1 perc | kevesebb mint 10 másodperc | kevesebb mint 1 perccel ezelőtt |
| 1999-12-31T23:59:45.000Z | kevesebb mint 1 perc | kevesebb mint 20 másodperc | kevesebb mint 1 perccel ezelőtt |
| 1999-12-31T23:59:35.000Z | kevesebb mint 1 perc | fél perc                   | kevesebb mint 1 perccel ezelőtt |
| 1999-12-31T23:59:00.000Z | 1 perc               | 1 perc                     | 1 perccel ezelőtt               |
| 1999-12-31T23:45:00.000Z | 15 perc              | 15 perc                    | 15 perccel ezelőtt              |
| 1999-12-31T23:30:00.000Z | 30 perc              | 30 perc                    | 30 perccel ezelőtt              |
| 1999-12-31T23:15:00.000Z | körülbelül 1 óra     | körülbelül 1 óra           | körülbelül 1 órával ezelőtt     |
| 1999-12-31T23:00:00.000Z | körülbelül 1 óra     | körülbelül 1 óra           | körülbelül 1 órával ezelőtt     |
| 1999-12-31T18:00:00.000Z | körülbelül 6 óra     | körülbelül 6 óra           | körülbelül 6 órával ezelőtt     |
| 1999-12-30T00:00:00.000Z | 2 nap                | 2 nap                      | 2 nappal ezelőtt                |
| 1999-12-15T00:00:00.000Z | 17 nap               | 17 nap                     | 17 nappal ezelőtt               |
| 1999-12-01T00:00:00.000Z | körülbelül 1 hónap   | körülbelül 1 hónap         | körülbelül 1 hónappal ezelőtt   |
| 1999-11-01T00:00:00.000Z | 2 hónap              | 2 hónap                    | 2 hónappal ezelőtt              |
| 1999-06-01T00:00:00.000Z | 7 hónap              | 7 hónap                    | 7 hónappal ezelőtt              |
| 1999-01-01T00:00:00.000Z | körülbelül 1 év      | körülbelül 1 év            | körülbelül 1 évvel ezelőtt      |
| 1998-12-01T00:00:00.000Z | körülbelül 1 év      | körülbelül 1 év            | körülbelül 1 évvel ezelőtt      |
| 1998-06-01T00:00:00.000Z | több mint 1 év       | több mint 1 év             | több mint 1 évvel ezelőtt       |
| 1998-01-01T00:00:00.000Z | körülbelül 2 év      | körülbelül 2 év            | körülbelül 2 évvel ezelőtt      |
| 1997-01-01T00:00:00.000Z | körülbelül 3 év      | körülbelül 3 év            | körülbelül 3 évvel ezelőtt      |
| 1996-01-01T00:00:00.000Z | körülbelül 4 év      | körülbelül 4 év            | körülbelül 4 évvel ezelőtt      |
| 1995-01-01T00:00:00.000Z | körülbelül 5 év      | körülbelül 5 év            | körülbelül 5 évvel ezelőtt      |
| 1994-01-01T00:00:00.000Z | körülbelül 6 év      | körülbelül 6 év            | körülbelül 6 évvel ezelőtt      |

## `formatDistanceStrict`

If now is January 1st, 2000, 00:00.

| Date                     | Result       | `addSuffix: true`       | With forced unit (i.e. `hour`) |
| ------------------------ | ------------ | ----------------------- | ------------------------------ |
| 2006-01-01T00:00:00.000Z | 6 év         | 6 év múlva              | 52608 óra                      |
| 2005-01-01T00:00:00.000Z | 5 év         | 5 év múlva              | 43848 óra                      |
| 2004-01-01T00:00:00.000Z | 4 év         | 4 év múlva              | 35064 óra                      |
| 2003-01-01T00:00:00.000Z | 3 év         | 3 év múlva              | 26304 óra                      |
| 2002-01-01T00:00:00.000Z | 2 év         | 2 év múlva              | 17544 óra                      |
| 2001-06-01T00:00:00.000Z | 1 év         | 1 év múlva              | 12408 óra                      |
| 2001-02-01T00:00:00.000Z | 1 év         | 1 év múlva              | 9528 óra                       |
| 2001-01-01T00:00:00.000Z | 1 év         | 1 év múlva              | 8784 óra                       |
| 2000-06-01T00:00:00.000Z | 5 hónap      | 5 hónap múlva           | 3648 óra                       |
| 2000-03-01T00:00:00.000Z | 2 hónap      | 2 hónap múlva           | 1440 óra                       |
| 2000-02-01T00:00:00.000Z | 1 hónap      | 1 hónap múlva           | 744 óra                        |
| 2000-01-15T00:00:00.000Z | 14 nap       | 14 nap múlva            | 336 óra                        |
| 2000-01-02T00:00:00.000Z | 1 nap        | 1 nap múlva             | 24 óra                         |
| 2000-01-01T06:00:00.000Z | 6 óra        | 6 óra múlva             | 6 óra                          |
| 2000-01-01T01:00:00.000Z | 1 óra        | 1 óra múlva             | 1 óra                          |
| 2000-01-01T00:45:00.000Z | 45 perc      | 45 perc múlva           | 1 óra                          |
| 2000-01-01T00:30:00.000Z | 30 perc      | 30 perc múlva           | 1 óra                          |
| 2000-01-01T00:15:00.000Z | 15 perc      | 15 perc múlva           | 0 óra                          |
| 2000-01-01T00:01:00.000Z | 1 perc       | 1 perc múlva            | 0 óra                          |
| 2000-01-01T00:00:25.000Z | 25 másodperc | 25 másodperc múlva      | 0 óra                          |
| 2000-01-01T00:00:15.000Z | 15 másodperc | 15 másodperc múlva      | 0 óra                          |
| 2000-01-01T00:00:05.000Z | 5 másodperc  | 5 másodperc múlva       | 0 óra                          |
| 2000-01-01T00:00:00.000Z | 0 másodperc  | 0 másodperce            | 0 óra                          |
| 1999-12-31T23:59:55.000Z | 5 másodperc  | 5 másodperccel ezelőtt  | 0 óra                          |
| 1999-12-31T23:59:45.000Z | 15 másodperc | 15 másodperccel ezelőtt | 0 óra                          |
| 1999-12-31T23:59:35.000Z | 25 másodperc | 25 másodperccel ezelőtt | 0 óra                          |
| 1999-12-31T23:59:00.000Z | 1 perc       | 1 perccel ezelőtt       | 0 óra                          |
| 1999-12-31T23:45:00.000Z | 15 perc      | 15 perccel ezelőtt      | 0 óra                          |
| 1999-12-31T23:30:00.000Z | 30 perc      | 30 perccel ezelőtt      | 1 óra                          |
| 1999-12-31T23:15:00.000Z | 45 perc      | 45 perccel ezelőtt      | 1 óra                          |
| 1999-12-31T23:00:00.000Z | 1 óra        | 1 órával ezelőtt        | 1 óra                          |
| 1999-12-31T18:00:00.000Z | 6 óra        | 6 órával ezelőtt        | 6 óra                          |
| 1999-12-30T00:00:00.000Z | 2 nap        | 2 nappal ezelőtt        | 48 óra                         |
| 1999-12-15T00:00:00.000Z | 17 nap       | 17 nappal ezelőtt       | 408 óra                        |
| 1999-12-01T00:00:00.000Z | 1 hónap      | 1 hónappal ezelőtt      | 744 óra                        |
| 1999-11-01T00:00:00.000Z | 2 hónap      | 2 hónappal ezelőtt      | 1464 óra                       |
| 1999-06-01T00:00:00.000Z | 7 hónap      | 7 hónappal ezelőtt      | 5136 óra                       |
| 1999-01-01T00:00:00.000Z | 1 év         | 1 évvel ezelőtt         | 8760 óra                       |
| 1998-12-01T00:00:00.000Z | 1 év         | 1 évvel ezelőtt         | 9504 óra                       |
| 1998-06-01T00:00:00.000Z | 2 év         | 2 évvel ezelőtt         | 13896 óra                      |
| 1998-01-01T00:00:00.000Z | 2 év         | 2 évvel ezelőtt         | 17520 óra                      |
| 1997-01-01T00:00:00.000Z | 3 év         | 3 évvel ezelőtt         | 26280 óra                      |
| 1996-01-01T00:00:00.000Z | 4 év         | 4 évvel ezelőtt         | 35064 óra                      |
| 1995-01-01T00:00:00.000Z | 5 év         | 5 évvel ezelőtt         | 43824 óra                      |
| 1994-01-01T00:00:00.000Z | 6 év         | 6 évvel ezelőtt         | 52584 óra                      |

## `formatRelative`

If now is January 1st, 2000, 00:00.

| Date                     | Result               |
| ------------------------ | -------------------- |
| 2000-01-10T00:00:00.000Z | 2000. 01. 10.        |
| 2000-01-05T00:00:00.000Z | szerdán 0:00-kor     |
| 2000-01-02T00:00:00.000Z | holnap 0:00-kor      |
| 2000-01-01T00:00:00.000Z | ma 0:00-kor          |
| 1999-12-31T00:00:00.000Z | tegnap 0:00-kor      |
| 1999-12-27T00:00:00.000Z | múlt hétfőn 0:00-kor |
| 1999-12-21T00:00:00.000Z | 1999. 12. 21.        |
