/*
 This file is part of GNU Taler
 (C) 2019 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

/**
 * Helpers to create headless wallets.
 * @author Florian Dold <dold@taler.net>
 */

/**
 * Imports.
 */
import type { AccessStats, IDBFactory } from "@gnu-taler/idb-bridge";
import { DefaultNodeWalletArgs } from "./host-common.js";
import { Wallet } from "./index.js";

/**
 * Get a wallet instance with default settings for node.
 *
 * Extended version that allows getting DB stats.
 */
export async function createNativeWalletHost2(
  args: DefaultNodeWalletArgs = {},
): Promise<{
  wallet: Wallet;
  getDbStats: () => AccessStats;
}> {
  throw Error("not implemented");
}
