# Moroccan Arabic (ar-MA) locale

## `format` and `parse`

| Title                           | Token string | Date                     | `format` result                                    | `parse` result           |
| ------------------------------- | ------------ | ------------------------ | -------------------------------------------------- | ------------------------ |
| Calendar year                   | yo           | 1987-02-11T12:13:14.015Z | 1987                                               | 1987-01-01T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5                                                  | 0005-01-01T00:00:00.000Z |
| Local week-numbering year       | Yo           | 1987-02-11T12:13:14.015Z | 1987                                               | 1986-12-29T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5                                                  | 0004-12-27T00:00:00.000Z |
| Quarter (formatting)            | Qo           | 2019-01-01T12:13:14.015Z | 1                                                  | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                                  | 2019-04-01T00:00:00.000Z |
|                                 | QQQ          | 2019-01-01T12:13:14.015Z | ر1                                                 | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | ر2                                                 | 2019-04-01T00:00:00.000Z |
|                                 | QQQQ         | 2019-01-01T12:13:14.015Z | الربع الأول                                        | Invalid Date             |
|                                 |              | 2019-04-01T12:13:14.015Z | الربع الثاني                                       | Invalid Date             |
|                                 | QQQQQ        | 2019-01-01T12:13:14.015Z | 1                                                  | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                                  | 2019-04-01T00:00:00.000Z |
| Quarter (stand-alone)           | qo           | 2019-01-01T12:13:14.015Z | 1                                                  | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                                  | 2019-04-01T00:00:00.000Z |
|                                 | qqq          | 2019-01-01T12:13:14.015Z | ر1                                                 | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | ر2                                                 | 2019-04-01T00:00:00.000Z |
|                                 | qqqq         | 2019-01-01T12:13:14.015Z | الربع الأول                                        | Invalid Date             |
|                                 |              | 2019-04-01T12:13:14.015Z | الربع الثاني                                       | Invalid Date             |
| Month (formatting)              | Mo           | 2019-02-11T12:13:14.015Z | 2                                                  | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7                                                  | 2019-07-01T00:00:00.000Z |
|                                 | MMM          | 2019-02-11T12:13:14.015Z | فبر                                                | Invalid Date             |
|                                 |              | 2019-07-10T12:13:14.015Z | يولـ                                               | Invalid Date             |
|                                 | MMMM         | 2019-02-11T12:13:14.015Z | فبراير                                             | Invalid Date             |
|                                 |              | 2019-07-10T12:13:14.015Z | يوليوز                                             | Invalid Date             |
|                                 | MMMMM        | 2019-02-11T12:13:14.015Z | ف                                                  | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | ي                                                  | 2019-01-01T00:00:00.000Z |
| Month (stand-alone)             | Lo           | 2019-02-11T12:13:14.015Z | 2                                                  | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7                                                  | 2019-07-01T00:00:00.000Z |
|                                 | LLL          | 2019-02-11T12:13:14.015Z | فبر                                                | Invalid Date             |
|                                 |              | 2019-07-10T12:13:14.015Z | يولـ                                               | Invalid Date             |
|                                 | LLLL         | 2019-02-11T12:13:14.015Z | فبراير                                             | Invalid Date             |
|                                 |              | 2019-07-10T12:13:14.015Z | يوليوز                                             | Invalid Date             |
|                                 | LLLLL        | 2019-02-11T12:13:14.015Z | ف                                                  | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | ي                                                  | 2019-01-01T00:00:00.000Z |
| Local week of year              | wo           | 2019-01-01T12:13:14.015Z | 1                                                  | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48                                                 | 2019-11-25T00:00:00.000Z |
| ISO week of year                | Io           | 2019-01-01T12:13:14.015Z | 1                                                  | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48                                                 | 2019-11-25T00:00:00.000Z |
| Day of month                    | do           | 2019-02-11T12:13:14.015Z | 11                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28                                                 | 2019-02-28T00:00:00.000Z |
| Day of year                     | Do           | 2019-02-11T12:13:14.015Z | 42                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-12-31T12:13:14.015Z | 365                                                | 2019-12-31T00:00:00.000Z |
| Day of week (formatting)        | E            | 2019-02-11T12:13:14.015Z | اثنـ                                               | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | جمعة                                               | 2019-02-15T00:00:00.000Z |
|                                 | EE           | 2019-02-11T12:13:14.015Z | اثنـ                                               | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | جمعة                                               | 2019-02-15T00:00:00.000Z |
|                                 | EEE          | 2019-02-11T12:13:14.015Z | اثنـ                                               | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | جمعة                                               | 2019-02-15T00:00:00.000Z |
|                                 | EEEE         | 2019-02-11T12:13:14.015Z | الإثنين                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | الجمعة                                             | 2019-02-15T00:00:00.000Z |
|                                 | EEEEE        | 2019-02-11T12:13:14.015Z | ن                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ج                                                  | 2019-02-15T00:00:00.000Z |
|                                 | EEEEEE       | 2019-02-11T12:13:14.015Z | اثنين                                              | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | جمعة                                               | 2019-02-15T00:00:00.000Z |
| ISO day of week (formatting)    | io           | 2019-02-11T12:13:14.015Z | 1                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5                                                  | 2019-02-15T00:00:00.000Z |
|                                 | iii          | 2019-02-11T12:13:14.015Z | اثنـ                                               | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | جمعة                                               | 2019-02-15T00:00:00.000Z |
|                                 | iiii         | 2019-02-11T12:13:14.015Z | الإثنين                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | الجمعة                                             | 2019-02-15T00:00:00.000Z |
|                                 | iiiii        | 2019-02-11T12:13:14.015Z | ن                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ج                                                  | 2019-02-15T00:00:00.000Z |
|                                 | iiiiii       | 2019-02-11T12:13:14.015Z | اثنين                                              | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | جمعة                                               | 2019-02-15T00:00:00.000Z |
| Local day of week (formatting)  | eo           | 2019-02-11T12:13:14.015Z | 1                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5                                                  | 2019-02-15T00:00:00.000Z |
|                                 | eee          | 2019-02-11T12:13:14.015Z | اثنـ                                               | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | جمعة                                               | 2019-02-15T00:00:00.000Z |
|                                 | eeee         | 2019-02-11T12:13:14.015Z | الإثنين                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | الجمعة                                             | 2019-02-15T00:00:00.000Z |
|                                 | eeeee        | 2019-02-11T12:13:14.015Z | ن                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ج                                                  | 2019-02-15T00:00:00.000Z |
|                                 | eeeeee       | 2019-02-11T12:13:14.015Z | اثنين                                              | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | جمعة                                               | 2019-02-15T00:00:00.000Z |
| Local day of week (stand-alone) | co           | 2019-02-11T12:13:14.015Z | 1                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5                                                  | 2019-02-15T00:00:00.000Z |
|                                 | ccc          | 2019-02-11T12:13:14.015Z | اثنـ                                               | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | جمعة                                               | 2019-02-15T00:00:00.000Z |
|                                 | cccc         | 2019-02-11T12:13:14.015Z | الإثنين                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | الجمعة                                             | 2019-02-15T00:00:00.000Z |
|                                 | ccccc        | 2019-02-11T12:13:14.015Z | ن                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ج                                                  | 2019-02-15T00:00:00.000Z |
|                                 | cccccc       | 2019-02-11T12:13:14.015Z | اثنين                                              | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | جمعة                                               | 2019-02-15T00:00:00.000Z |
| AM, PM                          | a            | 2019-02-11T11:13:14.015Z | ص                                                  | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | م                                                  | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | م                                                  | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | ص                                                  | Invalid Date             |
|                                 | aa           | 2019-02-11T11:13:14.015Z | ص                                                  | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | م                                                  | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | م                                                  | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | ص                                                  | Invalid Date             |
|                                 | aaa          | 2019-02-11T11:13:14.015Z | ص                                                  | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | م                                                  | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | م                                                  | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | ص                                                  | Invalid Date             |
|                                 | aaaa         | 2019-02-11T11:13:14.015Z | ص                                                  | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | م                                                  | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | م                                                  | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | ص                                                  | Invalid Date             |
|                                 | aaaaa        | 2019-02-11T11:13:14.015Z | ص                                                  | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | م                                                  | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | م                                                  | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | ص                                                  | Invalid Date             |
| AM, PM, noon, midnight          | b            | 2019-02-11T11:13:14.015Z | ص                                                  | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | م                                                  | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | م                                                  | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | ص                                                  | Invalid Date             |
|                                 | bb           | 2019-02-11T11:13:14.015Z | ص                                                  | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | م                                                  | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | م                                                  | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | ص                                                  | Invalid Date             |
|                                 | bbb          | 2019-02-11T11:13:14.015Z | ص                                                  | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | م                                                  | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | م                                                  | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | ص                                                  | Invalid Date             |
|                                 | bbbb         | 2019-02-11T11:13:14.015Z | ص                                                  | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | م                                                  | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | م                                                  | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | ص                                                  | Invalid Date             |
|                                 | bbbbb        | 2019-02-11T11:13:14.015Z | ص                                                  | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | م                                                  | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | م                                                  | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | ص                                                  | Invalid Date             |
| Flexible day period             | B            | 2019-02-11T11:13:14.015Z | في الصباح                                          | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z |                                                    | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | في المساء                                          | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | في الليل                                           | Invalid Date             |
|                                 | BB           | 2019-02-11T11:13:14.015Z | في الصباح                                          | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z |                                                    | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | في المساء                                          | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | في الليل                                           | Invalid Date             |
|                                 | BBB          | 2019-02-11T11:13:14.015Z | في الصباح                                          | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z |                                                    | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | في المساء                                          | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | في الليل                                           | Invalid Date             |
|                                 | BBBB         | 2019-02-11T11:13:14.015Z |                                                    | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | بعد الظـهر                                         | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | في المساء                                          | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | في الليل                                           | Invalid Date             |
|                                 | BBBBB        | 2019-02-11T11:13:14.015Z | في الصباح                                          | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | بعد الظـهر                                         | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | في المساء                                          | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | في الليل                                           | Invalid Date             |
| Hour [1-12]                     | ho           | 2019-02-11T11:13:14.015Z | 11                                                 | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11                                                 | 2019-02-11T23:00:00.000Z |
| Hour [0-23]                     | Ho           | 2019-02-11T11:13:14.015Z | 11                                                 | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23                                                 | 2019-02-11T23:00:00.000Z |
| Hour [0-11]                     | Ko           | 2019-02-11T11:13:14.015Z | 11                                                 | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11                                                 | 2019-02-11T23:00:00.000Z |
| Hour [1-24]                     | ko           | 2019-02-11T11:13:14.015Z | 11                                                 | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23                                                 | 2019-02-11T23:00:00.000Z |
| Minute                          | mo           | 2019-01-01T12:01:14.015Z | 1                                                  | 2019-01-01T12:01:00.000Z |
|                                 |              | 2019-04-01T12:55:14.015Z | 55                                                 | 2019-04-01T12:55:00.000Z |
| Second                          | so           | 2019-01-01T12:13:01.015Z | 1                                                  | 2019-01-01T12:13:01.000Z |
|                                 |              | 2019-04-01T12:13:55.015Z | 55                                                 | 2019-04-01T12:13:55.000Z |
| Long localized date             | P            | 1987-02-11T12:13:14.015Z | 02/11/1987                                         | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 05/29/1453                                         | 1453-05-29T00:00:00.000Z |
|                                 | PP           | 1987-02-11T12:13:14.015Z | فبر 11, 1987                                       | Invalid Date             |
|                                 |              | 1453-05-29T23:59:59.999Z | ماي 29, 1453                                       | 1453-05-29T00:00:00.000Z |
|                                 | PPP          | 1987-02-11T12:13:14.015Z | فبراير 11, 1987                                    | Invalid Date             |
|                                 |              | 1453-05-29T23:59:59.999Z | ماي 29, 1453                                       | 1453-05-29T00:00:00.000Z |
|                                 | PPPP         | 1987-02-11T12:13:14.015Z | الأربعاء, فبراير 11, 1987                          | Invalid Date             |
|                                 |              | 1453-05-29T23:59:59.999Z | الأحد, ماي 29, 1453                                | 1453-05-29T00:00:00.000Z |
| Long localized time             | p            | 1987-02-11T12:13:14.015Z | 12:13 م                                            | Invalid Date             |
|                                 |              | 1453-05-29T23:59:59.999Z | 11:59 م                                            | Invalid Date             |
|                                 | pp           | 1987-02-11T12:13:14.015Z | 12:13:14 م                                         | Invalid Date             |
|                                 |              | 1453-05-29T23:59:59.999Z | 11:59:59 م                                         | Invalid Date             |
|                                 | ppp          | 1987-02-11T12:13:14.015Z | 12:13:14 م GMT+0                                   | Invalid Date             |
|                                 |              | 1453-05-29T23:59:59.999Z | 11:59:59 م GMT+0                                   | Invalid Date             |
|                                 | pppp         | 1987-02-11T12:13:14.015Z | 12:13:14 م GMT+00:00                               | Invalid Date             |
|                                 |              | 1453-05-29T23:59:59.999Z | 11:59:59 م GMT+00:00                               | Invalid Date             |
| Combination of date and time    | Pp           | 1987-02-11T12:13:14.015Z | 02/11/1987, 12:13 م                                | Invalid Date             |
|                                 |              | 1453-05-29T23:59:59.999Z | 05/29/1453, 11:59 م                                | Invalid Date             |
|                                 | PPpp         | 1987-02-11T12:13:14.015Z | فبر 11, 1987, 12:13:14 م                           | Invalid Date             |
|                                 |              | 1453-05-29T23:59:59.999Z | ماي 29, 1453, 11:59:59 م                           | Invalid Date             |
|                                 | PPPppp       | 1987-02-11T12:13:14.015Z | فبراير 11, 1987 عند 12:13:14 م GMT+0               | Invalid Date             |
|                                 |              | 1453-05-29T23:59:59.999Z | ماي 29, 1453 عند 11:59:59 م GMT+0                  | Invalid Date             |
|                                 | PPPPpppp     | 1987-02-11T12:13:14.015Z | الأربعاء, فبراير 11, 1987 عند 12:13:14 م GMT+00:00 | Invalid Date             |
|                                 |              | 1453-05-29T23:59:59.999Z | الأحد, ماي 29, 1453 عند 11:59:59 م GMT+00:00       | Invalid Date             |

## `formatDistance`

If now is January 1st, 2000, 00:00.

| Date                     | Result             | `includeSeconds: true` | `addSuffix: true`          |
| ------------------------ | ------------------ | ---------------------- | -------------------------- |
| 2006-01-01T00:00:00.000Z | 6 أعوام تقريباً    | 6 أعوام تقريباً        | في خلال 6 أعوام تقريباً    |
| 2005-01-01T00:00:00.000Z | 5 أعوام تقريباً    | 5 أعوام تقريباً        | في خلال 5 أعوام تقريباً    |
| 2004-01-01T00:00:00.000Z | 4 أعوام تقريباً    | 4 أعوام تقريباً        | في خلال 4 أعوام تقريباً    |
| 2003-01-01T00:00:00.000Z | 3 أعوام تقريباً    | 3 أعوام تقريباً        | في خلال 3 أعوام تقريباً    |
| 2002-01-01T00:00:00.000Z | عامين تقريباً      | عامين تقريباً          | في خلال عامين تقريباً      |
| 2001-06-01T00:00:00.000Z | أكثر من عام        | أكثر من عام            | في خلال أكثر من عام        |
| 2001-02-01T00:00:00.000Z | عام واحد تقريباً   | عام واحد تقريباً       | في خلال عام واحد تقريباً   |
| 2001-01-01T00:00:00.000Z | عام واحد تقريباً   | عام واحد تقريباً       | في خلال عام واحد تقريباً   |
| 2000-06-01T00:00:00.000Z | 5 أشهر             | 5 أشهر                 | في خلال 5 أشهر             |
| 2000-03-01T00:00:00.000Z | شهرين              | شهرين                  | في خلال شهرين              |
| 2000-02-01T00:00:00.000Z | شهر واحد تقريباً   | شهر واحد تقريباً       | في خلال شهر واحد تقريباً   |
| 2000-01-15T00:00:00.000Z | 14 يوم             | 14 يوم                 | في خلال 14 يوم             |
| 2000-01-02T00:00:00.000Z | يوم واحد           | يوم واحد               | في خلال يوم واحد           |
| 2000-01-01T06:00:00.000Z | 6 ساعات تقريباً    | 6 ساعات تقريباً        | في خلال 6 ساعات تقريباً    |
| 2000-01-01T01:00:00.000Z | ساعة واحدة تقريباً | ساعة واحدة تقريباً     | في خلال ساعة واحدة تقريباً |
| 2000-01-01T00:45:00.000Z | ساعة واحدة تقريباً | ساعة واحدة تقريباً     | في خلال ساعة واحدة تقريباً |
| 2000-01-01T00:30:00.000Z | 30 دقيقة           | 30 دقيقة               | في خلال 30 دقيقة           |
| 2000-01-01T00:15:00.000Z | 15 دقيقة           | 15 دقيقة               | في خلال 15 دقيقة           |
| 2000-01-01T00:01:00.000Z | دقيقة واحدة        | دقيقة واحدة            | في خلال دقيقة واحدة        |
| 2000-01-01T00:00:25.000Z | أقل من دقيقة       | نصف دقيقة              | في خلال أقل من دقيقة       |
| 2000-01-01T00:00:15.000Z | أقل من دقيقة       | أقل من 20 ثانية        | في خلال أقل من دقيقة       |
| 2000-01-01T00:00:05.000Z | أقل من دقيقة       | أقل من 10 ثواني        | في خلال أقل من دقيقة       |
| 2000-01-01T00:00:00.000Z | أقل من دقيقة       | أقل من 5 ثواني         | منذ أقل من دقيقة           |
| 1999-12-31T23:59:55.000Z | أقل من دقيقة       | أقل من 10 ثواني        | منذ أقل من دقيقة           |
| 1999-12-31T23:59:45.000Z | أقل من دقيقة       | أقل من 20 ثانية        | منذ أقل من دقيقة           |
| 1999-12-31T23:59:35.000Z | أقل من دقيقة       | نصف دقيقة              | منذ أقل من دقيقة           |
| 1999-12-31T23:59:00.000Z | دقيقة واحدة        | دقيقة واحدة            | منذ دقيقة واحدة            |
| 1999-12-31T23:45:00.000Z | 15 دقيقة           | 15 دقيقة               | منذ 15 دقيقة               |
| 1999-12-31T23:30:00.000Z | 30 دقيقة           | 30 دقيقة               | منذ 30 دقيقة               |
| 1999-12-31T23:15:00.000Z | ساعة واحدة تقريباً | ساعة واحدة تقريباً     | منذ ساعة واحدة تقريباً     |
| 1999-12-31T23:00:00.000Z | ساعة واحدة تقريباً | ساعة واحدة تقريباً     | منذ ساعة واحدة تقريباً     |
| 1999-12-31T18:00:00.000Z | 6 ساعات تقريباً    | 6 ساعات تقريباً        | منذ 6 ساعات تقريباً        |
| 1999-12-30T00:00:00.000Z | يومين              | يومين                  | منذ يومين                  |
| 1999-12-15T00:00:00.000Z | 17 يوم             | 17 يوم                 | منذ 17 يوم                 |
| 1999-12-01T00:00:00.000Z | شهر واحد تقريباً   | شهر واحد تقريباً       | منذ شهر واحد تقريباً       |
| 1999-11-01T00:00:00.000Z | شهرين              | شهرين                  | منذ شهرين                  |
| 1999-06-01T00:00:00.000Z | 7 أشهر             | 7 أشهر                 | منذ 7 أشهر                 |
| 1999-01-01T00:00:00.000Z | عام واحد تقريباً   | عام واحد تقريباً       | منذ عام واحد تقريباً       |
| 1998-12-01T00:00:00.000Z | عام واحد تقريباً   | عام واحد تقريباً       | منذ عام واحد تقريباً       |
| 1998-06-01T00:00:00.000Z | أكثر من عام        | أكثر من عام            | منذ أكثر من عام            |
| 1998-01-01T00:00:00.000Z | عامين تقريباً      | عامين تقريباً          | منذ عامين تقريباً          |
| 1997-01-01T00:00:00.000Z | 3 أعوام تقريباً    | 3 أعوام تقريباً        | منذ 3 أعوام تقريباً        |
| 1996-01-01T00:00:00.000Z | 4 أعوام تقريباً    | 4 أعوام تقريباً        | منذ 4 أعوام تقريباً        |
| 1995-01-01T00:00:00.000Z | 5 أعوام تقريباً    | 5 أعوام تقريباً        | منذ 5 أعوام تقريباً        |
| 1994-01-01T00:00:00.000Z | 6 أعوام تقريباً    | 6 أعوام تقريباً        | منذ 6 أعوام تقريباً        |

## `formatDistanceStrict`

If now is January 1st, 2000, 00:00.

| Date                     | Result      | `addSuffix: true`   | With forced unit (i.e. `hour`) |
| ------------------------ | ----------- | ------------------- | ------------------------------ |
| 2006-01-01T00:00:00.000Z | 6 أعوام     | في خلال 6 أعوام     | 52608 ساعة                     |
| 2005-01-01T00:00:00.000Z | 5 أعوام     | في خلال 5 أعوام     | 43848 ساعة                     |
| 2004-01-01T00:00:00.000Z | 4 أعوام     | في خلال 4 أعوام     | 35064 ساعة                     |
| 2003-01-01T00:00:00.000Z | 3 أعوام     | في خلال 3 أعوام     | 26304 ساعة                     |
| 2002-01-01T00:00:00.000Z | عامين       | في خلال عامين       | 17544 ساعة                     |
| 2001-06-01T00:00:00.000Z | عام واحد    | في خلال عام واحد    | 12408 ساعة                     |
| 2001-02-01T00:00:00.000Z | عام واحد    | في خلال عام واحد    | 9528 ساعة                      |
| 2001-01-01T00:00:00.000Z | عام واحد    | في خلال عام واحد    | 8784 ساعة                      |
| 2000-06-01T00:00:00.000Z | 5 أشهر      | في خلال 5 أشهر      | 3648 ساعة                      |
| 2000-03-01T00:00:00.000Z | شهرين       | في خلال شهرين       | 1440 ساعة                      |
| 2000-02-01T00:00:00.000Z | شهر واحد    | في خلال شهر واحد    | 744 ساعة                       |
| 2000-01-15T00:00:00.000Z | 14 يوم      | في خلال 14 يوم      | 336 ساعة                       |
| 2000-01-02T00:00:00.000Z | يوم واحد    | في خلال يوم واحد    | 24 ساعة                        |
| 2000-01-01T06:00:00.000Z | 6 ساعات     | في خلال 6 ساعات     | 6 ساعات                        |
| 2000-01-01T01:00:00.000Z | ساعة واحدة  | في خلال ساعة واحدة  | ساعة واحدة                     |
| 2000-01-01T00:45:00.000Z | 45 دقيقة    | في خلال 45 دقيقة    | ساعة واحدة                     |
| 2000-01-01T00:30:00.000Z | 30 دقيقة    | في خلال 30 دقيقة    | ساعة واحدة                     |
| 2000-01-01T00:15:00.000Z | 15 دقيقة    | في خلال 15 دقيقة    | 0 ساعات                        |
| 2000-01-01T00:01:00.000Z | دقيقة واحدة | في خلال دقيقة واحدة | 0 ساعات                        |
| 2000-01-01T00:00:25.000Z | 25 ثانية    | في خلال 25 ثانية    | 0 ساعات                        |
| 2000-01-01T00:00:15.000Z | 15 ثانية    | في خلال 15 ثانية    | 0 ساعات                        |
| 2000-01-01T00:00:05.000Z | 5 ثواني     | في خلال 5 ثواني     | 0 ساعات                        |
| 2000-01-01T00:00:00.000Z | 0 ثواني     | منذ 0 ثواني         | 0 ساعات                        |
| 1999-12-31T23:59:55.000Z | 5 ثواني     | منذ 5 ثواني         | 0 ساعات                        |
| 1999-12-31T23:59:45.000Z | 15 ثانية    | منذ 15 ثانية        | 0 ساعات                        |
| 1999-12-31T23:59:35.000Z | 25 ثانية    | منذ 25 ثانية        | 0 ساعات                        |
| 1999-12-31T23:59:00.000Z | دقيقة واحدة | منذ دقيقة واحدة     | 0 ساعات                        |
| 1999-12-31T23:45:00.000Z | 15 دقيقة    | منذ 15 دقيقة        | 0 ساعات                        |
| 1999-12-31T23:30:00.000Z | 30 دقيقة    | منذ 30 دقيقة        | ساعة واحدة                     |
| 1999-12-31T23:15:00.000Z | 45 دقيقة    | منذ 45 دقيقة        | ساعة واحدة                     |
| 1999-12-31T23:00:00.000Z | ساعة واحدة  | منذ ساعة واحدة      | ساعة واحدة                     |
| 1999-12-31T18:00:00.000Z | 6 ساعات     | منذ 6 ساعات         | 6 ساعات                        |
| 1999-12-30T00:00:00.000Z | يومين       | منذ يومين           | 48 ساعة                        |
| 1999-12-15T00:00:00.000Z | 17 يوم      | منذ 17 يوم          | 408 ساعة                       |
| 1999-12-01T00:00:00.000Z | شهر واحد    | منذ شهر واحد        | 744 ساعة                       |
| 1999-11-01T00:00:00.000Z | شهرين       | منذ شهرين           | 1464 ساعة                      |
| 1999-06-01T00:00:00.000Z | 7 أشهر      | منذ 7 أشهر          | 5136 ساعة                      |
| 1999-01-01T00:00:00.000Z | عام واحد    | منذ عام واحد        | 8760 ساعة                      |
| 1998-12-01T00:00:00.000Z | عام واحد    | منذ عام واحد        | 9504 ساعة                      |
| 1998-06-01T00:00:00.000Z | عامين       | منذ عامين           | 13896 ساعة                     |
| 1998-01-01T00:00:00.000Z | عامين       | منذ عامين           | 17520 ساعة                     |
| 1997-01-01T00:00:00.000Z | 3 أعوام     | منذ 3 أعوام         | 26280 ساعة                     |
| 1996-01-01T00:00:00.000Z | 4 أعوام     | منذ 4 أعوام         | 35064 ساعة                     |
| 1995-01-01T00:00:00.000Z | 5 أعوام     | منذ 5 أعوام         | 43824 ساعة                     |
| 1994-01-01T00:00:00.000Z | 6 أعوام     | منذ 6 أعوام         | 52584 ساعة                     |

## `formatRelative`

If now is January 1st, 2000, 00:00.

| Date                     | Result                  |
| ------------------------ | ----------------------- |
| 2000-01-10T00:00:00.000Z | 01/10/2000              |
| 2000-01-05T00:00:00.000Z | الأربعاء عند 12:00 ص    |
| 2000-01-02T00:00:00.000Z | غداً عند 12:00 ص        |
| 2000-01-01T00:00:00.000Z | اليوم عند 12:00 ص       |
| 1999-12-31T00:00:00.000Z | أمس عند 12:00 ص         |
| 1999-12-27T00:00:00.000Z | أخر الإثنين عند 12:00 ص |
| 1999-12-21T00:00:00.000Z | 12/21/1999              |
