/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, {
/******/ 				configurable: false,
/******/ 				enumerable: true,
/******/ 				get: getter
/******/ 			});
/******/ 		}
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 8);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*
 This file is part of TALER
 (C) 2018 GNUnet e.V. and INRIA

 TALER is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 TALER is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Types and helper functions for dealing with Taler amounts.
 */
/**
 * Imports.
 */
const checkable_1 = __webpack_require__(1);
/**
 * Number of fractional units that one value unit represents.
 */
exports.fractionalBase = 1e8;
/**
 * Non-negative financial amount.  Fractional values are expressed as multiples
 * of 1e-8.
 */
let AmountJson = class AmountJson {
};
__decorate([
    checkable_1.Checkable.Number()
], AmountJson.prototype, "value", void 0);
__decorate([
    checkable_1.Checkable.Number()
], AmountJson.prototype, "fraction", void 0);
__decorate([
    checkable_1.Checkable.String()
], AmountJson.prototype, "currency", void 0);
AmountJson = __decorate([
    checkable_1.Checkable.Class()
], AmountJson);
exports.AmountJson = AmountJson;
/**
 * Get the largest amount that is safely representable.
 */
function getMaxAmount(currency) {
    return {
        currency,
        fraction: Math.pow(2, 32),
        value: Number.MAX_SAFE_INTEGER,
    };
}
exports.getMaxAmount = getMaxAmount;
/**
 * Get an amount that represents zero units of a currency.
 */
function getZero(currency) {
    return {
        currency,
        fraction: 0,
        value: 0,
    };
}
exports.getZero = getZero;
/**
 * Add two amounts.  Return the result and whether
 * the addition overflowed.  The overflow is always handled
 * by saturating and never by wrapping.
 *
 * Throws when currencies don't match.
 */
function add(first, ...rest) {
    const currency = first.currency;
    let value = first.value + Math.floor(first.fraction / exports.fractionalBase);
    if (value > Number.MAX_SAFE_INTEGER) {
        return { amount: getMaxAmount(currency), saturated: true };
    }
    let fraction = first.fraction % exports.fractionalBase;
    for (const x of rest) {
        if (x.currency !== currency) {
            throw Error(`Mismatched currency: ${x.currency} and ${currency}`);
        }
        value = value + x.value + Math.floor((fraction + x.fraction) / exports.fractionalBase);
        fraction = Math.floor((fraction + x.fraction) % exports.fractionalBase);
        if (value > Number.MAX_SAFE_INTEGER) {
            return { amount: getMaxAmount(currency), saturated: true };
        }
    }
    return { amount: { currency, value, fraction }, saturated: false };
}
exports.add = add;
/**
 * Subtract two amounts.  Return the result and whether
 * the subtraction overflowed.  The overflow is always handled
 * by saturating and never by wrapping.
 *
 * Throws when currencies don't match.
 */
function sub(a, ...rest) {
    const currency = a.currency;
    let value = a.value;
    let fraction = a.fraction;
    for (const b of rest) {
        if (b.currency !== currency) {
            throw Error(`Mismatched currency: ${b.currency} and ${currency}`);
        }
        if (fraction < b.fraction) {
            if (value < 1) {
                return { amount: { currency, value: 0, fraction: 0 }, saturated: true };
            }
            value--;
            fraction += exports.fractionalBase;
        }
        console.assert(fraction >= b.fraction);
        fraction -= b.fraction;
        if (value < b.value) {
            return { amount: { currency, value: 0, fraction: 0 }, saturated: true };
        }
        value -= b.value;
    }
    return { amount: { currency, value, fraction }, saturated: false };
}
exports.sub = sub;
/**
 * Compare two amounts.  Returns 0 when equal, -1 when a < b
 * and +1 when a > b.  Throws when currencies don't match.
 */
function cmp(a, b) {
    if (a.currency !== b.currency) {
        throw Error(`Mismatched currency: ${a.currency} and ${b.currency}`);
    }
    const av = a.value + Math.floor(a.fraction / exports.fractionalBase);
    const af = a.fraction % exports.fractionalBase;
    const bv = b.value + Math.floor(b.fraction / exports.fractionalBase);
    const bf = b.fraction % exports.fractionalBase;
    switch (true) {
        case av < bv:
            return -1;
        case av > bv:
            return 1;
        case af < bf:
            return -1;
        case af > bf:
            return 1;
        case af === bf:
            return 0;
        default:
            throw Error("assertion failed");
    }
}
exports.cmp = cmp;
/**
 * Create a copy of an amount.
 */
function copy(a) {
    return {
        currency: a.currency,
        fraction: a.fraction,
        value: a.value,
    };
}
exports.copy = copy;
/**
 * Divide an amount.  Throws on division by zero.
 */
function divide(a, n) {
    if (n === 0) {
        throw Error(`Division by 0`);
    }
    if (n === 1) {
        return { value: a.value, fraction: a.fraction, currency: a.currency };
    }
    const r = a.value % n;
    return {
        currency: a.currency,
        fraction: Math.floor(((r * exports.fractionalBase) + a.fraction) / n),
        value: Math.floor(a.value / n),
    };
}
exports.divide = divide;
/**
 * Check if an amount is non-zero.
 */
function isNonZero(a) {
    return a.value > 0 || a.fraction > 0;
}
exports.isNonZero = isNonZero;
/**
 * Parse an amount like 'EUR:20.5' for 20 Euros and 50 ct.
 */
function parse(s) {
    const res = s.match(/([a-zA-Z0-9_*-]+):([0-9]+)([.][0-9]+)?/);
    if (!res) {
        return undefined;
    }
    return {
        currency: res[1],
        fraction: Math.round(exports.fractionalBase * Number.parseFloat(res[3] || "0")),
        value: Number.parseInt(res[2]),
    };
}
exports.parse = parse;
function parseOrThrow(s) {
    const res = parse(s);
    if (!res) {
        throw Error(`Can't parse amount: "${s}"`);
    }
    return res;
}
exports.parseOrThrow = parseOrThrow;
/**
 * Convert the amount to a float.
 */
function toFloat(a) {
    return a.value + (a.fraction / exports.fractionalBase);
}
exports.toFloat = toFloat;
/**
 * Convert a float to a Taler amount.
 * Loss of precision possible.
 */
function fromFloat(floatVal, currency) {
    return {
        currency,
        fraction: Math.floor((floatVal - Math.floor(floatVal)) * exports.fractionalBase),
        value: Math.floor(floatVal),
    };
}
exports.fromFloat = fromFloat;
/**
 * Convert to standard human-readable string representation that's
 * also used in JSON formats.
 */
function toString(a) {
    return `${a.currency}:${a.value + (a.fraction / exports.fractionalBase)}`;
}
exports.toString = toString;
function check(a) {
    if (typeof a !== "string") {
        return false;
    }
    try {
        const parsedAmount = parse(a);
        return !!parsedAmount;
    }
    catch (_a) {
        return false;
    }
}
exports.check = check;


/***/ }),
/* 1 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*
 This file is part of TALER
 (C) 2016 GNUnet e.V.

 TALER is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 TALER is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Decorators for validating JSON objects and converting them to a typed
 * object.
 *
 * The decorators are put onto classes, and the validation is done
 * via a static method that is filled in by the annotation.
 *
 * Example:
 * ```
 *  @Checkable.Class
 *  class Person {
 *    @Checkable.String
 *    name: string;
 *    @Checkable.Number
 *    age: number;
 *
 *    // Method will be implemented automatically
 *    static checked(obj: any): Person;
 *  }
 * ```
 */
var Checkable;
(function (Checkable) {
    // tslint:disable-next-line:no-shadowed-variable
    Checkable.SchemaError = (function SchemaError(message) {
        const that = this;
        that.name = "SchemaError";
        that.message = message;
        that.stack = new Error().stack;
    });
    Checkable.SchemaError.prototype = new Error();
    /**
     * Classes that are checkable are annotated with this
     * checkable info symbol, which contains the information necessary
     * to check if they're valid.
     */
    const checkableInfoSym = Symbol("checkableInfo");
    /**
     * Get the current property list for a checkable type.
     */
    function getCheckableInfo(target) {
        let chk = target[checkableInfoSym];
        if (!chk) {
            chk = { props: [] };
            target[checkableInfoSym] = chk;
        }
        return chk;
    }
    function checkNumber(target, prop, path) {
        if ((typeof target) !== "number") {
            throw new Checkable.SchemaError(`expected number for ${path}`);
        }
        return target;
    }
    function checkString(target, prop, path) {
        if (typeof target !== "string") {
            throw new Checkable.SchemaError(`expected string for ${path}, got ${typeof target} instead`);
        }
        if (prop.stringChecker && !prop.stringChecker(target)) {
            throw new Checkable.SchemaError(`string property ${path} malformed`);
        }
        return target;
    }
    function checkBoolean(target, prop, path) {
        if (typeof target !== "boolean") {
            throw new Checkable.SchemaError(`expected boolean for ${path}, got ${typeof target} instead`);
        }
        return target;
    }
    function checkAnyObject(target, prop, path) {
        if (typeof target !== "object") {
            throw new Checkable.SchemaError(`expected (any) object for ${path}, got ${typeof target} instead`);
        }
        return target;
    }
    function checkAny(target, prop, path) {
        return target;
    }
    function checkList(target, prop, path) {
        if (!Array.isArray(target)) {
            throw new Checkable.SchemaError(`array expected for ${path}, got ${typeof target} instead`);
        }
        for (let i = 0; i < target.length; i++) {
            const v = target[i];
            prop.elementChecker(v, prop.elementProp, path.concat([i]));
        }
        return target;
    }
    function checkMap(target, prop, path) {
        if (typeof target !== "object") {
            throw new Checkable.SchemaError(`expected  object for ${path}, got ${typeof target} instead`);
        }
        for (const key in target) {
            prop.keyProp.checker(key, prop.keyProp, path.concat([key]));
            const value = target[key];
            prop.valueProp.checker(value, prop.valueProp, path.concat([key]));
        }
    }
    function checkOptional(target, prop, path) {
        console.assert(prop.propertyKey);
        prop.elementChecker(target, prop.elementProp, path.concat([prop.propertyKey]));
        return target;
    }
    function checkValue(target, prop, path) {
        let type;
        if (prop.type) {
            type = prop.type;
        }
        else if (prop.typeThunk) {
            type = prop.typeThunk();
            if (!type) {
                throw Error(`assertion failed: typeThunk returned null (prop is ${JSON.stringify(prop)})`);
            }
        }
        else {
            throw Error(`assertion failed: type/typeThunk missing (prop is ${JSON.stringify(prop)})`);
        }
        const typeName = type.name || "??";
        const v = target;
        if (!v || typeof v !== "object") {
            throw new Checkable.SchemaError(`expected object for ${path.join(".")}, got ${typeof v} instead`);
        }
        const props = type.prototype[checkableInfoSym].props;
        const remainingPropNames = new Set(Object.getOwnPropertyNames(v));
        const obj = new type();
        for (const innerProp of props) {
            if (!remainingPropNames.has(innerProp.propertyKey)) {
                if (innerProp.optional) {
                    continue;
                }
                throw new Checkable.SchemaError(`Property ${innerProp.propertyKey} missing on ${path} of ${typeName}`);
            }
            if (!remainingPropNames.delete(innerProp.propertyKey)) {
                throw new Checkable.SchemaError("assertion failed");
            }
            const propVal = v[innerProp.propertyKey];
            obj[innerProp.propertyKey] = innerProp.checker(propVal, innerProp, path.concat([innerProp.propertyKey]));
        }
        if (!prop.extraAllowed && remainingPropNames.size !== 0) {
            const err = `superfluous properties ${JSON.stringify(Array.from(remainingPropNames.values()))} of ${typeName}`;
            throw new Checkable.SchemaError(err);
        }
        return obj;
    }
    /**
     * Class with checkable annotations on fields.
     * This annotation adds the implementation of the `checked`
     * static method.
     */
    function Class(opts = {}) {
        return (target) => {
            target.checked = (v) => {
                const cv = checkValue(v, {
                    checker: checkValue,
                    extraAllowed: !!opts.extra,
                    propertyKey: "(root)",
                    type: target,
                }, ["(root)"]);
                if (opts.validate) {
                    if (typeof target.validate !== "function") {
                        console.error("target", target);
                        throw Error("invalid Checkable annotion: validate method required");
                    }
                    // May throw exception
                    target.validate(cv);
                }
                return cv;
            };
            return target;
        };
    }
    Checkable.Class = Class;
    /**
     * Target property must be a Checkable object of the given type.
     */
    function Value(typeThunk) {
        function deco(target, propertyKey) {
            const chk = getCheckableInfo(target);
            chk.props.push({
                checker: checkValue,
                propertyKey,
                typeThunk,
            });
        }
        return deco;
    }
    Checkable.Value = Value;
    /**
     * List of values that match the given annotation.  For example, `@Checkable.List(Checkable.String)` is
     * an annotation for a list of strings.
     */
    function List(type) {
        const stub = {};
        type(stub, "(list-element)");
        const elementProp = getCheckableInfo(stub).props[0];
        const elementChecker = elementProp.checker;
        if (!elementChecker) {
            throw Error("assertion failed");
        }
        function deco(target, propertyKey) {
            const chk = getCheckableInfo(target);
            chk.props.push({
                checker: checkList,
                elementChecker,
                elementProp,
                propertyKey,
            });
        }
        return deco;
    }
    Checkable.List = List;
    /**
     * Map from the key type to value type.  Takes two annotations,
     * one for the key type and one for the value type.
     */
    function Map(keyType, valueType) {
        const keyStub = {};
        keyType(keyStub, "(map-key)");
        const keyProp = getCheckableInfo(keyStub).props[0];
        if (!keyProp) {
            throw Error("assertion failed");
        }
        const valueStub = {};
        valueType(valueStub, "(map-value)");
        const valueProp = getCheckableInfo(valueStub).props[0];
        if (!valueProp) {
            throw Error("assertion failed");
        }
        function deco(target, propertyKey) {
            const chk = getCheckableInfo(target);
            chk.props.push({
                checker: checkMap,
                keyProp,
                propertyKey,
                valueProp,
            });
        }
        return deco;
    }
    Checkable.Map = Map;
    /**
     * Makes another annotation optional, for example `@Checkable.Optional(Checkable.Number)`.
     */
    function Optional(type) {
        const stub = {};
        type(stub, "(optional-element)");
        const elementProp = getCheckableInfo(stub).props[0];
        const elementChecker = elementProp.checker;
        if (!elementChecker) {
            throw Error("assertion failed");
        }
        function deco(target, propertyKey) {
            const chk = getCheckableInfo(target);
            chk.props.push({
                checker: checkOptional,
                elementChecker,
                elementProp,
                optional: true,
                propertyKey,
            });
        }
        return deco;
    }
    Checkable.Optional = Optional;
    /**
     * Target property must be a number.
     */
    function Number() {
        const deco = (target, propertyKey) => {
            const chk = getCheckableInfo(target);
            chk.props.push({ checker: checkNumber, propertyKey });
        };
        return deco;
    }
    Checkable.Number = Number;
    /**
     * Target property must be an arbitary object.
     */
    function AnyObject() {
        const deco = (target, propertyKey) => {
            const chk = getCheckableInfo(target);
            chk.props.push({
                checker: checkAnyObject,
                propertyKey,
            });
        };
        return deco;
    }
    Checkable.AnyObject = AnyObject;
    /**
     * Target property can be anything.
     *
     * Not useful by itself, but in combination with higher-order annotations
     * such as List or Map.
     */
    function Any() {
        const deco = (target, propertyKey) => {
            const chk = getCheckableInfo(target);
            chk.props.push({
                checker: checkAny,
                optional: true,
                propertyKey,
            });
        };
        return deco;
    }
    Checkable.Any = Any;
    /**
     * Target property must be a string.
     */
    function String(stringChecker) {
        const deco = (target, propertyKey) => {
            const chk = getCheckableInfo(target);
            chk.props.push({ checker: checkString, propertyKey, stringChecker });
        };
        return deco;
    }
    Checkable.String = String;
    /**
     * Target property must be a boolean value.
     */
    function Boolean() {
        const deco = (target, propertyKey) => {
            const chk = getCheckableInfo(target);
            chk.props.push({ checker: checkBoolean, propertyKey });
        };
        return deco;
    }
    Checkable.Boolean = Boolean;
})(Checkable = exports.Checkable || (exports.Checkable = {}));


/***/ }),
/* 2 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*
 This file is part of TALER
 (C) 2016 GNUnet e.V.

 TALER is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 TALER is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
Object.defineProperty(exports, "__esModule", { value: true });
const Amounts = __webpack_require__(0);
const URI = __webpack_require__(11);
/**
 * Show an amount in a form suitable for the user.
 * FIXME:  In the future, this should consider currency-specific
 * settings such as significant digits or currency symbols.
 */
function amountToPretty(amount) {
    const x = amount.value + amount.fraction / Amounts.fractionalBase;
    return `${x} ${amount.currency}`;
}
exports.amountToPretty = amountToPretty;
/**
 * Canonicalize a base url, typically for the exchange.
 *
 * See http://api.taler.net/wallet.html#general
 */
function canonicalizeBaseUrl(url) {
    const x = new URI(url);
    if (!x.protocol()) {
        x.protocol("https");
    }
    x.path(x.path() + "/").normalizePath();
    x.fragment("");
    x.query();
    return x.href();
}
exports.canonicalizeBaseUrl = canonicalizeBaseUrl;
/**
 * Convert object to JSON with canonical ordering of keys
 * and whitespace omitted.
 */
function canonicalJson(obj) {
    // Check for cycles, etc.
    JSON.stringify(obj);
    if (typeof obj === "string" || typeof obj === "number" || obj === null) {
        return JSON.stringify(obj);
    }
    if (Array.isArray(obj)) {
        const objs = obj.map((e) => canonicalJson(e));
        return `[${objs.join(",")}]`;
    }
    const keys = [];
    for (const key in obj) {
        keys.push(key);
    }
    keys.sort();
    let s = "{";
    for (let i = 0; i < keys.length; i++) {
        const key = keys[i];
        s += JSON.stringify(key) + ":" + canonicalJson(obj[key]);
        if (i !== keys.length - 1) {
            s += ",";
        }
    }
    return s + "}";
}
exports.canonicalJson = canonicalJson;
/**
 * Check for deep equality of two objects.
 * Only arrays, objects and primitives are supported.
 */
function deepEquals(x, y) {
    if (x === y) {
        return true;
    }
    if (Array.isArray(x) && x.length !== y.length) {
        return false;
    }
    const p = Object.keys(x);
    return Object.keys(y).every((i) => p.indexOf(i) !== -1) &&
        p.every((i) => deepEquals(x[i], y[i]));
}
exports.deepEquals = deepEquals;
/**
 * Map from a collection to a list or results and then
 * concatenate the results.
 */
function flatMap(xs, f) {
    return xs.reduce((acc, next) => [...f(next), ...acc], []);
}
exports.flatMap = flatMap;
/**
 * Extract a numeric timstamp (in seconds) from the Taler date format
 * ("/Date([n])/").  Returns null if input is not in the right format.
 */
function getTalerStampSec(stamp) {
    const m = stamp.match(/\/?Date\(([0-9]*)\)\/?/);
    if (!m || !m[1]) {
        return null;
    }
    return parseInt(m[1], 10);
}
exports.getTalerStampSec = getTalerStampSec;
/**
 * Check if a timestamp is in the right format.
 */
function timestampCheck(stamp) {
    return getTalerStampSec(stamp) !== null;
}
exports.timestampCheck = timestampCheck;
/**
 * Get a JavaScript Date object from a Taler date string.
 * Returns null if input is not in the right format.
 */
function getTalerStampDate(stamp) {
    const sec = getTalerStampSec(stamp);
    if (sec == null) {
        return null;
    }
    return new Date(sec * 1000);
}
exports.getTalerStampDate = getTalerStampDate;
/**
 * Compute the hash function of a JSON object.
 */
function hash(val) {
    const str = canonicalJson(val);
    // https://github.com/darkskyapp/string-hash
    let h = 5381;
    let i = str.length;
    while (i) {
        h = (h * 33) ^ str.charCodeAt(--i);
    }
    /* JavaScript does bitwise operations (like XOR, above) on 32-bit signed
    * integers. Since we want the results to be always positive, convert the
    * signed int to an unsigned by doing an unsigned bitshift. */
    return h >>> 0;
}
exports.hash = hash;
/**
 * Lexically compare two strings.
 */
function strcmp(s1, s2) {
    if (s1 < s2) {
        return -1;
    }
    if (s1 > s2) {
        return 1;
    }
    return 0;
}
exports.strcmp = strcmp;


/***/ }),
/* 3 */
/***/ (function(module, exports, __webpack_require__) {

/* WEBPACK VAR INJECTION */(function(module, global) {var __WEBPACK_AMD_DEFINE_RESULT__;/*! https://mths.be/punycode v1.4.0 by @mathias */
;(function(root) {

	/** Detect free variables */
	var freeExports = typeof exports == 'object' && exports &&
		!exports.nodeType && exports;
	var freeModule = typeof module == 'object' && module &&
		!module.nodeType && module;
	var freeGlobal = typeof global == 'object' && global;
	if (
		freeGlobal.global === freeGlobal ||
		freeGlobal.window === freeGlobal ||
		freeGlobal.self === freeGlobal
	) {
		root = freeGlobal;
	}

	/**
	 * The `punycode` object.
	 * @name punycode
	 * @type Object
	 */
	var punycode,

	/** Highest positive signed 32-bit float value */
	maxInt = 2147483647, // aka. 0x7FFFFFFF or 2^31-1

	/** Bootstring parameters */
	base = 36,
	tMin = 1,
	tMax = 26,
	skew = 38,
	damp = 700,
	initialBias = 72,
	initialN = 128, // 0x80
	delimiter = '-', // '\x2D'

	/** Regular expressions */
	regexPunycode = /^xn--/,
	regexNonASCII = /[^\x20-\x7E]/, // unprintable ASCII chars + non-ASCII chars
	regexSeparators = /[\x2E\u3002\uFF0E\uFF61]/g, // RFC 3490 separators

	/** Error messages */
	errors = {
		'overflow': 'Overflow: input needs wider integers to process',
		'not-basic': 'Illegal input >= 0x80 (not a basic code point)',
		'invalid-input': 'Invalid input'
	},

	/** Convenience shortcuts */
	baseMinusTMin = base - tMin,
	floor = Math.floor,
	stringFromCharCode = String.fromCharCode,

	/** Temporary variable */
	key;

	/*--------------------------------------------------------------------------*/

	/**
	 * A generic error utility function.
	 * @private
	 * @param {String} type The error type.
	 * @returns {Error} Throws a `RangeError` with the applicable error message.
	 */
	function error(type) {
		throw new RangeError(errors[type]);
	}

	/**
	 * A generic `Array#map` utility function.
	 * @private
	 * @param {Array} array The array to iterate over.
	 * @param {Function} callback The function that gets called for every array
	 * item.
	 * @returns {Array} A new array of values returned by the callback function.
	 */
	function map(array, fn) {
		var length = array.length;
		var result = [];
		while (length--) {
			result[length] = fn(array[length]);
		}
		return result;
	}

	/**
	 * A simple `Array#map`-like wrapper to work with domain name strings or email
	 * addresses.
	 * @private
	 * @param {String} domain The domain name or email address.
	 * @param {Function} callback The function that gets called for every
	 * character.
	 * @returns {Array} A new string of characters returned by the callback
	 * function.
	 */
	function mapDomain(string, fn) {
		var parts = string.split('@');
		var result = '';
		if (parts.length > 1) {
			// In email addresses, only the domain name should be punycoded. Leave
			// the local part (i.e. everything up to `@`) intact.
			result = parts[0] + '@';
			string = parts[1];
		}
		// Avoid `split(regex)` for IE8 compatibility. See #17.
		string = string.replace(regexSeparators, '\x2E');
		var labels = string.split('.');
		var encoded = map(labels, fn).join('.');
		return result + encoded;
	}

	/**
	 * Creates an array containing the numeric code points of each Unicode
	 * character in the string. While JavaScript uses UCS-2 internally,
	 * this function will convert a pair of surrogate halves (each of which
	 * UCS-2 exposes as separate characters) into a single code point,
	 * matching UTF-16.
	 * @see `punycode.ucs2.encode`
	 * @see <https://mathiasbynens.be/notes/javascript-encoding>
	 * @memberOf punycode.ucs2
	 * @name decode
	 * @param {String} string The Unicode input string (UCS-2).
	 * @returns {Array} The new array of code points.
	 */
	function ucs2decode(string) {
		var output = [],
		    counter = 0,
		    length = string.length,
		    value,
		    extra;
		while (counter < length) {
			value = string.charCodeAt(counter++);
			if (value >= 0xD800 && value <= 0xDBFF && counter < length) {
				// high surrogate, and there is a next character
				extra = string.charCodeAt(counter++);
				if ((extra & 0xFC00) == 0xDC00) { // low surrogate
					output.push(((value & 0x3FF) << 10) + (extra & 0x3FF) + 0x10000);
				} else {
					// unmatched surrogate; only append this code unit, in case the next
					// code unit is the high surrogate of a surrogate pair
					output.push(value);
					counter--;
				}
			} else {
				output.push(value);
			}
		}
		return output;
	}

	/**
	 * Creates a string based on an array of numeric code points.
	 * @see `punycode.ucs2.decode`
	 * @memberOf punycode.ucs2
	 * @name encode
	 * @param {Array} codePoints The array of numeric code points.
	 * @returns {String} The new Unicode string (UCS-2).
	 */
	function ucs2encode(array) {
		return map(array, function(value) {
			var output = '';
			if (value > 0xFFFF) {
				value -= 0x10000;
				output += stringFromCharCode(value >>> 10 & 0x3FF | 0xD800);
				value = 0xDC00 | value & 0x3FF;
			}
			output += stringFromCharCode(value);
			return output;
		}).join('');
	}

	/**
	 * Converts a basic code point into a digit/integer.
	 * @see `digitToBasic()`
	 * @private
	 * @param {Number} codePoint The basic numeric code point value.
	 * @returns {Number} The numeric value of a basic code point (for use in
	 * representing integers) in the range `0` to `base - 1`, or `base` if
	 * the code point does not represent a value.
	 */
	function basicToDigit(codePoint) {
		if (codePoint - 48 < 10) {
			return codePoint - 22;
		}
		if (codePoint - 65 < 26) {
			return codePoint - 65;
		}
		if (codePoint - 97 < 26) {
			return codePoint - 97;
		}
		return base;
	}

	/**
	 * Converts a digit/integer into a basic code point.
	 * @see `basicToDigit()`
	 * @private
	 * @param {Number} digit The numeric value of a basic code point.
	 * @returns {Number} The basic code point whose value (when used for
	 * representing integers) is `digit`, which needs to be in the range
	 * `0` to `base - 1`. If `flag` is non-zero, the uppercase form is
	 * used; else, the lowercase form is used. The behavior is undefined
	 * if `flag` is non-zero and `digit` has no uppercase form.
	 */
	function digitToBasic(digit, flag) {
		//  0..25 map to ASCII a..z or A..Z
		// 26..35 map to ASCII 0..9
		return digit + 22 + 75 * (digit < 26) - ((flag != 0) << 5);
	}

	/**
	 * Bias adaptation function as per section 3.4 of RFC 3492.
	 * https://tools.ietf.org/html/rfc3492#section-3.4
	 * @private
	 */
	function adapt(delta, numPoints, firstTime) {
		var k = 0;
		delta = firstTime ? floor(delta / damp) : delta >> 1;
		delta += floor(delta / numPoints);
		for (/* no initialization */; delta > baseMinusTMin * tMax >> 1; k += base) {
			delta = floor(delta / baseMinusTMin);
		}
		return floor(k + (baseMinusTMin + 1) * delta / (delta + skew));
	}

	/**
	 * Converts a Punycode string of ASCII-only symbols to a string of Unicode
	 * symbols.
	 * @memberOf punycode
	 * @param {String} input The Punycode string of ASCII-only symbols.
	 * @returns {String} The resulting string of Unicode symbols.
	 */
	function decode(input) {
		// Don't use UCS-2
		var output = [],
		    inputLength = input.length,
		    out,
		    i = 0,
		    n = initialN,
		    bias = initialBias,
		    basic,
		    j,
		    index,
		    oldi,
		    w,
		    k,
		    digit,
		    t,
		    /** Cached calculation results */
		    baseMinusT;

		// Handle the basic code points: let `basic` be the number of input code
		// points before the last delimiter, or `0` if there is none, then copy
		// the first basic code points to the output.

		basic = input.lastIndexOf(delimiter);
		if (basic < 0) {
			basic = 0;
		}

		for (j = 0; j < basic; ++j) {
			// if it's not a basic code point
			if (input.charCodeAt(j) >= 0x80) {
				error('not-basic');
			}
			output.push(input.charCodeAt(j));
		}

		// Main decoding loop: start just after the last delimiter if any basic code
		// points were copied; start at the beginning otherwise.

		for (index = basic > 0 ? basic + 1 : 0; index < inputLength; /* no final expression */) {

			// `index` is the index of the next character to be consumed.
			// Decode a generalized variable-length integer into `delta`,
			// which gets added to `i`. The overflow checking is easier
			// if we increase `i` as we go, then subtract off its starting
			// value at the end to obtain `delta`.
			for (oldi = i, w = 1, k = base; /* no condition */; k += base) {

				if (index >= inputLength) {
					error('invalid-input');
				}

				digit = basicToDigit(input.charCodeAt(index++));

				if (digit >= base || digit > floor((maxInt - i) / w)) {
					error('overflow');
				}

				i += digit * w;
				t = k <= bias ? tMin : (k >= bias + tMax ? tMax : k - bias);

				if (digit < t) {
					break;
				}

				baseMinusT = base - t;
				if (w > floor(maxInt / baseMinusT)) {
					error('overflow');
				}

				w *= baseMinusT;

			}

			out = output.length + 1;
			bias = adapt(i - oldi, out, oldi == 0);

			// `i` was supposed to wrap around from `out` to `0`,
			// incrementing `n` each time, so we'll fix that now:
			if (floor(i / out) > maxInt - n) {
				error('overflow');
			}

			n += floor(i / out);
			i %= out;

			// Insert `n` at position `i` of the output
			output.splice(i++, 0, n);

		}

		return ucs2encode(output);
	}

	/**
	 * Converts a string of Unicode symbols (e.g. a domain name label) to a
	 * Punycode string of ASCII-only symbols.
	 * @memberOf punycode
	 * @param {String} input The string of Unicode symbols.
	 * @returns {String} The resulting Punycode string of ASCII-only symbols.
	 */
	function encode(input) {
		var n,
		    delta,
		    handledCPCount,
		    basicLength,
		    bias,
		    j,
		    m,
		    q,
		    k,
		    t,
		    currentValue,
		    output = [],
		    /** `inputLength` will hold the number of code points in `input`. */
		    inputLength,
		    /** Cached calculation results */
		    handledCPCountPlusOne,
		    baseMinusT,
		    qMinusT;

		// Convert the input in UCS-2 to Unicode
		input = ucs2decode(input);

		// Cache the length
		inputLength = input.length;

		// Initialize the state
		n = initialN;
		delta = 0;
		bias = initialBias;

		// Handle the basic code points
		for (j = 0; j < inputLength; ++j) {
			currentValue = input[j];
			if (currentValue < 0x80) {
				output.push(stringFromCharCode(currentValue));
			}
		}

		handledCPCount = basicLength = output.length;

		// `handledCPCount` is the number of code points that have been handled;
		// `basicLength` is the number of basic code points.

		// Finish the basic string - if it is not empty - with a delimiter
		if (basicLength) {
			output.push(delimiter);
		}

		// Main encoding loop:
		while (handledCPCount < inputLength) {

			// All non-basic code points < n have been handled already. Find the next
			// larger one:
			for (m = maxInt, j = 0; j < inputLength; ++j) {
				currentValue = input[j];
				if (currentValue >= n && currentValue < m) {
					m = currentValue;
				}
			}

			// Increase `delta` enough to advance the decoder's <n,i> state to <m,0>,
			// but guard against overflow
			handledCPCountPlusOne = handledCPCount + 1;
			if (m - n > floor((maxInt - delta) / handledCPCountPlusOne)) {
				error('overflow');
			}

			delta += (m - n) * handledCPCountPlusOne;
			n = m;

			for (j = 0; j < inputLength; ++j) {
				currentValue = input[j];

				if (currentValue < n && ++delta > maxInt) {
					error('overflow');
				}

				if (currentValue == n) {
					// Represent delta as a generalized variable-length integer
					for (q = delta, k = base; /* no condition */; k += base) {
						t = k <= bias ? tMin : (k >= bias + tMax ? tMax : k - bias);
						if (q < t) {
							break;
						}
						qMinusT = q - t;
						baseMinusT = base - t;
						output.push(
							stringFromCharCode(digitToBasic(t + qMinusT % baseMinusT, 0))
						);
						q = floor(qMinusT / baseMinusT);
					}

					output.push(stringFromCharCode(digitToBasic(q, 0)));
					bias = adapt(delta, handledCPCountPlusOne, handledCPCount == basicLength);
					delta = 0;
					++handledCPCount;
				}
			}

			++delta;
			++n;

		}
		return output.join('');
	}

	/**
	 * Converts a Punycode string representing a domain name or an email address
	 * to Unicode. Only the Punycoded parts of the input will be converted, i.e.
	 * it doesn't matter if you call it on a string that has already been
	 * converted to Unicode.
	 * @memberOf punycode
	 * @param {String} input The Punycoded domain name or email address to
	 * convert to Unicode.
	 * @returns {String} The Unicode representation of the given Punycode
	 * string.
	 */
	function toUnicode(input) {
		return mapDomain(input, function(string) {
			return regexPunycode.test(string)
				? decode(string.slice(4).toLowerCase())
				: string;
		});
	}

	/**
	 * Converts a Unicode string representing a domain name or an email address to
	 * Punycode. Only the non-ASCII parts of the domain name will be converted,
	 * i.e. it doesn't matter if you call it with a domain that's already in
	 * ASCII.
	 * @memberOf punycode
	 * @param {String} input The domain name or email address to convert, as a
	 * Unicode string.
	 * @returns {String} The Punycode representation of the given domain name or
	 * email address.
	 */
	function toASCII(input) {
		return mapDomain(input, function(string) {
			return regexNonASCII.test(string)
				? 'xn--' + encode(string)
				: string;
		});
	}

	/*--------------------------------------------------------------------------*/

	/** Define the public API */
	punycode = {
		/**
		 * A string representing the current Punycode.js version number.
		 * @memberOf punycode
		 * @type String
		 */
		'version': '1.3.2',
		/**
		 * An object of methods to convert from JavaScript's internal character
		 * representation (UCS-2) to Unicode code points, and back.
		 * @see <https://mathiasbynens.be/notes/javascript-encoding>
		 * @memberOf punycode
		 * @type Object
		 */
		'ucs2': {
			'decode': ucs2decode,
			'encode': ucs2encode
		},
		'decode': decode,
		'encode': encode,
		'toASCII': toASCII,
		'toUnicode': toUnicode
	};

	/** Expose `punycode` */
	// Some AMD build optimizers, like r.js, check for specific condition patterns
	// like the following:
	if (
		true
	) {
		!(__WEBPACK_AMD_DEFINE_RESULT__ = (function() {
			return punycode;
		}).call(exports, __webpack_require__, exports, module),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
	} else if (freeExports && freeModule) {
		if (module.exports == freeExports) {
			// in Node.js, io.js, or RingoJS v0.8.0+
			freeModule.exports = punycode;
		} else {
			// in Narwhal or RingoJS v0.7.0-
			for (key in punycode) {
				punycode.hasOwnProperty(key) && (freeExports[key] = punycode[key]);
			}
		}
	} else {
		// in Rhino or a web browser
		root.punycode = punycode;
	}

}(this));

/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(12)(module), __webpack_require__(4)))

/***/ }),
/* 4 */
/***/ (function(module, exports) {

var g;

// This works in non-strict mode
g = (function() {
	return this;
})();

try {
	// This works if eval is allowed (see CSP)
	g = g || Function("return this")() || (1,eval)("this");
} catch(e) {
	// This works if the window reference is available
	if(typeof window === "object")
		g = window;
}

// g can still be undefined, but nothing to do about it...
// We return undefined, instead of nothing here, so it's
// easier to handle this case. if(!global) { ...}

module.exports = g;


/***/ }),
/* 5 */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_RESULT__;/*!
 * URI.js - Mutating URLs
 * IPv6 Support
 *
 * Version: 1.19.0
 *
 * Author: Rodney Rehm
 * Web: http://medialize.github.io/URI.js/
 *
 * Licensed under
 *   MIT License http://www.opensource.org/licenses/mit-license
 *
 */

(function (root, factory) {
  'use strict';
  // https://github.com/umdjs/umd/blob/master/returnExports.js
  if (typeof module === 'object' && module.exports) {
    // Node
    module.exports = factory();
  } else if (true) {
    // AMD. Register as an anonymous module.
    !(__WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
				__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
				(__WEBPACK_AMD_DEFINE_FACTORY__.call(exports, __webpack_require__, exports, module)) :
				__WEBPACK_AMD_DEFINE_FACTORY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
  } else {
    // Browser globals (root is window)
    root.IPv6 = factory(root);
  }
}(this, function (root) {
  'use strict';

  /*
  var _in = "fe80:0000:0000:0000:0204:61ff:fe9d:f156";
  var _out = IPv6.best(_in);
  var _expected = "fe80::204:61ff:fe9d:f156";

  console.log(_in, _out, _expected, _out === _expected);
  */

  // save current IPv6 variable, if any
  var _IPv6 = root && root.IPv6;

  function bestPresentation(address) {
    // based on:
    // Javascript to test an IPv6 address for proper format, and to
    // present the "best text representation" according to IETF Draft RFC at
    // http://tools.ietf.org/html/draft-ietf-6man-text-addr-representation-04
    // 8 Feb 2010 Rich Brown, Dartware, LLC
    // Please feel free to use this code as long as you provide a link to
    // http://www.intermapper.com
    // http://intermapper.com/support/tools/IPV6-Validator.aspx
    // http://download.dartware.com/thirdparty/ipv6validator.js

    var _address = address.toLowerCase();
    var segments = _address.split(':');
    var length = segments.length;
    var total = 8;

    // trim colons (:: or ::a:b:c… or …a:b:c::)
    if (segments[0] === '' && segments[1] === '' && segments[2] === '') {
      // must have been ::
      // remove first two items
      segments.shift();
      segments.shift();
    } else if (segments[0] === '' && segments[1] === '') {
      // must have been ::xxxx
      // remove the first item
      segments.shift();
    } else if (segments[length - 1] === '' && segments[length - 2] === '') {
      // must have been xxxx::
      segments.pop();
    }

    length = segments.length;

    // adjust total segments for IPv4 trailer
    if (segments[length - 1].indexOf('.') !== -1) {
      // found a "." which means IPv4
      total = 7;
    }

    // fill empty segments them with "0000"
    var pos;
    for (pos = 0; pos < length; pos++) {
      if (segments[pos] === '') {
        break;
      }
    }

    if (pos < total) {
      segments.splice(pos, 1, '0000');
      while (segments.length < total) {
        segments.splice(pos, 0, '0000');
      }
    }

    // strip leading zeros
    var _segments;
    for (var i = 0; i < total; i++) {
      _segments = segments[i].split('');
      for (var j = 0; j < 3 ; j++) {
        if (_segments[0] === '0' && _segments.length > 1) {
          _segments.splice(0,1);
        } else {
          break;
        }
      }

      segments[i] = _segments.join('');
    }

    // find longest sequence of zeroes and coalesce them into one segment
    var best = -1;
    var _best = 0;
    var _current = 0;
    var current = -1;
    var inzeroes = false;
    // i; already declared

    for (i = 0; i < total; i++) {
      if (inzeroes) {
        if (segments[i] === '0') {
          _current += 1;
        } else {
          inzeroes = false;
          if (_current > _best) {
            best = current;
            _best = _current;
          }
        }
      } else {
        if (segments[i] === '0') {
          inzeroes = true;
          current = i;
          _current = 1;
        }
      }
    }

    if (_current > _best) {
      best = current;
      _best = _current;
    }

    if (_best > 1) {
      segments.splice(best, _best, '');
    }

    length = segments.length;

    // assemble remaining segments
    var result = '';
    if (segments[0] === '')  {
      result = ':';
    }

    for (i = 0; i < length; i++) {
      result += segments[i];
      if (i === length - 1) {
        break;
      }

      result += ':';
    }

    if (segments[length - 1] === '') {
      result += ':';
    }

    return result;
  }

  function noConflict() {
    /*jshint validthis: true */
    if (root.IPv6 === this) {
      root.IPv6 = _IPv6;
    }

    return this;
  }

  return {
    best: bestPresentation,
    noConflict: noConflict
  };
}));


/***/ }),
/* 6 */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_RESULT__;/*!
 * URI.js - Mutating URLs
 * Second Level Domain (SLD) Support
 *
 * Version: 1.19.0
 *
 * Author: Rodney Rehm
 * Web: http://medialize.github.io/URI.js/
 *
 * Licensed under
 *   MIT License http://www.opensource.org/licenses/mit-license
 *
 */

(function (root, factory) {
  'use strict';
  // https://github.com/umdjs/umd/blob/master/returnExports.js
  if (typeof module === 'object' && module.exports) {
    // Node
    module.exports = factory();
  } else if (true) {
    // AMD. Register as an anonymous module.
    !(__WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
				__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
				(__WEBPACK_AMD_DEFINE_FACTORY__.call(exports, __webpack_require__, exports, module)) :
				__WEBPACK_AMD_DEFINE_FACTORY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
  } else {
    // Browser globals (root is window)
    root.SecondLevelDomains = factory(root);
  }
}(this, function (root) {
  'use strict';

  // save current SecondLevelDomains variable, if any
  var _SecondLevelDomains = root && root.SecondLevelDomains;

  var SLD = {
    // list of known Second Level Domains
    // converted list of SLDs from https://github.com/gavingmiller/second-level-domains
    // ----
    // publicsuffix.org is more current and actually used by a couple of browsers internally.
    // downside is it also contains domains like "dyndns.org" - which is fine for the security
    // issues browser have to deal with (SOP for cookies, etc) - but is way overboard for URI.js
    // ----
    list: {
      'ac':' com gov mil net org ',
      'ae':' ac co gov mil name net org pro sch ',
      'af':' com edu gov net org ',
      'al':' com edu gov mil net org ',
      'ao':' co ed gv it og pb ',
      'ar':' com edu gob gov int mil net org tur ',
      'at':' ac co gv or ',
      'au':' asn com csiro edu gov id net org ',
      'ba':' co com edu gov mil net org rs unbi unmo unsa untz unze ',
      'bb':' biz co com edu gov info net org store tv ',
      'bh':' biz cc com edu gov info net org ',
      'bn':' com edu gov net org ',
      'bo':' com edu gob gov int mil net org tv ',
      'br':' adm adv agr am arq art ato b bio blog bmd cim cng cnt com coop ecn edu eng esp etc eti far flog fm fnd fot fst g12 ggf gov imb ind inf jor jus lel mat med mil mus net nom not ntr odo org ppg pro psc psi qsl rec slg srv tmp trd tur tv vet vlog wiki zlg ',
      'bs':' com edu gov net org ',
      'bz':' du et om ov rg ',
      'ca':' ab bc mb nb nf nl ns nt nu on pe qc sk yk ',
      'ck':' biz co edu gen gov info net org ',
      'cn':' ac ah bj com cq edu fj gd gov gs gx gz ha hb he hi hl hn jl js jx ln mil net nm nx org qh sc sd sh sn sx tj tw xj xz yn zj ',
      'co':' com edu gov mil net nom org ',
      'cr':' ac c co ed fi go or sa ',
      'cy':' ac biz com ekloges gov ltd name net org parliament press pro tm ',
      'do':' art com edu gob gov mil net org sld web ',
      'dz':' art asso com edu gov net org pol ',
      'ec':' com edu fin gov info med mil net org pro ',
      'eg':' com edu eun gov mil name net org sci ',
      'er':' com edu gov ind mil net org rochest w ',
      'es':' com edu gob nom org ',
      'et':' biz com edu gov info name net org ',
      'fj':' ac biz com info mil name net org pro ',
      'fk':' ac co gov net nom org ',
      'fr':' asso com f gouv nom prd presse tm ',
      'gg':' co net org ',
      'gh':' com edu gov mil org ',
      'gn':' ac com gov net org ',
      'gr':' com edu gov mil net org ',
      'gt':' com edu gob ind mil net org ',
      'gu':' com edu gov net org ',
      'hk':' com edu gov idv net org ',
      'hu':' 2000 agrar bolt casino city co erotica erotika film forum games hotel info ingatlan jogasz konyvelo lakas media news org priv reklam sex shop sport suli szex tm tozsde utazas video ',
      'id':' ac co go mil net or sch web ',
      'il':' ac co gov idf k12 muni net org ',
      'in':' ac co edu ernet firm gen gov i ind mil net nic org res ',
      'iq':' com edu gov i mil net org ',
      'ir':' ac co dnssec gov i id net org sch ',
      'it':' edu gov ',
      'je':' co net org ',
      'jo':' com edu gov mil name net org sch ',
      'jp':' ac ad co ed go gr lg ne or ',
      'ke':' ac co go info me mobi ne or sc ',
      'kh':' com edu gov mil net org per ',
      'ki':' biz com de edu gov info mob net org tel ',
      'km':' asso com coop edu gouv k medecin mil nom notaires pharmaciens presse tm veterinaire ',
      'kn':' edu gov net org ',
      'kr':' ac busan chungbuk chungnam co daegu daejeon es gangwon go gwangju gyeongbuk gyeonggi gyeongnam hs incheon jeju jeonbuk jeonnam k kg mil ms ne or pe re sc seoul ulsan ',
      'kw':' com edu gov net org ',
      'ky':' com edu gov net org ',
      'kz':' com edu gov mil net org ',
      'lb':' com edu gov net org ',
      'lk':' assn com edu gov grp hotel int ltd net ngo org sch soc web ',
      'lr':' com edu gov net org ',
      'lv':' asn com conf edu gov id mil net org ',
      'ly':' com edu gov id med net org plc sch ',
      'ma':' ac co gov m net org press ',
      'mc':' asso tm ',
      'me':' ac co edu gov its net org priv ',
      'mg':' com edu gov mil nom org prd tm ',
      'mk':' com edu gov inf name net org pro ',
      'ml':' com edu gov net org presse ',
      'mn':' edu gov org ',
      'mo':' com edu gov net org ',
      'mt':' com edu gov net org ',
      'mv':' aero biz com coop edu gov info int mil museum name net org pro ',
      'mw':' ac co com coop edu gov int museum net org ',
      'mx':' com edu gob net org ',
      'my':' com edu gov mil name net org sch ',
      'nf':' arts com firm info net other per rec store web ',
      'ng':' biz com edu gov mil mobi name net org sch ',
      'ni':' ac co com edu gob mil net nom org ',
      'np':' com edu gov mil net org ',
      'nr':' biz com edu gov info net org ',
      'om':' ac biz co com edu gov med mil museum net org pro sch ',
      'pe':' com edu gob mil net nom org sld ',
      'ph':' com edu gov i mil net ngo org ',
      'pk':' biz com edu fam gob gok gon gop gos gov net org web ',
      'pl':' art bialystok biz com edu gda gdansk gorzow gov info katowice krakow lodz lublin mil net ngo olsztyn org poznan pwr radom slupsk szczecin torun warszawa waw wroc wroclaw zgora ',
      'pr':' ac biz com edu est gov info isla name net org pro prof ',
      'ps':' com edu gov net org plo sec ',
      'pw':' belau co ed go ne or ',
      'ro':' arts com firm info nom nt org rec store tm www ',
      'rs':' ac co edu gov in org ',
      'sb':' com edu gov net org ',
      'sc':' com edu gov net org ',
      'sh':' co com edu gov net nom org ',
      'sl':' com edu gov net org ',
      'st':' co com consulado edu embaixada gov mil net org principe saotome store ',
      'sv':' com edu gob org red ',
      'sz':' ac co org ',
      'tr':' av bbs bel biz com dr edu gen gov info k12 name net org pol tel tsk tv web ',
      'tt':' aero biz cat co com coop edu gov info int jobs mil mobi museum name net org pro tel travel ',
      'tw':' club com ebiz edu game gov idv mil net org ',
      'mu':' ac co com gov net or org ',
      'mz':' ac co edu gov org ',
      'na':' co com ',
      'nz':' ac co cri geek gen govt health iwi maori mil net org parliament school ',
      'pa':' abo ac com edu gob ing med net nom org sld ',
      'pt':' com edu gov int net nome org publ ',
      'py':' com edu gov mil net org ',
      'qa':' com edu gov mil net org ',
      're':' asso com nom ',
      'ru':' ac adygeya altai amur arkhangelsk astrakhan bashkiria belgorod bir bryansk buryatia cbg chel chelyabinsk chita chukotka chuvashia com dagestan e-burg edu gov grozny int irkutsk ivanovo izhevsk jar joshkar-ola kalmykia kaluga kamchatka karelia kazan kchr kemerovo khabarovsk khakassia khv kirov koenig komi kostroma kranoyarsk kuban kurgan kursk lipetsk magadan mari mari-el marine mil mordovia mosreg msk murmansk nalchik net nnov nov novosibirsk nsk omsk orenburg org oryol penza perm pp pskov ptz rnd ryazan sakhalin samara saratov simbirsk smolensk spb stavropol stv surgut tambov tatarstan tom tomsk tsaritsyn tsk tula tuva tver tyumen udm udmurtia ulan-ude vladikavkaz vladimir vladivostok volgograd vologda voronezh vrn vyatka yakutia yamal yekaterinburg yuzhno-sakhalinsk ',
      'rw':' ac co com edu gouv gov int mil net ',
      'sa':' com edu gov med net org pub sch ',
      'sd':' com edu gov info med net org tv ',
      'se':' a ac b bd c d e f g h i k l m n o org p parti pp press r s t tm u w x y z ',
      'sg':' com edu gov idn net org per ',
      'sn':' art com edu gouv org perso univ ',
      'sy':' com edu gov mil net news org ',
      'th':' ac co go in mi net or ',
      'tj':' ac biz co com edu go gov info int mil name net nic org test web ',
      'tn':' agrinet com defense edunet ens fin gov ind info intl mincom nat net org perso rnrt rns rnu tourism ',
      'tz':' ac co go ne or ',
      'ua':' biz cherkassy chernigov chernovtsy ck cn co com crimea cv dn dnepropetrovsk donetsk dp edu gov if in ivano-frankivsk kh kharkov kherson khmelnitskiy kiev kirovograd km kr ks kv lg lugansk lutsk lviv me mk net nikolaev od odessa org pl poltava pp rovno rv sebastopol sumy te ternopil uzhgorod vinnica vn zaporizhzhe zhitomir zp zt ',
      'ug':' ac co go ne or org sc ',
      'uk':' ac bl british-library co cym gov govt icnet jet lea ltd me mil mod national-library-scotland nel net nhs nic nls org orgn parliament plc police sch scot soc ',
      'us':' dni fed isa kids nsn ',
      'uy':' com edu gub mil net org ',
      've':' co com edu gob info mil net org web ',
      'vi':' co com k12 net org ',
      'vn':' ac biz com edu gov health info int name net org pro ',
      'ye':' co com gov ltd me net org plc ',
      'yu':' ac co edu gov org ',
      'za':' ac agric alt bourse city co cybernet db edu gov grondar iaccess imt inca landesign law mil net ngo nis nom olivetti org pix school tm web ',
      'zm':' ac co com edu gov net org sch ',
      // https://en.wikipedia.org/wiki/CentralNic#Second-level_domains
      'com': 'ar br cn de eu gb gr hu jpn kr no qc ru sa se uk us uy za ',
      'net': 'gb jp se uk ',
      'org': 'ae',
      'de': 'com '
    },
    // gorhill 2013-10-25: Using indexOf() instead Regexp(). Significant boost
    // in both performance and memory footprint. No initialization required.
    // http://jsperf.com/uri-js-sld-regex-vs-binary-search/4
    // Following methods use lastIndexOf() rather than array.split() in order
    // to avoid any memory allocations.
    has: function(domain) {
      var tldOffset = domain.lastIndexOf('.');
      if (tldOffset <= 0 || tldOffset >= (domain.length-1)) {
        return false;
      }
      var sldOffset = domain.lastIndexOf('.', tldOffset-1);
      if (sldOffset <= 0 || sldOffset >= (tldOffset-1)) {
        return false;
      }
      var sldList = SLD.list[domain.slice(tldOffset+1)];
      if (!sldList) {
        return false;
      }
      return sldList.indexOf(' ' + domain.slice(sldOffset+1, tldOffset) + ' ') >= 0;
    },
    is: function(domain) {
      var tldOffset = domain.lastIndexOf('.');
      if (tldOffset <= 0 || tldOffset >= (domain.length-1)) {
        return false;
      }
      var sldOffset = domain.lastIndexOf('.', tldOffset-1);
      if (sldOffset >= 0) {
        return false;
      }
      var sldList = SLD.list[domain.slice(tldOffset+1)];
      if (!sldList) {
        return false;
      }
      return sldList.indexOf(' ' + domain.slice(0, tldOffset) + ' ') >= 0;
    },
    get: function(domain) {
      var tldOffset = domain.lastIndexOf('.');
      if (tldOffset <= 0 || tldOffset >= (domain.length-1)) {
        return null;
      }
      var sldOffset = domain.lastIndexOf('.', tldOffset-1);
      if (sldOffset <= 0 || sldOffset >= (tldOffset-1)) {
        return null;
      }
      var sldList = SLD.list[domain.slice(tldOffset+1)];
      if (!sldList) {
        return null;
      }
      if (sldList.indexOf(' ' + domain.slice(sldOffset+1, tldOffset) + ' ') < 0) {
        return null;
      }
      return domain.slice(sldOffset+1);
    },
    noConflict: function(){
      if (root.SecondLevelDomains === this) {
        root.SecondLevelDomains = _SecondLevelDomains;
      }
      return this;
    }
  };

  return SLD;
}));


/***/ }),
/* 7 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*
 This file is part of TALER
 (C) 2015 GNUnet e.V.

 TALER is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 TALER is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
Object.defineProperty(exports, "__esModule", { value: true });
const emscLoader_1 = __webpack_require__(14);
const emscLib = emscLoader_1.getLib();
/**
 * Size of a native pointer.  Must match the size
 * use when compiling via emscripten.
 */
const PTR_SIZE = 4;
const GNUNET_OK = 1;
/**
 * Get an emscripten-compiled function.
 */
const getEmsc = (name, ret, argTypes) => {
    return (...args) => {
        return emscLib.ccall(name, ret, argTypes, args);
    };
};
/**
 * Wrapped emscripten functions that do not allocate any memory.
 */
const emsc = {
    amount_add: getEmsc("TALER_amount_add", "number", ["number", "number", "number"]),
    amount_cmp: getEmsc("TALER_amount_cmp", "number", ["number", "number"]),
    amount_get_zero: getEmsc("TALER_amount_get_zero", "number", ["string", "number"]),
    amount_hton: getEmsc("TALER_amount_hton", "void", ["number", "number"]),
    amount_normalize: getEmsc("TALER_amount_normalize", "void", ["number"]),
    amount_ntoh: getEmsc("TALER_amount_ntoh", "void", ["number", "number"]),
    amount_subtract: getEmsc("TALER_amount_subtract", "number", ["number", "number", "number"]),
    ecdh_eddsa: getEmsc("GNUNET_CRYPTO_ecdh_eddsa", "number", ["number", "number", "number"]),
    eddsa_sign: getEmsc("GNUNET_CRYPTO_eddsa_sign", "number", ["number", "number", "number"]),
    eddsa_verify: getEmsc("GNUNET_CRYPTO_eddsa_verify", "number", ["number", "number", "number", "number"]),
    free: (ptr) => emscLib._free(ptr),
    get_currency: getEmsc("TALER_WR_get_currency", "string", ["number"]),
    get_fraction: getEmsc("TALER_WR_get_fraction", "number", ["number"]),
    get_value: getEmsc("TALER_WR_get_value", "number", ["number"]),
    hash: getEmsc("GNUNET_CRYPTO_hash", "void", ["number", "number", "number"]),
    hash_context_abort: getEmsc("GNUNET_CRYPTO_hash_context_abort", "void", ["number"]),
    hash_context_finish: getEmsc("GNUNET_CRYPTO_hash_context_finish", "void", ["number", "number"]),
    hash_context_read: getEmsc("GNUNET_CRYPTO_hash_context_read", "void", ["number", "number", "number"]),
    hash_create_random: getEmsc("GNUNET_CRYPTO_hash_create_random", "void", ["number", "number"]),
    memmove: getEmsc("memmove", "number", ["number", "number", "number"]),
    random_block: getEmsc("GNUNET_CRYPTO_random_block", "void", ["number", "number", "number"]),
    rsa_blinding_key_destroy: getEmsc("GNUNET_CRYPTO_rsa_blinding_key_free", "void", ["number"]),
    rsa_public_key_free: getEmsc("GNUNET_CRYPTO_rsa_public_key_free", "void", ["number"]),
    rsa_signature_free: getEmsc("GNUNET_CRYPTO_rsa_signature_free", "void", ["number"]),
    setup_fresh_coin: getEmsc("TALER_setup_fresh_coin", "void", ["number", "number", "number"]),
    string_to_data: getEmsc("GNUNET_STRINGS_string_to_data", "number", ["number", "number", "number", "number"]),
};
/**
 * Emscripten functions that allocate memory.
 */
const emscAlloc = {
    data_to_string_alloc: getEmsc("GNUNET_STRINGS_data_to_string_alloc", "number", ["number", "number"]),
    ecdhe_key_create: getEmsc("GNUNET_CRYPTO_ecdhe_key_create", "number", []),
    ecdhe_public_key_from_private: getEmsc("TALER_WRALL_ecdhe_public_key_from_private", "number", ["number"]),
    ecdsa_key_create: getEmsc("GNUNET_CRYPTO_ecdsa_key_create", "number", []),
    ecdsa_public_key_from_private: getEmsc("TALER_WRALL_ecdsa_public_key_from_private", "number", ["number"]),
    eddsa_key_create: getEmsc("GNUNET_CRYPTO_eddsa_key_create", "number", []),
    eddsa_public_key_from_private: getEmsc("TALER_WRALL_eddsa_public_key_from_private", "number", ["number"]),
    get_amount: getEmsc("TALER_WRALL_get_amount", "number", ["number", "number", "number", "string"]),
    hash_context_start: getEmsc("GNUNET_CRYPTO_hash_context_start", "number", []),
    malloc: (size) => emscLib._malloc(size),
    purpose_create: getEmsc("TALER_WRALL_purpose_create", "number", ["number", "number", "number"]),
    rsa_blind: getEmsc("GNUNET_CRYPTO_rsa_blind", "number", ["number", "number", "number", "number", "number"]),
    rsa_blinding_key_create: getEmsc("GNUNET_CRYPTO_rsa_blinding_key_create", "number", ["number"]),
    rsa_blinding_key_decode: getEmsc("GNUNET_CRYPTO_rsa_blinding_key_decode", "number", ["number", "number"]),
    rsa_blinding_key_encode: getEmsc("GNUNET_CRYPTO_rsa_blinding_key_encode", "number", ["number", "number"]),
    rsa_public_key_decode: getEmsc("GNUNET_CRYPTO_rsa_public_key_decode", "number", ["number", "number"]),
    rsa_public_key_encode: getEmsc("GNUNET_CRYPTO_rsa_public_key_encode", "number", ["number", "number"]),
    rsa_signature_decode: getEmsc("GNUNET_CRYPTO_rsa_signature_decode", "number", ["number", "number"]),
    rsa_signature_encode: getEmsc("GNUNET_CRYPTO_rsa_signature_encode", "number", ["number", "number"]),
    rsa_unblind: getEmsc("GNUNET_CRYPTO_rsa_unblind", "number", ["number", "number", "number"]),
};
/**
 * Constants for signatures purposes, define what the signatures vouches for.
 */
var SignaturePurpose;
(function (SignaturePurpose) {
    SignaturePurpose[SignaturePurpose["RESERVE_WITHDRAW"] = 1200] = "RESERVE_WITHDRAW";
    SignaturePurpose[SignaturePurpose["WALLET_COIN_DEPOSIT"] = 1201] = "WALLET_COIN_DEPOSIT";
    SignaturePurpose[SignaturePurpose["MASTER_DENOMINATION_KEY_VALIDITY"] = 1025] = "MASTER_DENOMINATION_KEY_VALIDITY";
    SignaturePurpose[SignaturePurpose["WALLET_COIN_MELT"] = 1202] = "WALLET_COIN_MELT";
    SignaturePurpose[SignaturePurpose["TEST"] = 4242] = "TEST";
    SignaturePurpose[SignaturePurpose["MERCHANT_PAYMENT_OK"] = 1104] = "MERCHANT_PAYMENT_OK";
    SignaturePurpose[SignaturePurpose["MASTER_WIRE_FEES"] = 1028] = "MASTER_WIRE_FEES";
    SignaturePurpose[SignaturePurpose["WALLET_COIN_PAYBACK"] = 1203] = "WALLET_COIN_PAYBACK";
})(SignaturePurpose = exports.SignaturePurpose || (exports.SignaturePurpose = {}));
/**
 * Desired quality levels for random numbers.
 */
var RandomQuality;
(function (RandomQuality) {
    RandomQuality[RandomQuality["WEAK"] = 0] = "WEAK";
    RandomQuality[RandomQuality["STRONG"] = 1] = "STRONG";
    RandomQuality[RandomQuality["NONCE"] = 2] = "NONCE";
})(RandomQuality = exports.RandomQuality || (exports.RandomQuality = {}));
/**
 * Context for cummulative hashing.
 */
class HashContext {
    constructor() {
        this.hashContextPtr = emscAlloc.hash_context_start();
    }
    /**
     * Add data to be hashed.
     */
    read(obj) {
        if (!this.hashContextPtr) {
            throw Error("assertion failed");
        }
        emsc.hash_context_read(this.hashContextPtr, obj.nativePtr, obj.size());
    }
    /**
     * Finish the hash computation.
     */
    finish(h) {
        if (!this.hashContextPtr) {
            throw Error("assertion failed");
        }
        h.alloc();
        emsc.hash_context_finish(this.hashContextPtr, h.nativePtr);
    }
    /**
     * Abort hashing without computing the result.
     */
    destroy() {
        if (this.hashContextPtr) {
            emsc.hash_context_abort(this.hashContextPtr);
        }
        this.hashContextPtr = undefined;
    }
}
exports.HashContext = HashContext;
/**
 * Arena object that points to an allocaed block of memory.
 */
class MallocArenaObject {
    constructor(arena) {
        this._nativePtr = undefined;
        /**
         * Is this a weak reference to the underlying memory?
         */
        this.isWeak = false;
        if (!arena) {
            if (arenaStack.length === 0) {
                throw Error("No arena available");
            }
            arena = arenaStack[arenaStack.length - 1];
        }
        arena.put(this);
    }
    destroy() {
        if (this._nativePtr && !this.isWeak) {
            emsc.free(this.nativePtr);
            this._nativePtr = undefined;
        }
    }
    alloc(size) {
        if (this._nativePtr !== undefined) {
            throw Error("Double allocation");
        }
        this.nativePtr = emscAlloc.malloc(size);
    }
    set nativePtr(v) {
        if (v === undefined) {
            throw Error("Native pointer must be a number or null");
        }
        this._nativePtr = v;
    }
    get nativePtr() {
        // We want to allow latent allocation
        // of native wrappers, but we never want to
        // pass 'undefined' to emscripten.
        if (this._nativePtr === undefined) {
            throw Error("Native pointer not initialized");
        }
        return this._nativePtr;
    }
}
/**
 * Arena that must be manually destroyed.
 */
class SimpleArena {
    constructor() {
        this.heap = [];
    }
    put(obj) {
        this.heap.push(obj);
    }
    destroy() {
        for (const obj of this.heap) {
            obj.destroy();
        }
        this.heap = [];
    }
}
/**
 * Arena that destroys all its objects once control has returned to the message
 * loop.
 */
class SyncArena extends SimpleArena {
    constructor() {
        super();
    }
    pub(obj) {
        super.put(obj);
        if (!this.isScheduled) {
            this.schedule();
        }
        this.heap.push(obj);
    }
    schedule() {
        this.isScheduled = true;
        Promise.resolve().then(() => {
            this.isScheduled = false;
            this.destroy();
        });
    }
}
const arenaStack = [];
arenaStack.push(new SyncArena());
/**
 * Representation of monetary value in a given currency.
 */
class Amount extends MallocArenaObject {
    constructor(args, arena) {
        super(arena);
        if (args) {
            this.nativePtr = emscAlloc.get_amount(args.value, 0, args.fraction, args.currency);
        }
        else {
            this.nativePtr = emscAlloc.get_amount(0, 0, 0, "");
        }
    }
    static getZero(currency, a) {
        const am = new Amount(undefined, a);
        const r = emsc.amount_get_zero(currency, am.nativePtr);
        if (r !== GNUNET_OK) {
            throw Error("invalid currency");
        }
        return am;
    }
    toNbo(a) {
        const x = new AmountNbo(a);
        x.alloc();
        emsc.amount_hton(x.nativePtr, this.nativePtr);
        return x;
    }
    fromNbo(nbo) {
        emsc.amount_ntoh(this.nativePtr, nbo.nativePtr);
    }
    get value() {
        return emsc.get_value(this.nativePtr);
    }
    get fraction() {
        return emsc.get_fraction(this.nativePtr);
    }
    get currency() {
        return emsc.get_currency(this.nativePtr);
    }
    toJson() {
        return {
            currency: emsc.get_currency(this.nativePtr),
            fraction: emsc.get_fraction(this.nativePtr),
            value: emsc.get_value(this.nativePtr),
        };
    }
    /**
     * Add an amount to this amount.
     */
    add(a) {
        const res = emsc.amount_add(this.nativePtr, a.nativePtr, this.nativePtr);
        if (res < 1) {
            // Overflow
            return false;
        }
        return true;
    }
    /**
     * Perform saturating subtraction on amounts.
     */
    sub(a) {
        // this = this - a
        const res = emsc.amount_subtract(this.nativePtr, this.nativePtr, a.nativePtr);
        if (res === 0) {
            // Underflow
            return false;
        }
        if (res > 0) {
            return true;
        }
        throw Error("Incompatible currencies");
    }
    cmp(a) {
        // If we don't check this, the c code aborts.
        if (this.currency !== a.currency) {
            throw Error(`incomparable currencies (${this.currency} and ${a.currency})`);
        }
        return emsc.amount_cmp(this.nativePtr, a.nativePtr);
    }
    normalize() {
        emsc.amount_normalize(this.nativePtr);
    }
}
exports.Amount = Amount;
/**
 * Count the UTF-8 characters in a JavaScript string.
 */
function countUtf8Bytes(str) {
    let s = str.length;
    // JavaScript strings are UTF-16 arrays
    for (let i = str.length - 1; i >= 0; i--) {
        const code = str.charCodeAt(i);
        if (code > 0x7f && code <= 0x7ff) {
            // We need an extra byte in utf-8 here
            s++;
        }
        else if (code > 0x7ff && code <= 0xffff) {
            // We need two extra bytes in utf-8 here
            s += 2;
        }
        // Skip over the other surrogate
        if (code >= 0xDC00 && code <= 0xDFFF) {
            i--;
        }
    }
    return s;
}
/**
 * Managed reference to a contiguous block of memory in the Emscripten heap.
 * Can be converted from / to a serialized representation.
 * Should contain only data, not pointers.
 */
class PackedArenaObject extends MallocArenaObject {
    constructor(a) {
        super(a);
    }
    randomize(qual = RandomQuality.STRONG) {
        emsc.random_block(qual, this.nativePtr, this.size());
    }
    toCrock() {
        const d = emscAlloc.data_to_string_alloc(this.nativePtr, this.size());
        const s = emscLib.Pointer_stringify(d);
        emsc.free(d);
        return s;
    }
    toJson() {
        // Per default, the json encoding of
        // packed arena objects is just the crockford encoding.
        // Subclasses typically want to override this.
        return this.toCrock();
    }
    loadCrock(s) {
        this.alloc();
        // We need to get the javascript string
        // to the emscripten heap first.
        const buf = ByteArray.fromStringWithNull(s);
        const res = emsc.string_to_data(buf.nativePtr, s.length, this.nativePtr, this.size());
        buf.destroy();
        if (res < 1) {
            throw { error: "wrong encoding" };
        }
    }
    alloc() {
        // FIXME: should the client be allowed to call alloc multiple times?
        if (!this._nativePtr) {
            this.nativePtr = emscAlloc.malloc(this.size());
        }
    }
    hash() {
        const x = new HashCode();
        x.alloc();
        emsc.hash(this.nativePtr, this.size(), x.nativePtr);
        return x;
    }
    hexdump() {
        const bytes = [];
        for (let i = 0; i < this.size(); i++) {
            let b = emscLib.getValue(this.nativePtr + i, "i8");
            b = (b + 256) % 256;
            bytes.push("0".concat(b.toString(16)).slice(-2));
        }
        const lines = [];
        for (let i = 0; i < bytes.length; i += 8) {
            lines.push(bytes.slice(i, i + 8).join(","));
        }
        return lines.join("\n");
    }
}
/**
 * Amount, encoded for network transmission.
 */
class AmountNbo extends PackedArenaObject {
    size() {
        return 24;
    }
    toJson() {
        const a = new SimpleArena();
        const am = new Amount(undefined, a);
        am.fromNbo(this);
        const json = am.toJson();
        a.destroy();
        return json;
    }
}
exports.AmountNbo = AmountNbo;
/**
 * Create a packed arena object from the base32 crockford encoding.
 */
function fromCrock(s, ctor) {
    const x = new ctor();
    x.alloc();
    x.loadCrock(s);
    return x;
}
/**
 * Create a packed arena object from the base32 crockford encoding for objects
 * that have a special decoding function.
 */
function fromCrockDecoded(s, ctor, decodeFn) {
    const obj = new ctor();
    const buf = ByteArray.fromCrock(s);
    obj.nativePtr = decodeFn(buf.nativePtr, buf.size());
    buf.destroy();
    return obj;
}
/**
 * Encode an object using a special encoding function.
 */
function encode(obj, encodeFn, arena) {
    const ptr = emscAlloc.malloc(PTR_SIZE);
    const len = encodeFn(obj.nativePtr, ptr);
    const res = new ByteArray(len, undefined, arena);
    res.nativePtr = emscLib.getValue(ptr, "*");
    emsc.free(ptr);
    return res;
}
/**
 * Private EdDSA key.
 */
class EddsaPrivateKey extends PackedArenaObject {
    static create(a) {
        const obj = new EddsaPrivateKey(a);
        obj.nativePtr = emscAlloc.eddsa_key_create();
        return obj;
    }
    size() {
        return 32;
    }
    getPublicKey(a) {
        const obj = new EddsaPublicKey(a);
        obj.nativePtr = emscAlloc.eddsa_public_key_from_private(this.nativePtr);
        return obj;
    }
    static fromCrock(s) {
        return fromCrock(s, this);
    }
}
exports.EddsaPrivateKey = EddsaPrivateKey;
/**
 * Low-level handle to an EdDSA private key.
 */
class EcdsaPrivateKey extends PackedArenaObject {
    static create(a) {
        const obj = new EcdsaPrivateKey(a);
        obj.nativePtr = emscAlloc.ecdsa_key_create();
        return obj;
    }
    size() {
        return 32;
    }
    getPublicKey(a) {
        const obj = new EcdsaPublicKey(a);
        obj.nativePtr = emscAlloc.ecdsa_public_key_from_private(this.nativePtr);
        return obj;
    }
    static fromCrock(s) {
        return fromCrock(s, this);
    }
}
exports.EcdsaPrivateKey = EcdsaPrivateKey;
/**
 * Low-level handle to an ECDHE private key.
 */
class EcdhePrivateKey extends PackedArenaObject {
    static create(a) {
        const obj = new EcdhePrivateKey(a);
        obj.nativePtr = emscAlloc.ecdhe_key_create();
        return obj;
    }
    size() {
        return 32;
    }
    getPublicKey(a) {
        const obj = new EcdhePublicKey(a);
        obj.nativePtr = emscAlloc.ecdhe_public_key_from_private(this.nativePtr);
        return obj;
    }
    static fromCrock(s) {
        return fromCrock(s, this);
    }
}
exports.EcdhePrivateKey = EcdhePrivateKey;
/**
 * Low-level handle to an EdDSA public key.
 */
class EddsaPublicKey extends PackedArenaObject {
    size() {
        return 32;
    }
    static fromCrock(s) {
        return fromCrock(s, this);
    }
}
exports.EddsaPublicKey = EddsaPublicKey;
/**
 * Low-level handle to an ECDSA public key.
 */
class EcdsaPublicKey extends PackedArenaObject {
    size() {
        return 32;
    }
    static fromCrock(s) {
        return fromCrock(s, this);
    }
}
exports.EcdsaPublicKey = EcdsaPublicKey;
/**
 * Low-level handle to an ECDHE public key.
 */
class EcdhePublicKey extends PackedArenaObject {
    size() {
        return 32;
    }
    static fromCrock(s) {
        return fromCrock(s, this);
    }
}
exports.EcdhePublicKey = EcdhePublicKey;
/**
 * Low-level handle to a blinding key secret.
 */
class RsaBlindingKeySecret extends PackedArenaObject {
    size() {
        return 32;
    }
    /**
     * Create a random blinding key secret.
     */
    static create(a) {
        const o = new RsaBlindingKeySecret(a);
        o.alloc();
        o.randomize();
        return o;
    }
    static fromCrock(s) {
        return fromCrock(s, this);
    }
}
exports.RsaBlindingKeySecret = RsaBlindingKeySecret;
/**
 * Low-level handle to a hash code.
 */
class HashCode extends PackedArenaObject {
    size() {
        return 64;
    }
    static fromCrock(s) {
        return fromCrock(s, this);
    }
    random(qual = RandomQuality.STRONG) {
        this.alloc();
        emsc.hash_create_random(qual, this.nativePtr);
    }
}
exports.HashCode = HashCode;
/**
 * Low-level handle to a byte array.
 */
class ByteArray extends PackedArenaObject {
    size() {
        return this.allocatedSize;
    }
    constructor(desiredSize, init, a) {
        super(a);
        if (init === undefined) {
            this.nativePtr = emscAlloc.malloc(desiredSize);
        }
        else {
            this.nativePtr = init;
        }
        this.allocatedSize = desiredSize;
    }
    static fromStringWithoutNull(s, a) {
        // UTF-8 bytes, including 0-terminator
        const terminatedByteLength = countUtf8Bytes(s) + 1;
        const hstr = emscAlloc.malloc(terminatedByteLength);
        emscLib.stringToUTF8(s, hstr, terminatedByteLength);
        return new ByteArray(terminatedByteLength - 1, hstr, a);
    }
    static fromStringWithNull(s, a) {
        // UTF-8 bytes, including 0-terminator
        const terminatedByteLength = countUtf8Bytes(s) + 1;
        const hstr = emscAlloc.malloc(terminatedByteLength);
        emscLib.stringToUTF8(s, hstr, terminatedByteLength);
        return new ByteArray(terminatedByteLength, hstr, a);
    }
    static fromCrock(s, a) {
        // this one is a bit more complicated than the other fromCrock functions,
        // since we don't have a fixed size
        const byteLength = countUtf8Bytes(s);
        const hstr = emscAlloc.malloc(byteLength + 1);
        emscLib.stringToUTF8(s, hstr, byteLength + 1);
        const decodedLen = Math.floor((byteLength * 5) / 8);
        const ba = new ByteArray(decodedLen, undefined, a);
        const res = emsc.string_to_data(hstr, byteLength, ba.nativePtr, decodedLen);
        emsc.free(hstr);
        if (res !== GNUNET_OK) {
            throw Error("decoding failed");
        }
        return ba;
    }
}
exports.ByteArray = ByteArray;
/**
 * Data to sign, together with a header that includes a purpose id
 * and size.
 */
class EccSignaturePurpose extends PackedArenaObject {
    size() {
        return this.payloadSize + 8;
    }
    constructor(purpose, payload, a) {
        super(a);
        this.nativePtr = emscAlloc.purpose_create(purpose, payload.nativePtr, payload.size());
        this.payloadSize = payload.size();
    }
}
exports.EccSignaturePurpose = EccSignaturePurpose;
class SignatureStruct {
    constructor(x) {
        this.members = {};
        for (const k in x) {
            this.set(k, x[k]);
        }
    }
    toPurpose(a) {
        let totalSize = 0;
        for (const f of this.fieldTypes()) {
            const name = f[0];
            const member = this.members[name];
            if (!member) {
                throw Error(`Member ${name} not set`);
            }
            totalSize += member.size();
        }
        const buf = emscAlloc.malloc(totalSize);
        let ptr = buf;
        for (const f of this.fieldTypes()) {
            const name = f[0];
            const member = this.members[name];
            const size = member.size();
            emsc.memmove(ptr, member.nativePtr, size);
            ptr += size;
        }
        const ba = new ByteArray(totalSize, buf, a);
        return new EccSignaturePurpose(this.purpose(), ba);
    }
    toJson() {
        const res = {};
        for (const f of this.fieldTypes()) {
            const name = f[0];
            const member = this.members[name];
            if (!member) {
                throw Error(`Member ${name} not set`);
            }
            res[name] = member.toJson();
        }
        res.purpose = this.purpose();
        return res;
    }
    set(name, value) {
        const typemap = {};
        for (const f of this.fieldTypes()) {
            typemap[f[0]] = f[1];
        }
        if (!(name in typemap)) {
            throw Error(`Key ${name} not found`);
        }
        if (!(value instanceof typemap[name])) {
            throw Error("Wrong type for ${name}");
        }
        this.members[name] = value;
    }
}
/**
 * Low-level handle to a WithdrawRequest signature structure.
 */
class WithdrawRequestPS extends SignatureStruct {
    constructor(w) {
        super(w);
    }
    purpose() {
        return SignaturePurpose.RESERVE_WITHDRAW;
    }
    fieldTypes() {
        return [
            ["reserve_pub", EddsaPublicKey],
            ["amount_with_fee", AmountNbo],
            ["withdraw_fee", AmountNbo],
            ["h_denomination_pub", HashCode],
            ["h_coin_envelope", HashCode],
        ];
    }
}
exports.WithdrawRequestPS = WithdrawRequestPS;
/**
 * Low-level handle to a PaybackRequest signature structure.
 */
class PaybackRequestPS extends SignatureStruct {
    constructor(w) {
        super(w);
    }
    purpose() {
        return SignaturePurpose.WALLET_COIN_PAYBACK;
    }
    fieldTypes() {
        return [
            ["coin_pub", EddsaPublicKey],
            ["h_denom_pub", HashCode],
            ["coin_blind", RsaBlindingKeySecret],
        ];
    }
}
exports.PaybackRequestPS = PaybackRequestPS;
/**
 * Low-level handle to a RefreshMeltCoinAffirmationPS signature structure.
 */
class RefreshMeltCoinAffirmationPS extends SignatureStruct {
    constructor(w) {
        super(w);
    }
    purpose() {
        return SignaturePurpose.WALLET_COIN_MELT;
    }
    fieldTypes() {
        return [
            ["session_hash", HashCode],
            ["amount_with_fee", AmountNbo],
            ["melt_fee", AmountNbo],
            ["coin_pub", EddsaPublicKey],
        ];
    }
}
exports.RefreshMeltCoinAffirmationPS = RefreshMeltCoinAffirmationPS;
/**
 * Low-level handle to a structure being signed over.
 */
class MasterWireFeePS extends SignatureStruct {
    constructor(w) {
        super(w);
    }
    purpose() {
        return SignaturePurpose.MASTER_WIRE_FEES;
    }
    fieldTypes() {
        return [
            ["h_wire_method", HashCode],
            ["start_date", AbsoluteTimeNbo],
            ["end_date", AbsoluteTimeNbo],
            ["wire_fee", AmountNbo],
            ["closing_fee", AmountNbo],
        ];
    }
}
exports.MasterWireFeePS = MasterWireFeePS;
/**
 * Low-level handle to an absolute time in network byte order (NBO).
 */
class AbsoluteTimeNbo extends PackedArenaObject {
    static fromTalerString(s) {
        const x = new AbsoluteTimeNbo();
        x.alloc();
        const r = /Date\(([0-9]+)\)/;
        const m = r.exec(s);
        if (!m || m.length !== 2) {
            throw Error();
        }
        const n = parseInt(m[1], 10) * 1000000;
        // XXX: This only works up to 54 bit numbers.
        set64(x.nativePtr, n);
        return x;
    }
    static fromStampSeconds(stamp) {
        const x = new AbsoluteTimeNbo();
        x.alloc();
        // XXX: This only works up to 54 bit numbers.
        set64(x.nativePtr, stamp * 1000000);
        return x;
    }
    size() {
        return 8;
    }
}
exports.AbsoluteTimeNbo = AbsoluteTimeNbo;
// XXX: This only works up to 54 bit numbers.
function set64(p, n) {
    for (let i = 0; i < 8; ++i) {
        emscLib.setValue(p + (7 - i), n & 0xFF, "i8");
        n = Math.floor(n / 256);
    }
}
// XXX: This only works up to 54 bit numbers.
function set32(p, n) {
    for (let i = 0; i < 4; ++i) {
        emscLib.setValue(p + (3 - i), n & 0xFF, "i8");
        n = Math.floor(n / 256);
    }
}
/**
 * Low-level handle to an unsigned 64-bit value.
 */
class UInt64 extends PackedArenaObject {
    static fromNumber(n) {
        const x = new UInt64();
        x.alloc();
        set64(x.nativePtr, n);
        return x;
    }
    size() {
        return 8;
    }
}
exports.UInt64 = UInt64;
/**
 * Low-level handle to an unsigned 32-bit value.
 */
class UInt32 extends PackedArenaObject {
    static fromNumber(n) {
        const x = new UInt32();
        x.alloc();
        set32(x.nativePtr, n);
        return x;
    }
    size() {
        return 4;
    }
}
exports.UInt32 = UInt32;
/**
 * Low-level handle to a struct being signed over.
 */
class DepositRequestPS extends SignatureStruct {
    constructor(w) {
        super(w);
    }
    purpose() {
        return SignaturePurpose.WALLET_COIN_DEPOSIT;
    }
    fieldTypes() {
        return [
            ["h_contract", HashCode],
            ["h_wire", HashCode],
            ["timestamp", AbsoluteTimeNbo],
            ["refund_deadline", AbsoluteTimeNbo],
            ["amount_with_fee", AmountNbo],
            ["deposit_fee", AmountNbo],
            ["merchant", EddsaPublicKey],
            ["coin_pub", EddsaPublicKey],
        ];
    }
}
exports.DepositRequestPS = DepositRequestPS;
/**
 * Low-level handle to a structure being signed over.
 */
class DenominationKeyValidityPS extends SignatureStruct {
    constructor(w) {
        super(w);
    }
    purpose() {
        return SignaturePurpose.MASTER_DENOMINATION_KEY_VALIDITY;
    }
    fieldTypes() {
        return [
            ["master", EddsaPublicKey],
            ["start", AbsoluteTimeNbo],
            ["expire_withdraw", AbsoluteTimeNbo],
            ["expire_spend", AbsoluteTimeNbo],
            ["expire_legal", AbsoluteTimeNbo],
            ["value", AmountNbo],
            ["fee_withdraw", AmountNbo],
            ["fee_deposit", AmountNbo],
            ["fee_refresh", AmountNbo],
            ["fee_refund", AmountNbo],
            ["denom_hash", HashCode],
        ];
    }
}
exports.DenominationKeyValidityPS = DenominationKeyValidityPS;
/**
 * Low-level handle to a structure being signed over.
 */
class PaymentSignaturePS extends SignatureStruct {
    constructor(w) {
        super(w);
    }
    purpose() {
        return SignaturePurpose.MERCHANT_PAYMENT_OK;
    }
    fieldTypes() {
        return [
            ["contract_hash", HashCode],
        ];
    }
}
exports.PaymentSignaturePS = PaymentSignaturePS;
/**
 * Low-level handle to an RsaPublicKey.
 */
class RsaPublicKey extends MallocArenaObject {
    static fromCrock(s) {
        return fromCrockDecoded(s, this, emscAlloc.rsa_public_key_decode);
    }
    toCrock() {
        return this.encode().toCrock();
    }
    destroy() {
        emsc.rsa_public_key_free(this.nativePtr);
        this.nativePtr = 0;
    }
    encode(arena) {
        return encode(this, emscAlloc.rsa_public_key_encode);
    }
}
exports.RsaPublicKey = RsaPublicKey;
/**
 * Low-level handle to an EddsaSignature.
 */
class EddsaSignature extends PackedArenaObject {
    size() {
        return 64;
    }
    static fromCrock(s) {
        return fromCrock(s, this);
    }
}
exports.EddsaSignature = EddsaSignature;
/**
 * Low-level handle to an RsaSignature.
 */
class RsaSignature extends MallocArenaObject {
    static fromCrock(s, a) {
        return fromCrockDecoded(s, this, emscAlloc.rsa_signature_decode);
    }
    encode(arena) {
        return encode(this, emscAlloc.rsa_signature_encode);
    }
    destroy() {
        emsc.rsa_signature_free(this.nativePtr);
        this.nativePtr = 0;
    }
}
exports.RsaSignature = RsaSignature;
/**
 * Blind a value so it can be blindly signed.
 */
function rsaBlind(hashCode, blindingKey, pkey, arena) {
    const buf_ptr_out = emscAlloc.malloc(PTR_SIZE);
    const buf_size_out = emscAlloc.malloc(PTR_SIZE);
    const res = emscAlloc.rsa_blind(hashCode.nativePtr, blindingKey.nativePtr, pkey.nativePtr, buf_ptr_out, buf_size_out);
    const buf_ptr = emscLib.getValue(buf_ptr_out, "*");
    const buf_size = emscLib.getValue(buf_size_out, "*");
    emsc.free(buf_ptr_out);
    emsc.free(buf_size_out);
    if (res !== GNUNET_OK) {
        // malicious key
        return null;
    }
    return new ByteArray(buf_size, buf_ptr, arena);
}
exports.rsaBlind = rsaBlind;
/**
 * Sign data using EdDSA.
 */
function eddsaSign(purpose, priv, a) {
    const sig = new EddsaSignature(a);
    sig.alloc();
    const res = emsc.eddsa_sign(priv.nativePtr, purpose.nativePtr, sig.nativePtr);
    if (res < 1) {
        throw Error("EdDSA signing failed");
    }
    return sig;
}
exports.eddsaSign = eddsaSign;
/**
 * Verify EdDSA-signed data.
 */
function eddsaVerify(purposeNum, verify, sig, pub, a) {
    const r = emsc.eddsa_verify(purposeNum, verify.nativePtr, sig.nativePtr, pub.nativePtr);
    return r === GNUNET_OK;
}
exports.eddsaVerify = eddsaVerify;
/**
 * Unblind a blindly signed value.
 */
function rsaUnblind(sig, bk, pk, a) {
    const x = new RsaSignature(a);
    x.nativePtr = emscAlloc.rsa_unblind(sig.nativePtr, bk.nativePtr, pk.nativePtr);
    return x;
}
exports.rsaUnblind = rsaUnblind;
/**
 * Diffie-Hellman operation between an ECDHE private key
 * and an EdDSA public key.
 */
function ecdhEddsa(priv, pub) {
    const h = new HashCode();
    h.alloc();
    const res = emsc.ecdh_eddsa(priv.nativePtr, pub.nativePtr, h.nativePtr);
    if (res !== GNUNET_OK) {
        throw Error("ecdh_eddsa failed");
    }
    return h;
}
exports.ecdhEddsa = ecdhEddsa;
/**
 * Derive a fresh coin from the given seed.  Used during refreshing.
 */
function setupFreshCoin(secretSeed, coinIndex) {
    const priv = new EddsaPrivateKey();
    priv.isWeak = true;
    const blindingKey = new RsaBlindingKeySecret();
    blindingKey.isWeak = true;
    const buf = new ByteArray(priv.size() + blindingKey.size());
    emsc.setup_fresh_coin(secretSeed.nativePtr, coinIndex, buf.nativePtr);
    priv.nativePtr = buf.nativePtr;
    blindingKey.nativePtr = buf.nativePtr + priv.size();
    return { priv, blindingKey };
}
exports.setupFreshCoin = setupFreshCoin;


/***/ }),
/* 8 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*
 This file is part of TALER
 (C) 2016 GNUnet e.V.

 TALER is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 TALER is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Web worker for crypto operations.
 */
/**
 * Imports.
 */
const Amounts = __webpack_require__(0);
const dbTypes_1 = __webpack_require__(9);
const helpers_1 = __webpack_require__(2);
const emscInterface_1 = __webpack_require__(7);
const native = __webpack_require__(7);
var RpcFunctions;
(function (RpcFunctions) {
    /**
     * Create a pre-coin of the given denomination to be withdrawn from then given
     * reserve.
     */
    function createPreCoin(denom, reserve) {
        const reservePriv = new native.EddsaPrivateKey();
        reservePriv.loadCrock(reserve.reserve_priv);
        const reservePub = new native.EddsaPublicKey();
        reservePub.loadCrock(reserve.reserve_pub);
        const denomPub = native.RsaPublicKey.fromCrock(denom.denomPub);
        const coinPriv = native.EddsaPrivateKey.create();
        const coinPub = coinPriv.getPublicKey();
        const blindingFactor = native.RsaBlindingKeySecret.create();
        const pubHash = coinPub.hash();
        const ev = native.rsaBlind(pubHash, blindingFactor, denomPub);
        if (!ev) {
            throw Error("couldn't blind (malicious exchange key?)");
        }
        if (!denom.feeWithdraw) {
            throw Error("Field fee_withdraw missing");
        }
        const amountWithFee = new native.Amount(denom.value);
        amountWithFee.add(new native.Amount(denom.feeWithdraw));
        const withdrawFee = new native.Amount(denom.feeWithdraw);
        // Signature
        const withdrawRequest = new native.WithdrawRequestPS({
            amount_with_fee: amountWithFee.toNbo(),
            h_coin_envelope: ev.hash(),
            h_denomination_pub: denomPub.encode().hash(),
            reserve_pub: reservePub,
            withdraw_fee: withdrawFee.toNbo(),
        });
        const sig = native.eddsaSign(withdrawRequest.toPurpose(), reservePriv);
        const preCoin = {
            blindingKey: blindingFactor.toCrock(),
            coinEv: ev.toCrock(),
            coinPriv: coinPriv.toCrock(),
            coinPub: coinPub.toCrock(),
            coinValue: denom.value,
            denomPub: denomPub.encode().toCrock(),
            exchangeBaseUrl: reserve.exchange_base_url,
            isFromTip: false,
            reservePub: reservePub.toCrock(),
            withdrawSig: sig.toCrock(),
        };
        return preCoin;
    }
    RpcFunctions.createPreCoin = createPreCoin;
    /**
     * Create a planchet used for tipping, including the private keys.
     */
    function createTipPlanchet(denom) {
        const denomPub = native.RsaPublicKey.fromCrock(denom.denomPub);
        const coinPriv = native.EddsaPrivateKey.create();
        const coinPub = coinPriv.getPublicKey();
        const blindingFactor = native.RsaBlindingKeySecret.create();
        const pubHash = coinPub.hash();
        const ev = native.rsaBlind(pubHash, blindingFactor, denomPub);
        if (!ev) {
            throw Error("couldn't blind (malicious exchange key?)");
        }
        if (!denom.feeWithdraw) {
            throw Error("Field fee_withdraw missing");
        }
        const tipPlanchet = {
            blindingKey: blindingFactor.toCrock(),
            coinEv: ev.toCrock(),
            coinPriv: coinPriv.toCrock(),
            coinPub: coinPub.toCrock(),
            coinValue: denom.value,
            denomPub: denomPub.encode().toCrock(),
            denomPubHash: denomPub.encode().hash().toCrock(),
        };
        return tipPlanchet;
    }
    RpcFunctions.createTipPlanchet = createTipPlanchet;
    /**
     * Create and sign a message to request payback for a coin.
     */
    function createPaybackRequest(coin) {
        const p = new native.PaybackRequestPS({
            coin_blind: native.RsaBlindingKeySecret.fromCrock(coin.blindingKey),
            coin_pub: native.EddsaPublicKey.fromCrock(coin.coinPub),
            h_denom_pub: native.RsaPublicKey.fromCrock(coin.denomPub).encode().hash(),
        });
        const coinPriv = native.EddsaPrivateKey.fromCrock(coin.coinPriv);
        const coinSig = native.eddsaSign(p.toPurpose(), coinPriv);
        const paybackRequest = {
            coin_blind_key_secret: coin.blindingKey,
            coin_pub: coin.coinPub,
            coin_sig: coinSig.toCrock(),
            denom_pub: coin.denomPub,
            denom_sig: coin.denomSig,
        };
        return paybackRequest;
    }
    RpcFunctions.createPaybackRequest = createPaybackRequest;
    /**
     * Check if a payment signature is valid.
     */
    function isValidPaymentSignature(sig, contractHash, merchantPub) {
        const p = new native.PaymentSignaturePS({
            contract_hash: native.HashCode.fromCrock(contractHash),
        });
        const nativeSig = new native.EddsaSignature();
        nativeSig.loadCrock(sig);
        const nativePub = native.EddsaPublicKey.fromCrock(merchantPub);
        return native.eddsaVerify(native.SignaturePurpose.MERCHANT_PAYMENT_OK, p.toPurpose(), nativeSig, nativePub);
    }
    RpcFunctions.isValidPaymentSignature = isValidPaymentSignature;
    /**
     * Check if a wire fee is correctly signed.
     */
    function isValidWireFee(type, wf, masterPub) {
        const p = new native.MasterWireFeePS({
            closing_fee: (new native.Amount(wf.closingFee)).toNbo(),
            end_date: native.AbsoluteTimeNbo.fromStampSeconds(wf.endStamp),
            h_wire_method: native.ByteArray.fromStringWithNull(type).hash(),
            start_date: native.AbsoluteTimeNbo.fromStampSeconds(wf.startStamp),
            wire_fee: (new native.Amount(wf.wireFee)).toNbo(),
        });
        const nativeSig = new native.EddsaSignature();
        nativeSig.loadCrock(wf.sig);
        const nativePub = native.EddsaPublicKey.fromCrock(masterPub);
        return native.eddsaVerify(native.SignaturePurpose.MASTER_WIRE_FEES, p.toPurpose(), nativeSig, nativePub);
    }
    RpcFunctions.isValidWireFee = isValidWireFee;
    /**
     * Check if the signature of a denomination is valid.
     */
    function isValidDenom(denom, masterPub) {
        const p = new native.DenominationKeyValidityPS({
            denom_hash: native.RsaPublicKey.fromCrock(denom.denomPub).encode().hash(),
            expire_legal: native.AbsoluteTimeNbo.fromTalerString(denom.stampExpireLegal),
            expire_spend: native.AbsoluteTimeNbo.fromTalerString(denom.stampExpireDeposit),
            expire_withdraw: native.AbsoluteTimeNbo.fromTalerString(denom.stampExpireWithdraw),
            fee_deposit: (new native.Amount(denom.feeDeposit)).toNbo(),
            fee_refresh: (new native.Amount(denom.feeRefresh)).toNbo(),
            fee_refund: (new native.Amount(denom.feeRefund)).toNbo(),
            fee_withdraw: (new native.Amount(denom.feeWithdraw)).toNbo(),
            master: native.EddsaPublicKey.fromCrock(masterPub),
            start: native.AbsoluteTimeNbo.fromTalerString(denom.stampStart),
            value: (new native.Amount(denom.value)).toNbo(),
        });
        const nativeSig = new native.EddsaSignature();
        nativeSig.loadCrock(denom.masterSig);
        const nativePub = native.EddsaPublicKey.fromCrock(masterPub);
        return native.eddsaVerify(native.SignaturePurpose.MASTER_DENOMINATION_KEY_VALIDITY, p.toPurpose(), nativeSig, nativePub);
    }
    RpcFunctions.isValidDenom = isValidDenom;
    /**
     * Create a new EdDSA key pair.
     */
    function createEddsaKeypair() {
        const priv = native.EddsaPrivateKey.create();
        const pub = priv.getPublicKey();
        return { priv: priv.toCrock(), pub: pub.toCrock() };
    }
    RpcFunctions.createEddsaKeypair = createEddsaKeypair;
    /**
     * Unblind a blindly signed value.
     */
    function rsaUnblind(sig, bk, pk) {
        const denomSig = native.rsaUnblind(native.RsaSignature.fromCrock(sig), native.RsaBlindingKeySecret.fromCrock(bk), native.RsaPublicKey.fromCrock(pk));
        return denomSig.encode().toCrock();
    }
    RpcFunctions.rsaUnblind = rsaUnblind;
    /**
     * Generate updated coins (to store in the database)
     * and deposit permissions for each given coin.
     */
    function signDeposit(contractTerms, cds, totalAmount) {
        const ret = {
            originalCoins: [],
            sigs: [],
            updatedCoins: [],
        };
        const contractTermsHash = hashString(helpers_1.canonicalJson(contractTerms));
        const feeList = cds.map((x) => x.denom.feeDeposit);
        let fees = Amounts.add(Amounts.getZero(feeList[0].currency), ...feeList).amount;
        // okay if saturates
        fees = Amounts.sub(fees, Amounts.parseOrThrow(contractTerms.max_fee)).amount;
        const total = Amounts.add(fees, totalAmount).amount;
        const amountSpent = native.Amount.getZero(cds[0].coin.currentAmount.currency);
        const amountRemaining = new native.Amount(total);
        for (const cd of cds) {
            let coinSpend;
            const originalCoin = Object.assign({}, (cd.coin));
            if (amountRemaining.value === 0 && amountRemaining.fraction === 0) {
                break;
            }
            if (amountRemaining.cmp(new native.Amount(cd.coin.currentAmount)) < 0) {
                coinSpend = new native.Amount(amountRemaining.toJson());
            }
            else {
                coinSpend = new native.Amount(cd.coin.currentAmount);
            }
            amountSpent.add(coinSpend);
            amountRemaining.sub(coinSpend);
            const feeDeposit = new native.Amount(cd.denom.feeDeposit);
            // Give the merchant at least the deposit fee, otherwise it'll reject
            // the coin.
            if (coinSpend.cmp(feeDeposit) < 0) {
                coinSpend = feeDeposit;
            }
            const newAmount = new native.Amount(cd.coin.currentAmount);
            newAmount.sub(coinSpend);
            cd.coin.currentAmount = newAmount.toJson();
            cd.coin.status = dbTypes_1.CoinStatus.PurchasePending;
            const d = new native.DepositRequestPS({
                amount_with_fee: coinSpend.toNbo(),
                coin_pub: native.EddsaPublicKey.fromCrock(cd.coin.coinPub),
                deposit_fee: new native.Amount(cd.denom.feeDeposit).toNbo(),
                h_contract: native.HashCode.fromCrock(contractTermsHash),
                h_wire: native.HashCode.fromCrock(contractTerms.H_wire),
                merchant: native.EddsaPublicKey.fromCrock(contractTerms.merchant_pub),
                refund_deadline: native.AbsoluteTimeNbo.fromTalerString(contractTerms.refund_deadline),
                timestamp: native.AbsoluteTimeNbo.fromTalerString(contractTerms.timestamp),
            });
            const coinSig = native.eddsaSign(d.toPurpose(), native.EddsaPrivateKey.fromCrock(cd.coin.coinPriv))
                .toCrock();
            const s = {
                coin_pub: cd.coin.coinPub,
                coin_sig: coinSig,
                contribution: Amounts.toString(coinSpend.toJson()),
                denom_pub: cd.coin.denomPub,
                exchange_url: cd.denom.exchangeBaseUrl,
                ub_sig: cd.coin.denomSig,
            };
            ret.sigs.push(s);
            ret.updatedCoins.push(cd.coin);
            ret.originalCoins.push(originalCoin);
        }
        return ret;
    }
    RpcFunctions.signDeposit = signDeposit;
    /**
     * Create a new refresh session.
     */
    function createRefreshSession(exchangeBaseUrl, kappa, meltCoin, newCoinDenoms, meltFee) {
        let valueWithFee = Amounts.getZero(newCoinDenoms[0].value.currency);
        for (const ncd of newCoinDenoms) {
            valueWithFee = Amounts.add(valueWithFee, ncd.value, ncd.feeWithdraw).amount;
        }
        // melt fee
        valueWithFee = Amounts.add(valueWithFee, meltFee).amount;
        const sessionHc = new emscInterface_1.HashContext();
        const transferPubs = [];
        const transferPrivs = [];
        const preCoinsForGammas = [];
        for (let i = 0; i < kappa; i++) {
            const t = native.EcdhePrivateKey.create();
            const pub = t.getPublicKey();
            sessionHc.read(pub);
            transferPrivs.push(t.toCrock());
            transferPubs.push(pub.toCrock());
        }
        for (const denom of newCoinDenoms) {
            const r = native.RsaPublicKey.fromCrock(denom.denomPub);
            sessionHc.read(r.encode());
        }
        sessionHc.read(native.EddsaPublicKey.fromCrock(meltCoin.coinPub));
        sessionHc.read((new native.Amount(valueWithFee)).toNbo());
        for (let i = 0; i < kappa; i++) {
            const preCoins = [];
            for (let j = 0; j < newCoinDenoms.length; j++) {
                const transferPriv = native.EcdhePrivateKey.fromCrock(transferPrivs[i]);
                const oldCoinPub = native.EddsaPublicKey.fromCrock(meltCoin.coinPub);
                const transferSecret = native.ecdhEddsa(transferPriv, oldCoinPub);
                const fresh = native.setupFreshCoin(transferSecret, j);
                const coinPriv = fresh.priv;
                const coinPub = coinPriv.getPublicKey();
                const blindingFactor = fresh.blindingKey;
                const pubHash = coinPub.hash();
                const denomPub = native.RsaPublicKey.fromCrock(newCoinDenoms[j].denomPub);
                const ev = native.rsaBlind(pubHash, blindingFactor, denomPub);
                if (!ev) {
                    throw Error("couldn't blind (malicious exchange key?)");
                }
                const preCoin = {
                    blindingKey: blindingFactor.toCrock(),
                    coinEv: ev.toCrock(),
                    privateKey: coinPriv.toCrock(),
                    publicKey: coinPub.toCrock(),
                };
                preCoins.push(preCoin);
                sessionHc.read(ev);
            }
            preCoinsForGammas.push(preCoins);
        }
        const sessionHash = new emscInterface_1.HashCode();
        sessionHash.alloc();
        sessionHc.finish(sessionHash);
        const confirmData = new emscInterface_1.RefreshMeltCoinAffirmationPS({
            amount_with_fee: (new emscInterface_1.Amount(valueWithFee)).toNbo(),
            coin_pub: emscInterface_1.EddsaPublicKey.fromCrock(meltCoin.coinPub),
            melt_fee: (new emscInterface_1.Amount(meltFee)).toNbo(),
            session_hash: sessionHash,
        });
        const confirmSig = native.eddsaSign(confirmData.toPurpose(), native.EddsaPrivateKey.fromCrock(meltCoin.coinPriv)).toCrock();
        let valueOutput = Amounts.getZero(newCoinDenoms[0].value.currency);
        for (const denom of newCoinDenoms) {
            valueOutput = Amounts.add(valueOutput, denom.value).amount;
        }
        const refreshSession = {
            confirmSig,
            exchangeBaseUrl,
            finished: false,
            hash: sessionHash.toCrock(),
            meltCoinPub: meltCoin.coinPub,
            newDenomHashes: newCoinDenoms.map((d) => d.denomPubHash),
            newDenoms: newCoinDenoms.map((d) => d.denomPub),
            norevealIndex: undefined,
            preCoinsForGammas,
            transferPrivs,
            transferPubs,
            valueOutput,
            valueWithFee,
        };
        return refreshSession;
    }
    RpcFunctions.createRefreshSession = createRefreshSession;
    /**
     * Hash a string including the zero terminator.
     */
    function hashString(str) {
        const b = native.ByteArray.fromStringWithNull(str);
        return b.hash().toCrock();
    }
    RpcFunctions.hashString = hashString;
    /**
     * Hash a denomination public key.
     */
    function hashDenomPub(denomPub) {
        return native.RsaPublicKey.fromCrock(denomPub).encode().hash().toCrock();
    }
    RpcFunctions.hashDenomPub = hashDenomPub;
})(RpcFunctions || (RpcFunctions = {}));
const worker = self;
worker.onmessage = (msg) => {
    if (!Array.isArray(msg.data.args)) {
        console.error("args must be array");
        return;
    }
    if (typeof msg.data.id !== "number") {
        console.error("RPC id must be number");
    }
    if (typeof msg.data.operation !== "string") {
        console.error("RPC operation must be string");
    }
    const f = RpcFunctions[msg.data.operation];
    if (!f) {
        console.error(`unknown operation: '${msg.data.operation}'`);
        return;
    }
    const res = f(...msg.data.args);
    worker.postMessage({ result: res, id: msg.data.id });
};


/***/ }),
/* 9 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*
 This file is part of TALER
 (C) 2018 GNUnet e.V. and INRIA

 TALER is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 TALER is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Types for records stored in the wallet's database.
 *
 * Types for the objects in the database should end in "-Record".
 */
/**
 * Imports.
 */
const amounts_1 = __webpack_require__(0);
const checkable_1 = __webpack_require__(1);
const talerTypes_1 = __webpack_require__(10);
const query_1 = __webpack_require__(13);
/**
 * Current database version, should be incremented
 * each time we do incompatible schema changes on the database.
 * In the future we might consider adding migration functions for
 * each version increment.
 */
exports.WALLET_DB_VERSION = 26;
/**
 * Status of a denomination.
 */
var DenominationStatus;
(function (DenominationStatus) {
    /**
     * Verification was delayed.
     */
    DenominationStatus[DenominationStatus["Unverified"] = 0] = "Unverified";
    /**
     * Verified as valid.
     */
    DenominationStatus[DenominationStatus["VerifiedGood"] = 1] = "VerifiedGood";
    /**
     * Verified as invalid.
     */
    DenominationStatus[DenominationStatus["VerifiedBad"] = 2] = "VerifiedBad";
})(DenominationStatus = exports.DenominationStatus || (exports.DenominationStatus = {}));
/**
 * Denomination record as stored in the wallet's database.
 */
let DenominationRecord = class DenominationRecord {
};
__decorate([
    checkable_1.Checkable.Value(() => amounts_1.AmountJson)
], DenominationRecord.prototype, "value", void 0);
__decorate([
    checkable_1.Checkable.String()
], DenominationRecord.prototype, "denomPub", void 0);
__decorate([
    checkable_1.Checkable.String()
], DenominationRecord.prototype, "denomPubHash", void 0);
__decorate([
    checkable_1.Checkable.Value(() => amounts_1.AmountJson)
], DenominationRecord.prototype, "feeWithdraw", void 0);
__decorate([
    checkable_1.Checkable.Value(() => amounts_1.AmountJson)
], DenominationRecord.prototype, "feeDeposit", void 0);
__decorate([
    checkable_1.Checkable.Value(() => amounts_1.AmountJson)
], DenominationRecord.prototype, "feeRefresh", void 0);
__decorate([
    checkable_1.Checkable.Value(() => amounts_1.AmountJson)
], DenominationRecord.prototype, "feeRefund", void 0);
__decorate([
    checkable_1.Checkable.String()
], DenominationRecord.prototype, "stampStart", void 0);
__decorate([
    checkable_1.Checkable.String()
], DenominationRecord.prototype, "stampExpireWithdraw", void 0);
__decorate([
    checkable_1.Checkable.String()
], DenominationRecord.prototype, "stampExpireLegal", void 0);
__decorate([
    checkable_1.Checkable.String()
], DenominationRecord.prototype, "stampExpireDeposit", void 0);
__decorate([
    checkable_1.Checkable.String()
], DenominationRecord.prototype, "masterSig", void 0);
__decorate([
    checkable_1.Checkable.Number()
], DenominationRecord.prototype, "status", void 0);
__decorate([
    checkable_1.Checkable.Boolean()
], DenominationRecord.prototype, "isOffered", void 0);
__decorate([
    checkable_1.Checkable.String()
], DenominationRecord.prototype, "exchangeBaseUrl", void 0);
DenominationRecord = __decorate([
    checkable_1.Checkable.Class()
], DenominationRecord);
exports.DenominationRecord = DenominationRecord;
/**
 * Status of a coin.
 */
var CoinStatus;
(function (CoinStatus) {
    /**
     * Withdrawn and never shown to anybody.
     */
    CoinStatus[CoinStatus["Fresh"] = 0] = "Fresh";
    /**
     * Currently planned to be sent to a merchant for a purchase.
     */
    CoinStatus[CoinStatus["PurchasePending"] = 1] = "PurchasePending";
    /**
     * Used for a completed transaction and now dirty.
     */
    CoinStatus[CoinStatus["Dirty"] = 2] = "Dirty";
    /**
     * A coin that was refreshed.
     */
    CoinStatus[CoinStatus["Refreshed"] = 3] = "Refreshed";
    /**
     * Coin marked to be paid back, but payback not finished.
     */
    CoinStatus[CoinStatus["PaybackPending"] = 4] = "PaybackPending";
    /**
     * Coin fully paid back.
     */
    CoinStatus[CoinStatus["PaybackDone"] = 5] = "PaybackDone";
    /**
     * Coin was dirty but can't be refreshed.
     */
    CoinStatus[CoinStatus["Useless"] = 6] = "Useless";
    /**
     * The coin was withdrawn for a tip that the user hasn't accepted yet.
     */
    CoinStatus[CoinStatus["TainedByTip"] = 7] = "TainedByTip";
})(CoinStatus = exports.CoinStatus || (exports.CoinStatus = {}));
/**
 * Proposal record, stored in the wallet's database.
 */
let ProposalDownloadRecord = class ProposalDownloadRecord {
};
__decorate([
    checkable_1.Checkable.String()
], ProposalDownloadRecord.prototype, "url", void 0);
__decorate([
    checkable_1.Checkable.Value(() => talerTypes_1.ContractTerms)
], ProposalDownloadRecord.prototype, "contractTerms", void 0);
__decorate([
    checkable_1.Checkable.String()
], ProposalDownloadRecord.prototype, "merchantSig", void 0);
__decorate([
    checkable_1.Checkable.String()
], ProposalDownloadRecord.prototype, "contractTermsHash", void 0);
__decorate([
    checkable_1.Checkable.Optional(checkable_1.Checkable.Number())
], ProposalDownloadRecord.prototype, "id", void 0);
__decorate([
    checkable_1.Checkable.Number()
], ProposalDownloadRecord.prototype, "timestamp", void 0);
__decorate([
    checkable_1.Checkable.String()
], ProposalDownloadRecord.prototype, "noncePriv", void 0);
ProposalDownloadRecord = __decorate([
    checkable_1.Checkable.Class()
], ProposalDownloadRecord);
exports.ProposalDownloadRecord = ProposalDownloadRecord;
/* tslint:disable:completed-docs */
/**
 * The stores and indices for the wallet database.
 */
var Stores;
(function (Stores) {
    class ExchangeStore extends query_1.Store {
        constructor() {
            super("exchanges", { keyPath: "baseUrl" });
            this.pubKeyIndex = new query_1.Index(this, "pubKeyIndex", "masterPublicKey");
        }
    }
    class CoinsStore extends query_1.Store {
        constructor() {
            super("coins", { keyPath: "coinPub" });
            this.exchangeBaseUrlIndex = new query_1.Index(this, "exchangeBaseUrl", "exchangeBaseUrl");
            this.denomPubIndex = new query_1.Index(this, "denomPubIndex", "denomPub");
        }
    }
    class ProposalsStore extends query_1.Store {
        constructor() {
            super("proposals", {
                autoIncrement: true,
                keyPath: "id",
            });
            this.urlIndex = new query_1.Index(this, "urlIndex", "url");
            this.timestampIndex = new query_1.Index(this, "timestampIndex", "timestamp");
        }
    }
    class PurchasesStore extends query_1.Store {
        constructor() {
            super("purchases", { keyPath: "contractTermsHash" });
            this.fulfillmentUrlIndex = new query_1.Index(this, "fulfillmentUrlIndex", "contractTerms.fulfillment_url");
            this.orderIdIndex = new query_1.Index(this, "orderIdIndex", "contractTerms.order_id");
            this.timestampIndex = new query_1.Index(this, "timestampIndex", "timestamp");
        }
    }
    class DenominationsStore extends query_1.Store {
        constructor() {
            // cast needed because of bug in type annotations
            super("denominations", { keyPath: ["exchangeBaseUrl", "denomPub"] });
            this.denomPubHashIndex = new query_1.Index(this, "denomPubHashIndex", "denomPubHash");
            this.exchangeBaseUrlIndex = new query_1.Index(this, "exchangeBaseUrlIndex", "exchangeBaseUrl");
            this.denomPubIndex = new query_1.Index(this, "denomPubIndex", "denomPub");
        }
    }
    class CurrenciesStore extends query_1.Store {
        constructor() {
            super("currencies", { keyPath: "name" });
        }
    }
    class ConfigStore extends query_1.Store {
        constructor() {
            super("config", { keyPath: "key" });
        }
    }
    class ExchangeWireFeesStore extends query_1.Store {
        constructor() {
            super("exchangeWireFees", { keyPath: "exchangeBaseUrl" });
        }
    }
    class ReservesStore extends query_1.Store {
        constructor() {
            super("reserves", { keyPath: "reserve_pub" });
            this.timestampCreatedIndex = new query_1.Index(this, "timestampCreatedIndex", "created");
            this.timestampConfirmedIndex = new query_1.Index(this, "timestampConfirmedIndex", "timestamp_confirmed");
            this.timestampDepletedIndex = new query_1.Index(this, "timestampDepletedIndex", "timestamp_depleted");
        }
    }
    class TipsStore extends query_1.Store {
        constructor() {
            super("tips", { keyPath: ["tipId", "merchantDomain"] });
            this.coinPubIndex = new query_1.Index(this, "coinPubIndex", "coinPubs", { multiEntry: true });
        }
    }
    class SenderWiresStore extends query_1.Store {
        constructor() {
            super("senderWires", { keyPath: "id" });
        }
    }
    Stores.coins = new CoinsStore();
    Stores.coinsReturns = new query_1.Store("coinsReturns", { keyPath: "contractTermsHash" });
    Stores.config = new ConfigStore();
    Stores.currencies = new CurrenciesStore();
    Stores.denominations = new DenominationsStore();
    Stores.exchangeWireFees = new ExchangeWireFeesStore();
    Stores.exchanges = new ExchangeStore();
    Stores.precoins = new query_1.Store("precoins", { keyPath: "coinPub" });
    Stores.proposals = new ProposalsStore();
    Stores.refresh = new query_1.Store("refresh", { keyPath: "id", autoIncrement: true });
    Stores.reserves = new ReservesStore();
    Stores.purchases = new PurchasesStore();
    Stores.tips = new TipsStore();
    Stores.senderWires = new SenderWiresStore();
})(Stores = exports.Stores || (exports.Stores = {}));
/* tslint:enable:completed-docs */


/***/ }),
/* 10 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*
 This file is part of TALER
 (C) 2018 GNUnet e.V. and INRIA

 TALER is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 TALER is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Type and schema definitions for the base taler protocol.
 *
 * All types here should be "@Checkable".
 *
 * Even though the rest of the wallet uses camelCase for fields, use snake_case
 * here, since that's the convention for the Taler JSON+HTTP API.
 */
/**
 * Imports.
 */
const checkable_1 = __webpack_require__(1);
const Amounts = __webpack_require__(0);
const helpers_1 = __webpack_require__(2);
/**
 * Denomination as found in the /keys response from the exchange.
 */
let Denomination = class Denomination {
};
__decorate([
    checkable_1.Checkable.String(Amounts.check)
], Denomination.prototype, "value", void 0);
__decorate([
    checkable_1.Checkable.String()
], Denomination.prototype, "denom_pub", void 0);
__decorate([
    checkable_1.Checkable.String(Amounts.check)
], Denomination.prototype, "fee_withdraw", void 0);
__decorate([
    checkable_1.Checkable.String(Amounts.check)
], Denomination.prototype, "fee_deposit", void 0);
__decorate([
    checkable_1.Checkable.String(Amounts.check)
], Denomination.prototype, "fee_refresh", void 0);
__decorate([
    checkable_1.Checkable.String(Amounts.check)
], Denomination.prototype, "fee_refund", void 0);
__decorate([
    checkable_1.Checkable.String(helpers_1.timestampCheck)
], Denomination.prototype, "stamp_start", void 0);
__decorate([
    checkable_1.Checkable.String(helpers_1.timestampCheck)
], Denomination.prototype, "stamp_expire_withdraw", void 0);
__decorate([
    checkable_1.Checkable.String(helpers_1.timestampCheck)
], Denomination.prototype, "stamp_expire_legal", void 0);
__decorate([
    checkable_1.Checkable.String(helpers_1.timestampCheck)
], Denomination.prototype, "stamp_expire_deposit", void 0);
__decorate([
    checkable_1.Checkable.String()
], Denomination.prototype, "master_sig", void 0);
Denomination = __decorate([
    checkable_1.Checkable.Class()
], Denomination);
exports.Denomination = Denomination;
/**
 * Signature by the auditor that a particular denomination key is audited.
 */
let AuditorDenomSig = class AuditorDenomSig {
};
__decorate([
    checkable_1.Checkable.String()
], AuditorDenomSig.prototype, "denom_pub_h", void 0);
__decorate([
    checkable_1.Checkable.String()
], AuditorDenomSig.prototype, "auditor_sig", void 0);
AuditorDenomSig = __decorate([
    checkable_1.Checkable.Class()
], AuditorDenomSig);
exports.AuditorDenomSig = AuditorDenomSig;
/**
 * Auditor information as given by the exchange in /keys.
 */
let Auditor = class Auditor {
};
__decorate([
    checkable_1.Checkable.String()
], Auditor.prototype, "auditor_pub", void 0);
__decorate([
    checkable_1.Checkable.String()
], Auditor.prototype, "auditor_url", void 0);
__decorate([
    checkable_1.Checkable.List(checkable_1.Checkable.Value(() => AuditorDenomSig))
], Auditor.prototype, "denomination_keys", void 0);
Auditor = __decorate([
    checkable_1.Checkable.Class()
], Auditor);
exports.Auditor = Auditor;
/**
 * Response that we get from the exchange for a payback request.
 */
let PaybackConfirmation = class PaybackConfirmation {
};
__decorate([
    checkable_1.Checkable.String()
], PaybackConfirmation.prototype, "reserve_pub", void 0);
__decorate([
    checkable_1.Checkable.String()
], PaybackConfirmation.prototype, "amount", void 0);
__decorate([
    checkable_1.Checkable.String()
], PaybackConfirmation.prototype, "timestamp", void 0);
__decorate([
    checkable_1.Checkable.String()
], PaybackConfirmation.prototype, "exchange_sig", void 0);
__decorate([
    checkable_1.Checkable.String()
], PaybackConfirmation.prototype, "exchange_pub", void 0);
PaybackConfirmation = __decorate([
    checkable_1.Checkable.Class()
], PaybackConfirmation);
exports.PaybackConfirmation = PaybackConfirmation;
/**
 * Information about an exchange as stored inside a
 * merchant's contract terms.
 */
let ExchangeHandle = class ExchangeHandle {
};
__decorate([
    checkable_1.Checkable.String()
], ExchangeHandle.prototype, "master_pub", void 0);
__decorate([
    checkable_1.Checkable.String()
], ExchangeHandle.prototype, "url", void 0);
ExchangeHandle = __decorate([
    checkable_1.Checkable.Class()
], ExchangeHandle);
exports.ExchangeHandle = ExchangeHandle;
/**
 * Contract terms from a merchant.
 */
let ContractTerms = class ContractTerms {
    static validate(x) {
        if (x.exchanges.length === 0) {
            throw Error("no exchanges in contract terms");
        }
    }
};
__decorate([
    checkable_1.Checkable.String()
], ContractTerms.prototype, "H_wire", void 0);
__decorate([
    checkable_1.Checkable.String()
], ContractTerms.prototype, "wire_method", void 0);
__decorate([
    checkable_1.Checkable.Optional(checkable_1.Checkable.String())
], ContractTerms.prototype, "summary", void 0);
__decorate([
    checkable_1.Checkable.Optional(checkable_1.Checkable.String())
], ContractTerms.prototype, "nonce", void 0);
__decorate([
    checkable_1.Checkable.String(Amounts.check)
], ContractTerms.prototype, "amount", void 0);
__decorate([
    checkable_1.Checkable.List(checkable_1.Checkable.AnyObject())
], ContractTerms.prototype, "auditors", void 0);
__decorate([
    checkable_1.Checkable.Optional(checkable_1.Checkable.String())
], ContractTerms.prototype, "pay_deadline", void 0);
__decorate([
    checkable_1.Checkable.Any()
], ContractTerms.prototype, "locations", void 0);
__decorate([
    checkable_1.Checkable.String(Amounts.check)
], ContractTerms.prototype, "max_fee", void 0);
__decorate([
    checkable_1.Checkable.Any()
], ContractTerms.prototype, "merchant", void 0);
__decorate([
    checkable_1.Checkable.String()
], ContractTerms.prototype, "merchant_pub", void 0);
__decorate([
    checkable_1.Checkable.List(checkable_1.Checkable.Value(() => ExchangeHandle))
], ContractTerms.prototype, "exchanges", void 0);
__decorate([
    checkable_1.Checkable.List(checkable_1.Checkable.AnyObject())
], ContractTerms.prototype, "products", void 0);
__decorate([
    checkable_1.Checkable.String(helpers_1.timestampCheck)
], ContractTerms.prototype, "refund_deadline", void 0);
__decorate([
    checkable_1.Checkable.String(helpers_1.timestampCheck)
], ContractTerms.prototype, "timestamp", void 0);
__decorate([
    checkable_1.Checkable.String()
], ContractTerms.prototype, "order_id", void 0);
__decorate([
    checkable_1.Checkable.String()
], ContractTerms.prototype, "pay_url", void 0);
__decorate([
    checkable_1.Checkable.String()
], ContractTerms.prototype, "fulfillment_url", void 0);
__decorate([
    checkable_1.Checkable.Optional(checkable_1.Checkable.Number())
], ContractTerms.prototype, "wire_fee_amortization", void 0);
__decorate([
    checkable_1.Checkable.Optional(checkable_1.Checkable.String())
], ContractTerms.prototype, "max_wire_fee", void 0);
__decorate([
    checkable_1.Checkable.Any()
], ContractTerms.prototype, "extra", void 0);
ContractTerms = __decorate([
    checkable_1.Checkable.Class({ validate: true })
], ContractTerms);
exports.ContractTerms = ContractTerms;
/**
 * Refund permission in the format that the merchant gives it to us.
 */
let MerchantRefundPermission = class MerchantRefundPermission {
};
__decorate([
    checkable_1.Checkable.String(Amounts.check)
], MerchantRefundPermission.prototype, "refund_amount", void 0);
__decorate([
    checkable_1.Checkable.String(Amounts.check)
], MerchantRefundPermission.prototype, "refund_fee", void 0);
__decorate([
    checkable_1.Checkable.String()
], MerchantRefundPermission.prototype, "coin_pub", void 0);
__decorate([
    checkable_1.Checkable.Number()
], MerchantRefundPermission.prototype, "rtransaction_id", void 0);
__decorate([
    checkable_1.Checkable.String()
], MerchantRefundPermission.prototype, "merchant_sig", void 0);
MerchantRefundPermission = __decorate([
    checkable_1.Checkable.Class()
], MerchantRefundPermission);
exports.MerchantRefundPermission = MerchantRefundPermission;
/**
 * Response for a refund pickup or a /pay in abort mode.
 */
let MerchantRefundResponse = class MerchantRefundResponse {
};
__decorate([
    checkable_1.Checkable.String()
], MerchantRefundResponse.prototype, "merchant_pub", void 0);
__decorate([
    checkable_1.Checkable.String()
], MerchantRefundResponse.prototype, "h_contract_terms", void 0);
__decorate([
    checkable_1.Checkable.List(checkable_1.Checkable.Value(() => MerchantRefundPermission))
], MerchantRefundResponse.prototype, "refund_permissions", void 0);
MerchantRefundResponse = __decorate([
    checkable_1.Checkable.Class()
], MerchantRefundResponse);
exports.MerchantRefundResponse = MerchantRefundResponse;
/**
 * Reserve signature, defined as separate class to facilitate
 * schema validation with "@Checkable".
 */
let ReserveSigSingleton = class ReserveSigSingleton {
};
__decorate([
    checkable_1.Checkable.String()
], ReserveSigSingleton.prototype, "reserve_sig", void 0);
ReserveSigSingleton = __decorate([
    checkable_1.Checkable.Class()
], ReserveSigSingleton);
exports.ReserveSigSingleton = ReserveSigSingleton;
/**
 * Response to /reserve/status
 */
let ReserveStatus = class ReserveStatus {
};
__decorate([
    checkable_1.Checkable.String()
], ReserveStatus.prototype, "balance", void 0);
__decorate([
    checkable_1.Checkable.Any()
], ReserveStatus.prototype, "history", void 0);
ReserveStatus = __decorate([
    checkable_1.Checkable.Class()
], ReserveStatus);
exports.ReserveStatus = ReserveStatus;
/**
 * Response of the merchant
 * to the TipPickupRequest.
 */
let TipResponse = class TipResponse {
};
__decorate([
    checkable_1.Checkable.String()
], TipResponse.prototype, "reserve_pub", void 0);
__decorate([
    checkable_1.Checkable.List(checkable_1.Checkable.Value(() => ReserveSigSingleton))
], TipResponse.prototype, "reserve_sigs", void 0);
TipResponse = __decorate([
    checkable_1.Checkable.Class()
], TipResponse);
exports.TipResponse = TipResponse;
/**
 * Token containing all the information for the wallet
 * to process a tip.  Given by the merchant to the wallet.
 */
let TipToken = class TipToken {
};
__decorate([
    checkable_1.Checkable.String(helpers_1.timestampCheck)
], TipToken.prototype, "expiration", void 0);
__decorate([
    checkable_1.Checkable.String()
], TipToken.prototype, "exchange_url", void 0);
__decorate([
    checkable_1.Checkable.String()
], TipToken.prototype, "pickup_url", void 0);
__decorate([
    checkable_1.Checkable.String()
], TipToken.prototype, "tip_id", void 0);
__decorate([
    checkable_1.Checkable.String()
], TipToken.prototype, "amount", void 0);
__decorate([
    checkable_1.Checkable.String()
], TipToken.prototype, "next_url", void 0);
TipToken = __decorate([
    checkable_1.Checkable.Class()
], TipToken);
exports.TipToken = TipToken;
/**
 * Element of the payback list that the
 * exchange gives us in /keys.
 */
let Payback = class Payback {
};
__decorate([
    checkable_1.Checkable.String()
], Payback.prototype, "h_denom_pub", void 0);
Payback = __decorate([
    checkable_1.Checkable.Class()
], Payback);
exports.Payback = Payback;
/**
 * Structure that the exchange gives us in /keys.
 */
let KeysJson = class KeysJson {
};
__decorate([
    checkable_1.Checkable.List(checkable_1.Checkable.Value(() => Denomination))
], KeysJson.prototype, "denoms", void 0);
__decorate([
    checkable_1.Checkable.String()
], KeysJson.prototype, "master_public_key", void 0);
__decorate([
    checkable_1.Checkable.List(checkable_1.Checkable.Value(() => Auditor))
], KeysJson.prototype, "auditors", void 0);
__decorate([
    checkable_1.Checkable.String(helpers_1.timestampCheck)
], KeysJson.prototype, "list_issue_date", void 0);
__decorate([
    checkable_1.Checkable.Optional(checkable_1.Checkable.List(checkable_1.Checkable.Value(() => Payback)))
], KeysJson.prototype, "payback", void 0);
__decorate([
    checkable_1.Checkable.Any()
], KeysJson.prototype, "signkeys", void 0);
__decorate([
    checkable_1.Checkable.Optional(checkable_1.Checkable.String())
], KeysJson.prototype, "version", void 0);
KeysJson = __decorate([
    checkable_1.Checkable.Class({ extra: true })
], KeysJson);
exports.KeysJson = KeysJson;
/**
 * Wire fees as anounced by the exchange.
 */
let WireFeesJson = class WireFeesJson {
};
__decorate([
    checkable_1.Checkable.String(Amounts.check)
], WireFeesJson.prototype, "wire_fee", void 0);
__decorate([
    checkable_1.Checkable.String(Amounts.check)
], WireFeesJson.prototype, "closing_fee", void 0);
__decorate([
    checkable_1.Checkable.String()
], WireFeesJson.prototype, "sig", void 0);
__decorate([
    checkable_1.Checkable.String(helpers_1.timestampCheck)
], WireFeesJson.prototype, "start_date", void 0);
__decorate([
    checkable_1.Checkable.String(helpers_1.timestampCheck)
], WireFeesJson.prototype, "end_date", void 0);
WireFeesJson = __decorate([
    checkable_1.Checkable.Class()
], WireFeesJson);
exports.WireFeesJson = WireFeesJson;
/**
 * Information about wire transfer methods supported
 * by the exchange.
 */
let WireDetailJson = class WireDetailJson {
};
__decorate([
    checkable_1.Checkable.String()
], WireDetailJson.prototype, "type", void 0);
__decorate([
    checkable_1.Checkable.List(checkable_1.Checkable.Value(() => WireFeesJson))
], WireDetailJson.prototype, "fees", void 0);
WireDetailJson = __decorate([
    checkable_1.Checkable.Class({ extra: true })
], WireDetailJson);
exports.WireDetailJson = WireDetailJson;
/**
 * Type guard for wire details.
 */
function isWireDetail(x) {
    return x && typeof x === "object" && typeof x.type === "string";
}
exports.isWireDetail = isWireDetail;
/**
 * Proposal returned from the contract URL.
 */
let Proposal = class Proposal {
};
__decorate([
    checkable_1.Checkable.Value(() => ContractTerms)
], Proposal.prototype, "contract_terms", void 0);
__decorate([
    checkable_1.Checkable.String()
], Proposal.prototype, "sig", void 0);
Proposal = __decorate([
    checkable_1.Checkable.Class({ extra: true })
], Proposal);
exports.Proposal = Proposal;


/***/ }),
/* 11 */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*!
 * URI.js - Mutating URLs
 *
 * Version: 1.19.0
 *
 * Author: Rodney Rehm
 * Web: http://medialize.github.io/URI.js/
 *
 * Licensed under
 *   MIT License http://www.opensource.org/licenses/mit-license
 *
 */
(function (root, factory) {
  'use strict';
  // https://github.com/umdjs/umd/blob/master/returnExports.js
  if (typeof module === 'object' && module.exports) {
    // Node
    module.exports = factory(__webpack_require__(3), __webpack_require__(5), __webpack_require__(6));
  } else if (true) {
    // AMD. Register as an anonymous module.
    !(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__(3), __webpack_require__(5), __webpack_require__(6)], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
				__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
				(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
  } else {
    // Browser globals (root is window)
    root.URI = factory(root.punycode, root.IPv6, root.SecondLevelDomains, root);
  }
}(this, function (punycode, IPv6, SLD, root) {
  'use strict';
  /*global location, escape, unescape */
  // FIXME: v2.0.0 renamce non-camelCase properties to uppercase
  /*jshint camelcase: false */

  // save current URI variable, if any
  var _URI = root && root.URI;

  function URI(url, base) {
    var _urlSupplied = arguments.length >= 1;
    var _baseSupplied = arguments.length >= 2;

    // Allow instantiation without the 'new' keyword
    if (!(this instanceof URI)) {
      if (_urlSupplied) {
        if (_baseSupplied) {
          return new URI(url, base);
        }

        return new URI(url);
      }

      return new URI();
    }

    if (url === undefined) {
      if (_urlSupplied) {
        throw new TypeError('undefined is not a valid argument for URI');
      }

      if (typeof location !== 'undefined') {
        url = location.href + '';
      } else {
        url = '';
      }
    }

    if (url === null) {
      if (_urlSupplied) {
        throw new TypeError('null is not a valid argument for URI');
      }
    }

    this.href(url);

    // resolve to base according to http://dvcs.w3.org/hg/url/raw-file/tip/Overview.html#constructor
    if (base !== undefined) {
      return this.absoluteTo(base);
    }

    return this;
  }

  function isInteger(value) {
    return /^[0-9]+$/.test(value);
  }

  URI.version = '1.19.0';

  var p = URI.prototype;
  var hasOwn = Object.prototype.hasOwnProperty;

  function escapeRegEx(string) {
    // https://github.com/medialize/URI.js/commit/85ac21783c11f8ccab06106dba9735a31a86924d#commitcomment-821963
    return string.replace(/([.*+?^=!:${}()|[\]\/\\])/g, '\\$1');
  }

  function getType(value) {
    // IE8 doesn't return [Object Undefined] but [Object Object] for undefined value
    if (value === undefined) {
      return 'Undefined';
    }

    return String(Object.prototype.toString.call(value)).slice(8, -1);
  }

  function isArray(obj) {
    return getType(obj) === 'Array';
  }

  function filterArrayValues(data, value) {
    var lookup = {};
    var i, length;

    if (getType(value) === 'RegExp') {
      lookup = null;
    } else if (isArray(value)) {
      for (i = 0, length = value.length; i < length; i++) {
        lookup[value[i]] = true;
      }
    } else {
      lookup[value] = true;
    }

    for (i = 0, length = data.length; i < length; i++) {
      /*jshint laxbreak: true */
      var _match = lookup && lookup[data[i]] !== undefined
        || !lookup && value.test(data[i]);
      /*jshint laxbreak: false */
      if (_match) {
        data.splice(i, 1);
        length--;
        i--;
      }
    }

    return data;
  }

  function arrayContains(list, value) {
    var i, length;

    // value may be string, number, array, regexp
    if (isArray(value)) {
      // Note: this can be optimized to O(n) (instead of current O(m * n))
      for (i = 0, length = value.length; i < length; i++) {
        if (!arrayContains(list, value[i])) {
          return false;
        }
      }

      return true;
    }

    var _type = getType(value);
    for (i = 0, length = list.length; i < length; i++) {
      if (_type === 'RegExp') {
        if (typeof list[i] === 'string' && list[i].match(value)) {
          return true;
        }
      } else if (list[i] === value) {
        return true;
      }
    }

    return false;
  }

  function arraysEqual(one, two) {
    if (!isArray(one) || !isArray(two)) {
      return false;
    }

    // arrays can't be equal if they have different amount of content
    if (one.length !== two.length) {
      return false;
    }

    one.sort();
    two.sort();

    for (var i = 0, l = one.length; i < l; i++) {
      if (one[i] !== two[i]) {
        return false;
      }
    }

    return true;
  }

  function trimSlashes(text) {
    var trim_expression = /^\/+|\/+$/g;
    return text.replace(trim_expression, '');
  }

  URI._parts = function() {
    return {
      protocol: null,
      username: null,
      password: null,
      hostname: null,
      urn: null,
      port: null,
      path: null,
      query: null,
      fragment: null,
      // state
      preventInvalidHostname: URI.preventInvalidHostname,
      duplicateQueryParameters: URI.duplicateQueryParameters,
      escapeQuerySpace: URI.escapeQuerySpace
    };
  };
  // state: throw on invalid hostname
  // see https://github.com/medialize/URI.js/pull/345
  // and https://github.com/medialize/URI.js/issues/354
  URI.preventInvalidHostname = false;
  // state: allow duplicate query parameters (a=1&a=1)
  URI.duplicateQueryParameters = false;
  // state: replaces + with %20 (space in query strings)
  URI.escapeQuerySpace = true;
  // static properties
  URI.protocol_expression = /^[a-z][a-z0-9.+-]*$/i;
  URI.idn_expression = /[^a-z0-9\._-]/i;
  URI.punycode_expression = /(xn--)/i;
  // well, 333.444.555.666 matches, but it sure ain't no IPv4 - do we care?
  URI.ip4_expression = /^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}$/;
  // credits to Rich Brown
  // source: http://forums.intermapper.com/viewtopic.php?p=1096#1096
  // specification: http://www.ietf.org/rfc/rfc4291.txt
  URI.ip6_expression = /^\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(%.+)?\s*$/;
  // expression used is "gruber revised" (@gruber v2) determined to be the
  // best solution in a regex-golf we did a couple of ages ago at
  // * http://mathiasbynens.be/demo/url-regex
  // * http://rodneyrehm.de/t/url-regex.html
  URI.find_uri_expression = /\b((?:[a-z][\w-]+:(?:\/{1,3}|[a-z0-9%])|www\d{0,3}[.]|[a-z0-9.\-]+[.][a-z]{2,4}\/)(?:[^\s()<>]+|\(([^\s()<>]+|(\([^\s()<>]+\)))*\))+(?:\(([^\s()<>]+|(\([^\s()<>]+\)))*\)|[^\s`!()\[\]{};:'".,<>?«»“”‘’]))/ig;
  URI.findUri = {
    // valid "scheme://" or "www."
    start: /\b(?:([a-z][a-z0-9.+-]*:\/\/)|www\.)/gi,
    // everything up to the next whitespace
    end: /[\s\r\n]|$/,
    // trim trailing punctuation captured by end RegExp
    trim: /[`!()\[\]{};:'".,<>?«»“”„‘’]+$/,
    // balanced parens inclusion (), [], {}, <>
    parens: /(\([^\)]*\)|\[[^\]]*\]|\{[^}]*\}|<[^>]*>)/g,
  };
  // http://www.iana.org/assignments/uri-schemes.html
  // http://en.wikipedia.org/wiki/List_of_TCP_and_UDP_port_numbers#Well-known_ports
  URI.defaultPorts = {
    http: '80',
    https: '443',
    ftp: '21',
    gopher: '70',
    ws: '80',
    wss: '443'
  };
  // list of protocols which always require a hostname
  URI.hostProtocols = [
    'http',
    'https'
  ];

  // allowed hostname characters according to RFC 3986
  // ALPHA DIGIT "-" "." "_" "~" "!" "$" "&" "'" "(" ")" "*" "+" "," ";" "=" %encoded
  // I've never seen a (non-IDN) hostname other than: ALPHA DIGIT . - _
  URI.invalid_hostname_characters = /[^a-zA-Z0-9\.\-:_]/;
  // map DOM Elements to their URI attribute
  URI.domAttributes = {
    'a': 'href',
    'blockquote': 'cite',
    'link': 'href',
    'base': 'href',
    'script': 'src',
    'form': 'action',
    'img': 'src',
    'area': 'href',
    'iframe': 'src',
    'embed': 'src',
    'source': 'src',
    'track': 'src',
    'input': 'src', // but only if type="image"
    'audio': 'src',
    'video': 'src'
  };
  URI.getDomAttribute = function(node) {
    if (!node || !node.nodeName) {
      return undefined;
    }

    var nodeName = node.nodeName.toLowerCase();
    // <input> should only expose src for type="image"
    if (nodeName === 'input' && node.type !== 'image') {
      return undefined;
    }

    return URI.domAttributes[nodeName];
  };

  function escapeForDumbFirefox36(value) {
    // https://github.com/medialize/URI.js/issues/91
    return escape(value);
  }

  // encoding / decoding according to RFC3986
  function strictEncodeURIComponent(string) {
    // see https://developer.mozilla.org/en-US/docs/JavaScript/Reference/Global_Objects/encodeURIComponent
    return encodeURIComponent(string)
      .replace(/[!'()*]/g, escapeForDumbFirefox36)
      .replace(/\*/g, '%2A');
  }
  URI.encode = strictEncodeURIComponent;
  URI.decode = decodeURIComponent;
  URI.iso8859 = function() {
    URI.encode = escape;
    URI.decode = unescape;
  };
  URI.unicode = function() {
    URI.encode = strictEncodeURIComponent;
    URI.decode = decodeURIComponent;
  };
  URI.characters = {
    pathname: {
      encode: {
        // RFC3986 2.1: For consistency, URI producers and normalizers should
        // use uppercase hexadecimal digits for all percent-encodings.
        expression: /%(24|26|2B|2C|3B|3D|3A|40)/ig,
        map: {
          // -._~!'()*
          '%24': '$',
          '%26': '&',
          '%2B': '+',
          '%2C': ',',
          '%3B': ';',
          '%3D': '=',
          '%3A': ':',
          '%40': '@'
        }
      },
      decode: {
        expression: /[\/\?#]/g,
        map: {
          '/': '%2F',
          '?': '%3F',
          '#': '%23'
        }
      }
    },
    reserved: {
      encode: {
        // RFC3986 2.1: For consistency, URI producers and normalizers should
        // use uppercase hexadecimal digits for all percent-encodings.
        expression: /%(21|23|24|26|27|28|29|2A|2B|2C|2F|3A|3B|3D|3F|40|5B|5D)/ig,
        map: {
          // gen-delims
          '%3A': ':',
          '%2F': '/',
          '%3F': '?',
          '%23': '#',
          '%5B': '[',
          '%5D': ']',
          '%40': '@',
          // sub-delims
          '%21': '!',
          '%24': '$',
          '%26': '&',
          '%27': '\'',
          '%28': '(',
          '%29': ')',
          '%2A': '*',
          '%2B': '+',
          '%2C': ',',
          '%3B': ';',
          '%3D': '='
        }
      }
    },
    urnpath: {
      // The characters under `encode` are the characters called out by RFC 2141 as being acceptable
      // for usage in a URN. RFC2141 also calls out "-", ".", and "_" as acceptable characters, but
      // these aren't encoded by encodeURIComponent, so we don't have to call them out here. Also
      // note that the colon character is not featured in the encoding map; this is because URI.js
      // gives the colons in URNs semantic meaning as the delimiters of path segements, and so it
      // should not appear unencoded in a segment itself.
      // See also the note above about RFC3986 and capitalalized hex digits.
      encode: {
        expression: /%(21|24|27|28|29|2A|2B|2C|3B|3D|40)/ig,
        map: {
          '%21': '!',
          '%24': '$',
          '%27': '\'',
          '%28': '(',
          '%29': ')',
          '%2A': '*',
          '%2B': '+',
          '%2C': ',',
          '%3B': ';',
          '%3D': '=',
          '%40': '@'
        }
      },
      // These characters are the characters called out by RFC2141 as "reserved" characters that
      // should never appear in a URN, plus the colon character (see note above).
      decode: {
        expression: /[\/\?#:]/g,
        map: {
          '/': '%2F',
          '?': '%3F',
          '#': '%23',
          ':': '%3A'
        }
      }
    }
  };
  URI.encodeQuery = function(string, escapeQuerySpace) {
    var escaped = URI.encode(string + '');
    if (escapeQuerySpace === undefined) {
      escapeQuerySpace = URI.escapeQuerySpace;
    }

    return escapeQuerySpace ? escaped.replace(/%20/g, '+') : escaped;
  };
  URI.decodeQuery = function(string, escapeQuerySpace) {
    string += '';
    if (escapeQuerySpace === undefined) {
      escapeQuerySpace = URI.escapeQuerySpace;
    }

    try {
      return URI.decode(escapeQuerySpace ? string.replace(/\+/g, '%20') : string);
    } catch(e) {
      // we're not going to mess with weird encodings,
      // give up and return the undecoded original string
      // see https://github.com/medialize/URI.js/issues/87
      // see https://github.com/medialize/URI.js/issues/92
      return string;
    }
  };
  // generate encode/decode path functions
  var _parts = {'encode':'encode', 'decode':'decode'};
  var _part;
  var generateAccessor = function(_group, _part) {
    return function(string) {
      try {
        return URI[_part](string + '').replace(URI.characters[_group][_part].expression, function(c) {
          return URI.characters[_group][_part].map[c];
        });
      } catch (e) {
        // we're not going to mess with weird encodings,
        // give up and return the undecoded original string
        // see https://github.com/medialize/URI.js/issues/87
        // see https://github.com/medialize/URI.js/issues/92
        return string;
      }
    };
  };

  for (_part in _parts) {
    URI[_part + 'PathSegment'] = generateAccessor('pathname', _parts[_part]);
    URI[_part + 'UrnPathSegment'] = generateAccessor('urnpath', _parts[_part]);
  }

  var generateSegmentedPathFunction = function(_sep, _codingFuncName, _innerCodingFuncName) {
    return function(string) {
      // Why pass in names of functions, rather than the function objects themselves? The
      // definitions of some functions (but in particular, URI.decode) will occasionally change due
      // to URI.js having ISO8859 and Unicode modes. Passing in the name and getting it will ensure
      // that the functions we use here are "fresh".
      var actualCodingFunc;
      if (!_innerCodingFuncName) {
        actualCodingFunc = URI[_codingFuncName];
      } else {
        actualCodingFunc = function(string) {
          return URI[_codingFuncName](URI[_innerCodingFuncName](string));
        };
      }

      var segments = (string + '').split(_sep);

      for (var i = 0, length = segments.length; i < length; i++) {
        segments[i] = actualCodingFunc(segments[i]);
      }

      return segments.join(_sep);
    };
  };

  // This takes place outside the above loop because we don't want, e.g., encodeUrnPath functions.
  URI.decodePath = generateSegmentedPathFunction('/', 'decodePathSegment');
  URI.decodeUrnPath = generateSegmentedPathFunction(':', 'decodeUrnPathSegment');
  URI.recodePath = generateSegmentedPathFunction('/', 'encodePathSegment', 'decode');
  URI.recodeUrnPath = generateSegmentedPathFunction(':', 'encodeUrnPathSegment', 'decode');

  URI.encodeReserved = generateAccessor('reserved', 'encode');

  URI.parse = function(string, parts) {
    var pos;
    if (!parts) {
      parts = {
        preventInvalidHostname: URI.preventInvalidHostname
      };
    }
    // [protocol"://"[username[":"password]"@"]hostname[":"port]"/"?][path]["?"querystring]["#"fragment]

    // extract fragment
    pos = string.indexOf('#');
    if (pos > -1) {
      // escaping?
      parts.fragment = string.substring(pos + 1) || null;
      string = string.substring(0, pos);
    }

    // extract query
    pos = string.indexOf('?');
    if (pos > -1) {
      // escaping?
      parts.query = string.substring(pos + 1) || null;
      string = string.substring(0, pos);
    }

    // extract protocol
    if (string.substring(0, 2) === '//') {
      // relative-scheme
      parts.protocol = null;
      string = string.substring(2);
      // extract "user:pass@host:port"
      string = URI.parseAuthority(string, parts);
    } else {
      pos = string.indexOf(':');
      if (pos > -1) {
        parts.protocol = string.substring(0, pos) || null;
        if (parts.protocol && !parts.protocol.match(URI.protocol_expression)) {
          // : may be within the path
          parts.protocol = undefined;
        } else if (string.substring(pos + 1, pos + 3) === '//') {
          string = string.substring(pos + 3);

          // extract "user:pass@host:port"
          string = URI.parseAuthority(string, parts);
        } else {
          string = string.substring(pos + 1);
          parts.urn = true;
        }
      }
    }

    // what's left must be the path
    parts.path = string;

    // and we're done
    return parts;
  };
  URI.parseHost = function(string, parts) {
    if (!string) {
      string = '';
    }

    // Copy chrome, IE, opera backslash-handling behavior.
    // Back slashes before the query string get converted to forward slashes
    // See: https://github.com/joyent/node/blob/386fd24f49b0e9d1a8a076592a404168faeecc34/lib/url.js#L115-L124
    // See: https://code.google.com/p/chromium/issues/detail?id=25916
    // https://github.com/medialize/URI.js/pull/233
    string = string.replace(/\\/g, '/');

    // extract host:port
    var pos = string.indexOf('/');
    var bracketPos;
    var t;

    if (pos === -1) {
      pos = string.length;
    }

    if (string.charAt(0) === '[') {
      // IPv6 host - http://tools.ietf.org/html/draft-ietf-6man-text-addr-representation-04#section-6
      // I claim most client software breaks on IPv6 anyways. To simplify things, URI only accepts
      // IPv6+port in the format [2001:db8::1]:80 (for the time being)
      bracketPos = string.indexOf(']');
      parts.hostname = string.substring(1, bracketPos) || null;
      parts.port = string.substring(bracketPos + 2, pos) || null;
      if (parts.port === '/') {
        parts.port = null;
      }
    } else {
      var firstColon = string.indexOf(':');
      var firstSlash = string.indexOf('/');
      var nextColon = string.indexOf(':', firstColon + 1);
      if (nextColon !== -1 && (firstSlash === -1 || nextColon < firstSlash)) {
        // IPv6 host contains multiple colons - but no port
        // this notation is actually not allowed by RFC 3986, but we're a liberal parser
        parts.hostname = string.substring(0, pos) || null;
        parts.port = null;
      } else {
        t = string.substring(0, pos).split(':');
        parts.hostname = t[0] || null;
        parts.port = t[1] || null;
      }
    }

    if (parts.hostname && string.substring(pos).charAt(0) !== '/') {
      pos++;
      string = '/' + string;
    }

    if (parts.preventInvalidHostname) {
      URI.ensureValidHostname(parts.hostname, parts.protocol);
    }

    if (parts.port) {
      URI.ensureValidPort(parts.port);
    }

    return string.substring(pos) || '/';
  };
  URI.parseAuthority = function(string, parts) {
    string = URI.parseUserinfo(string, parts);
    return URI.parseHost(string, parts);
  };
  URI.parseUserinfo = function(string, parts) {
    // extract username:password
    var firstSlash = string.indexOf('/');
    var pos = string.lastIndexOf('@', firstSlash > -1 ? firstSlash : string.length - 1);
    var t;

    // authority@ must come before /path
    if (pos > -1 && (firstSlash === -1 || pos < firstSlash)) {
      t = string.substring(0, pos).split(':');
      parts.username = t[0] ? URI.decode(t[0]) : null;
      t.shift();
      parts.password = t[0] ? URI.decode(t.join(':')) : null;
      string = string.substring(pos + 1);
    } else {
      parts.username = null;
      parts.password = null;
    }

    return string;
  };
  URI.parseQuery = function(string, escapeQuerySpace) {
    if (!string) {
      return {};
    }

    // throw out the funky business - "?"[name"="value"&"]+
    string = string.replace(/&+/g, '&').replace(/^\?*&*|&+$/g, '');

    if (!string) {
      return {};
    }

    var items = {};
    var splits = string.split('&');
    var length = splits.length;
    var v, name, value;

    for (var i = 0; i < length; i++) {
      v = splits[i].split('=');
      name = URI.decodeQuery(v.shift(), escapeQuerySpace);
      // no "=" is null according to http://dvcs.w3.org/hg/url/raw-file/tip/Overview.html#collect-url-parameters
      value = v.length ? URI.decodeQuery(v.join('='), escapeQuerySpace) : null;

      if (hasOwn.call(items, name)) {
        if (typeof items[name] === 'string' || items[name] === null) {
          items[name] = [items[name]];
        }

        items[name].push(value);
      } else {
        items[name] = value;
      }
    }

    return items;
  };

  URI.build = function(parts) {
    var t = '';

    if (parts.protocol) {
      t += parts.protocol + ':';
    }

    if (!parts.urn && (t || parts.hostname)) {
      t += '//';
    }

    t += (URI.buildAuthority(parts) || '');

    if (typeof parts.path === 'string') {
      if (parts.path.charAt(0) !== '/' && typeof parts.hostname === 'string') {
        t += '/';
      }

      t += parts.path;
    }

    if (typeof parts.query === 'string' && parts.query) {
      t += '?' + parts.query;
    }

    if (typeof parts.fragment === 'string' && parts.fragment) {
      t += '#' + parts.fragment;
    }
    return t;
  };
  URI.buildHost = function(parts) {
    var t = '';

    if (!parts.hostname) {
      return '';
    } else if (URI.ip6_expression.test(parts.hostname)) {
      t += '[' + parts.hostname + ']';
    } else {
      t += parts.hostname;
    }

    if (parts.port) {
      t += ':' + parts.port;
    }

    return t;
  };
  URI.buildAuthority = function(parts) {
    return URI.buildUserinfo(parts) + URI.buildHost(parts);
  };
  URI.buildUserinfo = function(parts) {
    var t = '';

    if (parts.username) {
      t += URI.encode(parts.username);
    }

    if (parts.password) {
      t += ':' + URI.encode(parts.password);
    }

    if (t) {
      t += '@';
    }

    return t;
  };
  URI.buildQuery = function(data, duplicateQueryParameters, escapeQuerySpace) {
    // according to http://tools.ietf.org/html/rfc3986 or http://labs.apache.org/webarch/uri/rfc/rfc3986.html
    // being »-._~!$&'()*+,;=:@/?« %HEX and alnum are allowed
    // the RFC explicitly states ?/foo being a valid use case, no mention of parameter syntax!
    // URI.js treats the query string as being application/x-www-form-urlencoded
    // see http://www.w3.org/TR/REC-html40/interact/forms.html#form-content-type

    var t = '';
    var unique, key, i, length;
    for (key in data) {
      if (hasOwn.call(data, key) && key) {
        if (isArray(data[key])) {
          unique = {};
          for (i = 0, length = data[key].length; i < length; i++) {
            if (data[key][i] !== undefined && unique[data[key][i] + ''] === undefined) {
              t += '&' + URI.buildQueryParameter(key, data[key][i], escapeQuerySpace);
              if (duplicateQueryParameters !== true) {
                unique[data[key][i] + ''] = true;
              }
            }
          }
        } else if (data[key] !== undefined) {
          t += '&' + URI.buildQueryParameter(key, data[key], escapeQuerySpace);
        }
      }
    }

    return t.substring(1);
  };
  URI.buildQueryParameter = function(name, value, escapeQuerySpace) {
    // http://www.w3.org/TR/REC-html40/interact/forms.html#form-content-type -- application/x-www-form-urlencoded
    // don't append "=" for null values, according to http://dvcs.w3.org/hg/url/raw-file/tip/Overview.html#url-parameter-serialization
    return URI.encodeQuery(name, escapeQuerySpace) + (value !== null ? '=' + URI.encodeQuery(value, escapeQuerySpace) : '');
  };

  URI.addQuery = function(data, name, value) {
    if (typeof name === 'object') {
      for (var key in name) {
        if (hasOwn.call(name, key)) {
          URI.addQuery(data, key, name[key]);
        }
      }
    } else if (typeof name === 'string') {
      if (data[name] === undefined) {
        data[name] = value;
        return;
      } else if (typeof data[name] === 'string') {
        data[name] = [data[name]];
      }

      if (!isArray(value)) {
        value = [value];
      }

      data[name] = (data[name] || []).concat(value);
    } else {
      throw new TypeError('URI.addQuery() accepts an object, string as the name parameter');
    }
  };

  URI.setQuery = function(data, name, value) {
    if (typeof name === 'object') {
      for (var key in name) {
        if (hasOwn.call(name, key)) {
          URI.setQuery(data, key, name[key]);
        }
      }
    } else if (typeof name === 'string') {
      data[name] = value === undefined ? null : value;
    } else {
      throw new TypeError('URI.setQuery() accepts an object, string as the name parameter');
    }
  };

  URI.removeQuery = function(data, name, value) {
    var i, length, key;

    if (isArray(name)) {
      for (i = 0, length = name.length; i < length; i++) {
        data[name[i]] = undefined;
      }
    } else if (getType(name) === 'RegExp') {
      for (key in data) {
        if (name.test(key)) {
          data[key] = undefined;
        }
      }
    } else if (typeof name === 'object') {
      for (key in name) {
        if (hasOwn.call(name, key)) {
          URI.removeQuery(data, key, name[key]);
        }
      }
    } else if (typeof name === 'string') {
      if (value !== undefined) {
        if (getType(value) === 'RegExp') {
          if (!isArray(data[name]) && value.test(data[name])) {
            data[name] = undefined;
          } else {
            data[name] = filterArrayValues(data[name], value);
          }
        } else if (data[name] === String(value) && (!isArray(value) || value.length === 1)) {
          data[name] = undefined;
        } else if (isArray(data[name])) {
          data[name] = filterArrayValues(data[name], value);
        }
      } else {
        data[name] = undefined;
      }
    } else {
      throw new TypeError('URI.removeQuery() accepts an object, string, RegExp as the first parameter');
    }
  };
  URI.hasQuery = function(data, name, value, withinArray) {
    switch (getType(name)) {
      case 'String':
        // Nothing to do here
        break;

      case 'RegExp':
        for (var key in data) {
          if (hasOwn.call(data, key)) {
            if (name.test(key) && (value === undefined || URI.hasQuery(data, key, value))) {
              return true;
            }
          }
        }

        return false;

      case 'Object':
        for (var _key in name) {
          if (hasOwn.call(name, _key)) {
            if (!URI.hasQuery(data, _key, name[_key])) {
              return false;
            }
          }
        }

        return true;

      default:
        throw new TypeError('URI.hasQuery() accepts a string, regular expression or object as the name parameter');
    }

    switch (getType(value)) {
      case 'Undefined':
        // true if exists (but may be empty)
        return name in data; // data[name] !== undefined;

      case 'Boolean':
        // true if exists and non-empty
        var _booly = Boolean(isArray(data[name]) ? data[name].length : data[name]);
        return value === _booly;

      case 'Function':
        // allow complex comparison
        return !!value(data[name], name, data);

      case 'Array':
        if (!isArray(data[name])) {
          return false;
        }

        var op = withinArray ? arrayContains : arraysEqual;
        return op(data[name], value);

      case 'RegExp':
        if (!isArray(data[name])) {
          return Boolean(data[name] && data[name].match(value));
        }

        if (!withinArray) {
          return false;
        }

        return arrayContains(data[name], value);

      case 'Number':
        value = String(value);
        /* falls through */
      case 'String':
        if (!isArray(data[name])) {
          return data[name] === value;
        }

        if (!withinArray) {
          return false;
        }

        return arrayContains(data[name], value);

      default:
        throw new TypeError('URI.hasQuery() accepts undefined, boolean, string, number, RegExp, Function as the value parameter');
    }
  };


  URI.joinPaths = function() {
    var input = [];
    var segments = [];
    var nonEmptySegments = 0;

    for (var i = 0; i < arguments.length; i++) {
      var url = new URI(arguments[i]);
      input.push(url);
      var _segments = url.segment();
      for (var s = 0; s < _segments.length; s++) {
        if (typeof _segments[s] === 'string') {
          segments.push(_segments[s]);
        }

        if (_segments[s]) {
          nonEmptySegments++;
        }
      }
    }

    if (!segments.length || !nonEmptySegments) {
      return new URI('');
    }

    var uri = new URI('').segment(segments);

    if (input[0].path() === '' || input[0].path().slice(0, 1) === '/') {
      uri.path('/' + uri.path());
    }

    return uri.normalize();
  };

  URI.commonPath = function(one, two) {
    var length = Math.min(one.length, two.length);
    var pos;

    // find first non-matching character
    for (pos = 0; pos < length; pos++) {
      if (one.charAt(pos) !== two.charAt(pos)) {
        pos--;
        break;
      }
    }

    if (pos < 1) {
      return one.charAt(0) === two.charAt(0) && one.charAt(0) === '/' ? '/' : '';
    }

    // revert to last /
    if (one.charAt(pos) !== '/' || two.charAt(pos) !== '/') {
      pos = one.substring(0, pos).lastIndexOf('/');
    }

    return one.substring(0, pos + 1);
  };

  URI.withinString = function(string, callback, options) {
    options || (options = {});
    var _start = options.start || URI.findUri.start;
    var _end = options.end || URI.findUri.end;
    var _trim = options.trim || URI.findUri.trim;
    var _parens = options.parens || URI.findUri.parens;
    var _attributeOpen = /[a-z0-9-]=["']?$/i;

    _start.lastIndex = 0;
    while (true) {
      var match = _start.exec(string);
      if (!match) {
        break;
      }

      var start = match.index;
      if (options.ignoreHtml) {
        // attribut(e=["']?$)
        var attributeOpen = string.slice(Math.max(start - 3, 0), start);
        if (attributeOpen && _attributeOpen.test(attributeOpen)) {
          continue;
        }
      }

      var end = start + string.slice(start).search(_end);
      var slice = string.slice(start, end);
      // make sure we include well balanced parens
      var parensEnd = -1;
      while (true) {
        var parensMatch = _parens.exec(slice);
        if (!parensMatch) {
          break;
        }

        var parensMatchEnd = parensMatch.index + parensMatch[0].length;
        parensEnd = Math.max(parensEnd, parensMatchEnd);
      }

      if (parensEnd > -1) {
        slice = slice.slice(0, parensEnd) + slice.slice(parensEnd).replace(_trim, '');
      } else {
        slice = slice.replace(_trim, '');
      }

      if (slice.length <= match[0].length) {
        // the extract only contains the starting marker of a URI,
        // e.g. "www" or "http://"
        continue;
      }

      if (options.ignore && options.ignore.test(slice)) {
        continue;
      }

      end = start + slice.length;
      var result = callback(slice, start, end, string);
      if (result === undefined) {
        _start.lastIndex = end;
        continue;
      }

      result = String(result);
      string = string.slice(0, start) + result + string.slice(end);
      _start.lastIndex = start + result.length;
    }

    _start.lastIndex = 0;
    return string;
  };

  URI.ensureValidHostname = function(v, protocol) {
    // Theoretically URIs allow percent-encoding in Hostnames (according to RFC 3986)
    // they are not part of DNS and therefore ignored by URI.js

    var hasHostname = !!v; // not null and not an empty string
    var hasProtocol = !!protocol;
    var rejectEmptyHostname = false;

    if (hasProtocol) {
      rejectEmptyHostname = arrayContains(URI.hostProtocols, protocol);
    }

    if (rejectEmptyHostname && !hasHostname) {
      throw new TypeError('Hostname cannot be empty, if protocol is ' + protocol);
    } else if (v && v.match(URI.invalid_hostname_characters)) {
      // test punycode
      if (!punycode) {
        throw new TypeError('Hostname "' + v + '" contains characters other than [A-Z0-9.-:_] and Punycode.js is not available');
      }
      if (punycode.toASCII(v).match(URI.invalid_hostname_characters)) {
        throw new TypeError('Hostname "' + v + '" contains characters other than [A-Z0-9.-:_]');
      }
    }
  };

  URI.ensureValidPort = function (v) {
    if (!v) {
      return;
    }

    var port = Number(v);
    if (isInteger(port) && (port > 0) && (port < 65536)) {
      return;
    }

    throw new TypeError('Port "' + v + '" is not a valid port');
  };

  // noConflict
  URI.noConflict = function(removeAll) {
    if (removeAll) {
      var unconflicted = {
        URI: this.noConflict()
      };

      if (root.URITemplate && typeof root.URITemplate.noConflict === 'function') {
        unconflicted.URITemplate = root.URITemplate.noConflict();
      }

      if (root.IPv6 && typeof root.IPv6.noConflict === 'function') {
        unconflicted.IPv6 = root.IPv6.noConflict();
      }

      if (root.SecondLevelDomains && typeof root.SecondLevelDomains.noConflict === 'function') {
        unconflicted.SecondLevelDomains = root.SecondLevelDomains.noConflict();
      }

      return unconflicted;
    } else if (root.URI === this) {
      root.URI = _URI;
    }

    return this;
  };

  p.build = function(deferBuild) {
    if (deferBuild === true) {
      this._deferred_build = true;
    } else if (deferBuild === undefined || this._deferred_build) {
      this._string = URI.build(this._parts);
      this._deferred_build = false;
    }

    return this;
  };

  p.clone = function() {
    return new URI(this);
  };

  p.valueOf = p.toString = function() {
    return this.build(false)._string;
  };


  function generateSimpleAccessor(_part){
    return function(v, build) {
      if (v === undefined) {
        return this._parts[_part] || '';
      } else {
        this._parts[_part] = v || null;
        this.build(!build);
        return this;
      }
    };
  }

  function generatePrefixAccessor(_part, _key){
    return function(v, build) {
      if (v === undefined) {
        return this._parts[_part] || '';
      } else {
        if (v !== null) {
          v = v + '';
          if (v.charAt(0) === _key) {
            v = v.substring(1);
          }
        }

        this._parts[_part] = v;
        this.build(!build);
        return this;
      }
    };
  }

  p.protocol = generateSimpleAccessor('protocol');
  p.username = generateSimpleAccessor('username');
  p.password = generateSimpleAccessor('password');
  p.hostname = generateSimpleAccessor('hostname');
  p.port = generateSimpleAccessor('port');
  p.query = generatePrefixAccessor('query', '?');
  p.fragment = generatePrefixAccessor('fragment', '#');

  p.search = function(v, build) {
    var t = this.query(v, build);
    return typeof t === 'string' && t.length ? ('?' + t) : t;
  };
  p.hash = function(v, build) {
    var t = this.fragment(v, build);
    return typeof t === 'string' && t.length ? ('#' + t) : t;
  };

  p.pathname = function(v, build) {
    if (v === undefined || v === true) {
      var res = this._parts.path || (this._parts.hostname ? '/' : '');
      return v ? (this._parts.urn ? URI.decodeUrnPath : URI.decodePath)(res) : res;
    } else {
      if (this._parts.urn) {
        this._parts.path = v ? URI.recodeUrnPath(v) : '';
      } else {
        this._parts.path = v ? URI.recodePath(v) : '/';
      }
      this.build(!build);
      return this;
    }
  };
  p.path = p.pathname;
  p.href = function(href, build) {
    var key;

    if (href === undefined) {
      return this.toString();
    }

    this._string = '';
    this._parts = URI._parts();

    var _URI = href instanceof URI;
    var _object = typeof href === 'object' && (href.hostname || href.path || href.pathname);
    if (href.nodeName) {
      var attribute = URI.getDomAttribute(href);
      href = href[attribute] || '';
      _object = false;
    }

    // window.location is reported to be an object, but it's not the sort
    // of object we're looking for:
    // * location.protocol ends with a colon
    // * location.query != object.search
    // * location.hash != object.fragment
    // simply serializing the unknown object should do the trick
    // (for location, not for everything...)
    if (!_URI && _object && href.pathname !== undefined) {
      href = href.toString();
    }

    if (typeof href === 'string' || href instanceof String) {
      this._parts = URI.parse(String(href), this._parts);
    } else if (_URI || _object) {
      var src = _URI ? href._parts : href;
      for (key in src) {
        if (hasOwn.call(this._parts, key)) {
          this._parts[key] = src[key];
        }
      }
    } else {
      throw new TypeError('invalid input');
    }

    this.build(!build);
    return this;
  };

  // identification accessors
  p.is = function(what) {
    var ip = false;
    var ip4 = false;
    var ip6 = false;
    var name = false;
    var sld = false;
    var idn = false;
    var punycode = false;
    var relative = !this._parts.urn;

    if (this._parts.hostname) {
      relative = false;
      ip4 = URI.ip4_expression.test(this._parts.hostname);
      ip6 = URI.ip6_expression.test(this._parts.hostname);
      ip = ip4 || ip6;
      name = !ip;
      sld = name && SLD && SLD.has(this._parts.hostname);
      idn = name && URI.idn_expression.test(this._parts.hostname);
      punycode = name && URI.punycode_expression.test(this._parts.hostname);
    }

    switch (what.toLowerCase()) {
      case 'relative':
        return relative;

      case 'absolute':
        return !relative;

      // hostname identification
      case 'domain':
      case 'name':
        return name;

      case 'sld':
        return sld;

      case 'ip':
        return ip;

      case 'ip4':
      case 'ipv4':
      case 'inet4':
        return ip4;

      case 'ip6':
      case 'ipv6':
      case 'inet6':
        return ip6;

      case 'idn':
        return idn;

      case 'url':
        return !this._parts.urn;

      case 'urn':
        return !!this._parts.urn;

      case 'punycode':
        return punycode;
    }

    return null;
  };

  // component specific input validation
  var _protocol = p.protocol;
  var _port = p.port;
  var _hostname = p.hostname;

  p.protocol = function(v, build) {
    if (v) {
      // accept trailing ://
      v = v.replace(/:(\/\/)?$/, '');

      if (!v.match(URI.protocol_expression)) {
        throw new TypeError('Protocol "' + v + '" contains characters other than [A-Z0-9.+-] or doesn\'t start with [A-Z]');
      }
    }

    return _protocol.call(this, v, build);
  };
  p.scheme = p.protocol;
  p.port = function(v, build) {
    if (this._parts.urn) {
      return v === undefined ? '' : this;
    }

    if (v !== undefined) {
      if (v === 0) {
        v = null;
      }

      if (v) {
        v += '';
        if (v.charAt(0) === ':') {
          v = v.substring(1);
        }

        URI.ensureValidPort(v);
      }
    }
    return _port.call(this, v, build);
  };
  p.hostname = function(v, build) {
    if (this._parts.urn) {
      return v === undefined ? '' : this;
    }

    if (v !== undefined) {
      var x = { preventInvalidHostname: this._parts.preventInvalidHostname };
      var res = URI.parseHost(v, x);
      if (res !== '/') {
        throw new TypeError('Hostname "' + v + '" contains characters other than [A-Z0-9.-]');
      }

      v = x.hostname;
      if (this._parts.preventInvalidHostname) {
        URI.ensureValidHostname(v, this._parts.protocol);
      }
    }

    return _hostname.call(this, v, build);
  };

  // compound accessors
  p.origin = function(v, build) {
    if (this._parts.urn) {
      return v === undefined ? '' : this;
    }

    if (v === undefined) {
      var protocol = this.protocol();
      var authority = this.authority();
      if (!authority) {
        return '';
      }

      return (protocol ? protocol + '://' : '') + this.authority();
    } else {
      var origin = URI(v);
      this
        .protocol(origin.protocol())
        .authority(origin.authority())
        .build(!build);
      return this;
    }
  };
  p.host = function(v, build) {
    if (this._parts.urn) {
      return v === undefined ? '' : this;
    }

    if (v === undefined) {
      return this._parts.hostname ? URI.buildHost(this._parts) : '';
    } else {
      var res = URI.parseHost(v, this._parts);
      if (res !== '/') {
        throw new TypeError('Hostname "' + v + '" contains characters other than [A-Z0-9.-]');
      }

      this.build(!build);
      return this;
    }
  };
  p.authority = function(v, build) {
    if (this._parts.urn) {
      return v === undefined ? '' : this;
    }

    if (v === undefined) {
      return this._parts.hostname ? URI.buildAuthority(this._parts) : '';
    } else {
      var res = URI.parseAuthority(v, this._parts);
      if (res !== '/') {
        throw new TypeError('Hostname "' + v + '" contains characters other than [A-Z0-9.-]');
      }

      this.build(!build);
      return this;
    }
  };
  p.userinfo = function(v, build) {
    if (this._parts.urn) {
      return v === undefined ? '' : this;
    }

    if (v === undefined) {
      var t = URI.buildUserinfo(this._parts);
      return t ? t.substring(0, t.length -1) : t;
    } else {
      if (v[v.length-1] !== '@') {
        v += '@';
      }

      URI.parseUserinfo(v, this._parts);
      this.build(!build);
      return this;
    }
  };
  p.resource = function(v, build) {
    var parts;

    if (v === undefined) {
      return this.path() + this.search() + this.hash();
    }

    parts = URI.parse(v);
    this._parts.path = parts.path;
    this._parts.query = parts.query;
    this._parts.fragment = parts.fragment;
    this.build(!build);
    return this;
  };

  // fraction accessors
  p.subdomain = function(v, build) {
    if (this._parts.urn) {
      return v === undefined ? '' : this;
    }

    // convenience, return "www" from "www.example.org"
    if (v === undefined) {
      if (!this._parts.hostname || this.is('IP')) {
        return '';
      }

      // grab domain and add another segment
      var end = this._parts.hostname.length - this.domain().length - 1;
      return this._parts.hostname.substring(0, end) || '';
    } else {
      var e = this._parts.hostname.length - this.domain().length;
      var sub = this._parts.hostname.substring(0, e);
      var replace = new RegExp('^' + escapeRegEx(sub));

      if (v && v.charAt(v.length - 1) !== '.') {
        v += '.';
      }

      if (v.indexOf(':') !== -1) {
        throw new TypeError('Domains cannot contain colons');
      }

      if (v) {
        URI.ensureValidHostname(v, this._parts.protocol);
      }

      this._parts.hostname = this._parts.hostname.replace(replace, v);
      this.build(!build);
      return this;
    }
  };
  p.domain = function(v, build) {
    if (this._parts.urn) {
      return v === undefined ? '' : this;
    }

    if (typeof v === 'boolean') {
      build = v;
      v = undefined;
    }

    // convenience, return "example.org" from "www.example.org"
    if (v === undefined) {
      if (!this._parts.hostname || this.is('IP')) {
        return '';
      }

      // if hostname consists of 1 or 2 segments, it must be the domain
      var t = this._parts.hostname.match(/\./g);
      if (t && t.length < 2) {
        return this._parts.hostname;
      }

      // grab tld and add another segment
      var end = this._parts.hostname.length - this.tld(build).length - 1;
      end = this._parts.hostname.lastIndexOf('.', end -1) + 1;
      return this._parts.hostname.substring(end) || '';
    } else {
      if (!v) {
        throw new TypeError('cannot set domain empty');
      }

      if (v.indexOf(':') !== -1) {
        throw new TypeError('Domains cannot contain colons');
      }

      URI.ensureValidHostname(v, this._parts.protocol);

      if (!this._parts.hostname || this.is('IP')) {
        this._parts.hostname = v;
      } else {
        var replace = new RegExp(escapeRegEx(this.domain()) + '$');
        this._parts.hostname = this._parts.hostname.replace(replace, v);
      }

      this.build(!build);
      return this;
    }
  };
  p.tld = function(v, build) {
    if (this._parts.urn) {
      return v === undefined ? '' : this;
    }

    if (typeof v === 'boolean') {
      build = v;
      v = undefined;
    }

    // return "org" from "www.example.org"
    if (v === undefined) {
      if (!this._parts.hostname || this.is('IP')) {
        return '';
      }

      var pos = this._parts.hostname.lastIndexOf('.');
      var tld = this._parts.hostname.substring(pos + 1);

      if (build !== true && SLD && SLD.list[tld.toLowerCase()]) {
        return SLD.get(this._parts.hostname) || tld;
      }

      return tld;
    } else {
      var replace;

      if (!v) {
        throw new TypeError('cannot set TLD empty');
      } else if (v.match(/[^a-zA-Z0-9-]/)) {
        if (SLD && SLD.is(v)) {
          replace = new RegExp(escapeRegEx(this.tld()) + '$');
          this._parts.hostname = this._parts.hostname.replace(replace, v);
        } else {
          throw new TypeError('TLD "' + v + '" contains characters other than [A-Z0-9]');
        }
      } else if (!this._parts.hostname || this.is('IP')) {
        throw new ReferenceError('cannot set TLD on non-domain host');
      } else {
        replace = new RegExp(escapeRegEx(this.tld()) + '$');
        this._parts.hostname = this._parts.hostname.replace(replace, v);
      }

      this.build(!build);
      return this;
    }
  };
  p.directory = function(v, build) {
    if (this._parts.urn) {
      return v === undefined ? '' : this;
    }

    if (v === undefined || v === true) {
      if (!this._parts.path && !this._parts.hostname) {
        return '';
      }

      if (this._parts.path === '/') {
        return '/';
      }

      var end = this._parts.path.length - this.filename().length - 1;
      var res = this._parts.path.substring(0, end) || (this._parts.hostname ? '/' : '');

      return v ? URI.decodePath(res) : res;

    } else {
      var e = this._parts.path.length - this.filename().length;
      var directory = this._parts.path.substring(0, e);
      var replace = new RegExp('^' + escapeRegEx(directory));

      // fully qualifier directories begin with a slash
      if (!this.is('relative')) {
        if (!v) {
          v = '/';
        }

        if (v.charAt(0) !== '/') {
          v = '/' + v;
        }
      }

      // directories always end with a slash
      if (v && v.charAt(v.length - 1) !== '/') {
        v += '/';
      }

      v = URI.recodePath(v);
      this._parts.path = this._parts.path.replace(replace, v);
      this.build(!build);
      return this;
    }
  };
  p.filename = function(v, build) {
    if (this._parts.urn) {
      return v === undefined ? '' : this;
    }

    if (typeof v !== 'string') {
      if (!this._parts.path || this._parts.path === '/') {
        return '';
      }

      var pos = this._parts.path.lastIndexOf('/');
      var res = this._parts.path.substring(pos+1);

      return v ? URI.decodePathSegment(res) : res;
    } else {
      var mutatedDirectory = false;

      if (v.charAt(0) === '/') {
        v = v.substring(1);
      }

      if (v.match(/\.?\//)) {
        mutatedDirectory = true;
      }

      var replace = new RegExp(escapeRegEx(this.filename()) + '$');
      v = URI.recodePath(v);
      this._parts.path = this._parts.path.replace(replace, v);

      if (mutatedDirectory) {
        this.normalizePath(build);
      } else {
        this.build(!build);
      }

      return this;
    }
  };
  p.suffix = function(v, build) {
    if (this._parts.urn) {
      return v === undefined ? '' : this;
    }

    if (v === undefined || v === true) {
      if (!this._parts.path || this._parts.path === '/') {
        return '';
      }

      var filename = this.filename();
      var pos = filename.lastIndexOf('.');
      var s, res;

      if (pos === -1) {
        return '';
      }

      // suffix may only contain alnum characters (yup, I made this up.)
      s = filename.substring(pos+1);
      res = (/^[a-z0-9%]+$/i).test(s) ? s : '';
      return v ? URI.decodePathSegment(res) : res;
    } else {
      if (v.charAt(0) === '.') {
        v = v.substring(1);
      }

      var suffix = this.suffix();
      var replace;

      if (!suffix) {
        if (!v) {
          return this;
        }

        this._parts.path += '.' + URI.recodePath(v);
      } else if (!v) {
        replace = new RegExp(escapeRegEx('.' + suffix) + '$');
      } else {
        replace = new RegExp(escapeRegEx(suffix) + '$');
      }

      if (replace) {
        v = URI.recodePath(v);
        this._parts.path = this._parts.path.replace(replace, v);
      }

      this.build(!build);
      return this;
    }
  };
  p.segment = function(segment, v, build) {
    var separator = this._parts.urn ? ':' : '/';
    var path = this.path();
    var absolute = path.substring(0, 1) === '/';
    var segments = path.split(separator);

    if (segment !== undefined && typeof segment !== 'number') {
      build = v;
      v = segment;
      segment = undefined;
    }

    if (segment !== undefined && typeof segment !== 'number') {
      throw new Error('Bad segment "' + segment + '", must be 0-based integer');
    }

    if (absolute) {
      segments.shift();
    }

    if (segment < 0) {
      // allow negative indexes to address from the end
      segment = Math.max(segments.length + segment, 0);
    }

    if (v === undefined) {
      /*jshint laxbreak: true */
      return segment === undefined
        ? segments
        : segments[segment];
      /*jshint laxbreak: false */
    } else if (segment === null || segments[segment] === undefined) {
      if (isArray(v)) {
        segments = [];
        // collapse empty elements within array
        for (var i=0, l=v.length; i < l; i++) {
          if (!v[i].length && (!segments.length || !segments[segments.length -1].length)) {
            continue;
          }

          if (segments.length && !segments[segments.length -1].length) {
            segments.pop();
          }

          segments.push(trimSlashes(v[i]));
        }
      } else if (v || typeof v === 'string') {
        v = trimSlashes(v);
        if (segments[segments.length -1] === '') {
          // empty trailing elements have to be overwritten
          // to prevent results such as /foo//bar
          segments[segments.length -1] = v;
        } else {
          segments.push(v);
        }
      }
    } else {
      if (v) {
        segments[segment] = trimSlashes(v);
      } else {
        segments.splice(segment, 1);
      }
    }

    if (absolute) {
      segments.unshift('');
    }

    return this.path(segments.join(separator), build);
  };
  p.segmentCoded = function(segment, v, build) {
    var segments, i, l;

    if (typeof segment !== 'number') {
      build = v;
      v = segment;
      segment = undefined;
    }

    if (v === undefined) {
      segments = this.segment(segment, v, build);
      if (!isArray(segments)) {
        segments = segments !== undefined ? URI.decode(segments) : undefined;
      } else {
        for (i = 0, l = segments.length; i < l; i++) {
          segments[i] = URI.decode(segments[i]);
        }
      }

      return segments;
    }

    if (!isArray(v)) {
      v = (typeof v === 'string' || v instanceof String) ? URI.encode(v) : v;
    } else {
      for (i = 0, l = v.length; i < l; i++) {
        v[i] = URI.encode(v[i]);
      }
    }

    return this.segment(segment, v, build);
  };

  // mutating query string
  var q = p.query;
  p.query = function(v, build) {
    if (v === true) {
      return URI.parseQuery(this._parts.query, this._parts.escapeQuerySpace);
    } else if (typeof v === 'function') {
      var data = URI.parseQuery(this._parts.query, this._parts.escapeQuerySpace);
      var result = v.call(this, data);
      this._parts.query = URI.buildQuery(result || data, this._parts.duplicateQueryParameters, this._parts.escapeQuerySpace);
      this.build(!build);
      return this;
    } else if (v !== undefined && typeof v !== 'string') {
      this._parts.query = URI.buildQuery(v, this._parts.duplicateQueryParameters, this._parts.escapeQuerySpace);
      this.build(!build);
      return this;
    } else {
      return q.call(this, v, build);
    }
  };
  p.setQuery = function(name, value, build) {
    var data = URI.parseQuery(this._parts.query, this._parts.escapeQuerySpace);

    if (typeof name === 'string' || name instanceof String) {
      data[name] = value !== undefined ? value : null;
    } else if (typeof name === 'object') {
      for (var key in name) {
        if (hasOwn.call(name, key)) {
          data[key] = name[key];
        }
      }
    } else {
      throw new TypeError('URI.addQuery() accepts an object, string as the name parameter');
    }

    this._parts.query = URI.buildQuery(data, this._parts.duplicateQueryParameters, this._parts.escapeQuerySpace);
    if (typeof name !== 'string') {
      build = value;
    }

    this.build(!build);
    return this;
  };
  p.addQuery = function(name, value, build) {
    var data = URI.parseQuery(this._parts.query, this._parts.escapeQuerySpace);
    URI.addQuery(data, name, value === undefined ? null : value);
    this._parts.query = URI.buildQuery(data, this._parts.duplicateQueryParameters, this._parts.escapeQuerySpace);
    if (typeof name !== 'string') {
      build = value;
    }

    this.build(!build);
    return this;
  };
  p.removeQuery = function(name, value, build) {
    var data = URI.parseQuery(this._parts.query, this._parts.escapeQuerySpace);
    URI.removeQuery(data, name, value);
    this._parts.query = URI.buildQuery(data, this._parts.duplicateQueryParameters, this._parts.escapeQuerySpace);
    if (typeof name !== 'string') {
      build = value;
    }

    this.build(!build);
    return this;
  };
  p.hasQuery = function(name, value, withinArray) {
    var data = URI.parseQuery(this._parts.query, this._parts.escapeQuerySpace);
    return URI.hasQuery(data, name, value, withinArray);
  };
  p.setSearch = p.setQuery;
  p.addSearch = p.addQuery;
  p.removeSearch = p.removeQuery;
  p.hasSearch = p.hasQuery;

  // sanitizing URLs
  p.normalize = function() {
    if (this._parts.urn) {
      return this
        .normalizeProtocol(false)
        .normalizePath(false)
        .normalizeQuery(false)
        .normalizeFragment(false)
        .build();
    }

    return this
      .normalizeProtocol(false)
      .normalizeHostname(false)
      .normalizePort(false)
      .normalizePath(false)
      .normalizeQuery(false)
      .normalizeFragment(false)
      .build();
  };
  p.normalizeProtocol = function(build) {
    if (typeof this._parts.protocol === 'string') {
      this._parts.protocol = this._parts.protocol.toLowerCase();
      this.build(!build);
    }

    return this;
  };
  p.normalizeHostname = function(build) {
    if (this._parts.hostname) {
      if (this.is('IDN') && punycode) {
        this._parts.hostname = punycode.toASCII(this._parts.hostname);
      } else if (this.is('IPv6') && IPv6) {
        this._parts.hostname = IPv6.best(this._parts.hostname);
      }

      this._parts.hostname = this._parts.hostname.toLowerCase();
      this.build(!build);
    }

    return this;
  };
  p.normalizePort = function(build) {
    // remove port of it's the protocol's default
    if (typeof this._parts.protocol === 'string' && this._parts.port === URI.defaultPorts[this._parts.protocol]) {
      this._parts.port = null;
      this.build(!build);
    }

    return this;
  };
  p.normalizePath = function(build) {
    var _path = this._parts.path;
    if (!_path) {
      return this;
    }

    if (this._parts.urn) {
      this._parts.path = URI.recodeUrnPath(this._parts.path);
      this.build(!build);
      return this;
    }

    if (this._parts.path === '/') {
      return this;
    }

    _path = URI.recodePath(_path);

    var _was_relative;
    var _leadingParents = '';
    var _parent, _pos;

    // handle relative paths
    if (_path.charAt(0) !== '/') {
      _was_relative = true;
      _path = '/' + _path;
    }

    // handle relative files (as opposed to directories)
    if (_path.slice(-3) === '/..' || _path.slice(-2) === '/.') {
      _path += '/';
    }

    // resolve simples
    _path = _path
      .replace(/(\/(\.\/)+)|(\/\.$)/g, '/')
      .replace(/\/{2,}/g, '/');

    // remember leading parents
    if (_was_relative) {
      _leadingParents = _path.substring(1).match(/^(\.\.\/)+/) || '';
      if (_leadingParents) {
        _leadingParents = _leadingParents[0];
      }
    }

    // resolve parents
    while (true) {
      _parent = _path.search(/\/\.\.(\/|$)/);
      if (_parent === -1) {
        // no more ../ to resolve
        break;
      } else if (_parent === 0) {
        // top level cannot be relative, skip it
        _path = _path.substring(3);
        continue;
      }

      _pos = _path.substring(0, _parent).lastIndexOf('/');
      if (_pos === -1) {
        _pos = _parent;
      }
      _path = _path.substring(0, _pos) + _path.substring(_parent + 3);
    }

    // revert to relative
    if (_was_relative && this.is('relative')) {
      _path = _leadingParents + _path.substring(1);
    }

    this._parts.path = _path;
    this.build(!build);
    return this;
  };
  p.normalizePathname = p.normalizePath;
  p.normalizeQuery = function(build) {
    if (typeof this._parts.query === 'string') {
      if (!this._parts.query.length) {
        this._parts.query = null;
      } else {
        this.query(URI.parseQuery(this._parts.query, this._parts.escapeQuerySpace));
      }

      this.build(!build);
    }

    return this;
  };
  p.normalizeFragment = function(build) {
    if (!this._parts.fragment) {
      this._parts.fragment = null;
      this.build(!build);
    }

    return this;
  };
  p.normalizeSearch = p.normalizeQuery;
  p.normalizeHash = p.normalizeFragment;

  p.iso8859 = function() {
    // expect unicode input, iso8859 output
    var e = URI.encode;
    var d = URI.decode;

    URI.encode = escape;
    URI.decode = decodeURIComponent;
    try {
      this.normalize();
    } finally {
      URI.encode = e;
      URI.decode = d;
    }
    return this;
  };

  p.unicode = function() {
    // expect iso8859 input, unicode output
    var e = URI.encode;
    var d = URI.decode;

    URI.encode = strictEncodeURIComponent;
    URI.decode = unescape;
    try {
      this.normalize();
    } finally {
      URI.encode = e;
      URI.decode = d;
    }
    return this;
  };

  p.readable = function() {
    var uri = this.clone();
    // removing username, password, because they shouldn't be displayed according to RFC 3986
    uri.username('').password('').normalize();
    var t = '';
    if (uri._parts.protocol) {
      t += uri._parts.protocol + '://';
    }

    if (uri._parts.hostname) {
      if (uri.is('punycode') && punycode) {
        t += punycode.toUnicode(uri._parts.hostname);
        if (uri._parts.port) {
          t += ':' + uri._parts.port;
        }
      } else {
        t += uri.host();
      }
    }

    if (uri._parts.hostname && uri._parts.path && uri._parts.path.charAt(0) !== '/') {
      t += '/';
    }

    t += uri.path(true);
    if (uri._parts.query) {
      var q = '';
      for (var i = 0, qp = uri._parts.query.split('&'), l = qp.length; i < l; i++) {
        var kv = (qp[i] || '').split('=');
        q += '&' + URI.decodeQuery(kv[0], this._parts.escapeQuerySpace)
          .replace(/&/g, '%26');

        if (kv[1] !== undefined) {
          q += '=' + URI.decodeQuery(kv[1], this._parts.escapeQuerySpace)
            .replace(/&/g, '%26');
        }
      }
      t += '?' + q.substring(1);
    }

    t += URI.decodeQuery(uri.hash(), true);
    return t;
  };

  // resolving relative and absolute URLs
  p.absoluteTo = function(base) {
    var resolved = this.clone();
    var properties = ['protocol', 'username', 'password', 'hostname', 'port'];
    var basedir, i, p;

    if (this._parts.urn) {
      throw new Error('URNs do not have any generally defined hierarchical components');
    }

    if (!(base instanceof URI)) {
      base = new URI(base);
    }

    if (resolved._parts.protocol) {
      // Directly returns even if this._parts.hostname is empty.
      return resolved;
    } else {
      resolved._parts.protocol = base._parts.protocol;
    }

    if (this._parts.hostname) {
      return resolved;
    }

    for (i = 0; (p = properties[i]); i++) {
      resolved._parts[p] = base._parts[p];
    }

    if (!resolved._parts.path) {
      resolved._parts.path = base._parts.path;
      if (!resolved._parts.query) {
        resolved._parts.query = base._parts.query;
      }
    } else {
      if (resolved._parts.path.substring(-2) === '..') {
        resolved._parts.path += '/';
      }

      if (resolved.path().charAt(0) !== '/') {
        basedir = base.directory();
        basedir = basedir ? basedir : base.path().indexOf('/') === 0 ? '/' : '';
        resolved._parts.path = (basedir ? (basedir + '/') : '') + resolved._parts.path;
        resolved.normalizePath();
      }
    }

    resolved.build();
    return resolved;
  };
  p.relativeTo = function(base) {
    var relative = this.clone().normalize();
    var relativeParts, baseParts, common, relativePath, basePath;

    if (relative._parts.urn) {
      throw new Error('URNs do not have any generally defined hierarchical components');
    }

    base = new URI(base).normalize();
    relativeParts = relative._parts;
    baseParts = base._parts;
    relativePath = relative.path();
    basePath = base.path();

    if (relativePath.charAt(0) !== '/') {
      throw new Error('URI is already relative');
    }

    if (basePath.charAt(0) !== '/') {
      throw new Error('Cannot calculate a URI relative to another relative URI');
    }

    if (relativeParts.protocol === baseParts.protocol) {
      relativeParts.protocol = null;
    }

    if (relativeParts.username !== baseParts.username || relativeParts.password !== baseParts.password) {
      return relative.build();
    }

    if (relativeParts.protocol !== null || relativeParts.username !== null || relativeParts.password !== null) {
      return relative.build();
    }

    if (relativeParts.hostname === baseParts.hostname && relativeParts.port === baseParts.port) {
      relativeParts.hostname = null;
      relativeParts.port = null;
    } else {
      return relative.build();
    }

    if (relativePath === basePath) {
      relativeParts.path = '';
      return relative.build();
    }

    // determine common sub path
    common = URI.commonPath(relativePath, basePath);

    // If the paths have nothing in common, return a relative URL with the absolute path.
    if (!common) {
      return relative.build();
    }

    var parents = baseParts.path
      .substring(common.length)
      .replace(/[^\/]*$/, '')
      .replace(/.*?\//g, '../');

    relativeParts.path = (parents + relativeParts.path.substring(common.length)) || './';

    return relative.build();
  };

  // comparing URIs
  p.equals = function(uri) {
    var one = this.clone();
    var two = new URI(uri);
    var one_map = {};
    var two_map = {};
    var checked = {};
    var one_query, two_query, key;

    one.normalize();
    two.normalize();

    // exact match
    if (one.toString() === two.toString()) {
      return true;
    }

    // extract query string
    one_query = one.query();
    two_query = two.query();
    one.query('');
    two.query('');

    // definitely not equal if not even non-query parts match
    if (one.toString() !== two.toString()) {
      return false;
    }

    // query parameters have the same length, even if they're permuted
    if (one_query.length !== two_query.length) {
      return false;
    }

    one_map = URI.parseQuery(one_query, this._parts.escapeQuerySpace);
    two_map = URI.parseQuery(two_query, this._parts.escapeQuerySpace);

    for (key in one_map) {
      if (hasOwn.call(one_map, key)) {
        if (!isArray(one_map[key])) {
          if (one_map[key] !== two_map[key]) {
            return false;
          }
        } else if (!arraysEqual(one_map[key], two_map[key])) {
          return false;
        }

        checked[key] = true;
      }
    }

    for (key in two_map) {
      if (hasOwn.call(two_map, key)) {
        if (!checked[key]) {
          // two contains a parameter not present in one
          return false;
        }
      }
    }

    return true;
  };

  // state
  p.preventInvalidHostname = function(v) {
    this._parts.preventInvalidHostname = !!v;
    return this;
  };

  p.duplicateQueryParameters = function(v) {
    this._parts.duplicateQueryParameters = !!v;
    return this;
  };

  p.escapeQuerySpace = function(v) {
    this._parts.escapeQuerySpace = !!v;
    return this;
  };

  return URI;
}));


/***/ }),
/* 12 */
/***/ (function(module, exports) {

module.exports = function(module) {
	if(!module.webpackPolyfill) {
		module.deprecate = function() {};
		module.paths = [];
		// module.parent = undefined by default
		if(!module.children) module.children = [];
		Object.defineProperty(module, "loaded", {
			enumerable: true,
			get: function() {
				return module.l;
			}
		});
		Object.defineProperty(module, "id", {
			enumerable: true,
			get: function() {
				return module.i;
			}
		});
		module.webpackPolyfill = 1;
	}
	return module;
};


/***/ }),
/* 13 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*
 This file is part of TALER
 (C) 2016 GNUnet e.V.

 TALER is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 TALER is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Definition of an object store.
 */
class Store {
    constructor(name, storeParams, validator) {
        this.name = name;
        this.storeParams = storeParams;
        this.validator = validator;
    }
}
exports.Store = Store;
/**
 * Definition of an index.
 */
class Index {
    constructor(s, indexName, keyPath, options) {
        this.indexName = indexName;
        this.keyPath = keyPath;
        const defaultOptions = {
            multiEntry: false,
        };
        this.options = Object.assign({}, defaultOptions, (options || {}));
        this.storeName = s.name;
    }
}
exports.Index = Index;
class BaseQueryValue {
    constructor(root) {
        this.root = root;
    }
    map(f) {
        return new MapQueryValue(this, f);
    }
    cond(f, onTrue, onFalse) {
        return new Promise((resolve, reject) => {
            this.subscribeOne((v, tx) => {
                if (f(v)) {
                    onTrue(new QueryRoot(this.root.db));
                }
                else {
                    onFalse(new QueryRoot(this.root.db));
                }
            });
            resolve();
        });
    }
}
class FirstQueryValue extends BaseQueryValue {
    constructor(stream) {
        super(stream.root);
        this.gotValue = false;
        this.s = stream;
    }
    subscribeOne(f) {
        this.s.subscribe((isDone, value, tx) => {
            if (this.gotValue) {
                return;
            }
            if (isDone) {
                f(undefined, tx);
            }
            else {
                f(value, tx);
            }
            this.gotValue = true;
        });
    }
}
class MapQueryValue extends BaseQueryValue {
    constructor(v, mapFn) {
        super(v.root);
        this.v = v;
        this.mapFn = mapFn;
    }
    subscribeOne(f) {
        this.v.subscribeOne((v, tx) => this.mapFn(v));
    }
}
/**
 * Exception that should be thrown by client code to abort a transaction.
 */
exports.AbortTransaction = Symbol("abort_transaction");
/**
 * Get an unresolved promise together with its extracted resolve / reject
 * function.
 */
function openPromise() {
    let resolve = null;
    let reject = null;
    const promise = new Promise((res, rej) => {
        resolve = res;
        reject = rej;
    });
    if (!(resolve && reject)) {
        // Never happens, unless JS implementation is broken
        throw Error();
    }
    return { resolve, reject, promise };
}
exports.openPromise = openPromise;
class QueryStreamBase {
    constructor(root) {
        this.root = root;
    }
    first() {
        return new FirstQueryValue(this);
    }
    flatMap(f) {
        return new QueryStreamFlatMap(this, f);
    }
    map(f) {
        return new QueryStreamMap(this, f);
    }
    indexJoin(index, keyFn) {
        this.root.addStoreAccess(index.storeName, false);
        return new QueryStreamIndexJoin(this, index.storeName, index.indexName, keyFn);
    }
    indexJoinLeft(index, keyFn) {
        this.root.addStoreAccess(index.storeName, false);
        return new QueryStreamIndexJoinLeft(this, index.storeName, index.indexName, keyFn);
    }
    keyJoin(store, keyFn) {
        this.root.addStoreAccess(store.name, false);
        return new QueryStreamKeyJoin(this, store.name, keyFn);
    }
    filter(f) {
        return new QueryStreamFilter(this, f);
    }
    toArray() {
        const { resolve, promise } = openPromise();
        const values = [];
        this.subscribe((isDone, value) => {
            if (isDone) {
                resolve(values);
                return;
            }
            values.push(value);
        });
        return Promise.resolve()
            .then(() => this.root.finish())
            .then(() => promise);
    }
    fold(f, init) {
        const { resolve, promise } = openPromise();
        let acc = init;
        this.subscribe((isDone, value) => {
            if (isDone) {
                resolve(acc);
                return;
            }
            acc = f(value, acc);
        });
        return Promise.resolve()
            .then(() => this.root.finish())
            .then(() => promise);
    }
    forEach(f) {
        const { resolve, promise } = openPromise();
        this.subscribe((isDone, value) => {
            if (isDone) {
                resolve();
                return;
            }
            f(value);
        });
        return Promise.resolve()
            .then(() => this.root.finish())
            .then(() => promise);
    }
    run() {
        const { resolve, promise } = openPromise();
        this.subscribe((isDone, value) => {
            if (isDone) {
                resolve();
                return;
            }
        });
        return Promise.resolve()
            .then(() => this.root.finish())
            .then(() => promise);
    }
}
class QueryStreamFilter extends QueryStreamBase {
    constructor(s, filterFn) {
        super(s.root);
        this.s = s;
        this.filterFn = filterFn;
    }
    subscribe(f) {
        this.s.subscribe((isDone, value, tx) => {
            if (isDone) {
                f(true, undefined, tx);
                return;
            }
            if (this.filterFn(value)) {
                f(false, value, tx);
            }
        });
    }
}
class QueryStreamFlatMap extends QueryStreamBase {
    constructor(s, flatMapFn) {
        super(s.root);
        this.s = s;
        this.flatMapFn = flatMapFn;
    }
    subscribe(f) {
        this.s.subscribe((isDone, value, tx) => {
            if (isDone) {
                f(true, undefined, tx);
                return;
            }
            const values = this.flatMapFn(value);
            for (const v in values) {
                f(false, v, tx);
            }
        });
    }
}
class QueryStreamMap extends QueryStreamBase {
    constructor(s, mapFn) {
        super(s.root);
        this.s = s;
        this.mapFn = mapFn;
    }
    subscribe(f) {
        this.s.subscribe((isDone, value, tx) => {
            if (isDone) {
                f(true, undefined, tx);
                return;
            }
            const mappedValue = this.mapFn(value);
            f(false, mappedValue, tx);
        });
    }
}
class QueryStreamIndexJoin extends QueryStreamBase {
    constructor(s, storeName, indexName, key) {
        super(s.root);
        this.s = s;
        this.storeName = storeName;
        this.indexName = indexName;
        this.key = key;
    }
    subscribe(f) {
        this.s.subscribe((isDone, value, tx) => {
            if (isDone) {
                f(true, undefined, tx);
                return;
            }
            const s = tx.objectStore(this.storeName).index(this.indexName);
            const req = s.openCursor(IDBKeyRange.only(this.key(value)));
            req.onsuccess = () => {
                const cursor = req.result;
                if (cursor) {
                    f(false, { left: value, right: cursor.value }, tx);
                    cursor.continue();
                }
            };
        });
    }
}
class QueryStreamIndexJoinLeft extends QueryStreamBase {
    constructor(s, storeName, indexName, key) {
        super(s.root);
        this.s = s;
        this.storeName = storeName;
        this.indexName = indexName;
        this.key = key;
    }
    subscribe(f) {
        this.s.subscribe((isDone, value, tx) => {
            if (isDone) {
                f(true, undefined, tx);
                return;
            }
            const s = tx.objectStore(this.storeName).index(this.indexName);
            const req = s.openCursor(IDBKeyRange.only(this.key(value)));
            let gotMatch = false;
            req.onsuccess = () => {
                const cursor = req.result;
                if (cursor) {
                    gotMatch = true;
                    f(false, { left: value, right: cursor.value }, tx);
                    cursor.continue();
                }
                else {
                    if (!gotMatch) {
                        f(false, { left: value }, tx);
                    }
                }
            };
        });
    }
}
class QueryStreamKeyJoin extends QueryStreamBase {
    constructor(s, storeName, key) {
        super(s.root);
        this.s = s;
        this.storeName = storeName;
        this.key = key;
    }
    subscribe(f) {
        this.s.subscribe((isDone, value, tx) => {
            if (isDone) {
                f(true, undefined, tx);
                return;
            }
            const s = tx.objectStore(this.storeName);
            const req = s.openCursor(IDBKeyRange.only(this.key(value)));
            req.onsuccess = () => {
                const cursor = req.result;
                if (cursor) {
                    f(false, { left: value, right: cursor.value }, tx);
                    cursor.continue();
                }
                else {
                    f(true, undefined, tx);
                }
            };
        });
    }
}
class IterQueryStream extends QueryStreamBase {
    constructor(qr, storeName, options) {
        super(qr);
        this.options = options;
        this.storeName = storeName;
        this.subscribers = [];
        const doIt = (tx) => {
            const { indexName = void 0, only = void 0 } = this.options;
            let s;
            if (indexName !== void 0) {
                s = tx.objectStore(this.storeName)
                    .index(this.options.indexName);
            }
            else {
                s = tx.objectStore(this.storeName);
            }
            let kr;
            if (only !== undefined) {
                kr = IDBKeyRange.only(this.options.only);
            }
            const req = s.openCursor(kr);
            req.onsuccess = () => {
                const cursor = req.result;
                if (cursor) {
                    for (const f of this.subscribers) {
                        f(false, cursor.value, tx);
                    }
                    cursor.continue();
                }
                else {
                    for (const f of this.subscribers) {
                        f(true, undefined, tx);
                    }
                }
            };
        };
        this.root.addWork(doIt);
    }
    subscribe(f) {
        this.subscribers.push(f);
    }
}
/**
 * Root wrapper around an IndexedDB for queries with a fluent interface.
 */
class QueryRoot {
    constructor(db) {
        this.db = db;
        this.work = [];
        this.stores = new Set();
        this.finished = false;
        this.keys = {};
    }
    /**
     * Get a named key that was created during the query.
     */
    key(keyName) {
        return this.keys[keyName];
    }
    checkFinished() {
        if (this.finished) {
            throw Error("Can't add work to query after it was started");
        }
    }
    /**
     * Get a stream of all objects in the store.
     */
    iter(store) {
        this.checkFinished();
        this.stores.add(store.name);
        this.scheduleFinish();
        return new IterQueryStream(this, store.name, {});
    }
    /**
     * Count the number of objects in a store.
     */
    count(store) {
        this.checkFinished();
        const { resolve, promise } = openPromise();
        const doCount = (tx) => {
            const s = tx.objectStore(store.name);
            const req = s.count();
            req.onsuccess = () => {
                resolve(req.result);
            };
        };
        this.addWork(doCount, store.name, false);
        return Promise.resolve()
            .then(() => this.finish())
            .then(() => promise);
    }
    /**
     * Delete all objects in a store that match a predicate.
     */
    deleteIf(store, predicate) {
        this.checkFinished();
        const doDeleteIf = (tx) => {
            const s = tx.objectStore(store.name);
            const req = s.openCursor();
            let n = 0;
            req.onsuccess = () => {
                const cursor = req.result;
                if (cursor) {
                    if (predicate(cursor.value, n++)) {
                        cursor.delete();
                    }
                    cursor.continue();
                }
            };
        };
        this.addWork(doDeleteIf, store.name, true);
        return this;
    }
    iterIndex(index, only) {
        this.checkFinished();
        this.stores.add(index.storeName);
        this.scheduleFinish();
        return new IterQueryStream(this, index.storeName, {
            indexName: index.indexName,
            only,
        });
    }
    /**
     * Put an object into the given object store.
     * Overrides if an existing object with the same key exists
     * in the store.
     */
    put(store, val, keyName) {
        this.checkFinished();
        const doPut = (tx) => {
            const req = tx.objectStore(store.name).put(val);
            if (keyName) {
                req.onsuccess = () => {
                    this.keys[keyName] = req.result;
                };
            }
        };
        this.scheduleFinish();
        this.addWork(doPut, store.name, true);
        return this;
    }
    /**
     * Put an object into a store or return an existing record.
     */
    putOrGetExisting(store, val, key) {
        this.checkFinished();
        const { resolve, promise } = openPromise();
        const doPutOrGet = (tx) => {
            const objstore = tx.objectStore(store.name);
            const req = objstore.get(key);
            req.onsuccess = () => {
                if (req.result !== undefined) {
                    resolve(req.result);
                }
                else {
                    const req2 = objstore.add(val);
                    req2.onsuccess = () => {
                        resolve(val);
                    };
                }
            };
        };
        this.scheduleFinish();
        this.addWork(doPutOrGet, store.name, true);
        return promise;
    }
    putWithResult(store, val) {
        this.checkFinished();
        const { resolve, promise } = openPromise();
        const doPutWithResult = (tx) => {
            const req = tx.objectStore(store.name).put(val);
            req.onsuccess = () => {
                resolve(req.result);
            };
            this.scheduleFinish();
        };
        this.addWork(doPutWithResult, store.name, true);
        return Promise.resolve()
            .then(() => this.finish())
            .then(() => promise);
    }
    /**
     * Update objects inside a transaction.
     *
     * If the mutation function throws AbortTransaction, the whole transaction will be aborted.
     * If the mutation function returns undefined or null, no modification will be made.
     */
    mutate(store, key, f) {
        this.checkFinished();
        const doPut = (tx) => {
            const req = tx.objectStore(store.name).openCursor(IDBKeyRange.only(key));
            req.onsuccess = () => {
                const cursor = req.result;
                if (cursor) {
                    const value = cursor.value;
                    let modifiedValue;
                    try {
                        modifiedValue = f(value);
                    }
                    catch (e) {
                        if (e === exports.AbortTransaction) {
                            tx.abort();
                            return;
                        }
                        throw e;
                    }
                    if (modifiedValue !== undefined && modifiedValue !== null) {
                        cursor.update(modifiedValue);
                    }
                    cursor.continue();
                }
            };
        };
        this.scheduleFinish();
        this.addWork(doPut, store.name, true);
        return this;
    }
    /**
     * Add all object from an iterable to the given object store.
     */
    putAll(store, iterable) {
        this.checkFinished();
        const doPutAll = (tx) => {
            for (const obj of iterable) {
                tx.objectStore(store.name).put(obj);
            }
        };
        this.scheduleFinish();
        this.addWork(doPutAll, store.name, true);
        return this;
    }
    /**
     * Add an object to the given object store.
     * Fails if the object's key is already present
     * in the object store.
     */
    add(store, val) {
        this.checkFinished();
        const doAdd = (tx) => {
            tx.objectStore(store.name).add(val);
        };
        this.scheduleFinish();
        this.addWork(doAdd, store.name, true);
        return this;
    }
    /**
     * Get one object from a store by its key.
     */
    get(store, key) {
        this.checkFinished();
        if (key === void 0) {
            throw Error("key must not be undefined");
        }
        const { resolve, promise } = openPromise();
        const doGet = (tx) => {
            const req = tx.objectStore(store.name).get(key);
            req.onsuccess = () => {
                resolve(req.result);
            };
        };
        this.addWork(doGet, store.name, false);
        return Promise.resolve()
            .then(() => this.finish())
            .then(() => promise);
    }
    /**
     * Get get objects from a store by their keys.
     * If no object for a key exists, the resulting position in the array
     * contains 'undefined'.
     */
    getMany(store, keys) {
        this.checkFinished();
        const { resolve, promise } = openPromise();
        const results = [];
        const doGetMany = (tx) => {
            for (const key of keys) {
                if (key === void 0) {
                    throw Error("key must not be undefined");
                }
                const req = tx.objectStore(store.name).get(key);
                req.onsuccess = () => {
                    results.push(req.result);
                    if (results.length === keys.length) {
                        resolve(results);
                    }
                };
            }
        };
        this.addWork(doGetMany, store.name, false);
        return Promise.resolve()
            .then(() => this.finish())
            .then(() => promise);
    }
    /**
     * Get one object from a store by its key.
     */
    getIndexed(index, key) {
        this.checkFinished();
        if (key === void 0) {
            throw Error("key must not be undefined");
        }
        const { resolve, promise } = openPromise();
        const doGetIndexed = (tx) => {
            const req = tx.objectStore(index.storeName)
                .index(index.indexName)
                .get(key);
            req.onsuccess = () => {
                resolve(req.result);
            };
        };
        this.addWork(doGetIndexed, index.storeName, false);
        return Promise.resolve()
            .then(() => this.finish())
            .then(() => promise);
    }
    scheduleFinish() {
        if (!this.finishScheduled) {
            Promise.resolve().then(() => this.finish());
            this.finishScheduled = true;
        }
    }
    /**
     * Finish the query, and start the query in the first place if necessary.
     */
    finish() {
        if (this.kickoffPromise) {
            return this.kickoffPromise;
        }
        this.kickoffPromise = new Promise((resolve, reject) => {
            // At this point, we can't add any more work
            this.finished = true;
            if (this.work.length === 0) {
                resolve();
                return;
            }
            const mode = this.hasWrite ? "readwrite" : "readonly";
            const tx = this.db.transaction(Array.from(this.stores), mode);
            tx.oncomplete = () => {
                resolve();
            };
            tx.onabort = () => {
                console.warn(`aborted ${mode} transaction on stores [${[...this.stores]}]`);
                reject(Error("transaction aborted"));
            };
            tx.onerror = (e) => {
                console.warn(`error in transaction`, e.target.error);
            };
            for (const w of this.work) {
                w(tx);
            }
        });
        return this.kickoffPromise;
    }
    /**
     * Delete an object by from the given object store.
     */
    delete(store, key) {
        this.checkFinished();
        const doDelete = (tx) => {
            tx.objectStore(store.name).delete(key);
        };
        this.scheduleFinish();
        this.addWork(doDelete, store.name, true);
        return this;
    }
    /**
     * Low-level function to add a task to the internal work queue.
     */
    addWork(workFn, storeName, isWrite) {
        this.work.push(workFn);
        if (storeName) {
            this.addStoreAccess(storeName, isWrite);
        }
    }
    addStoreAccess(storeName, isWrite) {
        if (storeName) {
            this.stores.add(storeName);
        }
        if (isWrite) {
            this.hasWrite = true;
        }
    }
}
exports.QueryRoot = QueryRoot;


/***/ }),
/* 14 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });
/* WEBPACK VAR INJECTION */(function(global) {/* harmony export (immutable) */ __webpack_exports__["getLib"] = getLib;
var require;/*
 This file is part of TALER
 (C) 2017 Inria and GNUnet e.V.

 TALER is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 TALER is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */


// @ts-nocheck


/**
 * This module loads the emscripten library, and is written in unchecked
 * JavaScript since it needs to do environment detection and dynamically select
 * the right way to load the library.
 */

/**
 * Load the taler emscripten lib.
 *
 * If in a WebWorker, importScripts is used.  Inside a browser, the module must
 * be globally available.  Inside node, require is used.
 */
function getLib() {
  if (true) {
    // Make sure that TypeScript doesn't try
    // to check the taler-emscripten-lib.
    const indirectRequire = require;
    const g = global;
    // unavoidable hack, so that emscripten detects
    // the environment as node even though importScripts
    // is present.
    const savedImportScripts = g.importScripts;
    delete g.importScripts;
    // Assume that the code is run from the build/ directory.
    const lib = __webpack_require__(15);
    g.importScripts = savedImportScripts;
    if (lib) {
      return lib;
    }
    // When we're running as a webpack bundle, the above require might
    // have failed and returned 'undefined', so we try other ways to import.
  }

  if (typeof importScripts !== "undefined") {
    self.TalerEmscriptenLib = {};
    importScripts('/emscripten/taler-emscripten-lib.js')
    if (!self.TalerEmscriptenLib) {
      throw Error("can't import taler emscripten lib");
    }
    return self.TalerEmscriptenLib
  }

  // Last resort, we don't have require, we're not running in a webworker.
  // Maybe we're on a normal browser page, in this case TalerEmscriptenLib
  // must be included in a script tag on the page.

  if (typeof window !== "undefined") {
    if (window.TalerEmscriptenLib) {
      return TalerEmscriptenLib;
    }
    throw Error("Looks like running in browser, but TalerEmscriptenLib is not defined");
  }
  throw Error("Running in unsupported environment");
}

/* WEBPACK VAR INJECTION */}.call(__webpack_exports__, __webpack_require__(4)))

/***/ }),
/* 15 */
/***/ (function(module, exports) {

module.exports = undefined;

/***/ })
/******/ ]);
//# sourceMappingURL=cryptoWorker-bundle.js.map