webpackJsonp([2],{

/***/ 158:
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*
 This file is part of TALER
 (C) 2016 Inria

 TALER is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 TALER is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Show wallet logs.
 *
 * @author Florian Dold
 */
const logging_1 = __webpack_require__(159);
const React = __webpack_require__(1);
const ReactDOM = __webpack_require__(3);
class LogView extends React.Component {
    render() {
        const e = this.props.log;
        return (React.createElement("div", { className: "tree-item" },
            React.createElement("ul", null,
                React.createElement("li", null,
                    "level: ",
                    e.level),
                React.createElement("li", null,
                    "msg: ",
                    e.msg),
                React.createElement("li", null,
                    "id: ",
                    e.id || "unknown"),
                React.createElement("li", null,
                    "file: ",
                    e.source || "(unknown)"),
                React.createElement("li", null,
                    "line: ",
                    e.line || "(unknown)"),
                React.createElement("li", null,
                    "col: ",
                    e.col || "(unknown)"),
                (e.detail ? React.createElement("li", null,
                    " detail: ",
                    React.createElement("pre", null, e.detail)) : []))));
    }
}
class Logs extends React.Component {
    constructor(props) {
        super({});
        this.update();
        this.state = {};
    }
    update() {
        return __awaiter(this, void 0, void 0, function* () {
            const logs = yield logging_1.getLogs();
            this.setState({ logs });
        });
    }
    render() {
        const logs = this.state.logs;
        if (!logs) {
            return React.createElement("span", null, "...");
        }
        return (React.createElement("div", { className: "tree-item" },
            "Logs:",
            logs.map((e) => React.createElement(LogView, { log: e }))));
    }
}
document.addEventListener("DOMContentLoaded", () => {
    ReactDOM.render(React.createElement(Logs, null), document.getElementById("container"));
});


/***/ }),

/***/ 159:
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*
 This file is part of TALER
 (C) 2016 Inria

 TALER is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 TALER is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Configurable logging.  Allows to log persistently to a database.
 */
const query_1 = __webpack_require__(136);
// Right now, our debug/info/warn/debug loggers just use the console based
// loggers.  This might change in the future.
function makeInfo() {
    return console.info.bind(console, "%o");
}
function makeWarn() {
    return console.warn.bind(console, "%o");
}
function makeError() {
    return console.error.bind(console, "%o");
}
function makeDebug() {
    return console.log.bind(console, "%o");
}
/**
 * Log a message using the configurable logger.
 */
function log(msg, level = "info") {
    return __awaiter(this, void 0, void 0, function* () {
        const ci = getCallInfo(2);
        return record(level, msg, undefined, ci.file, ci.line, ci.column);
    });
}
exports.log = log;
function getCallInfo(level) {
    // see https://github.com/v8/v8/wiki/Stack-Trace-API
    const stack = Error().stack;
    if (!stack) {
        return unknownFrame;
    }
    const lines = stack.split("\n");
    return parseStackLine(lines[level + 1]);
}
const unknownFrame = {
    column: 0,
    file: "(unknown)",
    line: 0,
    method: "(unknown)",
};
/**
 * Adapted from https://github.com/errwischt/stacktrace-parser.
 */
function parseStackLine(stackLine) {
    // tslint:disable-next-line:max-line-length
    const chrome = /^\s*at (?:(?:(?:Anonymous function)?|((?:\[object object\])?\S+(?: \[as \S+\])?)) )?\(?((?:file|http|https):.*?):(\d+)(?::(\d+))?\)?\s*$/i;
    const gecko = /^(?:\s*([^@]*)(?:\((.*?)\))?@)?(\S.*?):(\d+)(?::(\d+))?\s*$/i;
    const node = /^\s*at (?:((?:\[object object\])?\S+(?: \[as \S+\])?) )?\(?(.*?):(\d+)(?::(\d+))?\)?\s*$/i;
    let parts;
    parts = gecko.exec(stackLine);
    if (parts) {
        const f = {
            column: parts[5] ? +parts[5] : undefined,
            file: parts[3],
            line: +parts[4],
            method: parts[1] || "(unknown)",
        };
        return f;
    }
    parts = chrome.exec(stackLine);
    if (parts) {
        const f = {
            column: parts[4] ? +parts[4] : undefined,
            file: parts[2],
            line: +parts[3],
            method: parts[1] || "(unknown)",
        };
        return f;
    }
    parts = node.exec(stackLine);
    if (parts) {
        const f = {
            column: parts[4] ? +parts[4] : undefined,
            file: parts[2],
            line: +parts[3],
            method: parts[1] || "(unknown)",
        };
        return f;
    }
    return unknownFrame;
}
let db;
/**
 * Get all logs.  Only use for debugging, since this returns all logs ever made
 * at once without pagination.
 */
function getLogs() {
    return __awaiter(this, void 0, void 0, function* () {
        if (!db) {
            db = yield openLoggingDb();
        }
        return yield new query_1.QueryRoot(db).iter(logsStore).toArray();
    });
}
exports.getLogs = getLogs;
/**
 * The barrier ensures that only one DB write is scheduled against the log db
 * at the same time, so that the DB can stay responsive.  This is a bit of a
 * design problem with IndexedDB, it doesn't guarantee fairness.
 */
let barrier;
/**
 * Record an exeption in the log.
 */
function recordException(msg, e) {
    return __awaiter(this, void 0, void 0, function* () {
        let stack;
        let frame;
        try {
            stack = e.stack;
            if (stack) {
                const lines = stack.split("\n");
                frame = parseStackLine(lines[1]);
            }
        }
        catch (e) {
            // ignore
        }
        if (!frame) {
            frame = unknownFrame;
        }
        return record("error", e.toString(), stack, frame.file, frame.line, frame.column);
    });
}
exports.recordException = recordException;
/**
 * Cache for reports.  Also used when something is so broken that we can't even
 * access the database.
 */
const reportCache = {};
/**
 * Get a UUID that does not use cryptographically secure randomness.
 * Formatted as RFC4122 version 4 UUID.
 */
function getInsecureUuid() {
    return "xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g, (c) => {
        const r = Math.random() * 16 | 0;
        const v = c === "x" ? r : (r & 0x3 | 0x8);
        return v.toString(16);
    });
}
/**
 * Store a report and return a unique identifier to retrieve it later.
 */
function storeReport(report) {
    return __awaiter(this, void 0, void 0, function* () {
        const uid = getInsecureUuid();
        reportCache[uid] = report;
        return uid;
    });
}
exports.storeReport = storeReport;
/**
 * Retrieve a report by its unique identifier.
 */
function getReport(reportUid) {
    return __awaiter(this, void 0, void 0, function* () {
        return reportCache[reportUid];
    });
}
exports.getReport = getReport;
/**
 * Record a log entry in the database.
 */
function record(level, msg, detail, source, line, col) {
    return __awaiter(this, void 0, void 0, function* () {
        if (typeof indexedDB === "undefined") {
            console.log("can't access DB for logging in this context");
            console.log("log was", { level, msg, detail, source, line, col });
            return;
        }
        let myBarrier;
        if (barrier) {
            const p = barrier.promise;
            myBarrier = barrier = query_1.openPromise();
            yield p;
        }
        else {
            myBarrier = barrier = query_1.openPromise();
        }
        try {
            if (!db) {
                db = yield openLoggingDb();
            }
            const count = yield new query_1.QueryRoot(db).count(logsStore);
            if (count > 1000) {
                yield new query_1.QueryRoot(db).deleteIf(logsStore, (e, i) => (i < 200));
            }
            const entry = {
                col,
                detail,
                level,
                line,
                msg,
                source,
                timestamp: new Date().getTime(),
            };
            yield new query_1.QueryRoot(db).put(logsStore, entry);
        }
        finally {
            yield Promise.resolve().then(() => myBarrier.resolve());
        }
    });
}
exports.record = record;
const loggingDbVersion = 2;
const logsStore = new query_1.Store("logs");
/**
 * Get a handle to the IndexedDB used to store
 * logs.
 */
function openLoggingDb() {
    return new Promise((resolve, reject) => {
        const req = indexedDB.open("taler-logging", loggingDbVersion);
        req.onerror = (e) => {
            reject(e);
        };
        req.onsuccess = (e) => {
            resolve(req.result);
        };
        req.onupgradeneeded = (e) => {
            const resDb = req.result;
            if (e.oldVersion !== 0) {
                try {
                    resDb.deleteObjectStore("logs");
                }
                catch (e) {
                    console.error(e);
                }
            }
            resDb.createObjectStore("logs", { keyPath: "id", autoIncrement: true });
            resDb.createObjectStore("reports", { keyPath: "uid", autoIncrement: false });
        };
    });
}
exports.openLoggingDb = openLoggingDb;
/**
 * Log a message at severity info.
 */
exports.info = makeInfo();
/**
 * Log a message at severity debug.
 */
exports.debug = makeDebug();
/**
 * Log a message at severity warn.
 */
exports.warn = makeWarn();
/**
 * Log a message at severity error.
 */
exports.error = makeError();


/***/ })

},[158]);
//# sourceMappingURL=logs-bundle.js.map