/*
 *  Ball And Paddle
 *
 *  Copyright (C) 2007 by Eric Hutchins
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **/

#include "laser.h"

Laser::Laser (int x, int y, int width, int height, SDL_Surface * imgLaser)
{
  this->x = x;
  this->y = y;
  this->width = width;
  this->height = height;
  this->imgLaser = imgLaser;
  alive = true;
}

Laser::~Laser ()
{
}

void
Laser::draw (SDL_Surface * dest)
{
  if (!alive)
    return;
  SDL_Rect d = { (int) x, (int) y, 0, 0 };
  SDL_BlitSurface (imgLaser, NULL, dest, &d);
}

void
Laser::update (int time, vector < vector < Block * > >blocks,
	       vector < PowerUp * >&powerUps, int &score)
{
  y -= time * 0.4;
  if (!alive)
    return;
  int left = (int) x;
  int right = (int) (x + width - 1);
  int top = (int) y;
  int bottom = (int) (y + height - 1);

  if (top > 0 && left > 0 && top < 400 && left < 512)
    if (blocks[left / 32][top / 16]->isAlive ())
      alive = false;
  if (top > 0 && right < 512 && top < 400 && right > 0)
    if (blocks[right / 32][top / 16]->isAlive ())
      alive = false;
  if (bottom < 400 && left > 0 && bottom > 0 && left < 512)
    if (blocks[left / 32][bottom / 16]->isAlive ())
      alive = false;
  if (bottom < 400 && right < 512 && bottom > 0 && right > 0)
    if (blocks[right / 32][bottom / 16]->isAlive ())
      alive = false;

  vector < Block * >hitBlocks;

  if (top > 0 && left > 0 && top < 400 && left < 512)
    {
      bool isThere = false;
      for (int i = 0; i < hitBlocks.size (); i++)
	{
	  if (hitBlocks[i] == blocks[left / 32][top / 16])
	    isThere = true;
	}
      if (!isThere)
	hitBlocks.push_back (blocks[left / 32][top / 16]);
    }
  if (top > 0 && right < 512 && top < 400 && right > 0)
    {
      bool isThere = false;
      for (int i = 0; i < hitBlocks.size (); i++)
	{
	  if (hitBlocks[i] == blocks[right / 32][top / 16])
	    isThere = true;
	}
      if (!isThere)
	hitBlocks.push_back (blocks[right / 32][top / 16]);
    }
  if (bottom < 400 && left > 0 && bottom > 0 && left < 512)
    {
      bool isThere = false;
      for (int i = 0; i < hitBlocks.size (); i++)
	{
	  if (hitBlocks[i] == blocks[left / 32][bottom / 16])
	    isThere = true;
	}
      if (!isThere)
	hitBlocks.push_back (blocks[left / 32][bottom / 16]);
    }
  if (bottom < 400 && right < 512 && bottom > 0 && right > 0)
    {
      bool isThere = false;
      for (int i = 0; i < hitBlocks.size (); i++)
	{
	  if (hitBlocks[i] == blocks[right / 32][bottom / 16])
	    isThere = true;
	}
      if (!isThere)
	hitBlocks.push_back (blocks[right / 32][bottom / 16]);
    }

  for (int i = 0; i < hitBlocks.size (); i++)
    {
      if (hitBlocks[i]->weaken ())
	{
	  if (rand () > RAND_MAX * 0.8)
	    {
	      powerUps.
		push_back (new
			   PowerUp (hitBlocks[i]->getX () + 6,
				    hitBlocks[i]->getY (), 20, 16,
				    POWERUP_RANDOM));
	    }
	  switch (hitBlocks[i]->getMaxStrength ())
	    {
	    case 1:
	      score += 10;
	      break;
	    case 2:
	      score += 20;
	      break;
	    case 3:
	      score += 30;
	      break;
	    }
	}
    }
}
