/*
  Copyright (C) 2006-2007 Werner Dittmann

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef _ZRTPPACKETDHPART_H_
#define _ZRTPPACKETDHPART_H_

#include <libzrtpcpp/ZrtpPacketBase.h>

/**
 * Implement the DHPart packet.
 *
 * The ZRTP message DHPart. The implementation sends this
 * to exchange the Diffie-Helman public keys and the shared
 * secrets between the two parties.
 *
 * @author Werner Dittmann <Werner.Dittmann@t-online.de>
 */

class ZrtpPacketDHPart : public ZrtpPacketBase {

 protected:
    uint8_t *pv;
    DHPart_t* DHPartHeader;

 public:
    ZrtpPacketDHPart(SupportedPubKeys pkt);	/* Creates a DHPart packet with default data */
    ZrtpPacketDHPart(uint8_t* data);            /* Creates a DHPart packet from received data */
    virtual ~ZrtpPacketDHPart();

    uint8_t* getPv()             { return pv; }
    uint8_t* getRs1Id()          { return DHPartHeader->rs1Id; };
    uint8_t* getRs2Id()          { return DHPartHeader->rs2Id; };
    uint8_t* getSigsId()         { return DHPartHeader->sigsId; };
    uint8_t* getSrtpsId()        { return DHPartHeader->srtpsId; };
    uint8_t* getOtherSecretId()  { return DHPartHeader->otherSecretId; };

    void setPv(uint8_t* text) 	      { memcpy(pv, text, ((pktype == Dh3072) ? 384 :512)); };
    void setRs1Id(uint8_t* text)      { memcpy(DHPartHeader->rs1Id, text, sizeof(DHPartHeader->rs1Id)); };
    void setRs2Id(uint8_t* text)      { memcpy(DHPartHeader->rs2Id, text, sizeof(DHPartHeader->rs2Id)); };
    void setSigsId(uint8_t* text)     { memcpy(DHPartHeader->sigsId, text, sizeof(DHPartHeader->sigsId)); };
    void setSrtpsId(uint8_t* t)       { memcpy(DHPartHeader->srtpsId, t, sizeof(DHPartHeader->srtpsId)); };
    void setOtherSecretId(uint8_t* t) { memcpy(DHPartHeader->otherSecretId,t, sizeof(DHPartHeader->otherSecretId)); };

 private:
    SupportedPubKeys pktype;
     // DHPart packet is of variable length. It maximum size is 141 words:
     // - 13 words fixed sizze 
     // - up to 128 words variable part, depending on DH algorithm 
     // leads to a maximum of 4*141=5644 bytes.
     uint8_t data[768];       // large enough to hold a full blown DHPart packet

};

#endif // ZRTPPACKETDHPART

