/* LocaleInformation_hy.java --
   Copyright (C) 2004  Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


// This file was automatically generated by gnu.localegen from LDML

package gnu.java.locale;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.ListResourceBundle;

public class LocaleInformation_hy extends ListResourceBundle
{
  private static final String[] shortMonths = {
    "\u0545\u0576\u0580",
    "\u0553\u057f\u0580",
    "\u0544\u0580\u057f",
    "\u0531\u057a\u0580",
    "\u0544\u0575\u057d",
    "\u0545\u0576\u057d",
    "\u0545\u056c\u057d",
    "\u0555\u0563\u057d",
    "\u054d\u0565\u057a",
    "\u0540\u0578\u056f",
    "\u0546\u0578\u0575",
    "\u0534\u0565\u056f",
    null,
  };

  private static final String[] months = {
    "\u0545\u0578\u0582\u0576\u0578\u0582\u0561\u0580",
    "\u0553\u0565\u057f\u0580\u0578\u0582\u0561\u0580",
    "\u0544\u0561\u0580\u057f",
    "\u0531\u057a\u0580\u056b\u056c",
    "\u0544\u0561\u0575\u056b\u057d",
    "\u0545\u0578\u0582\u0576\u056b\u057d",
    "\u0545\u0578\u0582\u056c\u056b\u057d",
    "\u0555\u0563\u0578\u057d\u057f\u0578\u057d",
    "\u054d\u0565\u057a\u057f\u0565\u0574\u0562\u0565\u0580",
    "\u0540\u0578\u056f\u057f\u0565\u0574\u0562\u0565\u0580",
    "\u0546\u0578\u0575\u0565\u0574\u0562\u0565\u0580",
    "\u0534\u0565\u056f\u057f\u0565\u0574\u0562\u0565\u0580",
    null,
  };

  private static final String[] shortWeekdays = {
    null,
    "\u053f\u056b\u0580",
    "\u0535\u0580\u056f",
    "\u0535\u0580\u0584",
    "\u0549\u0578\u0580",
    "\u0540\u0576\u0563",
    "\u0548\u0582\u0580",
    "\u0547\u0561\u0562",
  };

  private static final String[] weekdays = {
    null,
    "\u053f\u056b\u0580\u0561\u056f\u056b",
    "\u0535\u0580\u056f\u0578\u0582\u0577\u0561\u0562\u0569\u056b",
    "\u0535\u0580\u0565\u0584\u0577\u0561\u0562\u0569\u056b",
    "\u0549\u0578\u0580\u0565\u0584\u0577\u0561\u0562\u0569\u056b",
    "\u0540\u056b\u0576\u0563\u0577\u0561\u0562\u0569\u056b",
    "\u0548\u0582\u0580\u0562\u0561\u0569",
    "\u0547\u0561\u0562\u0561\u0569",
  };

  private static final String[] eras = {
    "\u0545\u2024\u054f\u2024",
    "\u0546\u2024\u0554\u2024",
  };

  private static final String[] ampms = {
    "\u0531\u057c\u2024",
    "\u0535\u0580\u2024",
  };

  private static final String territoriesKeys = "TJ|TH|TG|GY|TD|GW|GT|GR|GQ|SZ|SY|GN|GM|SV|ST|GH|SR|SP|GE|SO|GD|SN|SM|GB|SL|GA|SK|SI|SG|SE|SD|SC|SB|SA|FR|FM|RW|RU|FJ|FI|RO|ET|ES|ER|EH|EG|EE|EC|DZ|QA|DO|PY|DM|PW|DK|DJ|PT|DE|PL|PK|PH|PG|CZ|PE|CY|CV|PA|CU|CR|CO|CN|CM|CL|CI|CH|CG|CF|OM|CA|BZ|BY|BW|BT|BS|BR|NZ|BO|BN|BJ|BI|BH|NR|BG|BF|NP|BE|NO|BD|BB|ZW|NL|BA|NI|NG|AZ|NE|ZM|AU|NA|AT|AR|MZ|AO|MY|MX|AM|MW|AL|MV|ZA|MU|MT|MR|AG|AF|AE|AD|MN|MM|ML|MK|MH|MG|MD|MC|MA|YE|LY|LV|LU|LT|LS|LR|LK|LI|LC|LB|LA|KZ|KW|KR|KP|KN|KM|KI|WS|KH|KG|KE|JP|JO|JM|VU|VN|VE|VC|VA|IT|IS|IR|IQ|UZ|UY|IN|IL|US|IE|ID|UG|UA|HU|HT|HR|TZ|HN|TW|TV|TT|TR|TO|TN|TM";

  private static final String territoriesValues = "\u054f\u0561\u0573\u056b\u056f\u057d\u057f\u0561\u0576|\u0539\u0561\u056b\u056c\u0561\u0576\u0564|\u054f\u0578\u0563\u0578|\u0533\u0561\u0575\u0561\u0576\u0561|\u0549\u0561\u0564|\u0533\u057e\u056b\u0576\u0565\u0561-\u0532\u056b\u057d\u0561\u0578\u0582|\u0533\u057e\u0561\u057f\u0565\u0574\u0561\u056c\u0561|\u0540\u0578\u0582\u0576\u0561\u057d\u057f\u0561\u0576|\u0540\u0561\u057d\u0561\u0580\u0561\u056f\u0561\u056e\u0561\u0575\u056b\u0576 \u0533\u057e\u056b\u0576\u0565\u0561|\u054d\u057e\u0561\u0566\u056b\u056c\u0565\u0576\u0564|\u054d\u056b\u0580\u056b\u0561|\u0533\u057e\u056b\u0576\u0565\u0561|\u0533\u0561\u0574\u0562\u056b\u0561|\u054d\u0561\u056c\u057e\u0561\u0564\u0578\u0580|\u054d\u0561\u0576-\u0539\u0578\u0574\u0565-\u0553\u0580\u056b\u0576\u057d\u056b\u057a\u056b|\u0533\u0561\u0576\u0561|\u054d\u0578\u0582\u0580\u056b\u0576\u0561\u0574|\u054d\u0565\u0580\u0562\u056b\u0561|\u054e\u0580\u0561\u057d\u057f\u0561\u0576|\u054d\u0578\u0574\u0561\u056c\u056b|\u0533\u0580\u0565\u0576\u0561\u0564\u0561|\u054d\u0565\u0576\u0565\u0563\u0561\u056c|\u054d\u0561\u0576 \u0544\u0561\u0580\u056b\u0576\u0578|\u0544\u0565\u056e \u0532\u0580\u056b\u057f\u0561\u0576\u056b\u0561|\u054d\u0575\u0565\u0580\u0561-\u053c\u0565\u0578\u0576\u0565|\u0533\u0561\u0562\u0578\u0576|\u054d\u056c\u0578\u057e\u0561\u056f\u056b\u0561|\u054d\u056c\u0578\u057e\u0565\u0576\u056b\u0561|\u054d\u056b\u0576\u0563\u0561\u057a\u0578\u0582\u0580|\u0547\u057e\u0565\u0564\u056b\u0561|\u054d\u0578\u0582\u0564\u0561\u0576|\u054d\u0565\u0575\u0577\u0565\u056c\u0576\u0565\u0580|\u054d\u0578\u056c\u0578\u0574\u0578\u0576\u0575\u0561\u0576 \u056f\u0572\u0566\u056b\u0576\u0565\u0580|\u054d\u0561\u0578\u0582\u0564\u056b\u0561\u0576 \u0531\u0580\u0561\u0562\u056b\u0561|\u0556\u0580\u0561\u0576\u057d\u056b\u0561|\u0544\u056b\u056f\u0580\u0578\u0576\u0565\u0566\u056b\u0561|\u054c\u0578\u0582\u0561\u0576\u0564\u0561|\u054c\u0578\u0582\u057d\u0561\u057d\u057f\u0561\u0576|\u0556\u056b\u057b\u056b|\u0556\u056b\u0576\u056c\u0561\u0576\u0564\u056b\u0561|\u054c\u0578\u0582\u0574\u056b\u0576\u056b\u0561|\u0535\u0569\u0578\u057e\u057a\u056b\u0561|\u053b\u057d\u057a\u0561\u0576\u056b\u0561|\u0537\u0580\u056b\u057f\u0580\u0565\u0561|\u0531\u0580\u0565\u057e\u0574\u057f\u0575\u0561\u0576 \u054d\u0561\u0570\u0561\u0580\u0561|\u0535\u0563\u056b\u057a\u057f\u0578\u057d|\u0537\u057d\u057f\u0578\u0576\u056b\u0561|\u0537\u056f\u057e\u0561\u0564\u0578\u0580|\u0531\u056c\u056a\u056b\u0580|\u053f\u0561\u057f\u0561\u0580|\u0534\u0578\u0574\u056b\u0576\u056b\u056f\u0575\u0561\u0576 \u0540\u0561\u0576\u0580\u0561\u057a\u0565\u057f\u0578\u0582\u0569\u0575\u0578\u0582\u0576|\u054a\u0561\u0580\u0561\u0563\u057e\u0561\u0575|\u0534\u0578\u0574\u056b\u0576\u056b\u056f\u0561|\u054a\u0561\u056c\u0561\u0578\u0582|\u0534\u0561\u0576\u056b\u0561|\u054b\u056b\u0562\u0578\u0582\u057f\u056b|\u054a\u0578\u0580\u057f\u0578\u0582\u0563\u0561\u056c\u056b\u0561|\u0533\u0565\u0580\u0574\u0561\u0576\u056b\u0561|\u053c\u0565\u0570\u0561\u057d\u057f\u0561\u0576|\u054a\u0561\u056f\u056b\u057d\u057f\u0561\u0576|\u0556\u056b\u056c\u056b\u057a\u056b\u0576\u0576\u0565\u0580|\u054a\u0561\u057a\u0578\u0582\u0561 \u0546\u0578\u0580 \u0533\u057e\u056b\u0576\u0565\u0561|\u0549\u0565\u056d\u056b\u0561\u0575\u056b \u0540\u0561\u0576\u0580\u0561\u057a\u0565\u057f\u0578\u0582\u0569\u0575\u0578\u0582\u0576|\u054a\u0565\u0580\u0578\u0582|\u053f\u056b\u057a\u0580\u0578\u057d|\u053f\u0561\u0562\u0578-\u054e\u0565\u0580\u0564\u0565|\u054a\u0561\u0576\u0561\u0574\u0561|\u053f\u0578\u0582\u0562\u0561|\u053f\u0578\u057d\u057f\u0561-\u054c\u056b\u056f\u0561|\u053f\u0578\u056c\u0578\u0582\u0574\u0562\u056b\u0561|\u0549\u056b\u0576\u0561\u057d\u057f\u0561\u0576|\u053f\u0561\u0574\u0565\u0580\u0578\u0582\u0576|\u0549\u056b\u056c\u056b|\u0553\u0572\u0578\u057d\u056f\u0580\u056b \u0531\u0583|\u0547\u057e\u0565\u0575\u0581\u0561\u0580\u056b\u0561|\u053f\u0578\u0576\u0563\u0578|\u053f\u0565\u0576\u057f\u0580\u0578\u0576\u0561\u056f\u0561\u0576 \u0531\u0586\u0580\u056b\u056f\u0575\u0561\u0576 \u0540\u0561\u0576\u0580\u0561\u057a\u0565\u057f\u0578\u0582\u0569\u0575\u0578\u0582\u0576|\u0555\u0574\u0561\u0576|\u053f\u0561\u0576\u0561\u0564\u0561|\u0532\u0565\u056c\u056b\u0566|\u0532\u0565\u056c\u0578\u057c\u0578\u0582\u057d|\u0532\u0578\u057f\u057d\u057e\u0561\u0576\u0561|\u0532\u0578\u0582\u057f\u0561\u0576|\u0532\u0561\u0570\u0561\u0574\u0576\u0565\u0580|\u0532\u0580\u0561\u0566\u056b\u056c\u056b\u0561|\u0546\u0578\u0580 \u0536\u0565\u056c\u0561\u0576\u0564\u056b\u0561|\u0532\u0578\u056c\u056b\u057e\u056b\u0561|\u0532\u0580\u0578\u0582\u0576\u0565\u0575|\u0532\u0565\u0576\u056b\u0576|\u0532\u0578\u0582\u0580\u0578\u0582\u0576\u0564\u056b|\u0532\u0561\u0570\u0580\u0565\u0575\u0576|\u0546\u0561\u0578\u0582\u0580\u0578\u0582|\u0532\u0578\u0582\u056c\u0572\u0561\u0580\u056b\u0561|\u0532\u0578\u0582\u0580\u056f\u056b\u0576\u0561 \u0556\u0561\u057d\u0578|\u0546\u0565\u057a\u0561\u056c|\u0532\u0565\u056c\u0563\u056b\u0561|\u0546\u0578\u0580\u057e\u0565\u0563\u056b\u0561|\u0532\u0561\u0576\u0563\u056c\u0561\u0564\u0565\u0577|\u0532\u0561\u0580\u0562\u0561\u0564\u0578\u057d|\u0536\u056b\u0574\u0562\u0561\u0562\u057e\u0565|\u0546\u056b\u0564\u0565\u0580\u056c\u0561\u0576\u0564\u0565\u0580|\u0532\u0578\u057d\u0576\u056b\u0561-\u0540\u0565\u0580\u0581\u0565\u0563\u0578\u057e\u056b\u0576\u0561|\u0546\u056b\u056f\u0561\u0580\u0561\u0563\u0578\u0582\u0561|\u0546\u056b\u0563\u0565\u0580\u056b\u0561|\u0531\u0564\u0580\u0562\u0565\u057b\u0561\u0576|\u0546\u056b\u0563\u0565\u0580|\u0536\u0561\u0574\u0562\u056b\u0561|\u0531\u057e\u057d\u057f\u0580\u0561\u056c\u056b\u0561|\u0546\u0561\u0574\u056b\u0562\u056b\u0561|\u0531\u057e\u057d\u057f\u0580\u056b\u0561|\u0531\u0580\u0563\u0565\u0576\u057f\u056b\u0576\u0561|\u0544\u0578\u0566\u0561\u0574\u0562\u056b\u056f|\u0531\u0576\u0563\u0578\u056c\u0561|\u0544\u0561\u056c\u0561\u0575\u0566\u056b\u0561|\u0544\u0565\u0584\u057d\u056b\u056f\u0561|\u0540\u0561\u0575\u0561\u057d\u057f\u0561\u0576\u056b \u0540\u0561\u0576\u0580\u0561\u057a\u0565\u057f\u0578\u0582\u0569\u056b\u0582\u0576|\u0544\u0561\u056c\u0561\u057e\u056b|\u0531\u056c\u0562\u0561\u0576\u056b\u0561|\u0544\u0561\u056c\u0564\u056b\u057e\u0576\u0565\u0580|\u0540\u0561\u0580\u0561\u057e\u0561\u0575\u056b\u0576 \u0531\u0586\u0580\u056b\u056f\u0561|\u0544\u0561\u057e\u0580\u056b\u057f\u0578\u057d|\u0544\u0561\u056c\u0569\u0561|\u0544\u0561\u057e\u0580\u056b\u057f\u0561\u0576\u056b\u0561|\u0531\u0576\u057f\u056b\u0563\u0578\u0582\u0561-\u0532\u0561\u0580\u0562\u0578\u0582\u0564\u0561|\u0531\u0586\u0572\u0561\u0576\u057d\u057f\u0561\u0576|\u0544\u056b\u0561\u0581\u0575\u0561\u056c \u0531\u0580\u0561\u0562\u0561\u056f\u0561\u0576 \u0537\u0574\u056b\u0580\u0561\u0569\u0576\u0565\u0580|\u0531\u0576\u0564\u0578\u0580\u0561|\u0544\u0578\u0576\u0572\u0578\u056c\u056b\u0561|\u0544\u0575\u0561\u0576\u0574\u0561|\u0544\u0561\u056c\u056b|\u0544\u0561\u056f\u0565\u0564\u0578\u0576\u056b\u0561|\u0544\u0561\u0580\u0577\u0561\u056c\u0575\u0561\u0576 \u056f\u0572\u0566\u056b\u0576\u0565\u0580|\u0544\u0561\u0564\u0561\u0563\u0561\u057d\u056f\u0561\u0580|\u0544\u0578\u056c\u0564\u0578\u057e\u0561|\u0544\u0578\u0576\u0561\u056f\u0578|\u0544\u0561\u0580\u0578\u056f\u0578|\u0535\u0574\u0565\u0576|\u053c\u056b\u0562\u056b\u0561|\u053c\u0561\u057f\u057e\u056b\u0561|\u053c\u0575\u0578\u0582\u0584\u057d\u0565\u0574\u0562\u0578\u0582\u0580\u0563|\u053c\u056b\u057f\u057e\u0561|\u053c\u0565\u057d\u0578\u057f\u0578|\u053c\u056b\u0562\u0565\u0580\u056b\u0561|\u0547\u0580\u056b \u053c\u0561\u0576\u056f\u0561|\u053c\u056b\u056d\u057f\u0565\u0576\u0577\u057f\u0565\u0575\u0576|\u054d\u0561\u0576\u057f\u0561 \u053c\u0578\u0582\u0579\u056b\u0561|\u053c\u056b\u0562\u0561\u0576\u0561\u0576|\u053c\u0561\u0578\u057d|\u0542\u0561\u0566\u0561\u056d\u057d\u057f\u0561\u0576|\u0554\u0578\u0582\u057e\u0565\u0575\u0569|\u0540\u0561\u0580\u0561\u057e\u0561\u0575\u056b\u0576 \u053f\u0578\u0580\u0565\u0561|\u0540\u0575\u0578\u0582\u057d\u056b\u057d\u0561\u0575\u056b\u0576 \u053f\u0578\u0580\u0565\u0561|\u054d\u0565\u0576\u057f \u053f\u056b\u057f\u057d-\u0546\u0565\u057e\u056b\u057d|\u053f\u0578\u0574\u0578\u0580\u0578\u057d|\u053f\u056b\u0580\u056b\u0562\u0561\u057f\u056b|\u054d\u0561\u0574\u0578\u0561|\u053f\u0561\u0574\u0562\u0578\u057b\u0561|\u053f\u056b\u0580\u0563\u056b\u0566\u057d\u057f\u0561\u0576|\u0554\u0565\u0576\u056b\u0561|\u0543\u0561\u057a\u0578\u0576\u056b\u0561|\u0540\u0578\u0580\u0564\u0561\u0576\u0561\u0576|\u054b\u0561\u0574\u0561\u0575\u056f\u0561|\u054e\u0561\u0576\u0578\u0582\u0561\u057f\u0578\u0582|\u054e\u056b\u0565\u057f\u0576\u0561\u0574|\u054e\u0565\u0576\u0565\u057d\u0578\u0582\u0565\u056c\u0561|\u054d\u0565\u0576\u057f \u054e\u056b\u057d\u0565\u0576\u057f-\u0533\u0580\u0565\u0576\u0561\u0564\u056b\u0576\u0576\u0565\u0580|\u054e\u0561\u057f\u056b\u056f\u0561\u0576|\u053b\u057f\u0561\u056c\u056b\u0561|\u053b\u057d\u056c\u0561\u0576\u0564\u056b\u0561|\u053b\u0580\u0561\u0576|\u053b\u0580\u0561\u0584|\u0548\u0582\u0566\u0562\u0565\u056f\u057d\u057f\u0561\u0576|\u0548\u0582\u0580\u0578\u0582\u0563\u057e\u0561\u0575|\u0540\u0576\u0564\u056f\u0561\u057d\u057f\u0561\u0576|\u053b\u057d\u0580\u0561\u0575\u0565\u056c|\u0531\u0574\u0567\u0580\u056b\u056f\u0561\u0575\u056b \u0544\u056b\u0561\u0581\u0575\u0561\u056c \u0546\u0561\u0570\u0561\u0576\u0563\u0576\u0567\u0580|\u053b\u057c\u056c\u0561\u0576\u0564\u056b\u0561|\u053b\u0576\u0564\u0578\u0576\u0565\u0566\u056b\u0561|\u0548\u0582\u0563\u0561\u0576\u0564\u0561|\u0548\u0582\u056f\u0580\u0561\u056b\u0576\u0561|\u0540\u0578\u0582\u0576\u0563\u0561\u0580\u056b\u0561|\u0540\u0561\u056b\u0569\u056b|\u0540\u0578\u0580\u057e\u0561\u0569\u056b\u0561|\u054f\u0561\u0576\u0566\u0561\u0576\u056b\u0561|\u0540\u0578\u0576\u0564\u0578\u0582\u0580\u0561\u057d|\u0539\u0561\u0575\u057e\u0561\u0576|\u054f\u0578\u0582\u057e\u0561\u056c\u0578\u0582|\u054f\u0580\u056b\u0576\u056b\u0564\u0561\u0564-\u054f\u0578\u0562\u0561\u0563\u0578|\u0539\u0578\u0582\u0580\u0584\u056b\u0561|\u054f\u0578\u0576\u0563\u0561|\u0539\u0578\u0582\u0576\u056b\u057d|\u0539\u0578\u0582\u0580\u0584\u0574\u0565\u0576\u057d\u057f\u0561\u0576";

  private static final Hashtable territories;
  static
  {
    territories = new Hashtable();
    Enumeration keys = new StringTokenizer(territoriesKeys, "|");
    Enumeration values = new StringTokenizer(territoriesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         territories.put(key, value);
      }
  }

  private static final String languagesKeys = "hy";

  private static final String languagesValues = "\u0540\u0561\u0575\u0565\u0580\u0567\u0576";

  private static final Hashtable languages;
  static
  {
    languages = new Hashtable();
    Enumeration keys = new StringTokenizer(languagesKeys, "|");
    Enumeration values = new StringTokenizer(languagesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         languages.put(key, value);
      }
  }

  private static final Object[][] contents =
  {
    { "decimalSeparator", "," },
    { "groupingSeparator", "." },
    { "percentFormat", "#0%" },
    { "currencyFormat", "#0.00 \u00a4;-#0.00 \u00a4" },
    { "shortMonths", shortMonths },
    { "months", months },
    { "shortWeekdays", shortWeekdays },
    { "weekdays", weekdays },
    { "eras", eras },
    { "ampms", ampms },
    { "shortDateFormat", "MM/dd/yy" },
    { "mediumDateFormat", "MMM d, yyyy" },
    { "longDateFormat", "MMMM dd, yyyy" },
    { "fullDateFormat", "EEEE, MMMM d, yyyy" },
    { "territories", territories },
    { "languages", languages },
  };

  public Object[][] getContents() { return contents; }
}
