/* LocaleInformation_sv.java --
   Copyright (C) 2004  Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


// This file was automatically generated by gnu.localegen from LDML

package gnu.java.locale;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.ListResourceBundle;

public class LocaleInformation_sv extends ListResourceBundle
{
  private static final String currenciesDisplayNameKeys = "JOD|BOV|FOK|LBP|EUR|VND|TZS|BOP|KHR|KHO|ZMP|AUP|XAF|MTP|GHR|ZMK|GHP|GHO|MTL|AUD|USS|ITL|USN|GHC|SGD|PAB|LAK|KGS|CHF|ATS|USD|ETD|BND|JMP|ETB|DZG|DZF|DZD|PYG|LYP|JMD|ISK|ESP|BMP|LYD|LYB|BMD|NLG|MRO|IRR|SEK|ERN|KES|CFF|ARS|ARP|ARM|TWD|SDP|GEL|GEK|MQF|FKP|ARA|SDD|IQD|TVD|SCR|LVR|FJP|LVL|CDL|CDG|CDF|FJD|NIO|MOP|NIG|NIC|FIN|FIM|SBD|LUF|TTO|AOS|AOR|MNT|HUF|BIF|AON|AOK|TTD|SZL|NHF|GBP|SAS|SAR|LTT|INR|PTE|AOA|PTC|LTL|KZT|KZR|VGD|NGP|MMX|NGN|HTG|SYP|PSP|BHD|MMK|ANG|CZK|IMP|BGX|LSL|GAF|BGO|BGN|BGM|CAD|BGL|TRL|KYD|CYP|ILS|GYD|AMD|ILP|MLF|ILL|VEB|ALX|LRD|ALV|HRK|REF|HRD|ALL|JEP|ALK|MKN|VDP|VDN|MKD|VDD|TPP|XPF|BEL|GWP|KWD|GWM|BEF|TPE|BEC|GWE|SVC|CWG|BDT|TOS|TOP|XOF|SUR|SUN|NCF|CVE|XNF|ZAR|DOP|CUX|ZAP|ZAL|TND|CUP|GUF|UGX|LNR|AIF|VAL|STE|UGS|STD|MHD|NZP|WST|WSP|HNL|XMF|TMM|GTQ|NZD|SSP|BBD|NAD|MGF|MGA|EGP|BZH|PLZ|BAN|PLX|BAM|BZD|BAD|PLN|YER|SRG|CSK|KRW|BYR|YEI|BYL|CSC|KRO|KRH|BYB|SQS|GRN|PKR|ZWD|LKR|GRD|IEP|YDD|RWF|CRC|TJS|TJR|EEK|GQP|MDR|HKD|DKK|MDL|GQF|GQE|IDR|AED|KPW|IDN|BWP|MDC|IDJ|KPP|IDG|VUV|XID|SOS|ADP|RUR|GPF|DJF|ADD|MCG|MCF|ECV|ECS|LIF|RUB|PHP|UZS|COP|THB|IBP|BUR|COF|BUK|COB|UZC|UAK|QAR|UAH|GNS|CNY|MZM|CNX|UYU|GNI|SML|MZE|CNP|PGK|OMS|GNF|OMR|UYP|XFU|BTR|ZRZ|MAF|MAD|BTN|XFO|UYF|MYR|ZRN|AZM|GMP|KMF|SLL|GMD|BSP|CMF|MXV|XEF|BSD|MXP|MXN|PES|GLK|BRZ|PEN|CLP|SKK|PEI|BRR|FRG|FRF|BRN|CLF|CLE|BRL|CLC|BRE|DES|MWP|BRC|BRB|MWK|PDR|DEM|TDF|PDN|PDK|NPR|CKD|JPY|MVR|XCF|MVP|XCD|SIT|YUR|AWG|YUO|DDM|YUN|YUM|TCC|YUG|YUF|RON|YUD|ROL|SIB|NOK|MUR|GIP|VNS|VNR|KID|SHP|VNN";

  private static final String currenciesDisplayNameValues = "Jordansk dinar|Boliviansk mvdol|F\u00e4r\u00f6isk krona|Libanesiskt pund|Euro|Vietnamesisk dong|Tanzanisk shilling|Boliviansk peso|Kambodjansk riel|Kambodjansk gammal riel|Zambiskt pund|Australiskt pund|CFA Franc BEAC|Maltesiskt pund|Ghanansk omv\u00e4rderad cedi|Zambisk kwacha|Ghananskt pund|Ghanansk gammal cedi|Maltesisk lira|Australisk dollar|US-dollar (samma dag)|Italiensk lira|US-dollar (n\u00e4sta dag)|Ghanansk cedi|Singaporiansk dollar|Panamansk balboa|Laotisk kip|Kirgizistansk som|Schweizisk franc|\u00d6sterrikisk schilling|US-dollar|Etiopisk dollar|Bruneisk dollar|Jamaicanskt pund|Etiopisk birr|Algerisk franc germinal|Algerisk ny franc|Algerisk dinar|Paraguaysk guarani|Libyskt pund|Jamaicansk dollar|Isl\u00e4ndsk krona|Spansk peseta|Bermuda-pund|Libysk dinar|Libyska brittiska milit\u00e4rmyndighetens lira|Bermuda-dollar|Nederl\u00e4ndsk gulden|Mauretansk ouguiya|Iransk rial|Svensk krona|Eritreansk nakfa|Kenyansk shilling|Centralafrikansk CFA-franc|Argentinsk peso|Argentinsk peso (1983-1985)|Argentinsk peso \u2013 Moneda nacional|Taiwanesisk ny dollar|Sudanesiskt pund|Georgisk lari|Georgisk kupon larit|Martiniqueisk franc|Falklands\u00f6arnas pund|Argentinsk austral|Sudanesisk dinar|Irakisk dinar|Tuvaluansk dollar|Seychellisk rupie|Lettisk rubel|Fijianskt pund|Lettisk lats|Kongolesisk zaire|Kongolesisk franc|Kongolesisk franc congolais|Fijiansk dollar|Nicaraguansk c\u00f3rdoba oro|Macaoisk pataca|Nicaraguansk guldc\u00f3rdoba|Nicaraguansk c\u00f3rdoba|Finsk mark (1860-1962)|Finsk mark|Salomon-dollar|Luxemburgsk franc|Trinidadisk gammal dollar|Angolansk escudo|Angolansk kwanza \u2013 Reajustado (1995-1999)|Mongolisk tugrik|Ungersk forint|Burundisk franc|Angolansk ny kwanza (1990-2000)|Angolansk kwanza (1977-1990)|Trinidadisk dollar|Swazil\u00e4ndsk lilangeni|Nyhebridisk CFP-franc|Brittiskt pund sterling|Saudisk sovereign riyal|Saudisk riyal|Lettisk talonas|Indisk rupie|Portugisisk escudo|Angolansk kwanza|Portugisisk conto|Lettisk lita|Kazakisk tenge|Kazakisk rubel|Jungfru\u00f6isk dollar|Nigerianskt pund|Myanmarisk dollar \u2013 Foreign Exchange Certificates|Nigeriansk naira|Haitisk gourde|Syriskt pund|Palestinskt pund|Bahrainsk dinar|Myanmarisk kyat|Nederl\u00e4ndsk antillisk gulden|Tjeckisk koruna|Isle of Man-pund sterling|Bulgarisk lev \u2013 Foreign Exchange Certificates|Lesothisk loti|Gabonesisk CFA-franc|Bulgarisk lev (1879-1952)|Bulgarisk ny lev|Bulgarisk socialistisk lev|Kanadensisk dollar|Bulgarisk h\u00e5rd lev|Turkisk lira|Cayman-dollar|Cypriotiskt pund|Israelisk ny shekel|Guyanansk dollar|Armenisk dram|Israeliskt pund|Malisk franc|Israelisk shekel|Venezuelansk bolivar|Albansk dollar \u2013 Foreign Exchange Certificates)|Liberisk dollar|Albansk lek \u2013 Valute)|Kroatisk kuna|R\u00e9union-franc|Kroatisk dinar|Albansk lek|Jersey-pund sterling|Albansk lek (1946-1961)|Makedonisk denar (1992-1993)|Nordvietnamesisk viet minh piastre dong viet|Nordvietnamesisk ny dong|Makedonisk denar|Nordvietnamesisk piastre dong viet|Timoriansk pataca|CFP-franc|Belgisk franc (finansiell)|Guinea-Bissau-peso|Kuwaitisk dinar|Portugisiska Guinea-mil reis|Belgisk franc|Timoriansk escudo|Belgisk franc (konvertibel)|Portugisiska Guinea-escudo|Salvadoransk col\u00f3n|Cura\u00e7ao-gulden|Bangladeshisk taka|Tonganskt pund sterling|Tongansk pa\u02bbanga|CFA Franc BCEAO|Sovjetisk rubel|Sovjetisk ny rubel|Nykaledonsk franc germinal|Kapverdisk escudo|Fransk Antillisk CFA-franc|Sydafrikansk rand|Dominikansk peso|Kubansk Foreign Exchange Certificates|Sydafrikansk rand|Sydafrikansk rand (finansiell)|Tunisisk dinar|Kubansk peso|Franska Guyanas Franc Guiana|Ugandisk shilling|Ceylonesisk rupie|Affars och Issas-franc|Vatikansk lira|S\u00e3o Tom\u00e9 och Pr\u00edncipe-escudo|Ugandisk shilling (1966-1987)|S\u00e3o Tom\u00e9 och Pr\u00edncipe-dobra|Marshall\u00f6isk dollar|Nyzeel\u00e4ndskt pund|V\u00e4stsamoansk tala|V\u00e4stsamoanskt pund|Hoduransk lempira|French Metropolitan Nouveau Franc|Turkmensk manat|Guatemalansk quetzal|Nyzeel\u00e4ndsk dollar|Skotskt pund|Barbadisk dollar|Namibisk dollar|Madagaskisk franc|Madagaskisk ariary|Egyptiskt pund|Brittiska Honduras-dollar|Polsk zloty (1950-1995)|Bosnisk-hercegovinsk ny dinar|Polsk US-dollar Foreign Exchange Certificates|Konvertibel bosnisk-hercegovinsk mark|Belizisk dollar|Bosnisk-hercegovinsk dinar|Polsk zloty|Jemenitisk rial|Surinamesisk gulden|Tjeckisk h\u00e5rd koruna|Sydkoreansk won|Vitrysk rubel|Jemenitisk imadi riyal|Vitrysk rubel (1992-1994)|Tjeckisk koruna|Sydkoreansk gammal won|Sydkoreansk hwan|Vitrysk ny rubel (1994-1999)|Somalil\u00e4ndsk shilling|Grekisk ny drachma|Pakistansk rupie|Zimbabwisk dollar|Srilankesisk rupie|Grekisk drachma|Irl\u00e4ndskt pund|Jemenitisk dinar|Rwandisk franc|Costarikansk col\u00f3n|Tadzjikisk somoni|Tadzjikisk rubel|Estnisk krona|Ekvatorialguineansk peseta guineana|Moldavisk rubelkupong|Hongkong-dollar|Dansk krona|Moldavisk leu|Ekvatorialguineansk franco|Ekvatorialguineansk ekwele guineana|Indonesisk rupiah|F\u00f6renade arabemiratens dirham|Nordkoreansk won|Indonesisk ny rupiah|Botswansk pula|Moldavisk leu-kupong|Indonesisk java rupiah|Nordkoreansk won|Indonesisk nica gulden|Vanuatisk vatu|Islamisk dinar|Somalisk shilling|Andorransk peseta|Rysk rubel (1991-1998)|Guadeloupisk franc|Djiboutisk franc|Andorransk diner|Monegaskisk franc germinal|Monegaskisk franc nouveau|Ecuadoriansk Unidad de Valor Constante (UVC)|Ecuadoriansk sucre|Liechtensteinsk franc|Rysk rubel|Filippinsk peso|Uzbekisk sum|Colombiansk peso|Thail\u00e4ndsk baht|Nordirl\u00e4ndskt pund|Burmesisk rupee|Kongolesisk CFA-franc|Burmesisk kyat|Colombiansk papperspeso|Uzbekisk coupon som|Ukrainsk karbovanetz|Qatarisk rial|Ukrainsk hryvnia|Guineansk syli|Kinesisk yuan renminbi|Mo\u00e7ambikisk metical|Kinesisk USA-dollar Foreign Exchange Certificates|Uruguayansk peso uruguayo|Guineansk franc (1960-1972)|Sanmarinsk lira|Mo\u00e7ambikisk escudo|Kinesisk jen min piao yuan|Papuansk kina|Omansk rial saidi|Guineansk franc|Omansk rial|Uruguayansk peso (1975-1993)|French UIC-Franc|Bhutanesisk rupie|Zairisk zaire|Marockansk franc|Marockansk dirham|Bhutanesisk ngultrum|Fransk guldfranc|Uruguayansk peso fuerte|Malaysisk ringgit|Zairisk ny zaire|Azerbajdzjansk manat|Gambiskt pund|Komorisk franc|Sierraleonsk leone|Gambisk dalasi|Bahamanskt pund|Kamerunsk CFA-franc|Mexikansk Unidad de Inversion (UDI)|CFA Franc BCEAEC|Bahamansk dollar|Mexikansk silverpeso (1861-1992)|Mexikansk peso|Peruansk sol|Gr\u00f6nl\u00e4ndsk krona|Brasiliansk cruzeiro (1942-1967)|Peruansk sol nuevo|Chilensk peso|Slovakisk koruna|Peruansk inti|Brasiliansk cruzeiro|Fransk Franc Germinal/Franc Poincare|Fransk franc|Brasiliansk cruzado novo|Chilensk unidad de fomento|Chilensk escudo|Brasiliansk real|Chilensk condor|Brasiliansk cruzeiro (1990-1993)|Tysk sperrmark|Malawiskt pund|Brasiliansk cruzado|Brasiliansk cruzeiro novo (1967-1986)|Malawisk kwacha|Transdniestrisk rubel|Tysk mark|Tchadisk CFA-franc|Transdniestrisk ny rubel|Transdniestrisk rubelkupong|Nepalesisk rupie|Cook-dollar|Japansk yen|Maldivisk rufiyaa|CFA Nouveau Franc|Maldivisk rupie|\u00d6stkaribisk dollar|Slovensk tolar|Jugoslavisk reformerad dinar|Aruba-florin|Jugoslavisk oktoberdinar|\u00d6sttysk mark|Jugoslavisk konvertibel dinar|Dinar (Serbien och Montenegro)|Turks and Caicos-crown|Jugoslavisk dinar (1994)|Jugoslavisk federationsdinar|Rum\u00e4nsk ny leu|Jugoslavisk h\u00e5rd dinar|Rum\u00e4nsk leu|Slovensk tolar bons|Norsk krona|Mauritisk rupie|Gibraltiskt pund|Vietnamesisk nationell dong|Vietnamesisk dong|Kiribatisk dollar|S:t Helena-pund|Vietnamesisk ny dong";

  private static final Hashtable currenciesDisplayName;
  static
  {
    currenciesDisplayName = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesDisplayNameKeys, "|");
    Enumeration values = new StringTokenizer(currenciesDisplayNameValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesDisplayName.put(key, value);
      }
  }

  private static final String currenciesSymbolKeys = "JOD|BOV|FOK|LBP|VND|TZS|BOP|KHR|KHO|ZMP|AUP|XAF|MTP|GHR|ZMK|GHP|GHO|MTL|AUD|USS|USN|GHC|SGD|PAB|LAK|KGS|CHF|ATS|USD|ETD|BND|JMP|ETB|DZG|DZF|DZD|PYG|LYP|JMD|ISK|ESP|BMP|LYD|LYB|BMD|NLG|MRO|IRR|SEK|ERN|KES|CFF|ARS|ARP|ARM|TWD|SDP|GEL|GEK|MQF|FKP|ARA|SDD|IQD|TVD|SCR|LVR|FJP|LVL|CDL|CDG|CDF|FJD|NIO|MOP|NIG|NIC|FIN|FIM|SBD|LUF|TTO|AOS|AOR|MNT|HUF|BIF|AON|AOK|TTD|SZL|NHF|SAS|SAR|LTT|PTE|AOA|PTC|LTL|KZT|KZR|VGD|NGP|MMX|NGN|HTG|SYP|PSP|BHD|MMK|ANG|CZK|IMP|BGX|LSL|GAF|BGO|BGN|BGM|CAD|BGL|TRL|KYD|CYP|ILS|GYD|AMD|ILP|MLF|ILL|VEB|ALX|LRD|ALV|HRK|REF|HRD|ALL|JEP|ALK|MKN|VDP|VDN|MKD|VDD|TPP|XPF|BEL|GWP|KWD|GWM|BEF|TPE|BEC|GWE|SVC|CWG|BDT|TOS|TOP|XOF|SUR|SUN|NCF|CVE|XNF|ZAR|DOP|CUX|ZAP|ZAL|TND|CUP|GUF|UGX|LNR|AIF|VAL|STE|UGS|STD|MHD|NZP|WST|WSP|HNL|XMF|TMM|GTQ|NZD|SSP|BBD|NAD|MGF|MGA|EGP|BZH|PLZ|BAN|PLX|BAM|BZD|BAD|PLN|YER|SRG|CSK|KRW|BYR|YEI|BYL|CSC|KRO|KRH|BYB|SQS|GRN|PKR|ZWD|LKR|GRD|IEP|YDD|RWF|CRC|TJS|TJR|EEK|GQP|MDR|HKD|DKK|MDL|GQF|GQE|IDR|AED|KPW|IDN|BWP|MDC|IDJ|KPP|IDG|VUV|XID|SOS|ADP|RUR|GPF|DJF|ADD|MCG|MCF|ECV|ECS|LIF|RUB|PHP|UZS|COP|THB|IBP|BUR|COF|BUK|COB|UZC|UAK|QAR|UAH|GNS|CNY|MZM|CNX|UYU|GNI|SML|MZE|CNP|PGK|OMS|GNF|UYP|OMR|XFU|BTR|ZRZ|MAF|MAD|BTN|XFO|UYF|MYR|ZRN|AZM|GMP|KMF|SLL|GMD|BSP|CMF|MXV|XEF|BSD|MXP|MXN|PES|GLK|BRZ|PEN|CLP|SKK|PEI|BRR|FRG|FRF|BRN|CLF|CLE|BRL|CLC|BRE|DES|MWP|BRC|BRB|MWK|PDR|DEM|TDF|PDN|PDK|NPR|CKD|MVR|XCF|MVP|XCD|SIT|YUR|AWG|YUO|DDM|YUN|YUM|TCC|YUG|YUF|RON|YUD|ROL|SIB|NOK|MUR|GIP|VNS|VNR|KID|SHP|VNN";

  private static final String currenciesSymbolValues = "JD|BOV|FOK|LL|VND|T Sh|BOP|CR|KHO|ZMP|AUP|XAF|MTP|GHR|ZMK|GHP|GHO|Lm|$A|USS|USN|GHC|S$|PAB|LAK|som|SwF|ATS|US$|ETD|BND|JMP|Br|DZG|DZF|DA|PYG|LYP|J$|ISK|ESP|BMP|LD|LYB|Ber$|NLG|UM|RI|kr|ERN|K Sh|CFF|Arg$|ARP|ARM|NT$|SDP|lari|GEK|MQF|FKP|ARA|SDD|ID|TVD|SR|LVR|FJP|LVL|CDL|CDG|CDF|F$|NIO|MOP|NIG|NIC|FIN|FIM|SI$|LUF|TTO|AOS|AOR|Tug|Ft|Fbu|AON|AOK|TT$|E|NHF|SAS|SRl|LTT|PTE|AOA|PTC|LTL|T|KZR|VGD|NGP|MMX|NGN|HTG|LS|PSP|BD|MMK|NA f.|CZK|IMP|BGX|M|GAF|BGO|BGN|BGM|Can$|lev|TL|KYD|\u00a3C|ILS|G$|dram|ILP|MLF|ILL|Be|ALX|LRD|ALV|HRK|REF|HRD|lek|JEP|ALK|MKN|VDP|VDN|MDen|VDD|TPP|CFPF|BEL|GWP|KD|GWM|BF|TPE|BEC|GWE|SVC|CWG|Tk|TOS|T$|XOF|SUR|SUN|NCF|CVEsc|XNF|R|RD$|CUX|ZAP|ZAL|TND|CUP|GUF|U Sh|LNR|AIF|VAL|STE|UGS|Db|MHD|NZP|WST|WSP|L|XMF|TMM|Q|$NZ|SSP|BDS$|N$|MGF|MGA|EGP|BZH|PLZ|BAN|PLX|KM|BZ$|BAD|Zl|YRl|Sf|CSK|KRW|Rbl|YEI|BYL|CSC|KRO|KRH|BYB|SQS|GRN|Pra|Z$|SL Re|GRD|IR\u00a3|YDD|RWF|C|TJS|TJR|EEK|GQP|MDR|HK$|DKr|MDL|GQF|GQE|Rp|AED|KPW|IDN|BWP|MDC|IDJ|KPP|IDG|VT|XID|So. Sh.|ADP|RUR|GPF|DF|ADD|MCG|MCF|ECV|ECS|LIF|RUB|PHP|UZS|Col$|THB|IBP|BUR|COF|BUK|COB|UZC|UAK|QR|UAH|GNS|Y|Mt|CNX|Ur$|GNI|SML|MZE|CNP|PGK|OMS|GF|UYP|RO|XFU|BTR|ZRZ|MAF|MAD|Nu|XFO|UYF|RM|ZRN|AZM|GMP|CF|SLL|GMD|BSP|CMF|MXV|XEF|BSD|MXP|MEX$|PES|GLK|BRZ|PEN|Ch$|Sk|PEI|BRR|FRG|FRF|BRN|CLF|CLE|R$|CLC|BRE|DES|MWP|BRC|BRB|MK|PDR|DEM|TDF|PDN|PDK|Nrs|CKD|MVR|XCF|MVP|EC$|SIT|YUR|AWG|YUO|DDM|YUN|YUM|TCC|YUG|YUF|RON|YUD|leu|SIB|NKr|MUR|GIP|VNS|VNR|KID|SHP|VNN";

  private static final Hashtable currenciesSymbol;
  static
  {
    currenciesSymbol = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesSymbolKeys, "|");
    Enumeration values = new StringTokenizer(currenciesSymbolValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesSymbol.put(key, value);
      }
  }

  private static final String[] shortMonths = {
    "jan",
    "feb",
    "mar",
    "apr",
    "maj",
    "jun",
    "jul",
    "aug",
    "sep",
    "okt",
    "nov",
    "dec",
    null,
  };

  private static final String[] months = {
    "januari",
    "februari",
    "mars",
    "april",
    "maj",
    "juni",
    "juli",
    "augusti",
    "september",
    "oktober",
    "november",
    "december",
    null,
  };

  private static final String[] shortWeekdays = {
    null,
    "s\u00f6",
    "m\u00e5",
    "ti",
    "on",
    "to",
    "fr",
    "l\u00f6",
  };

  private static final String[] weekdays = {
    null,
    "s\u00f6ndag",
    "m\u00e5ndag",
    "tisdag",
    "onsdag",
    "torsdag",
    "fredag",
    "l\u00f6rdag",
  };

  private static final String[] eras = {
    "f.Kr.",
    "e.Kr.",
  };

  private static final String[] ampms = {
    "f.m.",
    "e.m.",
  };

  private static final String[][] zoneStrings =
  {
    { "PST", "Pacific, normaltid", "PDT", "Pacific, sommartid",  "America/Los_Angeles" },
    { "GMT", "Greenwichtid", "GMT", "Greenwichtid",  "Africa/Casablanca" },
    { "EST", "Eastern, normaltid", "EDT", "Eastern, sommartid",  "America/New_York" },
    { "AST", "Alaska, normaltid", "ADT", "Alaska, sommartid",  "America/Anchorage" },
    { "GMT", "Greenwichtid", "GMT", "Greenwichtid",  "Etc/GMT" },
    { "CTT", "Kina, normaltid", "CDT", "Kina, normaltid",  "Asia/Shanghai" },
    { "AST", "Atlantic, normaltid", "ADT", "Atlantic, sommartid",  "America/Halifax" },
    { "CET", "Centraleuropa, normaltid", "CEST", "Centraleuropa, sommartid",  "Europe/Paris" },
    { "MST", "Mountain, normaltid", "MDT", "Mountain, sommartid",  "America/Denver" },
    { "IST", "Israel, normaltid", "IDT", "Israel, sommartid",  "Asia/Jerusalem" },
    { "HST", "Hawaii, normaltid", "HST", "Hawaii, normaltid",  "Pacific/Honolulu" },
    { "CNT", "Newfoundland, normaltid", "CDT", "Newfoundland, sommartid",  "America/St_Johns" },
    { "EST", "Eastern, normaltid", "EST", "Eastern, normaltid",  "America/Indianapolis" },
    { "CST", "Central, normaltid", "CDT", "Central, sommartid",  "America/Chicago" },
    { "EET", "\u00d6steuropa, normaltid", "EEST", "\u00d6steuropa, sommartid",  "Europe/Bucharest" },
    { "JST", "Japan, normaltid", "JST", "Japan, normaltid",  "Asia/Tokyo" },
    { "MST", "Mountain, normaltid", "MST", "Mountain, sommartid",  "America/Phoenix" },
  };

  private static final String territoriesKeys = "TL|TK|TJ|TH|TG|TF|GY|TD|TC|GW|GU|GT|GS|GR|GQ|GP|SZ|SY|GN|GM|GL|SV|ST|GI|GH|SR|GF|SP|GE|SO|GD|SN|SM|GB|SL|GA|SK|SJ|SI|SH|SG|SE|SD|SC|SB|SA|FR|FO|FM|RW|FK|RU|FJ|FI|RO|RE|ET|ES|ER|EH|EG|EE|EC|DZ|QA|DO|PY|DM|PW|DK|DJ|PT|PS|PR|DE|PN|PM|PL|PK|PH|PG|PF|CZ|PE|CY|CX|CV|PA|CU|CR|CO|CN|CM|CL|CK|CI|CH|CG|CF|CD|CC|OM|CA|BZ|BY|BW|BV|BT|BS|BR|NZ|BO|BN|BM|NU|BJ|BI|BH|NR|BG|BF|NP|BE|NO|BD|BB|ZW|NL|BA|NI|NG|NF|AZ|NE|NC|AW|ZM|NA|AU|AT|AS|AR|AQ|MZ|AO|MY|AN|MX|AM|MW|AL|MV|ZA|MU|MT|AI|MS|MR|AG|MQ|AF|MP|AE|MO|AD|MN|MM|ML|MK|YU|YT|MH|MG|MD|MC|MA|YE|LY|LV|LU|LT|LS|LR|LK|LI|LC|LB|LA|KZ|KY|KW|KR|KP|KN|KM|KI|WS|KH|KG|KE|WF|JP|JO|JM|VU|VN|VI|VG|VE|VC|VA|IT|IS|IR|IQ|UZ|IO|UY|IN|IL|US|IE|ID|UM|UG|UA|HU|HT|HR|TZ|HN|HM|TW|TV|HK|TT|TR|TO|TN|TM";

  private static final String territoriesValues = "\u00d6sttimor|Tokelau\u00f6arna|Tadzjikistan|Thailand|Togo|Franska Sydterritorierna|Guyana|Tchad|Turks- och Caicos\u00f6arna|Guinea-Bissau|Guam|Guatemala|Sydgeorgien och S\u00f6dra Sandwich\u00f6arna|Grekland|Ekvatorialguinea|Guadeloupe|Swaziland|Syrien|Guinea|Gambia|Gr\u00f6nland|El Salvador|S\u00e3o Tom\u00e9 och Pr\u00edncipe|Gibraltar|Ghana|Surinam|Franska Guyana|Serbien|Georgien|Somalia|Grenada|Senegal|San Marino|Storbritannien|Sierra Leone|Gabon|Slovakien|Svalbard och Jan Mayen|Slovenien|S:t Helena|Singapore|Sverige|Sudan|Seychellerna|Salomon\u00f6arna|Saudiarabien|Frankrike|F\u00e4r\u00f6arna|Mikronesien|Rwanda|Falklands\u00f6arna|Ryssland|Fiji|Finland|Rum\u00e4nien|R\u00e9union|Etiopien|Spanien|Eritrea|V\u00e4stra Sahara|Egypten|Estland|Ecuador|Algeriet|Qatar|Dominikanska republiken|Paraguay|Dominica|Palau|Danmark|Djibouti|Portugal|Palestinska territoriet|Puerto Rico|Tyskland|Pitcairn|S:t Pierre och Miquelon|Polen|Pakistan|Filippinerna|Papua Nya Guinea|Franska Polynesien|Tjeckien|Peru|Cypern|Jul\u00f6n|Kap Verde|Panama|Kuba|Costa Rica|Colombia|Kina|Kamerun|Chile|Cook\u00f6arna|Elfenbenskusten|Schweiz|Kongo-Brazzaville|Centralafrikanska republiken|Kongo-Kinshasa|Kokos\u00f6arna (Keeling\u00f6arna)|Oman|Kanada|Belize|Vitryssland|Botswana|Bouvet\u00f6n|Bhutan|Bahamas|Brasilien|Nya Zeeland|Bolivia|Brunei|Bermuda|Niue\u00f6n|Benin|Burundi|Bahrain|Nauru|Bulgarien|Burkina Faso|Nepal|Belgien|Norge|Bangladesh|Barbados|Zimbabwe|Nederl\u00e4nderna|Bosnien och Hercegovina|Nicaragua|Nigeria|Norfolk\u00f6n|Azerbajdzjan|Niger|Nya Kaledonien|Aruba|Zambia|Namibia|Australien|\u00d6sterrike|Amerikanska Samoa|Argentina|Antarktis|Mo\u00e7ambique|Angola|Malaysia|Nederl\u00e4ndska Antillerna|Mexiko|Armenien|Malawi|Albanien|Maldiverna|Sydafrika|Mauritius|Malta|Anguilla|Montserrat|Mauretanien|Antigua och Barbuda|Martinique|Afghanistan|Nordmarianerna|F\u00f6renade Arabemiraten|Macao (S.A.R. Kina)|Andorra|Mongoliet|Myanmar|Mali|Makedonien|Jugoslavien|Mayotte|Marshall\u00f6arna|Madagaskar|Moldavien|Monaco|Marocko|Jemen|Libyen|Lettland|Luxemburg|Litauen|Lesotho|Liberia|Sri Lanka|Liechtenstein|S:t Lucia|Libanon|Laos|Kazakstan|Cayman\u00f6arna|Kuwait|Sydkorea|Nordkorea|S:t Kitts och Nevis|Komorerna|Kiribati|Samoa|Kambodja|Kirgizistan|Kenya|Wallis- och Futuna\u00f6arna|Japan|Jordanien|Jamaica|Vanuatu|Vietnam|Amerikanska Jungfru\u00f6arna|Brittiska Jungfru\u00f6arna|Venezuela|S:t Vincent och Grenadinerna|Vatikanstaten|Italien|Island|Iran|Irak|Uzbekistan|Brittiska Indiska ocean\u00f6arna|Uruguay|Indien|Israel|USA|Irland|Indonesien|USAs yttre \u00f6ar|Uganda|Ukraina|Ungern|Haiti|Kroatien|Tanzania|Honduras|Heard- och McDonald\u00f6arna|Taiwan|Tuvalu|Hongkong (S.A.R. Kina)|Trinidad och Tobago|Turkiet|Tonga|Tunisien|Turkmenistan";

  private static final Hashtable territories;
  static
  {
    territories = new Hashtable();
    Enumeration keys = new StringTokenizer(territoriesKeys, "|");
    Enumeration values = new StringTokenizer(territoriesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         territories.put(key, value);
      }
  }

  private static final String languagesKeys = "gwi|akk|eka|xh|sux|sus|mis|loz|tog|pon|min|suk|wo|lol|kut|mic|wa|kum|zap|cus|jbo|doi|vo|oto|vi|rar|ve|rap|raj|ota|nzi|nap|uz|uga|tmh|nai|nah|ur|fat|uk|egy|ug|fan|ssa|mga|bat|nyo|bas|nyn|nym|hmn|ban|osa|bal|ty|bai|tw|srr|tli|tt|ts|bad|tr|to|tn|tl|tk|ti|th|kru|tg|byn|te|kro|csb|ta|tkl|efi|sw|sv|su|krc|st|ss|sr|sq|men|crp|so|afh|sn|sm|sl|grc|sk|grb|si|sh|crh|afa|sg|se|sd|udm|sc|sa|rw|ru|mdr|ro|rn|rm|mdf|tiv|ady|zun|kpe|qu|tig|son|cpp|sog|ada|kos|hit|cpf|cpe|him|kok|hil|got|gor|gon|din|nub|pt|ps|fur|phn|goh|snk|cop|ach|phi|pl|ace|pi|pa|bug|iba|sms|bua|mas|smn|os|map|or|man|smj|smi|mak|om|mai|oj|mag|mad|sma|oc|nso|btk|myv|dgr|ny|myn|nv|kmb|nr|gmh|no|nn|nl|ng|sla|ne|nd|cmc|tet|nb|na|ter|tem|my|lez|mt|peo|ms|mr|fro|mo|frm|mn|jrb|ml|mk|mi|mh|mg|mwr|bra|den|lv|lu|del|lt|lo|ln|li|ewo|lg|lb|la|jpr|vot|sit|ky|kw|kv|ku|sio|ks|kr|awa|ko|kn|km|kl|kk|rom|kj|sid|ki|kg|non|ka|mus|roa|nog|mun|mul|jv|gil|znd|shn|xal|aus|kho|ja|khi|pau|chy|tai|iu|pap|it|sgn|is|kha|chr|pam|pal|chp|io|cho|chn|chm|tyv|bnt|pag|ik|chk|ii|haw|lam|ig|chg|sga|paa|ie|id|lah|day|chb|ia|lad|hz|hai|dar|hy|ath|hu|ht|dak|hr|ho|hi|dyu|he|ast|ha|wen|gv|gu|sem|sel|iro|gn|gl|arw|gez|art|gd|ira|ga|arp|arn|fy|bla|gem|ypk|arc|fr|fo|cel|fj|fi|ff|tvl|ceb|fa|eu|sco|et|es|eo|en|el|tut|niu|tup|ee|tum|mos|dz|nic|lus|fiu|dv|nia|moh|lun|apa|lui|hup|bin|de|lua|bik|was|und|war|da|dum|wal|mno|wak|sat|cy|sas|kbd|cv|cu|mni|cs|sam|cr|sal|dua|co|sai|mnc|sah|kaw|inh|gba|sad|ch|ine|bho|enm|kar|inc|ce|gay|ca|umb|syr|kam|tsi|ang|kac|cau|kab|kaa|bs|car|br|bo|bn|bm|gaa|cai|bi|bh|bg|be|cad|ba|zu|zen|pro|hsb|az|ay|av|as|dsb|ar|ilo|elx|zh|an|pra|am|new|ak|za|af|ae|ab|aa|yo|alg|ale|mkh|yi|dra|ber|nds|bem|bej|tpi";

  private static final String languagesValues = "gwich\u02bbin|akkadiska|ekajuk|xhosa|sumeriska|susu|blandade spr\u00e5k|lozi|tonganska (Nyasa)|ponape|minangkabau|sukuma|wolof|lolo; mongo|kutenai|mic-mac|walloon|kumyk|zapotek|kushitiska (annat)|lojban|dogri|volap\u00fck|otomanguespr\u00e5k|vietnamesiska|rarotongan|venda|rapanui|rajasthani|ottomanturkiska (1500-1928)|nzima|napolitanska|uzbekiska|ugaritiska|tamashek|nordamerikanskt indianspr\u00e5k (annat)|nahuatl; aztekiska|urdu|fanti|ukrainska|fornegyptiska|uiguriska|fang|nilosahariskt (annat)|medeliriska (900-1200)|baltiskt (annat)|nyoro|basa|nyankole|nyamwezi|hmong|balinesiska|osage|baluchi|tahitiska|bamilekiska spr\u00e5k|twi|serer|tlingit|tatariska|tsonga|banda|turkiska|tonganska|tswana|tagalog|turkmeniska|tigrinja|thail\u00e4ndska|kurukh|tadzjikiska|blin|telugu|kru|kasjubiska|tamil|tokelauiska|efik|swahili|svenska|sundanesiska|karachay-balkar|syd\u00adsotho|swati|serbiska|albanska|mende|kreolska och pidgin (annat)|somaliska|afrihili|shona; manshona|samoanska|slovenska|forngrekiska (till 1453)|slovakiska|grebo|singalesiska|serbokroatiska|krimturkiska; krimtatar|afro-asiatiskt (andra)|sango|nord\u00adsamiska|sindhi|udmurtiska|sardiska|sanskrit|rwanda; kinjarwanda|ryska|mandar|rum\u00e4nska|rundi|r\u00e4to\u00adromanska|moksja|tivi|adygeiska|zu\u00f1i|kpelle|quechua|tigr\u00e9|songhai|kreolska och pidgin, portugisiskbaserade (\u00f6vriga)|sogdiska|adangme|kosreanska|hettitiska|kreolska och pidgin, franskbaserade (\u00f6vriga)|kreolska och pidgin, engelskbaserade (\u00f6vriga)|himachali|konkani|hiligaynon|gotiska|gorontalo|gondi|dinka|nubiska spr\u00e5k|portugisiska|pashto; afghanska|friulianska|kananeiska; feniciska|fornh\u00f6gtyska (ca.750-1050)|soninke|koptiska|acholi|filippinskt spr\u00e5k (annat)|polska|achinese|pali|panjabi|buginesiska|iban|skoltsamiska|buriat|massajiska|enaresamiska|ossetiska|austronesiska|oriya|mande|lulesamiska|samiskt spr\u00e5k (annat)|makasar|oromo|maithili|odjibwa; chippewa|magahi|madurese|sydsamiska|provensalska (efter 1500); occitanska|sotho, nord|batak|erjya|dogrib|nyanja|maya|navaho|kinbundu|syd\u00adndebele|medelh\u00f6gtyska (ca.1050-1500)|norska|ny\u00adnorsk|nederl\u00e4ndska|ndonga|slaviskt (annat)|nepalesisika|nord\u00adndebele|chamispr\u00e5k|tetum|norskt bokm\u00e5l|nauru|tereno|temne|burmanska|lezghien|maltesiska|fornpersiska (ca 600-400 f.Kr.)|malajiska|marathi|fornfranska (842- ca 1400)|moldaviska|medelfranska (ca 1400-1600)|mongoliska|judisk arabiska|malayalam|makedonska|maori|marshalliska|malagassiska|marwari|braj|slave|lettiska|luba-katanga|delaware|litauiska|laotiska|lingala|limburgiska|ewondo|luganda|luxemburgiska|latin|judisk farsi|votiska|sinotibetanska spr\u00e5k|kirgisiska|korniska|kome|kurdiska|siouxspr\u00e5k|kashmiriska|kanuri|awadhi|koreanska|kanaresiska; kannada|kambodjanska; khmeriska|gr\u00f6nl\u00e4ndska|kazakstanska|romani|kuanyama|sidamo|kikuyu|kikongo|fornnordiska|georgiska|muskogee|romanskt (annat)|nogai|mundaspr\u00e5k|flera spr\u00e5k|javanesiska|gilbertesiska; kiribati|zand\u00e9|shan|kalmuckiska|australiska spr\u00e5k|khotanesiska|japanska|khoisan (annat)|palau|cheyenne|tai (annat)|inuktitut|papiamento|italienska|teckenspr\u00e5k|isl\u00e4ndska|khasi|cherokesiska|pampanga|pahlavi|chipewyan|ido|choctaw|chinook|mari|tuviniska|bantuspr\u00e5k|pangasinan|inupiaq|chuukesiska|sichuan yi|hawaiiska|lamba|ibo|chagatai|forniriska (till 900)|papuaspr\u00e5k (annat)|interlingue|indonesiska|lahnda|dayak|chibcha|interlingua|ladino|herero|haida|dargwa|armeniska|athapasiska spr\u00e5k|ungerska|haitiska|dakota|kroatiska|hiri motu|hindi|dyula|hebreiska|asturiska|haussa|sorbiska spr\u00e5k|manx gaeliska|gujarati|semitiskt (annat)|selkup|irokesiska|guaran\u00ed|galiciska|arawakiska|geez|artificiellt (annat)|skotsk gaeliska|iranska|irl\u00e4ndsk gaeliska|arapaho|araukanska|frisiska|siksika|germanskt (annat)|yupiska spr\u00e5k|arameiska|franska|f\u00e4r\u00f6iska|keltiskt (annat)|fidjianska|finska|fulani|tuvaluanska|cebuano|farsi|baskiska|skotska|estniska|spanska|esperanto|engelska|grekiska|altaiskt (annat)|niuean|tupispr\u00e5k|ewe|tumbuka|mossi|dzongkha|kordofanspr\u00e5k (annat)|lushai|finskugriskt (annat)|divehi|nias|mohawk|lunda|apachespr\u00e5k|luise\u00f1o|hupa|bini|tyska|luba-lulua|bikol|washo|obest\u00e4mt|waray|danska|medelnederl\u00e4ndska (ca 1050-1350)|walamo|manobospr\u00e5k|wakash|santali|walesiska|sasak|kabardinska|tjuvasjiska|kyrkoslaviska|manipuri|tjeckiska|samariska|cree|salishspr\u00e5k|duala|korsikanska|nordamerikanskt indianskt (annat)|manchuriska|jakutiska|kawi|ingusjiska|gbaya|sandawe|chamorro|indoeuropeiskt (annat)|bhojpuri|medelengelska (1100-1500)|karen|indiskt (annat)|tjetjenska|gayo|katalanska|umbundu|syriska|kamba|tsimshian|fornengelska (ca 450-1100)|kachin|kaukasiskt (annat)|kabyliska|karakalpakiska|bosniska|karibiska|bretonska|tibetanska|bengali|bambara|ga|centralamerikanskt indianskt (annat)|bislama|bihari|bulgariska|vitryska|caddo|basjkiriska|zulu|zenaga|fornprovensalska (till 1500)|h\u00f6gsorbiska|azerbajdzjanska|aymara|avariska|assami|l\u00e5gsorbiska|arabiska|iloko|elamitiska|kinesiska|aragonesiska|prakrit|amhariska|newari|akan|zhuang|afrikaans|avestiska|abkhaziska|afar|yoruba|algonquinspr\u00e5k|aleutiska|mon-khmeriska (annat)|jiddisch|dravidiskt (annat)|berber|l\u00e5gtyska; l\u00e5gsaxiska|bemba|beyja|tok pisin";

  private static final Hashtable languages;
  static
  {
    languages = new Hashtable();
    Enumeration keys = new StringTokenizer(languagesKeys, "|");
    Enumeration values = new StringTokenizer(languagesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         languages.put(key, value);
      }
  }

  private static final String variantsKeys = "REVISED";

  private static final String variantsValues = "Reviderad";

  private static final Hashtable variants;
  static
  {
    variants = new Hashtable();
    Enumeration keys = new StringTokenizer(variantsKeys, "|");
    Enumeration values = new StringTokenizer(variantsValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         variants.put(key, value);
      }
  }

  private static final Object[][] contents =
  {
    { "decimalSeparator", "," },
    { "groupingSeparator", "\u00a0" },
    { "currenciesDisplayName", currenciesDisplayName },
    { "currenciesSymbol", currenciesSymbol },
    { "shortMonths", shortMonths },
    { "months", months },
    { "shortWeekdays", shortWeekdays },
    { "weekdays", weekdays },
    { "eras", eras },
    { "ampms", ampms },
    { "shortDateFormat", "yyyy-MM-dd" },
    { "mediumDateFormat", "yyyy-MM-dd" },
    { "longDateFormat", "'den 'd MMM yyyy" },
    { "fullDateFormat", "'den 'd MMMM yyyy" },
    { "shortTimeFormat", "HH.mm" },
    { "mediumTimeFormat", "HH.mm.ss" },
    { "longTimeFormat", "HH.mm.ss z" },
    { "fullTimeFormat", "'kl. 'HH.mm.ss z" },
    { "zoneStrings", zoneStrings },
    { "territories", territories },
    { "languages", languages },
    { "variants", variants },
  };

  public Object[][] getContents() { return contents; }
}
