/* LocaleInformation_tr.java --
   Copyright (C) 2004  Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


// This file was automatically generated by gnu.localegen from LDML

package gnu.java.locale;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.ListResourceBundle;

public class LocaleInformation_tr extends ListResourceBundle
{
  private static final String currenciesDisplayNameKeys = "JOD|BOV|XAU|FOK|LBP|EUR|VND|TZS|BOP|KHR|XAM|BOL|KHO|ZMP|AUP|XAF|MTP|GHR|ZMK|XAD|GHP|BOB|GHO|MTL|AUD|USS|ITL|USN|GHC|SGD|PAB|LAK|KGS|CHF|ATS|USD|ETD|BND|JMP|ETB|DZG|DZF|DZD|PYG|LYP|JMD|ISK|ESP|BMP|LYD|LYB|BMD|NLG|MRO|IRR|SEK|ERN|KES|CFF|ARS|ARP|ARM|TWD|SDP|GEL|GEK|MQF|FKP|ARA|SDD|IQD|TVD|SCR|LVR|FJP|LVL|CDL|CDG|CDF|FJD|NIO|MOP|NIG|NIC|XTR|FIN|FIM|SBD|LUF|TTO|AOS|AOR|MNT|HUF|BIF|AON|AOK|TTD|SZL|NHF|GBP|SAS|SAR|LTT|INR|PTE|AOA|PTC|LTL|KZT|KZR|VGD|NGP|MMX|NGN|HTG|SYP|PSP|BHD|MMK|ANG|CZK|IMP|BGX|LSL|GAF|BGO|BGN|BGM|CAD|BGL|TRL|KYD|CYP|ILS|GYD|AMD|ILP|MLF|ILL|VEB|ALX|LRD|ALV|HRK|REF|HRD|ALL|JEP|ALK|MKN|VDP|VDN|MKD|VDD|TPP|XPF|BEL|GWP|KWD|GWM|BEF|TPE|BEC|GWE|SVC|CWG|BDT|TOS|TOP|XOF|SUR|SUN|NCF|CVE|XNF|ZAR|DOP|CUX|ZAP|ZAL|TND|CUP|GUF|UGX|LNR|AIF|VAL|STE|UGS|STD|MHD|NZP|WST|WSP|HNL|XMF|TMM|GTQ|NZD|SSP|BBD|NAD|MGF|MGA|EGP|BZH|PLZ|BAN|PLX|BAM|BZD|BAD|PLN|YER|SRG|CSK|KRW|BYR|YEI|BYL|CSC|KRO|KRH|BYB|SQS|GRN|PKR|AFN|ZWD|LKR|GRD|IEP|AFA|YDD|RWF|CRC|TJS|TJR|EEK|GQP|MDR|HKD|DKK|MDL|GQF|GQE|IDR|AED|KPW|IDN|BWP|MDC|IDJ|KPP|IDG|VUV|XID|SOS|ADP|RUR|GPF|DJF|ADD|MCG|MCF|ECV|ECS|LIF|RUB|PHP|UZS|COP|THB|IBP|BUR|COF|BUK|COB|UZC|UAK|QAR|UAH|GNS|CNY|MZM|CNX|UYU|GNI|SML|CNP|MZE|GNF|OMS|PGK|OMR|UYP|XFU|BTR|ZRZ|MAF|MAD|BTN|XFO|UYF|MYR|ZRN|AZM|GMP|KMF|SLL|GMD|XEU|BSP|CMF|MXV|XEF|BSD|MXP|MXN|PES|GLK|BRZ|PEN|CLP|SKK|PEI|BRR|XDR|FRG|FRF|BRN|CLF|CLE|BRL|CLC|BRE|DES|MWP|BRC|BRB|MWK|PDR|DEM|TDF|PDN|PDK|NPR|CKD|JPY|MVR|XCF|MVP|XCD|SIT|YUR|AWG|YUO|DDM|YUN|YUM|TCC|YUG|YUF|RON|YUD|ROL|SIB|NOK|MUR|XBD|GIP|VNS|XBC|VNR|XBB|XBA|KID|SHP|VNN";

  private static final String currenciesDisplayNameValues = "\u00dcrd\u00fcn Dinar\u0131|Bolivya Mvdol|Alt\u0131n|Faroe Adalar\u0131 Kronu|L\u00fcbnan Liras\u0131|Euro|Vietnam Dongu|Tanzanya \u015eilini|Bolivya Pezosu|Kambo\u00e7ya Rieli|Asya Para Birimi|Bolivya Bolivyanosu (1863-1962)|Eski Kambo\u00e7ya Rieli|Zambiya Liras\u0131|Avustralya Liras\u0131|CFA Frang\u0131 BEAC|Malta Liras\u0131|Yeni Gana Sedisi|Zambiya Kva\u00e7as\u0131|Asya Hesap Birimi Dinar\u0131|Gana Liras\u0131|Bolivya Bolivyanosu|Eski Gana Sedisi|Malta Liras\u0131|Avustralya Dolar\u0131|ABD Dolar\u0131 (Ayn\u0131 g\u00fcn)|\u0130talyan Lireti|ABD Dolar\u0131 (Ertesi g\u00fcn)|Gana Sedisi|Singapur Dolar\u0131|Panama Balboas\u0131|Laos Kipi|K\u0131rg\u0131z Somu|\u0130svi\u00e7re Frang\u0131|Avusturya \u015eilini|ABD Dolar\u0131|Etiyopya Dolar\u0131|Brunei Dolar\u0131|Jamaika Liras\u0131|Etiyopya Birri|Cezayir Frang\u0131 (Germinal)|Yeni Cezayir Frang\u0131|Cezayir Dinar\u0131|Paraguay Guaranisi|Libya Liras\u0131|Jamaika Dolar\u0131|\u0130zlanda Kronu|\u0130spanyol Pezetas\u0131|Bermuda Liras\u0131|Libya Dinar\u0131|Libya \u0130ngiliz Askeri Y\u00f6netimi Liras\u0131|Bermuda Dolar\u0131|Hollanda Florini|Moritanya Ouguiyas\u0131|\u0130ran Riyali|\u0130sve\u00e7 Kronu|Eritre Nakfas\u0131|Kenya \u015eilini|Orta Afrika Cumhuriyeti Frang\u0131|Arjantin Pezosu|Arjantin Pezosu (1983-1985)|Arjantin Pezosu Moneda Nacional|Yeni Tayvan Dolar\u0131|Sudan Liras\u0131|G\u00fcrcistan Larisi|G\u00fcrcistan Kupon Larisi|Martinik Frang\u0131|Falkland Adalar\u0131 Liras\u0131|Arjantin Australi|Sudan Dinar\u0131|Irak Dinar\u0131|Tuvalu Dolar\u0131|Sey\u015feller Rupisi|Letonya Rublesi|Fiji Liras\u0131|Letonya Lat\u0131|Kongo Zairesi|Kongo Cumhuriyeti Frang\u0131|Kongo Frang\u0131|Fiji Dolar\u0131|Nikaragua Kordobas\u0131 (Oro)|Makao Patacas\u0131|Alt\u0131n Nikaragua Kordobas\u0131|Nikaragua Kordobas\u0131|COMECON Transfer Edilebilir Rublesi|Fin Markkas\u0131 (1860-1962)|Fin Markkas\u0131|Solomon Adalar\u0131 Dolar\u0131|L\u00fcksemburg Frang\u0131|Eski Trinidad ve Tobago Dolar\u0131|Angola Esk\u00fcdosu|Angola Kvanzas\u0131 Reajustado (1995-1999)|Mo\u011fol Tugriki|Macar Forinti|Burundi Frang\u0131|Yeni Angola Kvanzas\u0131 (1990-2000)|Angola Kvanzas\u0131 (1977-1990)|Trinidad ve Tobago Dolar\u0131|Swaziland Lilangenisi|Yeni Hebridler CFP Frang\u0131|\u0130ngiliz Sterlini|Suudi Arabistan Riyali (Sovereign)|Suudi Arabistan Riyali|Litvanya Talonu|Hindistan Rupisi|Portekiz Esk\u00fcdosu|Angola Kvanzas\u0131|Portekiz Conto|Litvanya Litas\u0131|Kazakistan Tengesi|Kazakistan Rublesi|\u0130ngiliz Virgin Adalar\u0131 Dolar\u0131|Nijerya Liras\u0131|Myanmar Dolar\u0131 FEC|Nijerya Nairas\u0131|Haiti Gurdu|Suriye Liras\u0131|Filistin Liras\u0131|Bahreyn Dinar\u0131|Myanmar Kyat\u0131|Hollanda Antilleri Guldeni|\u00c7ek Cumhuriyeti Korunas\u0131|Man Adas\u0131 Sterlini|Bulgar Levas\u0131 FEC|Lesotho Lotisi|Gabon CFA Frang\u0131|Bulgar Levas\u0131 (1879-1952)|Yeni Bulgar Levas\u0131|Sosyalist Bulgar Levas\u0131|Kanada Dolar\u0131|Bulgar Levas\u0131 (Hard)|T\u00fcrk Liras\u0131|Kayman Adalar\u0131 Dolar\u0131|G\u00fcney K\u0131br\u0131s Liras\u0131|Yeni \u0130srail \u015eekeli|Guyana Dolar\u0131|Ermenistan Dram\u0131|\u0130srail Liras\u0131|Mali Frang\u0131|\u0130srail \u015eekeli|Venezuela Bolivar\u0131|Arnavut Dolar\u0131 FEC|Liberya Dolar\u0131|Arnavutluk Leki Valute|H\u0131rvat Kunas\u0131|Reunion Frang\u0131|H\u0131rvat Dinar\u0131|Arnavutluk Leki|Jersey Sterlini|Arnavutluk Leki (1946-1961)|Makedonya Dinar\u0131 (1992-1993)|Kuzey Vietnam Viet Minh Piastre Dong Viet|Yeni Kuzey Vietnam Dongu|Makedonya Dinar\u0131|Kuzey Vietnam Piastre Dong Viet|Timor Patacas\u0131|CFP Frang\u0131|Bel\u00e7ika Frang\u0131 (finansal)|Gine-Bissau Pezosu|Kuveyt Dinar\u0131|Portekiz Ginesi Mil Reis|Bel\u00e7ika Frang\u0131|Timor Esk\u00fcdosu|Bel\u00e7ika Frang\u0131 (konvertibl)|Portekiz Ginesi Esk\u00fcdosu|El Salvador Kolonu|Kurasao Florini|Banglade\u015f Takas\u0131|Tonga Sterlini|Tonga Pa\u02bbangas\u0131|CFA Frang\u0131 BCEAO|Sovyet Rublesi|Yeni Sovyet Rublesi|Yeni Kaledonya Frang\u0131 (Germinal)|Cape Verde Esk\u00fcdosu|Frans\u0131z Antilleri CFA Frang\u0131|G\u00fcney Afrika Rand\u0131|Dominik Pezosu|K\u00fcba FEC|G\u00fcney Afrika Liras\u0131|G\u00fcney Afrika Rand\u0131 (finansal)|Tunus Dinar\u0131|K\u00fcba Pezosu|Frans\u0131z Guyanas\u0131 Frang\u0131|Uganda \u015eilini|Seylan Rupisi|Afarlar ve \u0130ssalar Frang\u0131|Vatikan \u015eehir Devleti Liras\u0131|Sao Tome ve Principe Esk\u00fcdosu|Uganda \u015eilini (1966-1987)|Sao Tome ve Principe Dobras\u0131|Marshall Adalar\u0131 Dolar\u0131|Yeni Zelanda Liras\u0131|Bat\u0131 Samoa Talas\u0131|Bat\u0131 Samoa Liras\u0131|Honduras Lempiras\u0131|Ana Fransa yeni Frang\u0131|T\u00fcrkmenistan Manat\u0131|Guatemala Ketzali|Yeni Zelanda Dolar\u0131|\u0130sko\u00e7ya Liras\u0131|Barbados Dolar\u0131|Namibya Dolar\u0131|Madagaskar Frang\u0131|Madagaskar Ariary|M\u0131s\u0131r Liras\u0131|\u0130ngiliz Honduras\u0131 Dolar\u0131|Polonya Zlotisi (1950-1995)|Yeni Bosna Hersek Dinar\u0131|Polonya ABD Dolar\u0131 FEC|Konvertibl Bosna Hersek Mark\u0131|Belize Dolar\u0131|Bosna Hersek Dinar\u0131|Polonya Zlotisi|Yemen Riyali|Surinam Guldeni|\u00c7ekoslavak Korunas\u0131 (Hard)|G\u00fcney Kore Wonu|Beyaz Rusya Rublesi|Yemen Riyali (Imadi)|Beyaz Rusya Rublesi (1992-1994)|\u00c7ekoslavak Korunas\u0131|Eski G\u00fcney Kore Wonu|G\u00fcney Kore Hwan\u0131|Yeni Beyaz Rusya Rublesi (1994-1999)|Somaliland \u015eilini|Yeni Yunan Drahmisi|Pakistan Rupisi|Afganistan Afganisi|Zimbabwe Dolar\u0131|Sri Lanka Rupisi|Yunan Drahmisi|\u0130rlanda Liras\u0131|Afganistan Afganisi (1927-2002)|Yemen Dinar\u0131|Ruanda Frang\u0131|Kosta Rika Kolonu|Tacikistan Somonisi|Tacikistan Rublesi|Estonya Krunu|Ekvator Ginesi Pezetas\u0131|Moldova Rublesi (Cupon)|Hong Kong Dolar\u0131|Danimarka Kronu|Moldova Leyi|Ekvator Ginesi Frang\u0131|Ekvator Ginesi Ekuelesi|Endonezya Rupiah\u0131|Birle\u015fik Arap Emirlikleri Dirhemi|Kuzey Kore Wonu|Yeni Endonezya Rupiah\u0131|Botsvana Pulas\u0131|Moldova Leyi (Cupon)|Endonezya Java Rupiah\u0131|Kuzey Kore Halk Cumhuriyeti Wonu|Endonezya Nica Florini|Vanuatu Vatusu|\u0130slam Dinar\u0131|Somali \u015eilini|Andora Pezetas\u0131|Rus Rublesi (1991-1998)|Guadeloupe Frang\u0131|Cibuti Frang\u0131|Andora Dinar\u0131|Fas Frang\u0131 (Germinal)|Yeni Fas Frang\u0131|Ekvator Unidad de Valor Constante (UVC)|Ekvator Sukresi|Liechtenstein Frang\u0131|Rus Rublesi|Filipinler Pezosu|\u00d6zbekistan Sumu|Kolombiya Pezosu|Tayland Baht\u0131|Kuzey \u0130rlanda Liras\u0131|Burma Rupisi|Kongo CFA Frang\u0131|Burma Kyat\u0131|Kolombiya Ka\u011f\u0131t Pezosu|\u00d6zbekistan Sumu (Coupon)|Ukrayna Karbovanetz|Katar Riyali|Ukrayna Grivnas\u0131|Gine Syli|\u00c7in Yuan\u0131 Renminbi|Mozambik Metical\u0131|\u00c7in ABD Dolar\u0131 FEC|Uruguay Pezosu (Uruguayo)|Gine Frang\u0131 (1960-1972)|San Marino Liras\u0131|\u00c7in Jen Min Piao Yuan\u0131|Mozambik Esk\u00fcdosu|Gine Frang\u0131|Umman Riyali (Saidi)|Papua Yeni Gine Kinas\u0131|Umman Riyali|Uruguay Pezosu (1975-1993)|Frans\u0131z UIC-Frang\u0131|Bhutan Rupisi|Zaire Zairesi|Fas Frang\u0131|Fas Dirhemi|Bhutan Ngultrumu|Frans\u0131z Alt\u0131n Frang\u0131|Uruguay Pezosu (Fuerte)|Malezya Ringiti|Yeni Zaire Zairesi|Azerbaycan Manat\u0131|Gambiya Liras\u0131|Komorlar Frang\u0131|Sierra Leone Leonesi|Gambiya Dalasisi|Avrupa Para Birimi|Bahama Liras\u0131|Kamerun CFA Frang\u0131|Meksika Unidad de Inversion (UDI)|CFA Frank BCEAEC|Bahama Dolar\u0131|G\u00fcm\u00fc\u015f Meksika Pezosu (1861-1992)|Meksika Pezosu|Peru Solu|Gr\u00f6nland Kronu|Brezilya Kruzeirosu (1942-1967)|Yeni Peru Solu|\u015eili Pezosu|Slovak Korunas\u0131|Peru \u0130nti|Brezilya Kruzeirosu|\u00d6zel \u00c7ekme Hakk\u0131 (SDR)|Frans\u0131z Frang\u0131 (Germinal/Franc Poincare)|Frans\u0131z Frang\u0131|Yeni Brezilya Kruzadosu|\u015eili Unidades de Fomento|\u015eili Esk\u00fcdosu|Brezilya Reali|\u015eili Condor|Brezilya Kruzeirosu (1990-1993)|Alman Sperrmark|Malavi Liras\u0131|Brezilya Kruzadosu|Yeni Brezilya Kruzeirosu (1967-1986)|Malavi Kva\u00e7as\u0131|Transdniestria Rublesi|Alman Mark\u0131|\u00c7ad CFA Frang\u0131|Yeni Transdniestria Rublesi|Transdniestria Rublesi (Kupon)|Nepal Rupisi|Cook Adalar\u0131 Dolar\u0131|Japon Yeni|Maldiv Adalar\u0131 Rufiyaa|CFA Yeni Frank|Maldiv Adalar\u0131 Rupisi|Do\u011fu Karayip Dolar\u0131|Slovenya Tolar\u0131|Yugoslav Dinar\u0131 (Reformed)|Aruba Florini|Yugoslav Ekim Dinar\u0131|Do\u011fu Alman Mark\u0131|Konvertibl Yugoslav Dinar\u0131|Yeni Yugoslav Dinar\u0131|Turks ve Caicos Adalar\u0131 Crownu|Yugoslav 1994 Dinar\u0131|Yugoslav Federasyonu Dinar\u0131|Yeni Romen Leyi|Yugoslav Dinar\u0131 (Hard)|Romen Leyi|Slovenya Tolar\u0131 (Bons)|Norve\u00e7 Kronu|Mauritius Rupisi|Avrupa Hesap Birimi (XBD)|Cebelitar\u0131k Liras\u0131|Vietnam Ulusal Dongu|Avrupa Hesap Birimi (XBC)|Vietnam Cumhuriyeti Dongu|Avrupa Para Birimi|Birle\u015fik Avrupa Birimi|Kiribati Dolar\u0131|Saint Helena Liras\u0131|Yeni Vietnam Dongu";

  private static final Hashtable currenciesDisplayName;
  static
  {
    currenciesDisplayName = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesDisplayNameKeys, "|");
    Enumeration values = new StringTokenizer(currenciesDisplayNameValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesDisplayName.put(key, value);
      }
  }

  private static final String currenciesSymbolKeys = "JOD|BOV|XAU|FOK|LBP|VND|TZS|BOP|KHR|XAM|BOL|KHO|ZMP|AUP|XAF|MTP|GHR|ZMK|XAD|GHP|BOB|GHO|MTL|AUD|USS|USN|GHC|SGD|PAB|LAK|KGS|CHF|ATS|USD|ETD|BND|JMP|ETB|DZG|DZF|DZD|PYG|LYP|JMD|ISK|ESP|BMP|LYD|LYB|BMD|NLG|MRO|IRR|SEK|ERN|KES|CFF|ARS|ARP|ARM|TWD|SDP|GEL|GEK|MQF|FKP|ARA|SDD|IQD|TVD|SCR|LVR|FJP|LVL|CDL|CDG|CDF|FJD|NIO|MOP|NIG|NIC|XTR|FIN|FIM|SBD|LUF|TTO|AOS|AOR|MNT|HUF|BIF|AON|AOK|TTD|SZL|NHF|SAS|SAR|LTT|INR|PTE|AOA|PTC|LTL|KZT|KZR|VGD|NGP|MMX|NGN|HTG|SYP|PSP|BHD|MMK|ANG|CZK|IMP|BGX|LSL|GAF|BGO|BGN|BGM|CAD|BGL|TRL|KYD|CYP|ILS|GYD|AMD|ILP|MLF|ILL|VEB|ALX|LRD|ALV|HRK|REF|HRD|ALL|JEP|ALK|MKN|VDP|VDN|MKD|VDD|TPP|XPF|BEL|GWP|KWD|GWM|BEF|TPE|BEC|GWE|SVC|CWG|BDT|TOS|TOP|XOF|SUR|SUN|NCF|CVE|XNF|ZAR|DOP|CUX|ZAP|ZAL|TND|CUP|GUF|UGX|LNR|AIF|VAL|STE|UGS|STD|MHD|NZP|WST|WSP|HNL|XMF|TMM|GTQ|NZD|SSP|BBD|NAD|MGF|MGA|EGP|BZH|PLZ|BAN|PLX|BAM|BZD|BAD|PLN|YER|SRG|CSK|KRW|BYR|YEI|BYL|CSC|KRO|KRH|BYB|SQS|GRN|PKR|AFN|ZWD|LKR|GRD|IEP|AFA|YDD|RWF|CRC|TJS|TJR|EEK|GQP|MDR|HKD|DKK|MDL|GQF|GQE|IDR|AED|KPW|IDN|BWP|MDC|IDJ|KPP|IDG|VUV|XID|SOS|ADP|RUR|GPF|DJF|ADD|MCG|MCF|ECV|ECS|LIF|RUB|PHP|UZS|COP|THB|IBP|BUR|COF|BUK|COB|UZC|UAK|QAR|UAH|GNS|CNY|MZM|CNX|UYU|GNI|SML|CNP|MZE|GNF|OMS|PGK|OMR|UYP|XFU|BTR|ZRZ|MAF|MAD|BTN|XFO|UYF|MYR|ZRN|AZM|GMP|KMF|SLL|GMD|XEU|BSP|CMF|MXV|XEF|BSD|MXP|MXN|PES|GLK|BRZ|PEN|CLP|SKK|PEI|BRR|XDR|FRG|FRF|BRN|CLF|CLE|BRL|CLC|BRE|DES|MWP|BRC|BRB|MWK|PDR|DEM|TDF|PDN|PDK|NPR|CKD|MVR|XCF|MVP|XCD|SIT|YUR|AWG|YUO|DDM|YUN|YUM|TCC|YUG|YUF|RON|YUD|ROL|SIB|NOK|MUR|XBD|GIP|VNS|XBC|VNR|XBB|XBA|KID|SHP|VNN";

  private static final String currenciesSymbolValues = "JD|BOV|XAU|FOK|LL|VND|T Sh|BOP|CR|XAM|BOL|KHO|ZMP|AUP|XAF|MTP|GHR|ZMK|XAD|GHP|Bs|GHO|Lm|$A|USS|USN|GHC|S$|PAB|LAK|som|SwF|ATS|US$|ETD|BND|JMP|Br|DZG|DZF|DA|PYG|LYP|J$|ISK|ESP|BMP|LD|LYB|Ber$|NLG|UM|RI|SKr|ERN|K Sh|CFF|Arg$|ARP|ARM|NT$|SDP|lari|GEK|MQF|FKP|ARA|SDD|ID|TVD|SR|LVR|FJP|LVL|CDL|CDG|CDF|F$|NIO|MOP|NIG|NIC|XTR|FIN|FIM|SI$|LUF|TTO|AOS|AOR|Tug|Ft|Fbu|AON|AOK|TT$|E|NHF|SAS|SRl|LTT|INR|PTE|AOA|PTC|LTL|T|KZR|VGD|NGP|MMX|NGN|HTG|LS|PSP|BD|MMK|NA f.|CZK|IMP|BGX|M|GAF|BGO|BGN|BGM|Can$|lev|TL|KYD|\u00a3C|ILS|G$|dram|ILP|MLF|ILL|Be|ALX|LRD|ALV|HRK|REF|HRD|lek|JEP|ALK|MKN|VDP|VDN|MDen|VDD|TPP|CFPF|BEL|GWP|KD|GWM|BF|TPE|BEC|GWE|SVC|CWG|Tk|TOS|T$|XOF|SUR|SUN|NCF|CVEsc|XNF|R|RD$|CUX|ZAP|ZAL|TND|CUP|GUF|U Sh|LNR|AIF|VAL|STE|UGS|Db|MHD|NZP|WST|WSP|L|XMF|TMM|Q|$NZ|SSP|BDS$|N$|MGF|MGA|EGP|BZH|PLZ|BAN|PLX|KM|BZ$|BAD|Zl|YRl|Sf|CSK|KRW|Rbl|YEI|BYL|CSC|KRO|KRH|BYB|SQS|GRN|Pra|Af|Z$|SL Re|GRD|IR\u00a3|AFA|YDD|RWF|C|TJS|TJR|EEK|GQP|MDR|HK$|DKr|MDL|GQF|GQE|Rp|AED|KPW|IDN|BWP|MDC|IDJ|KPP|IDG|VT|XID|So. Sh.|ADP|RUR|GPF|DF|ADD|MCG|MCF|ECV|ECS|LIF|RUB|PHP|UZS|Col$|THB|IBP|BUR|COF|BUK|COB|UZC|UAK|QR|UAH|GNS|Y|Mt|CNX|Ur$|GNI|SML|CNP|MZE|GF|OMS|PGK|RO|UYP|XFU|BTR|ZRZ|MAF|MAD|Nu|XFO|UYF|RM|ZRN|AZM|GMP|CF|SLL|GMD|XEU|BSP|CMF|MXV|XEF|BSD|MXP|MEX$|PES|GLK|BRZ|PEN|Ch$|Sk|PEI|BRR|XDR|FRG|FRF|BRN|CLF|CLE|R$|CLC|BRE|DES|MWP|BRC|BRB|MK|PDR|DEM|TDF|PDN|PDK|Nrs|CKD|MVR|XCF|MVP|EC$|SIT|YUR|AWG|YUO|DDM|YUN|YUM|TCC|YUG|YUF|RON|YUD|leu|SIB|NKr|MUR|XBD|GIP|VNS|XBC|VNR|XBB|XBA|KID|SHP|VNN";

  private static final Hashtable currenciesSymbol;
  static
  {
    currenciesSymbol = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesSymbolKeys, "|");
    Enumeration values = new StringTokenizer(currenciesSymbolValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesSymbol.put(key, value);
      }
  }

  private static final String[] shortMonths = {
    "Oca",
    "\u015eub",
    "Mar",
    "Nis",
    "May",
    "Haz",
    "Tem",
    "A\u011fu",
    "Eyl",
    "Eki",
    "Kas",
    "Ara",
    null,
  };

  private static final String[] months = {
    "Ocak",
    "\u015eubat",
    "Mart",
    "Nisan",
    "May\u0131s",
    "Haziran",
    "Temmuz",
    "A\u011fustos",
    "Eyl\u00fcl",
    "Ekim",
    "Kas\u0131m",
    "Aral\u0131k",
    null,
  };

  private static final String[] shortWeekdays = {
    null,
    "Paz",
    "Pzt",
    "Sal",
    "\u00c7ar",
    "Per",
    "Cum",
    "Cmt",
  };

  private static final String[] weekdays = {
    null,
    "Pazar",
    "Pazartesi",
    "Sal\u0131",
    "\u00c7ar\u015famba",
    "Per\u015fembe",
    "Cuma",
    "Cumartesi",
  };

  private static final String[] eras = {
    "M\u00d6",
    "MS",
  };

  private static final String territoriesKeys = "TL|TK|TJ|TH|TG|TF|GY|TD|TC|GW|GU|GT|GS|GR|GQ|GP|SZ|SY|GN|GM|GL|SV|ST|GI|GH|SR|GF|SP|GE|SO|GD|SN|SM|GB|SL|GA|SK|SJ|SI|SH|SG|SE|SD|SC|SB|SA|FR|FO|FM|RW|FK|RU|FJ|FI|RO|RE|ET|ES|ER|EH|EG|EE|EC|DZ|QA|DO|PY|DM|PW|DK|DJ|PT|PS|PR|DE|PN|PM|PL|PK|PH|PG|PF|CZ|PE|CY|CX|CV|PA|CU|CR|CO|CN|CM|CL|CK|CI|CH|CG|CF|CD|CC|OM|CA|BZ|BY|BW|BV|BT|BS|BR|NZ|BO|BN|BM|NU|BJ|BI|BH|NR|BG|BF|NP|BE|NO|BD|BB|ZW|NL|BA|NI|NG|NF|AZ|NE|NC|AW|ZM|NA|AU|AT|AS|AR|AQ|MZ|AO|MY|AN|MX|AM|MW|AL|MV|ZA|MU|MT|AI|MS|MR|AG|MQ|AF|MP|AE|MO|AD|MN|MM|ML|MK|YU|YT|MH|MG|MD|MC|MA|YE|LY|LV|LU|LT|LS|LR|LK|LI|LC|LB|LA|KZ|KY|KW|KR|KP|KN|KM|KI|WS|KH|KG|KE|WF|JP|JO|JM|VU|VN|VI|VG|VE|VC|VA|IT|IS|IR|IQ|UZ|IO|UY|IN|IL|US|IE|ID|UM|UG|UA|HU|HT|HR|TZ|HN|HM|TW|TV|HK|TT|TR|TO|TN|TM";

  private static final String territoriesValues = "Do\u011fu Timor|Tokelau|Tacikistan|Tayland|Togo|Frans\u0131z G\u00fcney B\u00f6lgeleri|Guyana|\u00c7ad|Turks ve Caicos Adalar\u0131|Gine-Bissau|Guam|Guatemala|G\u00fcney Georgia ve G\u00fcney Sandwich Adalar\u0131|Yunanistan|Ekvator Ginesi|Guadeloupe|Svaziland|Suriye|Gine|Gambia|Gr\u00f6nland|El Salvador|Sao Tome ve Principe|Cebelitar\u0131k|Gana|Surinam|Frans\u0131z Guyanas\u0131|S\u0131rbistan|G\u00fcrcistan|Somali|Granada|Senegal|San Marino|Birle\u015fik Krall\u0131k|Sierra Leone|Gabon|Slovakya|Svalbard ve Jan Mayen|Slovenya|Saint Helena|Singapur|\u0130sve\u00e7|Sudan|Sey\u015feller|Solomon Adalar\u0131|Suudi Arabistan|Fransa|Faroe Adalar\u0131|Mikronezya Federal Eyaletleri|Ruanda|Falkland Adalar\u0131 (Malvinalar)|Rusya Federasyonu|Fiji|Finlandiya|Romanya|Reunion|Etiyopya|\u0130spanya|Eritre|Bat\u0131 Sahara|M\u0131s\u0131r|Estonya|Ekvator|Cezayir|Katar|Dominik Cumhuriyeti|Paraguay|Dominik|Palau|Danimarka|Cibuti|Portekiz|Filistin B\u00f6lgesi|Porto Riko|Almanya|Pitcairn|Saint Pierre ve Miquelon|Polonya|Pakistan|Filipinler|Papua Yeni Gine|Frans\u0131z Polinezyas\u0131|\u00c7ek Cumhuriyeti|Peru|K\u0131br\u0131s|Christmas Adas\u0131|Cape Verde|Panama|K\u00fcba|Kosta Rika|Kolombiya|\u00c7in|Kamerun|\u015eili|Cook Adalar\u0131|Fildi\u015fi Sahilleri|\u0130svi\u00e7re|Kongo|Orta Afrika Cumhuriyeti|Kongo Demokratik Cumhuriyeti|Cocos (Keeling) Adalar\u0131|Umman|Kanada|Belize|Beyaz Rusya|Botsvana|Bouvet Adas\u0131|Bhutan|Bahamalar|Brezilya|Yeni Zelanda|Bolivya|Brunei|Bermuda|Niue Adalar\u0131|Benin|Burundi|Bahreyn|Nauru Adas\u0131|Bulgaristan|Burkina Faso|Nepal|Bel\u00e7ika|Norve\u00e7|Banglade\u015f|Barbados|Zimbabwe|Hollanda|Bosna Hersek|Nikaragua|Nijerya|Norfolk Adas\u0131|Azerbaycan|Nijer|Yeni Kaledonya|Aruba|Zambiya|Namibya|Avustralya|Avusturya|Amerikan Samoas\u0131|Arjantin|Antarktika|Mozambik|Angola|Malezya|Hollanda Antilleri|Meksika|Ermenistan|Malavi|Arnavutluk|Maldivler|G\u00fcney Afrika|Mauritius|Malta|Anguilla|Montserrat|Moritanya|Antigua ve Barbuda|Martinik|Afganistan|Kuzey Mariana Adalar\u0131|Birle\u015fik Arap Emirlikleri|Makao S.A.R. \u00c7in|Andora|Mo\u011folistan|Myanmar|Mali|Makedonya Cumhuriyeti|Yugoslavya|Mayotte|Marshall Adalar\u0131|Madagaskar|Moldovya Cumhuriyeti|Monako|Fas|Yemen|Libya|Letonya|L\u00fcksemburg|Litvanya|Lesotho|Liberya|Sri Lanka|Liechtenstein|Saint Lucia|L\u00fcbnan|Laos|Kazakistan|Kayman Adalar\u0131|Kuveyt|G\u00fcney Kore|Kuzey Kore|Saint Kittler ve Neviler|Komorlar|Kiribati|Samoa|Kambo\u00e7ya|K\u0131rg\u0131zistan|Kenya|Wallis ve Futuna|Japonya|\u00dcrd\u00fcn|Jamaika|Vanuatu|Vietnam|ABD Virgin Adalar\u0131|\u0130ngiliz Virgin Adalar\u0131|Venezuela|Saint Vincent ve Grenadinler|Kutsal Devlet (Vatikan \u015eehir Devleti)|\u0130talya|\u0130zlanda|\u0130ran|Irak|\u00d6zbekistan|Hint Okyanusu \u0130ngiliz B\u00f6lgesi|Uruguay|Hindistan|\u0130srail|Amerika Birle\u015fik Devletleri|\u0130rlanda|Endonezya|Amerika Birle\u015fik Devletleri K\u00fc\u00e7\u00fck D\u0131\u015f Adalar\u0131|Uganda|Ukrayna|Macaristan|Haiti|H\u0131rvatistan|Tanzanya|Honduras|Heard Adas\u0131 ve McDonald Adalar\u0131|Tayvan|Tuvalu|Hong Kong SAR - \u00c7in|Trinidad ve Tobago|T\u00fcrkiye|Tonga|Tunus|T\u00fcrkmenistan";

  private static final Hashtable territories;
  static
  {
    territories = new Hashtable();
    Enumeration keys = new StringTokenizer(territoriesKeys, "|");
    Enumeration values = new StringTokenizer(territoriesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         territories.put(key, value);
      }
  }

  private static final String languagesKeys = "es|ku|eo|ks|en|el|qu|ko|kn|km|kl|kk|wo|ka|dz|jv|pt|ps|de|pl|da|vo|ja|vi|cy|pa|cs|iu|it|co|is|uz|or|ik|ur|om|ca|ie|id|uk|ia|oc|ug|hy|br|hu|bo|bn|hr|bi|tw|bh|bg|tt|no|be|ts|hi|tr|nl|zu|ba|to|he|tn|tl|tk|ha|ne|az|ti|ay|th|tg|na|te|zh|ar|ta|gu|my|am|za|mt|ms|gn|sw|mr|sv|gl|su|af|st|mo|ss|mn|sr|sq|ml|ab|mk|aa|so|sn|mi|gd|sm|sl|mg|sk|ga|yo|si|sh|sg|yi|sd|fy|sa|fr|lv|lt|fo|rw|ru|lo|fj|ln|fi|ro|rn|rm|fa|la|xh|eu|ky|et";

  private static final String languagesValues = "\u0130spanyolca|K\u00fcrt\u00e7e|Esperanto|Ke\u015fmirce|\u0130ngilizce|Yunanca|Quechua|Korece|Kannada|Kambo\u00e7ya Dili|Gr\u00f6nland Dili|Kazak Dili|Wolof|G\u00fcrc\u00fcce|Bhutan Dili|Java Dili|Portekizce|Pe\u015ftun Dili|Almanca|Polonya Dili|Danca|Volapuk|Japonca|Vietnam Dili|Gal Dili|Pencap Dili|\u00c7ek\u00e7e|Inuktitut|\u0130talyanca|Korsika Dili|\u0130zlandaca|\u00d6zbek\u00e7e|Oriya|Inupiak|Urduca|Oromo (Afan)|Katalan Dili|Interlingue|Endonezya Dili|Ukraynaca|Interlingua|Occitan|Uygurca|Ermenice|Breton Dili|Macarca|Tibet\u00e7e|Bengal Dili|H\u0131rvat\u00e7a|Bislama|Twi|Bihari|Bulgarca|Tatarca|Norve\u00e7\u00e7e|Beyaz Rus\u00e7a|Tsonga|Hint Dili|T\u00fcrk\u00e7e|Hollanda Dili|Zulu|Ba\u015fk\u0131rt Dili|Tonga|\u0130branice|Setswana|Tagalog|T\u00fcrkmence|Hausa|Nepal Dili|Azerice|Tigrinya|Aymara|Tay Dili|Tacik Dili|Nauru|Telugu|\u00c7ince|Arap\u00e7a|Tamil|Gujarati|Birmanya Dili|Amharik|Zhuang|Malta Dili|Malay|Guarani|Swahili|Marathi|\u0130sve\u00e7\u00e7e|Gali\u00e7ya Dili|Sudan Dili|Afrikaan Dili|Sesotho|Moldavya Dili|Siswati|Mo\u011fol Dili|S\u0131rp\u00e7a|Arnavut\u00e7a|Malayalam|Abazca|Makedonca|Afar|Somali Dili|Shona|Maori|\u0130sko\u00e7 Gal Dili|Samoa Dili|Slovence|Malaga Dili|Slovak\u00e7a|\u0130rlanda Dili|Yoruba|Sinhal Dili|S\u0131rp-H\u0131rvat Dili|Sangho|Yiddi\u015f|Sindhi|Frizye Dili|Sanskrit\u00e7e|Frans\u0131zca|Letonya Dili|Litvanya Dili|Faroe Dili|Kinyarwanda|Rus\u00e7a|Laos Dili|Fiji Dili|Lingala|Fince|Romence|Kirundi|Rhaeto-Roman Dili|Fars\u00e7a|Latince|Xhosa|Bask Dili|K\u0131rg\u0131zca|Estonya Dili";

  private static final Hashtable languages;
  static
  {
    languages = new Hashtable();
    Enumeration keys = new StringTokenizer(languagesKeys, "|");
    Enumeration values = new StringTokenizer(languagesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         languages.put(key, value);
      }
  }

  private static final Object[][] contents =
  {
    { "decimalSeparator", "," },
    { "groupingSeparator", "." },
    { "currenciesDisplayName", currenciesDisplayName },
    { "currenciesSymbol", currenciesSymbol },
    { "shortMonths", shortMonths },
    { "months", months },
    { "shortWeekdays", shortWeekdays },
    { "weekdays", weekdays },
    { "eras", eras },
    { "shortDateFormat", "dd.MM.yyyy" },
    { "mediumDateFormat", "dd.MMM.yyyy" },
    { "longDateFormat", "dd MMMM yyyy EEEE" },
    { "fullDateFormat", "dd MMMM yyyy EEEE" },
    { "territories", territories },
    { "languages", languages },
  };

  public Object[][] getContents() { return contents; }
}
