


TRAMPOLINE(3)                                       TRAMPOLINE(3)


NNAAMMEE
       trampoline - closures as first-class C functions

SSYYNNOOPPSSIISS
       ##iinncclluuddee <<ttrraammppoolliinnee..hh>>

       ffuunnccttiioonn == aalllloocc__ttrraammppoolliinnee((aaddddrreessss,, vvaarriiaabbllee,, ddaattaa));;

       ffrreeee__ttrraammppoolliinnee((ffuunnccttiioonn));;

       iiss__ttrraammppoolliinnee((ffuunnccttiioonn))
       ttrraammppoolliinnee__aaddddrreessss((ffuunnccttiioonn))
       ttrraammppoolliinnee__vvaarriiaabbllee((ffuunnccttiioonn))
       ttrraammppoolliinnee__ddaattaa((ffuunnccttiioonn))

DDEESSCCRRIIPPTTIIOONN
       These  functions implement _c_l_o_s_u_r_e_s as first-class C func-
       tions.  A closure consists of a regular C function  and  a
       piece of data which gets passed to the C function when the
       closure is called.

       Closures as _f_i_r_s_t_-_c_l_a_s_s _C _f_u_n_c_t_i_o_n_s means  that  they  fit
       into a function pointer and can be called exactly like any
       other C function.   _f_u_n_c_t_i_o_n  ==  aalllloocc__ttrraammppoolliinnee((_a_d_d_r_e_s_s,,
       _v_a_r_i_a_b_l_e,,  _d_a_t_a))  allocates  a closure. When _f_u_n_c_t_i_o_n gets
       called, it stores _d_a_t_a in the variable _v_a_r_i_a_b_l_e and  calls
       the  C  function  at  _a_d_d_r_e_s_s.  The function at _a_d_d_r_e_s_s is
       responsible for fetching _d_a_t_a out of _v_a_r_i_a_b_l_e immediately,
       before execution of any other function call.

       This  is  much like ggcccc's local functions, except that the
       GNU C local functions have dynamic extent (i.e. are  deal-
       located when the creating function returns), while _t_r_a_m_p_o_-
       _l_i_n_e provides functions with indefinite  extent:  _f_u_n_c_t_i_o_n
       is  only  deallocated  when  ffrreeee__ttrraammppoolliinnee((_f_u_n_c_t_i_o_n))  is
       called.

       iiss__ttrraammppoolliinnee((_f_u_n_c_t_i_o_n))  checks  whether  the  C  function
       _f_u_n_c_t_i_o_n  was  produced by a call to _a_l_l_o_c___t_r_a_m_p_o_l_i_n_e.  If
       this returns true, the arguments given to _a_l_l_o_c___t_r_a_m_p_o_l_i_n_e
       can be retrieved:

           ttrraammppoolliinnee__aaddddrreessss((_f_u_n_c_t_i_o_n)) returns _a_d_d_r_e_s_s,

           ttrraammppoolliinnee__vvaarriiaabbllee((_f_u_n_c_t_i_o_n)) returns _v_a_r_i_a_b_l_e,

           ttrraammppoolliinnee__ddaattaa((_f_u_n_c_t_i_o_n)) returns _d_a_t_a.


SSEEEE AALLSSOO
       ggcccc(1), vvaarraarrggss(3), ccaallllbbaacckk(3)






                         25 October 1997                        1





TRAMPOLINE(3)                                       TRAMPOLINE(3)


BBUUGGSS
       Passing  the  data  through a global variable is not reen-
       trant. Don't call trampoline functions from within  signal
       handlers. This is fixed in the ccaallllbbaacckk(3) package.


PPOORRTTIINNGG
       The way ggcccc builds local functions is described in the gcc
       source, file gcc-2.6.3/config/_c_p_u/_c_p_u.h.


AAUUTTHHOORR
       Bruno Haible <bruno@clisp.org>


AACCKKNNOOWWLLEEDDGGEEMMEENNTTSS
       Many ideas were cribbed from the gcc source.








































                         25 October 1997                        2


