/* AMD pp. 290 - 295
 * Mixed model, unbalanced
 */

#include <dap.h>

void main()
{
  infile("amd290.dat", " ")
    {
      char machine[2], person[2];
      double productivity;
      input("machine person productivity");
      outset("amd290", "machine person  productivity");
      skip(1);
      while (step()) 
        output();
    }
  
  sort("amd290", "machine person", "");
  
  means("amd290.srt", "productivity", "N MEAN VAR", "machine person");
  
  effects("amd290.srt.mns", "productivity machine person",
                          "machine person machine*person", "");
  
  ftest("amd290.srt.mns.con", "productivity machine person", "machine*person", "", "");
  
  ftest("amd290.srt.mns.con", "productivity machine person", "machine", "machine*person", "");
  lsmeans("amd290.srt.mns.tst", "TUKEY", 0.05,
                  "productivity machine person", "machine", "", "8.4");
  
  ftest("amd290.srt.mns.con", "productivity machine person", "person", "machine*person", "");
  lsmeans("amd290.srt.mns.tst", "TUKEY", 0.05,
                  "productivity machine person", "person", "", "8.4");
}
