/*
 * Electric(tm) VLSI Design System
 *
 * File: usredtec.h
 * User interface technology editor: header file
 * Written by: Steven M. Rubin, Static Free Software
 *
 * Copyright (c) 2000 Static Free Software.
 *
 * Electric(tm) is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Electric(tm) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Electric(tm); see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, Mass 02111-1307, USA.
 *
 * Static Free Software
 * 4119 Alpine Road
 * Portola Valley, California 94028
 * info@staticfreesoft.com
 */

#if defined(__cplusplus) && !defined(ALLCPLUSPLUS)
extern "C"
{
#endif

/* the meaning of "EDTEC_option" on nodes */
#define LAYERCOLOR      1					/* color (layer facet) */
#define LAYERSTYLE      2					/* style (layer facet) */
#define LAYERCIF        3					/* CIF name (layer facet) */
#define LAYERFUNCTION   4					/* function (layer facet) */
#define LAYERLETTERS    5					/* letters (layer facet) */
#define LAYERPATTERN    6					/* pattern (layer facet) */
#define LAYERPATCH      8					/* patch of layer (node/arc facet) */
#define ARCFUNCTION     9					/* function (arc facet) */
#define NODEFUNCTION   10					/* function (node facet) */
#define ARCFIXANG      11					/* fixed-angle (arc facet) */
#define ARCWIPESPINS   12					/* wipes pins (arc facet) */
#define ARCNOEXTEND    13					/* end extension (arc facet) */
#define TECHLAMBDA     14					/* lambda (info facet) */
#define TECHDESCRIPT   15					/* description (info facet) */
#define NODESERPENTINE 16					/* serpentine MOS trans (node facet) */
#define LAYERDRCMINWID 17					/* DRC minimum width (layer facet, OBSOLETE) */
#define PORTOBJ        18					/* port object (node facet) */
#define HIGHLIGHTOBJ   19					/* highlight object (node/arc facet) */
#define LAYERGDS       20					/* Calma GDS-II layer (layer facet) */
#define NODESQUARE     21					/* square node (node facet) */
#define NODEWIPES      22					/* pin node can disappear (node facet) */
#define ARCINC         23					/* increment for arc angles (arc facet) */
#define NODELOCKABLE   25					/* lockable primitive (node facet) */
#define CENTEROBJ      26					/* grab point object (node facet) */
#define LAYERSPIRES    27					/* SPICE resistance (layer facet) */
#define LAYERSPICAP    28					/* SPICE capacitance (layer facet) */
#define LAYERSPIECAP   29					/* SPICE edge capacitance (layer facet) */
#define LAYERDXF       30					/* DXF layer (layer facet) */
#define LAYER3DHEIGHT  31					/* 3D height (layer facet) */
#define LAYER3DTHICK   32					/* 3D thickness (layer facet) */

/* the strings that appear in the technology editor */
#define TECEDNODETEXTCOLOR      "Color: "
#define TECEDNODETEXTSTYLE      "Style: "
#define TECEDNODETEXTFUNCTION   "Function: "
#define TECEDNODETEXTLETTERS    "Layer letters: "
#define TECEDNODETEXTGDS        "GDS-II Layer: "
#define TECEDNODETEXTGDSOLD     "Calma GDS-II Layer: "
#define TECEDNODETEXTCIF        "CIF Layer: "
#define TECEDNODETEXTDXF        "DXF Layer(s): "
#define TECEDNODETEXTSPICERES   "SPICE Resistance: "
#define TECEDNODETEXTSPICECAP   "SPICE Capacitance: "
#define TECEDNODETEXTSPICEECAP  "SPICE Edge Capacitance: "
#define TECEDNODETEXTDRCMINWID  "DRC Minimum Width: "
#define TECEDNODETEXT3DHEIGHT   "3D Height: "
#define TECEDNODETEXT3DTHICK    "3D Thickness: "

typedef struct Ilist
{
	char  *name;
	char  *constant;
	INTBIG value;
} LIST;


#define NOSAMPLE ((SAMPLE *)-1)

typedef struct Isample
{
	NODEINST        *node;					/* true node used for sample */
	NODEPROTO       *layer;					/* type of node used for sample */
	INTBIG           xpos, ypos;			/* center of sample */
	struct Isample  *assoc;					/* associated sample in first example */
	struct Irule    *rule;					/* rule associated with this sample */
	struct Iexample *parent;				/* example containing this sample */
	struct Isample  *nextsample;			/* next sample in list */
} SAMPLE;


#define NOEXAMPLE ((EXAMPLE *)-1)

typedef struct Iexample
{
	SAMPLE          *firstsample;			/* head of list of samples in example */
	SAMPLE          *studysample;			/* sample under analysis */
	INTBIG           lx, hx, ly, hy;		/* bounding box of example */
	struct Iexample *nextexample;			/* next example in list */
} EXAMPLE;


/* port connections */
#define NOPCON ((PCON *)-1)

typedef struct Ipcon
{
	INTBIG       *connects;
	INTBIG       *assoc;
	INTSML        total;
	INTSML        pcindex;
	struct Ipcon *nextpcon;
} PCON;


/* rectangle rules */
#define NORULE ((RULE *)-1)

typedef struct Irule
{
	INTBIG       *value;					/* data points for rule */
	INTSML        count;					/* number of points in rule */
	INTSML        istext;					/* nonzero if text at end of rule */
	INTSML        rindex;					/* identifier for this rule */
	INTSML        used;						/* nonzero if actually used */
	INTSML        multicut;					/* nonzero if this is multiple cut */
	INTSML        multixs, multiys;			/* size of multicut */
	INTSML        multiindent, multisep;	/* indent and separation of multicuts */
	struct Irule *nextrule;
} RULE;


/* the meaning of "us_tecflags" */
#define HASDRCMINWID         01				/* has DRC minimum width information */
#define HASDRCMINWIDR        02				/* has DRC minimum width information */
#define HASCOLORMAP          04				/* has color map */
#define HASARCWID           010				/* has arc width offset factors */
#define HASCIF              020				/* has CIF layers */
#define HASDXF              040				/* has DXF layers */
#define HASGDS             0100				/* has Calma GDS-II layers */
#define HASGRAB            0200				/* has grab point information */
#define HASSPIRES          0400				/* has SPICE resistance information */
#define HASSPICAP         01000				/* has SPICE capacitance information */
#define HASSPIECAP        02000				/* has SPICE edge capacitance information */
#define HAS3DINFO         04000				/* has 3D height/thickness information */
#define HASCONDRC        010000				/* has connected design rules */
#define HASCONDRCR       020000				/* has connected design rules reasons */
#define HASUNCONDRC      040000				/* has unconnected design rules */
#define HASUNCONDRCR    0100000				/* has unconnected design rules reasons */
#define HASCONDRCW      0200000				/* has connected wide design rules */
#define HASCONDRCWR     0400000				/* has connected wide design rules reasons */
#define HASUNCONDRCW   01000000				/* has unconnected wide design rules */
#define HASUNCONDRCWR  02000000				/* has unconnected wide design rules reasons */
#define HASCONDRCM     04000000				/* has connected multicut design rules */
#define HASCONDRCMR   010000000				/* has connected multicut design rules reasons */
#define HASUNCONDRCM  020000000				/* has unconnected multicut design rules */
#define HASUNCONDRCMR 040000000				/* has unconnected multicut design rules reasons */
#define HASEDGEDRC   0100000000				/* has edge design rules */
#define HASEDGEDRCR  0200000000				/* has edge design rules reasons */

/* additional technology variables */
#define NOTECHVAR ((TECHVAR *)-1)

typedef struct Itechvar
{
	char            *varname;
	struct Itechvar *nexttechvar;
	INTSML           changed;
	INTBIG           ival;
	float            fval;
	char            *sval;
	INTBIG           vartype;
	char            *description;
} TECHVAR;

extern TECHVAR us_knownvars[];

/* the globals that define a technology */
extern INTSML           us_teceddrclayers;
extern char           **us_teceddrclayernames;

extern LIST us_teclayer_functions[];
extern LIST us_tecarc_functions[];
extern LIST us_tecnode_functions[];

/* prototypes for intramodule routines */
void     us_tecedgetbbox(NODEINST *ni, INTBIG *lx, INTBIG *hx, INTBIG *ly, INTBIG *hy);
INTSML   us_tecedgetdrc(char *str, INTSML *connected, INTSML *wide, INTSML *multi,
			INTSML *widrule, INTSML *edge, INTBIG *amt, INTSML *layer1, INTSML *layer2,
			char **rule, INTSML maxlayers, char **layernames);
EXAMPLE *us_tecedgetexamples(NODEPROTO *np, INTSML isnode);
INTSML   us_teceditfindsequence(LIBRARY **dependentlibs, INTSML dependentlibcount,
			char *match, char *seqname, NODEPROTO ***sequence);
INTSML   us_teceditgetdependents(LIBRARY *lib, LIBRARY ***liblist);
INTSML   us_teceditgetlayerinfo(NODEPROTO *np, GRAPHICS *desc, char **cif, INTBIG *func,
			char **layerletters, char **dxf, INTBIG *gds, float *spires, float *spicap,
			float *spiecap, INTBIG *drcminwid, INTBIG *height3d, INTBIG *thick3d);
void     us_teceditsetpatch(NODEINST *ni, GRAPHICS *desc);
void     us_tecedmakearc(NODEPROTO *np, INTBIG func, INTBIG fixang, INTBIG wipes,
			INTBIG noextend, INTBIG anginc);
void     us_tecedmakeinfo(NODEPROTO *np, INTBIG lambda, char *description);
void     us_tecedmakelayer(NODEPROTO *np, INTSML colorindex, UINTSML stip[8], INTSML style,
			char *ciflayer, INTBIG functionindex, char *layerletters, char *dxf,
			INTBIG gds, float spires, float spicap, float spiecap,
			INTBIG height3d, INTBIG thick3d);
LIBRARY *us_tecedmakelibfromtech(TECHNOLOGY *tech);
void     us_tecedmakenode(NODEPROTO *np, INTBIG func, INTSML serp, INTSML square, INTSML wipes,
			INTSML lockable);
void     us_tecedpointout(NODEINST *ni, NODEPROTO *np);
char    *us_tecedsamplename(NODEPROTO *layernp);
void     us_tecedswapports(INTSML *p1, INTSML *p2, TECH_NODES *tlist);
void     us_tecfromlibinit(LIBRARY *lib, char *techname, INTSML dumpc);
void     us_tecedfreeexamples(EXAMPLE *ne);
char    *us_tecedstripdash(char *str);
void     us_tecedgetlayernamelist(void);
void     us_tecedloaddrcmessage(DRCRULES *rules, LIBRARY *lib);
INTSML   us_teceditgetdrcarrays(VARIABLE *var, DRCRULES *rules);

#if defined(__cplusplus) && !defined(ALLCPLUSPLUS)
}
#endif
