/* -*- tab-width: 4 -*-
 *
 * Electric(tm) VLSI Design System
 *
 * File: DEFTab.java
 *
 * Copyright (c) 2004, Oracle and/or its affiliates. All rights reserved.
 *
 * Electric(tm) is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * Electric(tm) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Electric(tm); see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, Mass 02111-1307, USA.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.tool.io.IOTool;

import java.awt.Frame;

import javax.swing.JPanel;

/**
 * Class to handle the "DEF" tab of the Preferences dialog.
 */
public class DEFTab extends PreferencePanel
{
	/** Creates new form DEFTab */
	public DEFTab(Frame parent, boolean modal)
	{
		super(parent, modal);
		initComponents();
	}

	/** return the panel to use for the user preferences. */
	public JPanel getUserPreferencesPanel() { return def; }

	/** return the name of this preferences tab. */
	public String getName() { return "DEF"; }

	/**
	 * Method called at the start of the dialog.
	 * Caches current values and displays them in the DEF tab.
	 */
	public void init()
	{
		defPlacePhysical.setSelected(IOTool.isDEFPhysicalPlacement());
		defIgnorePhysInNets.setSelected(IOTool.isDEFIgnorePhysicalInNets());
		defUsePureLayerNodes.setSelected(IOTool.isDEFUsePureLayerNodes());
		defPlaceLogical.setSelected(IOTool.isDEFLogicalPlacement());
		defIgnoreLogInSpecialNets.setSelected(IOTool.isDEFIgnoreLogicalInSpecialNets());
	}

	/**
	 * Method called when the "OK" panel is hit.
	 * Updates any changed fields in the DEF tab.
	 */
	public void term()
	{
		boolean currentValue = defPlacePhysical.isSelected();
		if (currentValue != IOTool.isDEFPhysicalPlacement())
			IOTool.setDEFPhysicalPlacement(currentValue);

		currentValue = defIgnorePhysInNets.isSelected();
		if (currentValue != IOTool.isDEFIgnorePhysicalInNets())
			IOTool.setDEFIgnorePhysicalInNets(currentValue);

		currentValue = defUsePureLayerNodes.isSelected();
		if (currentValue != IOTool.isDEFUsePureLayerNodes())
			IOTool.setDEFUsePureLayerNodes(currentValue);

		currentValue = defPlaceLogical.isSelected();
		if (currentValue != IOTool.isDEFLogicalPlacement())
			IOTool.setDEFLogicalPlacement(currentValue);

		currentValue = defIgnoreLogInSpecialNets.isSelected();
		if (currentValue != IOTool.isDEFIgnoreLogicalInSpecialNets())
			IOTool.setDEFIgnoreLogicalInSpecialNets(currentValue);
	}

	/**
	 * Method called when the factory reset is requested.
	 */
	public void reset()
	{
		if (IOTool.isFactoryDEFPhysicalPlacement() != IOTool.isDEFPhysicalPlacement())
			IOTool.setDEFPhysicalPlacement(IOTool.isFactoryDEFPhysicalPlacement());
		if (IOTool.isFactoryDEFIgnorePhysicalInNets() != IOTool.isDEFIgnorePhysicalInNets())
			IOTool.setDEFIgnorePhysicalInNets(IOTool.isFactoryDEFIgnorePhysicalInNets());
		if (IOTool.isFactoryDEFUsePureLayerNodes() != IOTool.isDEFUsePureLayerNodes())
			IOTool.setDEFUsePureLayerNodes(IOTool.isFactoryDEFUsePureLayerNodes());
		if (IOTool.isFactoryDEFLogicalPlacement() != IOTool.isDEFLogicalPlacement())
			IOTool.setDEFLogicalPlacement(IOTool.isFactoryDEFLogicalPlacement());
		if (IOTool.isFactoryDEFIgnoreLogicalInSpecialNets() != IOTool.isDEFIgnoreLogicalInSpecialNets())
			IOTool.setDEFIgnoreLogicalInSpecialNets(IOTool.isFactoryDEFIgnoreLogicalInSpecialNets());
	}

	/** This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        def = new javax.swing.JPanel();
        defPlacePhysical = new javax.swing.JCheckBox();
        defPlaceLogical = new javax.swing.JCheckBox();
        jLabel1 = new javax.swing.JLabel();
        defUsePureLayerNodes = new javax.swing.JCheckBox();
        defIgnoreLogInSpecialNets = new javax.swing.JCheckBox();
        defIgnorePhysInNets = new javax.swing.JCheckBox();

        setTitle("IO Options");
        setName(""); // NOI18N
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });
        getContentPane().setLayout(new java.awt.GridBagLayout());

        def.setLayout(new java.awt.GridBagLayout());

        defPlacePhysical.setText("Place physical interconnect");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 1, 4);
        def.add(defPlacePhysical, gridBagConstraints);

        defPlaceLogical.setText("Place logical interconnect");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 1, 4);
        def.add(defPlaceLogical, gridBagConstraints);

        jLabel1.setText("When reading DEF files:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        def.add(jLabel1, gridBagConstraints);

        defUsePureLayerNodes.setText("Use pure-layer nodes instead of arcs");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(1, 20, 4, 4);
        def.add(defUsePureLayerNodes, gridBagConstraints);

        defIgnoreLogInSpecialNets.setText("Ignore logical interconnect in SPECIALNETS section");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(1, 20, 4, 4);
        def.add(defIgnoreLogInSpecialNets, gridBagConstraints);

        defIgnorePhysInNets.setText("Ignore physical  interconnect in NETS section");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(1, 20, 1, 4);
        def.add(defIgnorePhysInNets, gridBagConstraints);

        getContentPane().add(def, new java.awt.GridBagConstraints());

        pack();
    }// </editor-fold>//GEN-END:initComponents

	/** Closes the dialog */
	private void closeDialog(java.awt.event.WindowEvent evt)//GEN-FIRST:event_closeDialog
	{
		setVisible(false);
		dispose();
	}//GEN-LAST:event_closeDialog

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel def;
    private javax.swing.JCheckBox defIgnoreLogInSpecialNets;
    private javax.swing.JCheckBox defIgnorePhysInNets;
    private javax.swing.JCheckBox defPlaceLogical;
    private javax.swing.JCheckBox defPlacePhysical;
    private javax.swing.JCheckBox defUsePureLayerNodes;
    private javax.swing.JLabel jLabel1;
    // End of variables declaration//GEN-END:variables

}
