/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output;

import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.prototype.ArcProto;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.io.output.Output;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;

public class PostScript
extends Output {
    private static final int PSSCALE = 4;
    private static final int CORNERDATESIZE = 14;
    private static final int HEADERDOT = 1;
    private static final int HEADERLINE = 2;
    private static final int HEADERPOLYGON = 3;
    private static final int HEADERFPOLYGON = 4;
    private static final int HEADERSTRING = 5;
    private boolean putHeaderDot;
    private boolean putHeaderLine;
    private boolean putHeaderPolygon;
    private boolean putHeaderFilledPolygon;
    private boolean putHeaderString;
    private boolean psUseColor;
    private boolean psUseColorStip;
    private boolean psUseColorMerge;
    private Cell cell;
    private WindowFrame wf;
    private EditWindow wnd;
    private int psNumPatternsEmitted;
    private HashMap patternsEmitted;
    private int currentLayer;
    private int lastColor;
    private boolean plotDates;
    private AffineTransform matrix;
    private static Layer blackLayer = Layer.newInstance(null, "black", new EGraphics(0, 0, 0, 100, 100, 100, 1.0, 1, new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}));
    String defaultFontName = null;
    String[] headerDot = new String[]{"/Putdot {", "    newpath moveto 0 0 rlineto stroke} def"};
    String[] headerLine = new String[]{"/Drawline {", "    newpath moveto lineto stroke} def"};
    String[] headerPolygon = new String[]{"/Polygon {", "    aload", "    length 2 idiv /len exch def", "    newpath", "    moveto", "    len 1 sub {lineto} repeat", "    closepath", "} def"};
    String[] headerFilledPolygon = new String[]{"/BuildCharDict 10 dict def", "/StippleFont1 7 dict def", "StippleFont1 begin", "    /FontType 3 def", "    /FontMatrix [1 0 0 1 0 0] def", "    /FontBBox [0 0 1 1] def", "    /Encoding 256 array def", "    0 1 255 {Encoding exch /.notdef put} for", "    /CharacterDefs 40 dict def", "    CharacterDefs /.notdef {} put", "    /BuildChar", "        { BuildCharDict begin", "            /char exch def", "            /fontdict exch def", "            /charname fontdict /Encoding get", "            char get def", "            /charproc fontdict /CharacterDefs get", "            charname get def", "            1 0 0 0 1 1 setcachedevice", "            gsave charproc grestore", "        end", "    } def", "end", "/StippleFont StippleFont1 definefont pop", "/StippleCharYSize 128 def", "/StippleCharXSize StippleCharYSize def", "/Filledpolygon {", "    gsave", "    /StippleFont findfont StippleCharYSize scalefont setfont", "    /LowY exch def /LowX exch def", "    /HighY exch LowY add def /HighX exch LowX add def", "    Polygon clip", "    /Char exch def", "    /LowY LowY StippleCharYSize div truncate StippleCharYSize mul def", "    /LowX LowX StippleCharXSize div truncate StippleCharXSize mul def", "    /HighY HighY StippleCharYSize div 1 add truncate StippleCharYSize mul def", "    /HighX HighX StippleCharXSize div 1 add truncate StippleCharXSize mul def", "    LowY StippleCharYSize HighY ", "    { LowX exch moveto ", "        LowX StippleCharXSize HighX ", "        { Char show pop ", "        } for ", "    } for", "    grestore", "} def"};
    String[] headerString = new String[]{"/ComStart 92 def", "/ComSub  100 def", "/ComSup  117 def", "/ComNorm 125 def", "/SSSize .70 def", "/SubDy  -.20 def", "/SupDy   .40 def", "/StringShow {", "    /ComMode 0 def", "    /TSize exch def", "    /TString exch def", "    /NormY currentpoint exch pop def", "    TSize scaleFont", "    TString {", "        /CharCode exch def", "        ComMode 1 eq {", "            /ComMode 0 def", "            CharCode ComSub eq {", "                TSize SSSize mul scaleFont", "                currentpoint pop NormY TSize SubDy mul add moveto", "            } if", "            CharCode ComSup eq {", "                TSize SSSize mul scaleFont", "                currentpoint pop NormY TSize SupDy mul add moveto", "            } if", "            CharCode ComNorm eq {", "                TSize scaleFont", "                currentpoint pop NormY moveto", "            } if", "            CharCode ComStart eq {", "                ( ) dup 0 CharCode put show", "            } if", "        }", "        {", "            CharCode ComStart eq {", "                /ComMode 1 def", "            }", "            {", "                ( ) dup 0 CharCode put show", "            } ifelse", "        } ifelse", "    } forall ", "} def", "/StringLength {", "    /ComMode 0 def", "    /StrLen 0 def", "    /TSize exch def", "    /TString exch def", "    TSize scaleFont", "    TString {", "        /CharCode exch def", "        ComMode 1 eq {", "            /ComMode 0 def", "            CharCode ComSub eq {", "                TSize SSSize mul scaleFont", "            } if", "            CharCode ComSup eq {", "                TSize SSSize mul scaleFont", "            } if", "            CharCode ComNorm eq {", "                TSize scaleFont", "            } if", "            CharCode ComStart eq {", "                ( ) dup 0 CharCode put stringwidth pop StrLen add", "                /StrLen exch def", "            } if", "        }", "        {", "            CharCode ComStart eq {", "                /ComMode 1 def", "            }", "            {", "                ( ) dup 0 CharCode put stringwidth pop StrLen add", "                /StrLen exch def", "            } ifelse", "        } ifelse", "    } forall ", "    StrLen 0", "} def", "/Centerstring {", "    dup /TSize exch def", "    dup scaleFont exch dup TSize StringLength", "    pop 3 -1 roll .5 mul", "    exch 5 -1 roll exch 2 div sub", "    exch 4 -1 roll exch 2 div sub", "    moveto TSize StringShow", "} def", "/Topstring {", "    dup /TSize exch def", "    dup scaleFont exch dup TSize StringLength", "    pop 3 -1 roll .5 mul", "    exch 5 -1 roll exch 2 div sub", "    exch 4 -1 roll exch sub", "    moveto TSize StringShow", "} def", "/Botstring {", "    dup /TSize exch def", "    scaleFont dup TSize StringLength pop", "    4 -1 roll exch 2 div sub", "    3 -1 roll moveto TSize StringShow", "} def", "/Leftstring {", "    dup /TSize exch def", "    dup scaleFont .4 mul", "    3 -1 roll exch sub", "    3 -1 roll exch", "    moveto TSize StringShow", "} def", "/Rightstring {", "    dup /TSize exch def", "    dup scaleFont exch dup TSize StringLength", "    pop 3 -1 roll .4 mul", "    exch 5 -1 roll exch sub", "    exch 4 -1 roll exch sub", "    moveto TSize StringShow", "} def", "/Topleftstring {", "    dup /TSize exch def", "    dup scaleFont .5 mul", "    3 -1 roll exch sub", "    3 -1 roll exch", "    moveto TSize StringShow", "} def", "/Toprightstring {", "    dup /TSize exch def", "    dup scaleFont exch dup TSize StringLength", "    pop 3 -1 roll .5 mul", "    exch 5 -1 roll exch sub", "    exch 4 -1 roll exch sub", "    moveto TSize StringShow", "} def", "/Botleftstring {", "    dup /TSize exch def", "    scaleFont 3 1 roll moveto TSize StringShow", "} def", "/Botrightstring {", "    dup /TSize exch def", "    scaleFont dup TSize StringLength", "    pop 4 -1 roll exch", "    sub 3 -1 roll", "    moveto TSize StringShow", "} def", "/Min {", "    dup 3 -1 roll dup", "    3 1 roll gt", "    {exch} if pop", "} def", "/Boxstring {", "    dup /TSize exch def", "    dup scaleFont", "    exch dup TSize StringLength pop", "    3 -1 roll dup", "    6 -1 roll mul", "    3 -1 roll div", "    4 -1 roll", "    Min Min", "    Centerstring", "} def"};

    public static void writePostScriptFile(Cell cell, VarContext context, String filePath) {
        PostScript.writeCellToFile(cell, context, filePath);
    }

    private static boolean writeCellToFile(Cell cell, VarContext context, String filePath) {
        boolean error = false;
        PostScript out = new PostScript();
        out.cell = cell;
        if (out.openTextOutputStream(filePath)) {
            error = true;
        }
        out.start();
        out.scanCircuit();
        out.done();
        if (out.closeTextOutputStream()) {
            error = true;
        }
        if (!error) {
            System.out.println(filePath + " written");
            if (cell != null) {
                IOTool.setPrintEPSSavedDate(cell, new Date());
            }
        }
        return error;
    }

    private PostScript() {
    }

    private void start() {
        double s;
        int j;
        int i;
        double scale;
        double pageMarginPS;
        this.wf = WindowFrame.getCurrentWindowFrame();
        if (this.wf != null && this.wf.getContent().getCell() != this.cell) {
            this.wf = null;
        }
        this.wnd = null;
        if (this.wf != null && this.wf.getContent() instanceof EditWindow) {
            this.wnd = (EditWindow)this.wf.getContent();
        }
        this.putHeaderDot = false;
        this.putHeaderLine = false;
        this.putHeaderPolygon = false;
        this.putHeaderFilledPolygon = false;
        this.putHeaderString = false;
        this.psUseColorMerge = false;
        this.psUseColorStip = false;
        this.psUseColor = false;
        switch (IOTool.getPrintColorMethod()) {
            case 1: {
                this.psUseColor = true;
                break;
            }
            case 2: {
                this.psUseColorStip = true;
                this.psUseColor = true;
                break;
            }
            case 3: {
                this.psUseColorMerge = true;
                this.psUseColor = true;
            }
        }
        boolean usePlotter = IOTool.isPrintForPlotter();
        this.plotDates = IOTool.isPlotDate();
        boolean epsFormat = IOTool.isPrintEncapsulated();
        double pageWid = IOTool.getPrintWidth() * 75.0;
        double pageHei = IOTool.getPrintHeight() * 75.0;
        double pageMargin = pageMarginPS = IOTool.getPrintMargin() * 75.0;
        Rectangle2D printBounds = this.getAreaToPrint(this.cell, false);
        if (printBounds == null) {
            return;
        }
        boolean rotatePlot = false;
        switch (IOTool.getPrintRotation()) {
            case 1: {
                rotatePlot = true;
                break;
            }
            case 2: {
                if ((!(pageHei > pageWid) && !usePlotter || !(printBounds.getWidth() > printBounds.getHeight())) && (!(pageWid > pageHei) || !(printBounds.getHeight() > printBounds.getWidth()))) break;
                rotatePlot = true;
            }
        }
        if (usePlotter) {
            pageHei = rotatePlot ? pageWid * printBounds.getWidth() / printBounds.getHeight() : pageWid * printBounds.getHeight() / printBounds.getWidth();
        }
        if (this.psUseColorMerge) {
            System.out.println("Cannot do color merging yet");
        }
        double cX = printBounds.getCenterX();
        double cY = printBounds.getCenterY();
        double unitsX = (pageWid - pageMargin * 2.0) * 4.0;
        double unitsY = (pageHei - pageMargin * 2.0) * 4.0;
        if (epsFormat && (scale = IOTool.getPrintEPSScale(this.cell)) != 0.0) {
            unitsX *= scale;
            unitsY *= scale;
        }
        if (usePlotter) {
            i = (int)(unitsX / printBounds.getWidth());
            j = (int)(unitsX / printBounds.getHeight());
        } else {
            i = (int)Math.min(unitsX / printBounds.getWidth(), unitsY / printBounds.getHeight());
            j = (int)Math.min(unitsX / printBounds.getHeight(), unitsY / printBounds.getWidth());
        }
        if (rotatePlot) {
            i = j;
        }
        double matrix00 = i;
        double matrix01 = 0.0;
        double matrix10 = 0.0;
        double matrix11 = i;
        double matrix20 = (double)(-i) * cX + unitsX / 2.0 + pageMarginPS * 4.0;
        double matrix21 = usePlotter ? (double)(-i) * printBounds.getMinY() + pageMarginPS * 4.0 : (double)(-i) * cY + unitsY / 2.0 + pageMarginPS * 4.0;
        this.matrix = new AffineTransform(matrix00, matrix01, matrix10, matrix11, matrix20, matrix21);
        if (epsFormat) {
            this.printWriter.print("%%!PS-Adobe-2.0 EPSF-2.0\n");
        } else {
            this.printWriter.print("%%!PS-Adobe-1.0\n");
        }
        this.printWriter.print("%%%%Title: " + this.cell.describe() + "\n");
        if (User.isIncludeDateAndVersionInOutput()) {
            this.printWriter.print("%%%%Creator: Electric VLSI Design System version " + Version.getVersion() + "\n");
            Date now = new Date();
            this.printWriter.print("%%%%CreationDate: " + TextUtils.formatDate(now) + "\n");
        } else {
            this.printWriter.print("%%%%Creator: Electric VLSI Design System\n");
        }
        if (epsFormat) {
            this.printWriter.print("%%%%Pages: 0\n");
        } else {
            this.printWriter.print("%%%%Pages: 1\n");
        }
        this.emitCopyright("%% ", "");
        double bblx = printBounds.getMinX();
        double bbhx = printBounds.getMaxX();
        double bbly = printBounds.getMinY();
        double bbhy = printBounds.getMaxY();
        Point2D bbCorner1 = this.psXform(new Point2D.Double(bblx, bbly));
        Point2D bbCorner2 = this.psXform(new Point2D.Double(bbhx, bbhy));
        bblx = bbCorner1.getX();
        bbly = bbCorner1.getY();
        bbhx = bbCorner2.getX();
        bbhy = bbCorner2.getY();
        if (rotatePlot) {
            double t1 = bblx;
            double t2 = bbhx;
            bblx = -bbhy + pageHei * 300.0 / 75.0;
            bbhx = -bbly + pageHei * 300.0 / 75.0;
            bbly = t1 + pageMargin * 2.0 * 300.0 / 75.0;
            bbhy = t2 + pageMargin * 2.0 * 300.0 / 75.0;
        }
        if (bblx > bbhx) {
            s = bblx;
            bblx = bbhx;
            bbhx = s;
        }
        if (bbly > bbhy) {
            s = bbly;
            bbly = bbhy;
            bbhy = s;
        }
        bblx = bblx / 300.0 * 72.0 * (double)(bblx >= 0.0 ? 1 : -1);
        bbly = bbly / 300.0 * 72.0 * (double)(bbly >= 0.0 ? 1 : -1);
        bbhx = bbhx / 300.0 * 72.0 * (double)(bbhx >= 0.0 ? 1 : -1);
        bbhy = bbhy / 300.0 * 72.0 * (double)(bbhy >= 0.0 ? 1 : -1);
        this.printWriter.print("%%%%BoundingBox: " + (int)(bblx - 1.0) + " " + (int)(bbly - 1.0) + " " + (int)(bbhx + 1.0) + " " + (int)(bbhy + 1.0) + "\n");
        this.printWriter.print("%%%%DocumentFonts: Times-Roman\n");
        this.printWriter.print("%%%%EndComments\n");
        if (this.cell != null) {
            Rectangle2D bounds = this.cell.getBounds();
            this.printWriter.print("%% cell dimensions: " + bounds.getWidth() + " wide x " + bounds.getHeight() + " high (database units)\n");
            this.printWriter.print("%% origin: " + bounds.getMinX() + " " + bounds.getMinY() + "\n");
        }
        if (epsFormat) {
            this.printWriter.print("%% The EPS header should declare a private dictionary.\n");
        } else {
            this.printWriter.print("%% The non-EPS header does not claim conformance to Adobe-2.0\n");
            this.printWriter.print("%% because the structure may not be exactly correct.\n");
        }
        this.printWriter.print("%%\n");
        if (usePlotter) {
            this.printWriter.print("<< /PageSize [" + (int)(pageWid * 72.0 / 75.0) + " " + (int)(pageHei * 72.0 / 75.0) + "] >> setpagedevice\n");
        }
        this.printWriter.print("72 300 div 72 300 div scale\n");
        this.printWriter.print("/DefaultFont /Times-Roman def\n");
        this.printWriter.print("/scaleFont {\n");
        this.printWriter.print("    DefaultFont findfont\n");
        this.printWriter.print("    exch scalefont setfont} def\n");
        this.printWriter.print("2 setlinewidth\n");
        this.printWriter.print("1 setlinecap\n");
        if (rotatePlot) {
            if (usePlotter) {
                this.printWriter.print(pageWid / 75.0 + " 300 mul " + (pageHei - pageWid) / 2.0 / 75.0 + " 300 mul translate 90 rotate\n");
            } else {
                this.printWriter.print((pageHei + pageWid) / 2.0 / 75.0 + " 300 mul " + (pageHei - pageWid) / 2.0 / 75.0 + " 300 mul translate 90 rotate\n");
            }
        }
        this.patternsEmitted = new HashMap();
        this.psNumPatternsEmitted = 0;
    }

    private void scanCircuit() {
        PSVisitor visitor = this.makePSVisitor();
        this.lastColor = -1;
        if (this.psUseColor) {
            List layerList = Technology.getCurrent().getLayersSortedByHeight();
            Iterator it = layerList.iterator();
            while (it.hasNext()) {
                Layer layer = (Layer)it.next();
                this.currentLayer = layer.getIndex() + 1;
                HierarchyEnumerator.enumerateCell(this.cell, VarContext.globalContext, null, visitor);
            }
            this.currentLayer = 0;
            HierarchyEnumerator.enumerateCell(this.cell, VarContext.globalContext, null, visitor);
        } else {
            this.currentLayer = -1;
            HierarchyEnumerator.enumerateCell(this.cell, VarContext.globalContext, null, visitor);
        }
    }

    private void done() {
        if (this.psUseColor) {
            this.printWriter.print("0 0 0 setrgbcolor\n");
        }
        if (this.wnd != null && this.wnd.isGrid()) {
            int gridx = (int)this.wnd.getGridXSpacing();
            int gridy = (int)this.wnd.getGridYSpacing();
            int lx = (int)this.cell.getBounds().getMinX();
            int ly = (int)this.cell.getBounds().getMinY();
            int hx = (int)this.cell.getBounds().getMaxX();
            int hy = (int)this.cell.getBounds().getMaxY();
            int gridlx = lx / gridx * gridx;
            int gridly = ly / gridy * gridy;
            if (gridlx > lx) {
                gridlx -= (gridlx - lx) / gridx * gridx;
            }
            if (gridly > ly) {
                gridly -= (gridly - ly) / gridy * gridy;
            }
            while (gridlx < lx) {
                gridlx += gridx;
            }
            while (gridly < ly) {
                gridly += gridy;
            }
            double matrix00 = this.matrix.getScaleX();
            double matrix01 = this.matrix.getShearX();
            double matrix10 = this.matrix.getShearY();
            double matrix11 = this.matrix.getScaleY();
            double matrix20 = this.matrix.getTranslateX();
            double matrix21 = this.matrix.getTranslateY();
            this.printWriter.print(gridlx + " " + gridx + " " + hx + "\n{\n");
            this.printWriter.print("    " + gridly + " " + gridy + " " + hy + "\n    {\n");
            this.printWriter.print("        dup 3 -1 roll dup dup\n");
            this.printWriter.print("        5 1 roll 3 1 roll\n");
            this.printWriter.print("        " + matrix00 + " mul exch " + matrix10 + " mul add " + matrix20 + " add\n");
            this.printWriter.print("        3 1 roll\n");
            this.printWriter.print("        " + matrix01 + " mul exch " + matrix11 + " mul add " + matrix21 + " add\n");
            this.printWriter.print("        newpath moveto 0 0 rlineto stroke\n");
            this.printWriter.print("    } for\n");
            this.printWriter.print("} for\n");
        }
        if (this.plotDates) {
            this.putPSHeader(5);
            this.printWriter.print("0 112 ");
            this.writePSString("Cell: " + this.cell.describe());
            this.printWriter.print(" 56 Botleftstring\n");
            this.printWriter.print("0 56 ");
            this.writePSString("Created: " + TextUtils.formatDate(this.cell.getCreationDate()));
            this.printWriter.print(" 56 Botleftstring\n");
            this.printWriter.print("0 0 ");
            this.writePSString("Revised: " + TextUtils.formatDate(this.cell.getRevisionDate()));
            this.printWriter.print(" 56 Botleftstring\n");
        }
        this.printWriter.print("showpage\n");
        this.printWriter.print("%%%%Trailer\n");
    }

    private PSVisitor makePSVisitor() {
        PSVisitor visitor = new PSVisitor(this);
        return visitor;
    }

    public static boolean syncAll() {
        boolean syncOther = false;
        Iterator lIt = Library.getLibraries();
        while (lIt.hasNext()) {
            Library lib = (Library)lIt.next();
            Iterator cIt = lib.getCells();
            while (cIt.hasNext()) {
                String fileName;
                Cell aCell = (Cell)cIt.next();
                Variable var = aCell.getVar(IOTool.POSTSCRIPT_FILENAME);
                if (var == null || (fileName = (String)var.getObject()).trim().length() <= 0) continue;
                syncOther = true;
                break;
            }
            if (!syncOther) continue;
            break;
        }
        if (syncOther) {
            Object[] options = new String[]{"Yes", "No"};
            int ret = JOptionPane.showOptionDialog(TopLevel.getCurrentJFrame(), "Would you like to synchronize all PostScript drawings?", "Synchronize EPS files", -1, 2, null, options, options[1]);
            if (ret == 1) {
                syncOther = false;
            }
        }
        if (syncOther) {
            PostScript.synchronizeEPSFiles();
            return true;
        }
        return false;
    }

    private static boolean synchronizeEPSFiles() {
        int numSyncs = 0;
        Iterator lIt = Library.getLibraries();
        while (lIt.hasNext()) {
            Library oLib = (Library)lIt.next();
            Iterator cIt = oLib.getCells();
            while (cIt.hasNext()) {
                Date lastChangeDate;
                Date lastSavedDate;
                Cell oCell = (Cell)cIt.next();
                String syncFileName = IOTool.getPrintEPSSynchronizeFile(oCell);
                if (syncFileName.length() == 0 || (lastSavedDate = IOTool.getPrintEPSSavedDate(oCell)) != null && lastSavedDate.after(lastChangeDate = oCell.getRevisionDate())) continue;
                boolean err = PostScript.writeCellToFile(oCell, VarContext.globalContext, syncFileName);
                if (err) {
                    return true;
                }
                ++numSyncs;
            }
        }
        if (numSyncs == 0) {
            System.out.println("No PostScript files needed to be written");
        }
        return false;
    }

    private void psPoly(Poly poly) {
        Layer layer = poly.getLayer();
        EGraphics gra = null;
        int index = 0;
        Color col = Color.BLACK;
        Technology tech = Technology.getCurrent();
        if (layer != null) {
            tech = layer.getTechnology();
            index = layer.getIndex();
            if (!layer.isVisible()) {
                return;
            }
            gra = layer.getGraphics();
            col = gra.getColor();
        }
        if (this.currentLayer >= 0 && (this.currentLayer == 0 ? tech == Technology.getCurrent() : tech != Technology.getCurrent() || this.currentLayer - 1 != index)) {
            return;
        }
        if (this.psUseColor && col.getRGB() != this.lastColor) {
            this.lastColor = col.getRGB();
            this.printWriter.print((float)col.getRed() / 255.0f + " " + (float)col.getGreen() / 255.0f + " " + (float)col.getBlue() / 255.0f + " setrgbcolor\n");
        }
        Poly.Type type = poly.getStyle();
        Point2D[] points = poly.getPoints();
        if (type == Poly.Type.FILLED) {
            Rectangle2D polyBox = poly.getBox();
            if (polyBox != null) {
                if (polyBox.getWidth() == 0.0) {
                    if (polyBox.getHeight() == 0.0) {
                        this.psDot(new Point2D.Double(polyBox.getCenterX(), polyBox.getCenterY()));
                    } else {
                        this.psLine(new Point2D.Double(polyBox.getCenterX(), polyBox.getMinY()), new Point2D.Double(polyBox.getCenterX(), polyBox.getMaxY()), 0);
                    }
                    return;
                }
                if (polyBox.getHeight() == 0.0) {
                    this.psLine(new Point2D.Double(polyBox.getMinX(), polyBox.getCenterY()), new Point2D.Double(polyBox.getMaxX(), polyBox.getCenterY()), 0);
                    return;
                }
                this.psPolygon(poly);
                return;
            }
            if (points.length == 1) {
                this.psDot(points[0]);
                return;
            }
            if (points.length == 2) {
                this.psLine(points[0], points[1], 0);
                return;
            }
            this.psPolygon(poly);
            return;
        }
        if (type == Poly.Type.CLOSED) {
            Point2D lastPt = points[points.length - 1];
            for (int k = 0; k < points.length; ++k) {
                this.psLine(lastPt, points[k], 0);
                lastPt = points[k];
            }
            return;
        }
        if (type == Poly.Type.OPENED || type == Poly.Type.OPENEDT1 || type == Poly.Type.OPENEDT2 || type == Poly.Type.OPENEDT3) {
            int lineType = 0;
            if (type == Poly.Type.OPENEDT1) {
                lineType = 1;
            } else if (type == Poly.Type.OPENEDT2) {
                lineType = 2;
            } else if (type == Poly.Type.OPENEDT3) {
                lineType = 3;
            }
            for (int k = 1; k < points.length; ++k) {
                this.psLine(points[k - 1], points[k], lineType);
            }
            return;
        }
        if (type == Poly.Type.VECTORS) {
            for (int k = 0; k < points.length; k += 2) {
                this.psLine(points[k], points[k + 1], 0);
            }
            return;
        }
        if (type == Poly.Type.CROSS || type == Poly.Type.BIGCROSS) {
            double x = poly.getCenterX();
            double y = poly.getCenterY();
            this.psLine(new Point2D.Double(x - 5.0, y), new Point2D.Double(x + 5.0, y), 0);
            this.psLine(new Point2D.Double(x, y + 5.0), new Point2D.Double(x, y - 5.0), 0);
            return;
        }
        if (type == Poly.Type.CROSSED) {
            Rectangle2D bounds = poly.getBounds2D();
            this.psLine(new Point2D.Double(bounds.getMinX(), bounds.getMinY()), new Point2D.Double(bounds.getMinX(), bounds.getMaxY()), 0);
            this.psLine(new Point2D.Double(bounds.getMinX(), bounds.getMaxY()), new Point2D.Double(bounds.getMaxX(), bounds.getMaxY()), 0);
            this.psLine(new Point2D.Double(bounds.getMaxX(), bounds.getMaxY()), new Point2D.Double(bounds.getMaxX(), bounds.getMinY()), 0);
            this.psLine(new Point2D.Double(bounds.getMaxX(), bounds.getMinY()), new Point2D.Double(bounds.getMinX(), bounds.getMinY()), 0);
            this.psLine(new Point2D.Double(bounds.getMinX(), bounds.getMinY()), new Point2D.Double(bounds.getMaxX(), bounds.getMaxY()), 0);
            this.psLine(new Point2D.Double(bounds.getMinX(), bounds.getMaxY()), new Point2D.Double(bounds.getMaxX(), bounds.getMinY()), 0);
            return;
        }
        if (type == Poly.Type.DISC) {
            this.psDisc(points[0], points[1]);
            type = Poly.Type.CIRCLE;
        }
        if (type == Poly.Type.CIRCLE || type == Poly.Type.THICKCIRCLE) {
            this.psCircle(points[0], points[1]);
            return;
        }
        if (type == Poly.Type.CIRCLEARC || type == Poly.Type.THICKCIRCLEARC) {
            this.psArc(points[0], points[1], points[2]);
            return;
        }
        this.psText(poly, tech);
    }

    void psDot(Point2D pt) {
        Point2D ps = this.psXform(pt);
        this.putPSHeader(1);
        this.printWriter.print(ps.getX() + " " + ps.getY() + " Putdot\n");
    }

    void psLine(Point2D from, Point2D to, int pattern) {
        Point2D pt1 = this.psXform(from);
        Point2D pt2 = this.psXform(to);
        this.putPSHeader(2);
        int i = 2;
        switch (pattern) {
            case 0: {
                this.printWriter.print(pt1.getX() + " " + pt1.getY() + " " + pt2.getX() + " " + pt2.getY() + " Drawline\n");
                break;
            }
            case 1: {
                this.printWriter.print("[" + i + " " + i * 3 + "] 0 setdash ");
                this.printWriter.print(pt1.getX() + " " + pt1.getY() + " " + pt2.getX() + " " + pt2.getY() + " Drawline\n");
                this.printWriter.print(" [] 0 setdash\n");
                break;
            }
            case 2: {
                this.printWriter.print("[" + i * 6 + " " + i * 3 + "] 0 setdash ");
                this.printWriter.print(pt1.getX() + " " + pt1.getY() + " " + pt2.getX() + " " + pt2.getY() + " Drawline\n");
                this.printWriter.print(" [] 0 setdash\n");
                break;
            }
            case 3: {
                this.printWriter.print("4 setlinewidth ");
                this.printWriter.print(pt1.getX() + " " + pt1.getY() + " " + pt2.getX() + " " + pt2.getY() + " Drawline\n");
                this.printWriter.print("2 setlinewidth\n");
            }
        }
    }

    void psArc(Point2D center, Point2D pt1, Point2D pt2) {
        Point2D pc = this.psXform(center);
        Point2D ps1 = this.psXform(pt1);
        Point2D ps2 = this.psXform(pt2);
        double radius = pc.distance(ps1);
        int startAngle = (DBMath.figureAngle(pc, ps2) + 5) / 10;
        int endAngle = (DBMath.figureAngle(pc, ps1) + 5) / 10;
        this.printWriter.print("newpath " + pc.getX() + " " + pc.getY() + " " + radius + " " + startAngle + " " + endAngle + " arc stroke\n");
    }

    void psCircle(Point2D center, Point2D pt) {
        Point2D pc = this.psXform(center);
        Point2D ps = this.psXform(pt);
        double radius = pc.distance(ps);
        this.printWriter.print("newpath " + pc.getX() + " " + pc.getY() + " " + radius + " 0 360 arc stroke\n");
    }

    void psDisc(Point2D center, Point2D pt) {
        Point2D pc = this.psXform(center);
        Point2D ps = this.psXform(pt);
        double radius = pc.distance(ps);
        this.printWriter.print("newpath " + pc.getX() + " " + pc.getY() + " " + radius + " 0 360 arc fill\n");
    }

    private void psPolygon(Poly poly) {
        double ly;
        double lx;
        Point2D[] points = poly.getPoints();
        if (points.length == 0) {
            return;
        }
        EGraphics desc = poly.getLayer().getGraphics();
        boolean stipplePattern = false;
        if (this.psUseColor) {
            if (this.psUseColorStip) {
                if (desc.isPatternedOnDisplay() || desc.isPatternedOnPrinter()) {
                    stipplePattern = true;
                }
            } else if (desc.isPatternedOnDisplay()) {
                stipplePattern = true;
            }
        } else if (desc.isPatternedOnPrinter()) {
            stipplePattern = true;
        }
        if (stipplePattern) {
            int[] pattern = desc.getPattern();
            boolean solid = true;
            for (int i = 0; i < 8; ++i) {
                if (pattern[i] == 65535) continue;
                solid = false;
                break;
            }
            if (solid) {
                stipplePattern = false;
            }
        }
        if (!stipplePattern) {
            this.putPSHeader(3);
            this.printWriter.print("[");
            for (int i = 0; i < points.length; ++i) {
                if (i != 0) {
                    this.printWriter.print(" ");
                }
                Point2D ps = this.psXform(points[i]);
                this.printWriter.print(ps.getX() + " " + ps.getY());
            }
            this.printWriter.print("] Polygon fill\n");
            return;
        }
        this.putPSHeader(3);
        this.putPSHeader(4);
        this.printWriter.print("(" + this.psPattern(desc) + ") [");
        Point2D ps = this.psXform(points[0]);
        double hx = lx = ps.getX();
        double hy = ly = ps.getY();
        for (int i = 0; i < points.length; ++i) {
            if (i != 0) {
                this.printWriter.print(" ");
            }
            Point2D psi = this.psXform(points[i]);
            this.printWriter.print(psi.getX() + " " + psi.getY());
            if (psi.getX() < lx) {
                lx = psi.getX();
            }
            if (psi.getX() > hx) {
                hx = psi.getX();
            }
            if (psi.getY() < ly) {
                ly = psi.getY();
            }
            if (!(psi.getY() > hy)) continue;
            hy = psi.getY();
        }
        this.printWriter.print("] " + (hx - lx + 1.0) + " " + (hy - ly + 1.0) + " " + lx + " " + ly + " Filledpolygon\n");
    }

    void psText(Poly poly, Technology tech) {
        Poly.Type style = poly.getStyle();
        TextDescriptor td = poly.getTextDescriptor();
        int size = td.getTrueSize(this.wnd) * 4;
        Rectangle2D bounds = poly.getBounds2D();
        if (size <= 0) {
            return;
        }
        String text = poly.getString().trim();
        if (text.length() == 0) {
            return;
        }
        if (this.defaultFontName == null) {
            this.defaultFontName = "Times";
        }
        Point2D psL = this.psXform(new Point2D.Double(bounds.getMinX(), bounds.getMinY()));
        Point2D psH = this.psXform(new Point2D.Double(bounds.getMaxX(), bounds.getMaxY()));
        double cX = (psL.getX() + psH.getX()) / 2.0;
        double cY = (psL.getY() + psH.getY()) / 2.0;
        double sX = Math.abs(psH.getX() - psL.getX());
        double sY = Math.abs(psH.getY() - psL.getY());
        this.putPSHeader(5);
        boolean changedFont = false;
        String faceName = null;
        int faceNumber = td.getFace();
        if (faceNumber != 0) {
            // empty if block
        }
        if (faceName != null) {
            String fixedFaceName = faceName.replace(' ', '-');
            this.printWriter.print("/DefaultFont /" + fixedFaceName + " def\n");
            changedFont = true;
        } else if (td.isItalic()) {
            if (td.isBold()) {
                this.printWriter.print("/DefaultFont /" + this.defaultFontName + "-BoldItalic def\n");
                changedFont = true;
            } else {
                this.printWriter.print("/DefaultFont /" + this.defaultFontName + "-Italic def\n");
                changedFont = true;
            }
        } else if (td.isBold()) {
            this.printWriter.print("/DefaultFont /" + this.defaultFontName + "-Bold def\n");
            changedFont = true;
        }
        if (poly.getStyle() == Poly.Type.TEXTBOX) {
            this.printWriter.print(cX + " " + cY + " " + sX + " " + sY + " ");
            this.writePSString(text);
            this.printWriter.print(" " + size + " Boxstring\n");
        } else {
            String opName = null;
            double x = 0.0;
            double y = 0.0;
            if (style == Poly.Type.TEXTCENT) {
                x = cX;
                y = cY;
                opName = "Centerstring";
            } else if (style == Poly.Type.TEXTTOP) {
                x = cX;
                y = psH.getY();
                opName = "Topstring";
            } else if (style == Poly.Type.TEXTBOT) {
                x = cX;
                y = psL.getY();
                opName = "Botstring";
            } else if (style == Poly.Type.TEXTLEFT) {
                x = psL.getX();
                y = cY;
                opName = "Leftstring";
            } else if (style == Poly.Type.TEXTRIGHT) {
                x = psH.getX();
                y = cY;
                opName = "Rightstring";
            } else if (style == Poly.Type.TEXTTOPLEFT) {
                x = psL.getX();
                y = psH.getY();
                opName = "Topleftstring";
            } else if (style == Poly.Type.TEXTTOPRIGHT) {
                x = psH.getX();
                y = psH.getY();
                opName = "Toprightstring";
            } else if (style == Poly.Type.TEXTBOTLEFT) {
                x = psL.getX();
                y = psL.getY();
                opName = "Botleftstring";
            } else if (style == Poly.Type.TEXTBOTRIGHT) {
                x = psH.getX();
                y = psL.getY();
                opName = "Botrightstring";
            }
            int xoff = (int)x;
            int yoff = (int)y;
            double descenderoffset = size / 12;
            TextDescriptor.Rotation rot = td.getRotation();
            if (rot == TextDescriptor.Rotation.ROT0) {
                y += descenderoffset;
            } else if (rot == TextDescriptor.Rotation.ROT90) {
                x -= descenderoffset;
            } else if (rot == TextDescriptor.Rotation.ROT180) {
                y -= descenderoffset;
            } else if (rot == TextDescriptor.Rotation.ROT270) {
                x += descenderoffset;
            }
            if (rot != TextDescriptor.Rotation.ROT0) {
                if (rot == TextDescriptor.Rotation.ROT90 || rot == TextDescriptor.Rotation.ROT270) {
                    if (style == Poly.Type.TEXTTOP) {
                        opName = "Rightstring";
                    } else if (style == Poly.Type.TEXTBOT) {
                        opName = "Leftstring";
                    } else if (style == Poly.Type.TEXTLEFT) {
                        opName = "Botstring";
                    } else if (style == Poly.Type.TEXTRIGHT) {
                        opName = "Topstring";
                    } else if (style == Poly.Type.TEXTTOPLEFT) {
                        opName = "Botrightstring";
                    } else if (style == Poly.Type.TEXTBOTRIGHT) {
                        opName = "Topleftstring";
                    }
                }
                y = 0.0;
                x = 0.0;
                if (rot == TextDescriptor.Rotation.ROT90) {
                    this.printWriter.print(xoff + " " + yoff + " translate 90 rotate\n");
                } else if (rot == TextDescriptor.Rotation.ROT180) {
                    this.printWriter.print(xoff + " " + yoff + " translate 180 rotate\n");
                } else if (rot == TextDescriptor.Rotation.ROT270) {
                    this.printWriter.print(xoff + " " + yoff + " translate 270 rotate\n");
                }
            }
            this.printWriter.print((int)x + " " + (int)y + " ");
            this.writePSString(text);
            this.printWriter.print(" " + size + " " + opName + "\n");
            if (rot != TextDescriptor.Rotation.ROT0) {
                if (rot == TextDescriptor.Rotation.ROT90) {
                    this.printWriter.print("-90 rotate " + -xoff + " " + -yoff + " translate\n");
                } else if (rot == TextDescriptor.Rotation.ROT180) {
                    this.printWriter.print("-180 rotate " + -xoff + " " + -yoff + " translate\n");
                } else if (rot == TextDescriptor.Rotation.ROT270) {
                    this.printWriter.print("-270 rotate " + -xoff + " " + -yoff + " translate\n");
                }
            }
        }
        if (changedFont) {
            this.printWriter.print("/DefaultFont /" + this.defaultFontName + " def\n");
        }
    }

    private void putPSHeader(int which) {
        switch (which) {
            case 1: {
                if (this.putHeaderDot) {
                    return;
                }
                this.putHeaderDot = true;
                for (int i = 0; i < this.headerDot.length; ++i) {
                    this.printWriter.print(this.headerDot[i] + "\n");
                }
                break;
            }
            case 2: {
                if (this.putHeaderLine) {
                    return;
                }
                this.putHeaderLine = true;
                for (int i = 0; i < this.headerLine.length; ++i) {
                    this.printWriter.print(this.headerLine[i] + "\n");
                }
                break;
            }
            case 3: {
                if (this.putHeaderPolygon) {
                    return;
                }
                this.putHeaderPolygon = true;
                for (int i = 0; i < this.headerPolygon.length; ++i) {
                    this.printWriter.print(this.headerPolygon[i] + "\n");
                }
                break;
            }
            case 4: {
                if (this.putHeaderFilledPolygon) {
                    return;
                }
                this.putHeaderFilledPolygon = true;
                for (int i = 0; i < this.headerFilledPolygon.length; ++i) {
                    this.printWriter.print(this.headerFilledPolygon[i] + "\n");
                }
                break;
            }
            case 5: {
                if (this.putHeaderString) {
                    return;
                }
                this.putHeaderString = true;
                for (int i = 0; i < this.headerString.length; ++i) {
                    this.printWriter.print(this.headerString[i] + "\n");
                }
                break;
            }
        }
    }

    char psPattern(EGraphics col) {
        Integer index = (Integer)this.patternsEmitted.get(col);
        if (index != null) {
            return (char)(65 + index);
        }
        this.patternsEmitted.put(col, new Integer(this.psNumPatternsEmitted));
        int[] raster = col.getPattern();
        char indexChar = (char)(this.psNumPatternsEmitted + 65);
        ++this.psNumPatternsEmitted;
        this.printWriter.print("StippleFont1 begin\n");
        this.printWriter.print("    Encoding (" + indexChar + ") 0 get /Stipple" + indexChar + " put\n");
        this.printWriter.print("    CharacterDefs /Stipple" + indexChar + " {\n");
        this.printWriter.print("        128 128 true [128 0 0 -128 0 128]\n");
        this.printWriter.print("        { <\n");
        for (int i = 0; i < 8; ++i) {
            int k;
            int bl = raster[i] & 0xFF;
            int bh = (raster[i] & 0xFF00) >> 8;
            int bld = 0;
            int bhd = 0;
            for (k = 0; k < 8; ++k) {
                bld <<= 1;
                bld |= bl & 1;
                bld <<= 1;
                bld |= bl & 1;
                bl >>= 1;
                bhd <<= 1;
                bhd |= bh & 1;
                bhd <<= 1;
                bhd |= bh & 1;
                bh >>= 1;
            }
            for (k = 0; k < 2; ++k) {
                this.printWriter.print("            ");
                for (int j = 0; j < 4; ++j) {
                    this.printWriter.print((bhd & 0xFFFF) + " " + (bld & 0xFFFF) + " ");
                }
                this.printWriter.print("\n");
            }
        }
        this.printWriter.print("        > } imagemask\n");
        this.printWriter.print("    } put\n");
        this.printWriter.print("end\n");
        return indexChar;
    }

    private Point2D psXform(Point2D pt) {
        Point2D.Double result = new Point2D.Double();
        this.matrix.transform(pt, result);
        return result;
    }

    private void writePSString(String str) {
        this.printWriter.print("(");
        for (int i = 0; i < str.length(); ++i) {
            char ca = str.charAt(i);
            if (ca == '(' || ca == ')' || ca == '\\') {
                this.printWriter.print("\\");
            }
            this.printWriter.print(ca);
        }
        this.printWriter.print(")");
    }

    private class PSVisitor
    extends HierarchyEnumerator.Visitor {
        private PostScript outPS;

        public PSVisitor(PostScript outPS) {
            this.outPS = outPS;
        }

        public boolean enterCell(HierarchyEnumerator.CellInfo info) {
            AffineTransform xform = info.getTransformToRoot();
            Iterator it = info.getCell().getArcs();
            while (it.hasNext()) {
                ArcInst ai = (ArcInst)it.next();
                ArcProto ap = ai.getProto();
                Technology tech = ap.getTechnology();
                Poly[] polys = tech.getShapeOfArc(ai, this.outPS.wnd);
                for (int i = 0; i < polys.length; ++i) {
                    polys[i].transform(xform);
                    PostScript.this.psPoly(polys[i]);
                }
            }
            return true;
        }

        public void exitCell(HierarchyEnumerator.CellInfo info) {
        }

        public boolean visitNodeInst(Nodable no, HierarchyEnumerator.CellInfo info) {
            AffineTransform xform = info.getTransformToRoot();
            NodeInst ni = (NodeInst)no;
            NodeProto np = no.getProto();
            if (np instanceof PrimitiveNode) {
                AffineTransform trans = ni.rotateOut();
                PrimitiveNode prim = (PrimitiveNode)ni.getProto();
                Technology tech = prim.getTechnology();
                Poly[] polys = tech.getShapeOfNode(ni, this.outPS.wnd);
                for (int i = 0; i < polys.length; ++i) {
                    polys[i].transform(trans);
                    polys[i].transform(xform);
                    PostScript.this.psPoly(polys[i]);
                }
                return false;
            }
            if (!ni.isExpanded()) {
                Rectangle2D bounds = ni.getBounds();
                Poly poly = new Poly(bounds.getCenterX(), bounds.getCenterY(), ni.getXSize(), ni.getYSize());
                AffineTransform localPureTrans = ni.rotateOutAboutTrueCenter(xform);
                poly.transform(localPureTrans);
                poly.setStyle(Poly.Type.CLOSED);
                poly.setLayer(blackLayer);
                PostScript.this.psPoly(poly);
                poly.setStyle(Poly.Type.TEXTBOX);
                TextDescriptor td = TextDescriptor.getInstanceTextDescriptor(null);
                td.setAbsSize(24);
                poly.setTextDescriptor(td);
                poly.setString(ni.getProto().describe());
                PostScript.this.psPoly(poly);
                return false;
            }
            return true;
        }
    }
}

