/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.network;

import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.text.Name;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class Global {
    private Name name;
    private int index;
    private static Global[] allGlobals = new Global[0];
    private static PortCharacteristic[] globalsBuf;
    private static Map globalsByName;
    public static final Global ground;
    public static final Global power;

    private Global(Name name) {
        this.name = name;
        this.index = allGlobals.length;
        Global[] newGlobals = new Global[this.index + 1];
        PortCharacteristic[] newGlobalsBuf = new PortCharacteristic[this.index + 1];
        for (int i = 0; i < this.index; ++i) {
            newGlobals[i] = allGlobals[i];
            newGlobalsBuf[i] = globalsBuf[i];
        }
        newGlobals[this.index] = this;
        allGlobals = newGlobals;
        globalsBuf = newGlobalsBuf;
        globalsByName.put(name.lowerCase(), this);
    }

    public String getName() {
        return this.name.toString();
    }

    public Name getNameKey() {
        return this.name;
    }

    public String toString() {
        return "Global " + this.name;
    }

    public static Global newGlobal(String name) {
        Name nameKey = Name.findName(name);
        Global g = (Global)globalsByName.get(nameKey);
        if (g == null) {
            g = new Global(nameKey);
        }
        return g;
    }

    static void clearBuf() {
        Arrays.fill(globalsBuf, null);
    }

    static String addToBuf(Global g, PortCharacteristic characteristic) {
        String errorMsg = null;
        PortCharacteristic oldCharacteristic = globalsBuf[g.index];
        if (oldCharacteristic == null) {
            Global.globalsBuf[g.index] = characteristic;
        } else if (oldCharacteristic != characteristic) {
            errorMsg = g.getName() + "(" + oldCharacteristic.getName() + "->" + characteristic.getName() + ")";
        }
        return errorMsg;
    }

    static String addToBuf(Set set) {
        String errorMsg = null;
        for (int i = 0; i < set.elems.length; ++i) {
            int index = ((Set)set).elems[i].index;
            String msg = Global.addToBuf(allGlobals[index], set.elemMap[index]);
            if (msg == null) continue;
            if (errorMsg != null) {
                errorMsg = errorMsg + " ";
            }
            errorMsg = errorMsg + msg;
        }
        return errorMsg;
    }

    static Set getBuf() {
        return Set.newSet(Global.globalsBuf);
    }

    static {
        globalsByName = new HashMap();
        ground = Global.newGlobal("gnd");
        power = Global.newGlobal("vdd");
    }

    public static class Set
    implements Comparable {
        private PortCharacteristic[] elemMap;
        private Global[] elems;
        private int[] indexOf;
        private static Map allSets = new TreeMap();
        private static Set fakeSet = new Set(new PortCharacteristic[0]);
        public static final Set empty = Set.newSet(new PortCharacteristic[0]);

        private Set(PortCharacteristic[] elemMap) {
            int maxElem = -1;
            int numElem = 0;
            for (int i = 0; i < elemMap.length; ++i) {
                if (elemMap[i] == null) continue;
                maxElem = i;
                ++numElem;
            }
            this.elemMap = new PortCharacteristic[maxElem + 1];
            this.elems = new Global[numElem];
            this.indexOf = new int[maxElem + 1];
            Arrays.fill(this.indexOf, -1);
            ArrayList elemList = new ArrayList(numElem);
            int local = 0;
            for (int i = 0; i < elemMap.length; ++i) {
                if (elemMap[i] == null) continue;
                this.elemMap[i] = elemMap[i];
                this.elems[local] = allGlobals[i];
                this.indexOf[i] = local++;
            }
        }

        public final boolean contains(Global global) {
            return global.index < this.elemMap.length && this.elemMap[global.index] != null;
        }

        public PortCharacteristic getCharacteristic(Global global) {
            return global.index < this.elemMap.length ? this.elemMap[global.index] : null;
        }

        public final int size() {
            return this.elems.length;
        }

        public final Global get(int i) {
            return this.elems[i];
        }

        public final int indexOf(Global g) {
            return g.index < this.indexOf.length ? this.indexOf[g.index] : -1;
        }

        public final int maxElement() {
            return this.elemMap.length - 1;
        }

        public int compareTo(Set set) {
            int i;
            int minLen = Math.min(this.elemMap.length, set.elemMap.length);
            for (i = 0; i < minLen && this.elemMap[i] == set.elemMap[i]; ++i) {
            }
            if (i < minLen) {
                if (this.elemMap[i] == null) {
                    return -1;
                }
                if (set.elemMap[i] == null) {
                    return 1;
                }
                return this.elemMap[i].getOrder() - set.elemMap[i].getOrder();
            }
            while (i < this.elemMap.length) {
                if (this.elemMap[i] != null) {
                    return 1;
                }
                ++i;
            }
            while (i < set.elemMap.length) {
                if (set.elemMap[i] != null) {
                    return -1;
                }
                ++i;
            }
            return 0;
        }

        public int compareTo(Object o) {
            return this.compareTo((Set)o);
        }

        public String toString() {
            String s = "Global.Set {";
            for (int i = 0; i < this.elemMap.length; ++i) {
                if (this.elemMap[i] == null) continue;
                s = s + " " + allGlobals[i] + ":" + this.elemMap[i].getName();
            }
            s = s + "}";
            return s;
        }

        private static Set newSet(PortCharacteristic[] elemMap) {
            Set.fakeSet.elemMap = elemMap;
            Set set = (Set)allSets.get(fakeSet);
            Set.fakeSet.elemMap = null;
            if (set == null) {
                set = new Set(elemMap);
                allSets.put(set, set);
            }
            return set;
        }
    }
}

