/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.database.text.TextUtils;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;

public class DXFTab
extends PreferencePanel {
    private Layer artworkLayer;
    private String initialNames;
    private boolean initialInputFlattensHierarchy;
    private boolean initialInputReadsAllLayers;
    private int initialScale;
    private TextUtils.UnitScale[] scales;
    private JPanel dxf;
    private JCheckBox dxfInputFlattensHierarchy;
    private JCheckBox dxfInputReadsAllLayers;
    private JTextField dxfLayerName;
    private JComboBox dxfScale;
    private JLabel header;
    private JLabel jLabel1;
    private JLabel jLabel17;
    private JSeparator jSeparator1;

    public DXFTab(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public JPanel getPanel() {
        return this.dxf;
    }

    public String getName() {
        return "DXF";
    }

    public void init() {
        this.initialNames = "";
        this.artworkLayer = Artwork.tech.findLayer("Graphics");
        if (this.artworkLayer != null) {
            this.initialNames = this.artworkLayer.getDXFLayer();
            this.dxfLayerName.setText(this.initialNames);
        }
        this.initialScale = IOTool.getDXFScale();
        this.scales = TextUtils.UnitScale.getUnitScales();
        for (int i = 0; i < this.scales.length; ++i) {
            this.dxfScale.addItem(this.scales[i].getName() + "Meter");
        }
        this.dxfScale.setSelectedItem(TextUtils.UnitScale.findFromIndex(this.initialScale).getName() + "Meter");
        this.initialInputFlattensHierarchy = IOTool.isDXFInputFlattensHierarchy();
        this.dxfInputFlattensHierarchy.setSelected(this.initialInputFlattensHierarchy);
        this.initialInputReadsAllLayers = IOTool.isDXFInputReadsAllLayers();
        this.dxfInputReadsAllLayers.setSelected(this.initialInputReadsAllLayers);
    }

    public void term() {
        boolean currentInputReadsAllLayers;
        boolean currentInputFlattensHierarchy;
        int currentScaleIndex;
        int currentScale;
        String currentNames = this.dxfLayerName.getText();
        if (!currentNames.equals(this.initialNames)) {
            this.artworkLayer.setDXFLayer(currentNames);
        }
        if ((currentScale = this.scales[currentScaleIndex = this.dxfScale.getSelectedIndex()].getIndex()) != this.initialScale) {
            IOTool.setDXFScale(currentScale);
        }
        if ((currentInputFlattensHierarchy = this.dxfInputFlattensHierarchy.isSelected()) != this.initialInputFlattensHierarchy) {
            IOTool.setDXFInputFlattensHierarchy(currentInputFlattensHierarchy);
        }
        if ((currentInputReadsAllLayers = this.dxfInputReadsAllLayers.isSelected()) != this.initialInputReadsAllLayers) {
            IOTool.setDXFInputReadsAllLayers(currentInputReadsAllLayers);
        }
    }

    private void initComponents() {
        this.dxf = new JPanel();
        this.dxfLayerName = new JTextField();
        this.dxfInputFlattensHierarchy = new JCheckBox();
        this.dxfInputReadsAllLayers = new JCheckBox();
        this.jLabel17 = new JLabel();
        this.dxfScale = new JComboBox();
        this.header = new JLabel();
        this.jLabel1 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("IO Options");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                DXFTab.this.closeDialog(evt);
            }
        });
        this.dxf.setLayout(new GridBagLayout());
        this.dxfLayerName.setColumns(8);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.anchor = 11;
        this.dxf.add((Component)this.dxfLayerName, gridBagConstraints);
        this.dxfInputFlattensHierarchy.setText("Input flattens hierarchy");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.anchor = 18;
        this.dxf.add((Component)this.dxfInputFlattensHierarchy, gridBagConstraints);
        this.dxfInputReadsAllLayers.setText("Input reads all layers");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.anchor = 18;
        this.dxf.add((Component)this.dxfInputReadsAllLayers, gridBagConstraints);
        this.jLabel17.setText("DXF Scale:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.dxf.add((Component)this.jLabel17, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.dxf.add((Component)this.dxfScale, gridBagConstraints);
        this.header.setText("DXF Input will accpt all of these layers (separate layer names with a comma):");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.anchor = 17;
        this.dxf.add((Component)this.header, gridBagConstraints);
        this.jLabel1.setText("DXF Output will use the first layer in the list");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.anchor = 17;
        this.dxf.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.dxf.add((Component)this.jSeparator1, gridBagConstraints);
        this.getContentPane().add((Component)this.dxf, new GridBagConstraints());
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }
}

