/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class TextTab
extends PreferencePanel {
    private String initialTextFontName;
    private TextDescriptor initialTextNodeDescriptor;
    private TextDescriptor currentTextNodeDescriptor;
    private TextDescriptor initialTextArcDescriptor;
    private TextDescriptor currentTextArcDescriptor;
    private TextDescriptor initialTextExportDescriptor;
    private TextDescriptor currentTextExportDescriptor;
    private TextDescriptor initialTextAnnotationDescriptor;
    private TextDescriptor currentTextAnnotationDescriptor;
    private TextDescriptor initialTextInstanceDescriptor;
    private TextDescriptor currentTextInstanceDescriptor;
    private TextDescriptor initialTextCellDescriptor;
    private TextDescriptor currentTextCellDescriptor;
    private TextDescriptor currentTextDescriptor;
    private String initialTextNodeFont;
    private String initialTextArcFont;
    private String initialTextExportFont;
    private String initialTextAnnotationFont;
    private String initialTextInstanceFont;
    private String initialTextCellFont;
    private int initialTextSmartVertical;
    private int initialTextSmartHorizontal;
    private StringBuffer currentTextNodeFont;
    private StringBuffer currentTextArcFont;
    private StringBuffer currentTextExportFont;
    private StringBuffer currentTextAnnotationFont;
    private StringBuffer currentTextInstanceFont;
    private StringBuffer currentTextCellFont;
    private StringBuffer currentTextFont;
    private boolean textValuesChanging = false;
    private JPanel bottom;
    private JLabel jLabel4;
    private JLabel jLabel41;
    private JLabel jLabel42;
    private JLabel jLabel43;
    private JLabel jLabel44;
    private JLabel jLabel56;
    private JLabel jLabel57;
    private JLabel jLabel6;
    private JSeparator jSeparator1;
    private JSeparator jSeparator3;
    private JPanel middle;
    private JPanel text;
    private JComboBox textAnchor;
    private JRadioButton textAnnotation;
    private JRadioButton textArcs;
    private JCheckBox textBold;
    private JRadioButton textCellText;
    private JComboBox textDefaultFont;
    private JComboBox textFace;
    private ButtonGroup textHorizontalGroup;
    private JRadioButton textInstances;
    private JCheckBox textItalic;
    private JCheckBox textNewVisibleInsideCell;
    private JRadioButton textNodes;
    private JTextField textPointSize;
    private JRadioButton textPoints;
    private JRadioButton textPorts;
    private ButtonGroup textSizeGroup;
    private JRadioButton textSmartHorizontalInside;
    private JRadioButton textSmartHorizontalOff;
    private JRadioButton textSmartHorizontalOutside;
    private JRadioButton textSmartVerticalInside;
    private JRadioButton textSmartVerticalOff;
    private JRadioButton textSmartVerticalOutside;
    private ButtonGroup textTypeGroup;
    private JCheckBox textUnderline;
    private JTextField textUnitSize;
    private JRadioButton textUnits;
    private ButtonGroup textVerticalGroup;
    private JPanel top;

    public TextTab(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public JPanel getPanel() {
        return this.text;
    }

    public String getName() {
        return "Text";
    }

    public void init() {
        Iterator it = TextDescriptor.Position.getPositions();
        while (it.hasNext()) {
            TextDescriptor.Position pos = (TextDescriptor.Position)it.next();
            this.textAnchor.addItem(pos);
        }
        this.initialTextNodeDescriptor = TextDescriptor.getNodeTextDescriptor(null);
        this.initialTextArcDescriptor = TextDescriptor.getArcTextDescriptor(null);
        this.initialTextExportDescriptor = TextDescriptor.getExportTextDescriptor(null);
        this.initialTextAnnotationDescriptor = TextDescriptor.getAnnotationTextDescriptor(null);
        this.initialTextInstanceDescriptor = TextDescriptor.getInstanceTextDescriptor(null);
        this.initialTextCellDescriptor = TextDescriptor.getCellTextDescriptor(null);
        this.initialTextNodeFont = TextDescriptor.getNodeTextDescriptorFont();
        this.initialTextArcFont = TextDescriptor.getArcTextDescriptorFont();
        this.initialTextExportFont = TextDescriptor.getExportTextDescriptorFont();
        this.initialTextAnnotationFont = TextDescriptor.getAnnotationTextDescriptorFont();
        this.initialTextInstanceFont = TextDescriptor.getInstanceTextDescriptorFont();
        this.initialTextCellFont = TextDescriptor.getCellTextDescriptorFont();
        this.currentTextNodeDescriptor = TextDescriptor.getNodeTextDescriptor(null);
        this.currentTextArcDescriptor = TextDescriptor.getArcTextDescriptor(null);
        this.currentTextExportDescriptor = TextDescriptor.getExportTextDescriptor(null);
        this.currentTextAnnotationDescriptor = TextDescriptor.getAnnotationTextDescriptor(null);
        this.currentTextInstanceDescriptor = TextDescriptor.getInstanceTextDescriptor(null);
        this.currentTextCellDescriptor = TextDescriptor.getCellTextDescriptor(null);
        this.currentTextNodeFont = new StringBuffer(TextDescriptor.getNodeTextDescriptorFont());
        this.currentTextArcFont = new StringBuffer(TextDescriptor.getArcTextDescriptorFont());
        this.currentTextExportFont = new StringBuffer(TextDescriptor.getExportTextDescriptorFont());
        this.currentTextAnnotationFont = new StringBuffer(TextDescriptor.getAnnotationTextDescriptorFont());
        this.currentTextInstanceFont = new StringBuffer(TextDescriptor.getInstanceTextDescriptorFont());
        this.currentTextCellFont = new StringBuffer(TextDescriptor.getCellTextDescriptorFont());
        this.initialTextSmartVertical = User.getSmartVerticalPlacement();
        switch (this.initialTextSmartVertical) {
            case 0: {
                this.textSmartVerticalOff.setSelected(true);
                break;
            }
            case 1: {
                this.textSmartVerticalInside.setSelected(true);
                break;
            }
            case 2: {
                this.textSmartVerticalOutside.setSelected(true);
            }
        }
        this.initialTextSmartHorizontal = User.getSmartHorizontalPlacement();
        switch (this.initialTextSmartVertical) {
            case 0: {
                this.textSmartHorizontalOff.setSelected(true);
                break;
            }
            case 1: {
                this.textSmartHorizontalInside.setSelected(true);
                break;
            }
            case 2: {
                this.textSmartHorizontalOutside.setSelected(true);
            }
        }
        this.initialTextFontName = User.getDefaultFont();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] fontNames = ge.getAvailableFontFamilyNames();
        this.textFace.addItem("DEFAULT FONT");
        for (int i = 0; i < fontNames.length; ++i) {
            this.textDefaultFont.addItem(fontNames[i]);
            this.textFace.addItem(fontNames[i]);
        }
        this.textDefaultFont.setSelectedItem(this.initialTextFontName);
        this.textNodes.setSelected(true);
        this.textButtonChanged();
        this.textNodes.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextTab.this.textButtonChanged();
            }
        });
        this.textArcs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextTab.this.textButtonChanged();
            }
        });
        this.textPorts.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextTab.this.textButtonChanged();
            }
        });
        this.textAnnotation.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextTab.this.textButtonChanged();
            }
        });
        this.textInstances.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextTab.this.textButtonChanged();
            }
        });
        this.textCellText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextTab.this.textButtonChanged();
            }
        });
        this.textPoints.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextTab.this.textValuesChanged();
            }
        });
        this.textUnits.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextTab.this.textValuesChanged();
            }
        });
        this.textItalic.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextTab.this.textValuesChanged();
            }
        });
        this.textBold.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextTab.this.textValuesChanged();
            }
        });
        this.textUnderline.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextTab.this.textValuesChanged();
            }
        });
        this.textFace.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextTab.this.textValuesChanged();
            }
        });
        this.textAnchor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextTab.this.textValuesChanged();
            }
        });
        this.textNewVisibleInsideCell.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextTab.this.textValuesChanged();
            }
        });
        this.textPointSize.getDocument().addDocumentListener(new TextSizeDocumentListener(this));
        this.textUnitSize.getDocument().addDocumentListener(new TextSizeDocumentListener(this));
    }

    private void textValuesChanged() {
        if (this.textValuesChanging) {
            return;
        }
        if (this.textPoints.isSelected()) {
            int size = TextUtils.atoi(this.textPointSize.getText());
            this.currentTextDescriptor.setAbsSize(size);
        } else {
            double size = TextUtils.atof(this.textUnitSize.getText());
            this.currentTextDescriptor.setRelSize(size);
        }
        this.currentTextDescriptor.setItalic(this.textItalic.isSelected());
        this.currentTextDescriptor.setBold(this.textBold.isSelected());
        this.currentTextDescriptor.setUnderline(this.textUnderline.isSelected());
        this.currentTextDescriptor.setPos((TextDescriptor.Position)this.textAnchor.getSelectedItem());
        this.currentTextDescriptor.setInterior(this.textNewVisibleInsideCell.isSelected());
        int index = this.textFace.getSelectedIndex();
        int len = this.currentTextFont.length();
        this.currentTextFont.delete(0, len);
        if (index != 0) {
            this.currentTextFont.append((String)this.textFace.getSelectedItem());
        }
    }

    private void textButtonChanged() {
        this.currentTextDescriptor = null;
        if (this.textNodes.isSelected()) {
            this.currentTextDescriptor = this.currentTextNodeDescriptor;
            this.currentTextFont = this.currentTextNodeFont;
        } else if (this.textArcs.isSelected()) {
            this.currentTextDescriptor = this.currentTextArcDescriptor;
            this.currentTextFont = this.currentTextArcFont;
        } else if (this.textPorts.isSelected()) {
            this.currentTextDescriptor = this.currentTextExportDescriptor;
            this.currentTextFont = this.currentTextExportFont;
        } else if (this.textAnnotation.isSelected()) {
            this.currentTextDescriptor = this.currentTextAnnotationDescriptor;
            this.currentTextFont = this.currentTextAnnotationFont;
        } else if (this.textInstances.isSelected()) {
            this.currentTextDescriptor = this.currentTextInstanceDescriptor;
            this.currentTextFont = this.currentTextInstanceFont;
        } else if (this.textCellText.isSelected()) {
            this.currentTextDescriptor = this.currentTextCellDescriptor;
            this.currentTextFont = this.currentTextCellFont;
        }
        this.loadCurrentDescriptorInfo();
    }

    private void loadCurrentDescriptorInfo() {
        this.textValuesChanging = true;
        TextDescriptor.Size size = this.currentTextDescriptor.getSize();
        if (size.isAbsolute()) {
            this.textPoints.setSelected(true);
            this.textPointSize.setText(Integer.toString((int)size.getSize()));
            this.textUnitSize.setText("");
        } else {
            this.textUnits.setSelected(true);
            this.textUnitSize.setText(TextUtils.formatDouble(size.getSize()));
            this.textPointSize.setText("");
        }
        this.textItalic.setSelected(this.currentTextDescriptor.isItalic());
        this.textBold.setSelected(this.currentTextDescriptor.isBold());
        this.textUnderline.setSelected(this.currentTextDescriptor.isUnderline());
        this.textAnchor.setSelectedItem(this.currentTextDescriptor.getPos());
        this.textValuesChanging = false;
        this.textNewVisibleInsideCell.setSelected(this.currentTextDescriptor.isInterior());
        if (this.currentTextFont.length() == 0) {
            this.textFace.setSelectedIndex(0);
        } else {
            this.textFace.setSelectedItem(this.currentTextFont.toString());
        }
    }

    public void term() {
        String currentFontName = (String)this.textDefaultFont.getSelectedItem();
        if (!currentFontName.equalsIgnoreCase(this.initialTextFontName)) {
            User.setDefaultFont(currentFontName);
        }
        if (!this.currentTextNodeDescriptor.compare(this.initialTextNodeDescriptor)) {
            TextDescriptor.setNodeTextDescriptor(this.currentTextNodeDescriptor);
        }
        if (!this.currentTextArcDescriptor.compare(this.initialTextArcDescriptor)) {
            TextDescriptor.setArcTextDescriptor(this.currentTextArcDescriptor);
        }
        if (!this.currentTextExportDescriptor.compare(this.initialTextExportDescriptor)) {
            TextDescriptor.setExportTextDescriptor(this.currentTextExportDescriptor);
        }
        if (!this.currentTextAnnotationDescriptor.compare(this.initialTextAnnotationDescriptor)) {
            TextDescriptor.setAnnotationTextDescriptor(this.currentTextAnnotationDescriptor);
        }
        if (!this.currentTextInstanceDescriptor.compare(this.initialTextInstanceDescriptor)) {
            TextDescriptor.setInstanceTextDescriptor(this.currentTextInstanceDescriptor);
        }
        if (!this.currentTextCellDescriptor.compare(this.initialTextCellDescriptor)) {
            TextDescriptor.setCellTextDescriptor(this.currentTextCellDescriptor);
        }
        if (!this.currentTextNodeFont.toString().equals(this.initialTextNodeFont)) {
            TextDescriptor.setNodeTextDescriptorFont(this.currentTextNodeFont.toString());
        }
        if (!this.currentTextArcFont.toString().equals(this.initialTextArcFont)) {
            TextDescriptor.setArcTextDescriptorFont(this.currentTextArcFont.toString());
        }
        if (!this.currentTextExportFont.toString().equals(this.initialTextExportFont)) {
            TextDescriptor.setExportTextDescriptorFont(this.currentTextExportFont.toString());
        }
        if (!this.currentTextAnnotationFont.toString().equals(this.initialTextAnnotationFont)) {
            TextDescriptor.setAnnotationTextDescriptorFont(this.currentTextAnnotationFont.toString());
        }
        if (!this.currentTextInstanceFont.toString().equals(this.initialTextInstanceFont)) {
            TextDescriptor.setInstanceTextDescriptorFont(this.currentTextInstanceFont.toString());
        }
        if (!this.currentTextCellFont.toString().equals(this.initialTextCellFont)) {
            TextDescriptor.setCellTextDescriptorFont(this.currentTextCellFont.toString());
        }
        int currentSmartVertical = 0;
        if (this.textSmartVerticalInside.isSelected()) {
            currentSmartVertical = 1;
        } else if (this.textSmartVerticalOutside.isSelected()) {
            currentSmartVertical = 2;
        }
        if (currentSmartVertical != this.initialTextSmartVertical) {
            User.setSmartVerticalPlacement(currentSmartVertical);
        }
        int currentSmartHorizontal = 0;
        if (this.textSmartHorizontalInside.isSelected()) {
            currentSmartHorizontal = 1;
        } else if (this.textSmartHorizontalOutside.isSelected()) {
            currentSmartHorizontal = 2;
        }
        if (currentSmartHorizontal != this.initialTextSmartHorizontal) {
            User.setSmartHorizontalPlacement(currentSmartHorizontal);
        }
    }

    private void initComponents() {
        this.textSizeGroup = new ButtonGroup();
        this.textTypeGroup = new ButtonGroup();
        this.textVerticalGroup = new ButtonGroup();
        this.textHorizontalGroup = new ButtonGroup();
        this.text = new JPanel();
        this.top = new JPanel();
        this.jLabel41 = new JLabel();
        this.textNodes = new JRadioButton();
        this.textArcs = new JRadioButton();
        this.textPorts = new JRadioButton();
        this.textAnnotation = new JRadioButton();
        this.textInstances = new JRadioButton();
        this.textCellText = new JRadioButton();
        this.jLabel42 = new JLabel();
        this.textPointSize = new JTextField();
        this.textUnitSize = new JTextField();
        this.jLabel43 = new JLabel();
        this.textFace = new JComboBox();
        this.textItalic = new JCheckBox();
        this.textBold = new JCheckBox();
        this.textUnderline = new JCheckBox();
        this.textPoints = new JRadioButton();
        this.textUnits = new JRadioButton();
        this.jSeparator3 = new JSeparator();
        this.jLabel4 = new JLabel();
        this.jLabel6 = new JLabel();
        this.textAnchor = new JComboBox();
        this.textNewVisibleInsideCell = new JCheckBox();
        this.middle = new JPanel();
        this.jLabel44 = new JLabel();
        this.textDefaultFont = new JComboBox();
        this.bottom = new JPanel();
        this.jLabel56 = new JLabel();
        this.textSmartVerticalOff = new JRadioButton();
        this.textSmartVerticalInside = new JRadioButton();
        this.textSmartVerticalOutside = new JRadioButton();
        this.jLabel57 = new JLabel();
        this.textSmartHorizontalOff = new JRadioButton();
        this.textSmartHorizontalInside = new JRadioButton();
        this.textSmartHorizontalOutside = new JRadioButton();
        this.jSeparator1 = new JSeparator();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Edit Options");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                TextTab.this.closeDialog(evt);
            }
        });
        this.text.setLayout(new GridBagLayout());
        this.top.setLayout(new GridBagLayout());
        this.top.setBorder(new TitledBorder("Default Text Style"));
        this.jLabel41.setText("Which type of text:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.top.add((Component)this.jLabel41, gridBagConstraints);
        this.textNodes.setText("Nodes");
        this.textTypeGroup.add(this.textNodes);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.top.add((Component)this.textNodes, gridBagConstraints);
        this.textArcs.setText("Arcs");
        this.textTypeGroup.add(this.textArcs);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.top.add((Component)this.textArcs, gridBagConstraints);
        this.textPorts.setText("Exports/Ports");
        this.textTypeGroup.add(this.textPorts);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.top.add((Component)this.textPorts, gridBagConstraints);
        this.textAnnotation.setText("Annotation text");
        this.textTypeGroup.add(this.textAnnotation);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.top.add((Component)this.textAnnotation, gridBagConstraints);
        this.textInstances.setText("Instance names");
        this.textTypeGroup.add(this.textInstances);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.top.add((Component)this.textInstances, gridBagConstraints);
        this.textCellText.setText("Cell text");
        this.textTypeGroup.add(this.textCellText);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.top.add((Component)this.textCellText, gridBagConstraints);
        this.jLabel42.setText("Size:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.top.add((Component)this.jLabel42, gridBagConstraints);
        this.textPointSize.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.top.add((Component)this.textPointSize, gridBagConstraints);
        this.textUnitSize.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.top.add((Component)this.textUnitSize, gridBagConstraints);
        this.jLabel43.setText("Font::");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.top.add((Component)this.jLabel43, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.top.add((Component)this.textFace, gridBagConstraints);
        this.textItalic.setText("Italic");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.top.add((Component)this.textItalic, gridBagConstraints);
        this.textBold.setText("Bold");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.top.add((Component)this.textBold, gridBagConstraints);
        this.textUnderline.setText("Underline");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.top.add((Component)this.textUnderline, gridBagConstraints);
        this.textPoints.setText("Points (max 63)");
        this.textSizeGroup.add(this.textPoints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.top.add((Component)this.textPoints, gridBagConstraints);
        this.textUnits.setText("Units (max 127.75)");
        this.textSizeGroup.add(this.textUnits);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.top.add((Component)this.textUnits, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.top.add((Component)this.jSeparator3, gridBagConstraints);
        this.jLabel4.setText("Default style:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.top.add((Component)this.jLabel4, gridBagConstraints);
        this.jLabel6.setText("Anchor:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.top.add((Component)this.jLabel6, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.top.add((Component)this.textAnchor, gridBagConstraints);
        this.textNewVisibleInsideCell.setText("Invisible outside cell");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.top.add((Component)this.textNewVisibleInsideCell, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.text.add((Component)this.top, gridBagConstraints);
        this.middle.setLayout(new GridBagLayout());
        this.jLabel44.setText("Default font:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.middle.add((Component)this.jLabel44, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.middle.add((Component)this.textDefaultFont, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.text.add((Component)this.middle, gridBagConstraints);
        this.bottom.setLayout(new GridBagLayout());
        this.bottom.setBorder(new TitledBorder("Smart Placement of Export Text"));
        this.jLabel56.setText("Vertical");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.bottom.add((Component)this.jLabel56, gridBagConstraints);
        this.textSmartVerticalOff.setText("Off");
        this.textVerticalGroup.add(this.textSmartVerticalOff);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.bottom.add((Component)this.textSmartVerticalOff, gridBagConstraints);
        this.textSmartVerticalInside.setText("Inside");
        this.textVerticalGroup.add(this.textSmartVerticalInside);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.bottom.add((Component)this.textSmartVerticalInside, gridBagConstraints);
        this.textSmartVerticalOutside.setText("Outside");
        this.textVerticalGroup.add(this.textSmartVerticalOutside);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.bottom.add((Component)this.textSmartVerticalOutside, gridBagConstraints);
        this.jLabel57.setText("Horizontal");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.bottom.add((Component)this.jLabel57, gridBagConstraints);
        this.textSmartHorizontalOff.setText("Off");
        this.textHorizontalGroup.add(this.textSmartHorizontalOff);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.bottom.add((Component)this.textSmartHorizontalOff, gridBagConstraints);
        this.textSmartHorizontalInside.setText("Inside");
        this.textHorizontalGroup.add(this.textSmartHorizontalInside);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.bottom.add((Component)this.textSmartHorizontalInside, gridBagConstraints);
        this.textSmartHorizontalOutside.setText("Outside");
        this.textHorizontalGroup.add(this.textSmartHorizontalOutside);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.bottom.add((Component)this.textSmartHorizontalOutside, gridBagConstraints);
        this.jSeparator1.setOrientation(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        this.bottom.add((Component)this.jSeparator1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        this.text.add((Component)this.bottom, gridBagConstraints);
        this.getContentPane().add((Component)this.text, new GridBagConstraints());
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private static class TextSizeDocumentListener
    implements DocumentListener {
        TextTab dialog;

        TextSizeDocumentListener(TextTab dialog) {
            this.dialog = dialog;
        }

        public void changedUpdate(DocumentEvent e) {
            this.dialog.textValuesChanged();
        }

        public void insertUpdate(DocumentEvent e) {
            this.dialog.textValuesChanged();
        }

        public void removeUpdate(DocumentEvent e) {
            this.dialog.textValuesChanged();
        }
    }
}

