/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.variable;

import com.sun.electric.database.change.Undo;
import com.sun.electric.database.geometry.Geometric;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ImmutableTextDescriptor;
import com.sun.electric.database.variable.MutableTextDescriptor;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.ActivityLogger;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.ui.EditWindow;
import java.awt.Font;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;

public abstract class ElectricObject {
    private TreeMap vars;
    private static final HashMap varKeys = new HashMap();
    private static final HashMap varLowCaseKeys = new HashMap();
    private static int debugGetParameterRecurse = 0;
    private static int debugGetParametersRecurse = 0;

    protected ElectricObject() {
    }

    public abstract boolean isLinked();

    public Variable getVar(String name) {
        Variable.Key key = ElectricObject.findKey(name);
        return this.getVar(key, null);
    }

    public Variable getVar(Variable.Key key) {
        return this.getVar(key, null);
    }

    public Variable getVar(String name, Class type) {
        Variable.Key key = ElectricObject.findKey(name);
        return this.getVar(key, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Variable getVar(Variable.Key key, Class type) {
        Variable var;
        this.checkExamine();
        if (key == null) {
            return null;
        }
        ElectricObject electricObject = this;
        synchronized (electricObject) {
            if (this.vars == null) {
                return null;
            }
            var = (Variable)this.vars.get(key);
        }
        if (var != null) {
            if (type == null) {
                return var;
            }
            if (type.isInstance(var.getObject())) {
                return var;
            }
        }
        return null;
    }

    public ImmutableTextDescriptor getTextDescriptor(String varName) {
        Variable var = this.getVar(varName);
        if (var == null) {
            return null;
        }
        return var.getTextDescriptor();
    }

    public MutableTextDescriptor getMutableTextDescriptor(String varName) {
        ImmutableTextDescriptor td = this.getTextDescriptor(varName);
        if (td == null) {
            return null;
        }
        return new MutableTextDescriptor(td);
    }

    public ImmutableTextDescriptor lowLevelSetTextDescriptor(String varName, ImmutableTextDescriptor td) {
        Variable var = this.getVar(varName);
        if (var == null) {
            throw new IllegalArgumentException("TextDescriptor with name " + varName + " not found on " + this);
        }
        return var.lowLevelSetTextDescriptor(td);
    }

    public Variable getParameter(String name) {
        if (debugGetParameterRecurse > 3) {
            ActivityLogger.logException(new Exception("GetParameter recurse error: " + debugGetParameterRecurse));
        }
        ++debugGetParameterRecurse;
        Variable.Key key = ElectricObject.findKey(name);
        if (key == null) {
            --debugGetParameterRecurse;
            return null;
        }
        Variable var = this.getVar(key, null);
        if (var != null && var.isParam()) {
            --debugGetParameterRecurse;
            return var;
        }
        ElectricObject defOwner = this.getVarDefaultOwner();
        if (defOwner == null) {
            --debugGetParameterRecurse;
            return null;
        }
        if (defOwner == this) {
            --debugGetParameterRecurse;
            return null;
        }
        Variable var2 = defOwner.getParameter(name);
        --debugGetParameterRecurse;
        return var2;
    }

    public Iterator getParameters() {
        if (debugGetParametersRecurse > 3) {
            ActivityLogger.logException(new Exception("GetParameters recurse error: " + debugGetParametersRecurse));
        }
        ++debugGetParametersRecurse;
        TreeMap<Variable.Key, Variable> keysToVars = new TreeMap<Variable.Key, Variable>();
        Iterator it = this.getVariables();
        while (it.hasNext()) {
            Variable v = (Variable)it.next();
            if (!v.isParam()) continue;
            keysToVars.put(v.getKey(), v);
        }
        ElectricObject defOwner = this.getVarDefaultOwner();
        if (defOwner == null) {
            --debugGetParametersRecurse;
            return keysToVars.values().iterator();
        }
        if (defOwner == this) {
            --debugGetParametersRecurse;
            return keysToVars.values().iterator();
        }
        Iterator it2 = defOwner.getParameters();
        while (it2.hasNext()) {
            Variable v = (Variable)it2.next();
            if (keysToVars.get(v.getKey()) != null) continue;
            keysToVars.put(v.getKey(), v);
        }
        --debugGetParametersRecurse;
        return keysToVars.values().iterator();
    }

    public ElectricObject getVarDefaultOwner() {
        return this;
    }

    public int numDisplayableVariables(boolean multipleStrings) {
        int numVars = 0;
        Iterator it = this.getVariables();
        while (it.hasNext()) {
            Variable var = (Variable)it.next();
            if (!var.isDisplay()) continue;
            int len = var.getLength();
            if (len > 1 && var.getTextDescriptor().getDispPart() == TextDescriptor.DispPos.NAMEVALUE) {
                ++len;
            }
            if (!multipleStrings) {
                len = 1;
            }
            numVars += len;
        }
        return numVars;
    }

    public void checkPossibleVariableEffects(Variable.Key key) {
    }

    public int addDisplayableVariables(Rectangle2D rect, Poly[] polys, int start, EditWindow wnd, boolean multipleStrings) {
        this.checkExamine();
        int numAddedVariables = 0;
        double cX = rect.getCenterX();
        double cY = rect.getCenterY();
        Iterator it = this.getVariables();
        while (it.hasNext()) {
            Variable var = (Variable)it.next();
            if (!var.isDisplay()) continue;
            Poly[] polyList = this.getPolyList(var, cX, cY, wnd, multipleStrings);
            for (int i = 0; i < polyList.length; ++i) {
                int index = start + numAddedVariables;
                polys[index] = polyList[i];
                polys[index].setStyle(Poly.rotateType(polys[index].getStyle(), this));
                ++numAddedVariables;
            }
        }
        return numAddedVariables;
    }

    public Poly computeTextPoly(EditWindow wnd, Variable var, Name name) {
        this.checkExamine();
        Poly poly = null;
        if (var != null) {
            Cell cell;
            Poly[] polys;
            if (this instanceof Export) {
                Export pp = (Export)this;
                PortInst pi = pp.getOriginalPort();
                Rectangle2D bounds = pi.getPoly().getBounds2D();
                Poly[] polys2 = pp.getPolyList(var, bounds.getCenterX(), bounds.getCenterY(), wnd, false);
                if (polys2.length > 0) {
                    poly = polys2[0];
                    poly.transform(pi.getNodeInst().rotateOut());
                }
            } else if (this instanceof PortInst) {
                PortInst pi = (PortInst)this;
                Rectangle2D bounds = pi.getPoly().getBounds2D();
                Poly[] polys3 = pi.getPolyList(var, bounds.getCenterX(), bounds.getCenterY(), wnd, false);
                if (polys3.length > 0) {
                    poly = polys3[0];
                    poly.transform(pi.getNodeInst().rotateOut());
                }
            } else if (this instanceof Geometric) {
                Poly[] polys4;
                Geometric geom = (Geometric)this;
                double x = geom.getTrueCenterX();
                double y = geom.getTrueCenterY();
                if (geom instanceof NodeInst) {
                    NodeInst ni = (NodeInst)geom;
                    Rectangle2D uBounds = ni.getUntransformedBounds();
                    x = uBounds.getCenterX();
                    y = uBounds.getCenterY();
                }
                if ((polys4 = geom.getPolyList(var, x, y, wnd, false)).length > 0) {
                    poly = polys4[0];
                    if (geom instanceof NodeInst) {
                        NodeInst ni = (NodeInst)geom;
                        poly.transform(ni.rotateOut());
                    }
                }
            } else if (this instanceof Cell && (polys = (cell = (Cell)this).getPolyList(var, 0.0, 0.0, wnd, false)).length > 0) {
                poly = polys[0];
            }
        } else if (name != null) {
            if (!(this instanceof Geometric)) {
                return null;
            }
            Geometric geom = (Geometric)this;
            ImmutableTextDescriptor td = geom.getTextDescriptor(this instanceof NodeInst ? NodeInst.NODE_NAME_TD : ArcInst.ARC_NAME_TD);
            Poly.Type style = td.getPos().getPolyType();
            Point2D[] pointList = null;
            pointList = style == Poly.Type.TEXTBOX ? Poly.makePoints(geom.getBounds()) : new Point2D.Double[]{new Point2D.Double(geom.getTrueCenterX() + td.getXOff(), geom.getTrueCenterY() + td.getYOff())};
            poly = new Poly(pointList);
            poly.setStyle(style);
            if (geom instanceof NodeInst) {
                poly.transform(((NodeInst)geom).rotateOutAboutTrueCenter());
            }
            poly.setTextDescriptor(td);
            poly.setString(name.toString());
        } else if (this instanceof Export) {
            Export pp = (Export)this;
            poly = pp.getNamePoly();
        } else {
            if (!(this instanceof NodeInst)) {
                return null;
            }
            NodeInst ni = (NodeInst)this;
            ImmutableTextDescriptor td = ni.getTextDescriptor(NodeInst.NODE_PROTO_TD);
            Poly.Type style = td.getPos().getPolyType();
            Point2D[] pointList = null;
            pointList = style == Poly.Type.TEXTBOX ? Poly.makePoints(ni.getBounds()) : new Point2D.Double[]{new Point2D.Double(ni.getTrueCenterX() + td.getXOff(), ni.getTrueCenterY() + td.getYOff())};
            poly = new Poly(pointList);
            poly.setStyle(style);
            poly.setTextDescriptor(td);
            poly.setString(ni.getProto().describe(false));
        }
        if (poly != null) {
            poly.setExactTextBounds(wnd, this);
        }
        return poly;
    }

    public Poly[] getPolyList(Variable var, double cX, double cY, EditWindow wnd, boolean multipleStrings) {
        double offX = var.getXOff();
        double offY = var.getYOff();
        int varLength = var.getLength();
        double height = 0.0;
        Poly.Type style = var.getPos().getPolyType();
        TextDescriptor td = var.getTextDescriptor();
        if (this instanceof NodeInst && (offX != 0.0 || offY != 0.0)) {
            MutableTextDescriptor mtd = new MutableTextDescriptor(td);
            mtd.setOff(0.0, 0.0);
            td = mtd;
        }
        boolean headerString = false;
        Font font = null;
        double scale = 1.0;
        if (wnd != null) {
            font = wnd.getFont(td);
            scale = wnd.getScale();
        }
        if (varLength > 1) {
            height = font == null ? 1.0 / scale : (double)font.getSize2D() / scale;
            scale *= User.getGlobalTextScale();
            if (td.getDispPart() == TextDescriptor.DispPos.NAMEVALUE) {
                headerString = true;
                ++varLength;
            }
            if (multipleStrings) {
                if (style == Poly.Type.TEXTCENT || style == Poly.Type.TEXTBOX || style == Poly.Type.TEXTLEFT || style == Poly.Type.TEXTRIGHT) {
                    cY += height * (double)(varLength - 1) / 2.0;
                }
                if (style == Poly.Type.TEXTBOT || style == Poly.Type.TEXTBOTLEFT || style == Poly.Type.TEXTBOTRIGHT) {
                    cY += height * (double)(varLength - 1);
                }
            } else {
                if (style == Poly.Type.TEXTCENT || style == Poly.Type.TEXTBOX || style == Poly.Type.TEXTLEFT || style == Poly.Type.TEXTRIGHT) {
                    cY -= height * (double)(varLength - 1) / 2.0;
                }
                if (style == Poly.Type.TEXTTOP || style == Poly.Type.TEXTTOPLEFT || style == Poly.Type.TEXTTOPRIGHT) {
                    cY -= height * (double)(varLength - 1);
                }
                varLength = 1;
                headerString = false;
            }
        }
        Poly[] polys = new Poly[varLength];
        for (int i = 0; i < varLength; ++i) {
            String message = null;
            VarContext context = null;
            if (wnd != null) {
                context = wnd.getVarContext();
            }
            TextDescriptor entryTD = td;
            if (varLength > 1 && headerString) {
                if (i == 0) {
                    message = var.getTrueName() + "[" + (varLength - 1) + "]:";
                    MutableTextDescriptor mtd = new MutableTextDescriptor(td);
                    mtd.setUnderline(true);
                    entryTD = mtd;
                } else {
                    message = var.describe(i - 1, context, this);
                }
            } else {
                message = var.describe(i, context, this);
            }
            Point2D[] pointList = null;
            if (style == Poly.Type.TEXTBOX && this instanceof Geometric) {
                Geometric geom = (Geometric)this;
                Rectangle2D bounds = geom.getBounds();
                pointList = Poly.makePoints(bounds);
            } else if (font == null) {
                double fakeWidth = (double)message.length() * entryTD.getTrueSize(wnd) * 0.75 / scale;
                pointList = new Point2D.Double[]{new Point2D.Double(cX + offX - fakeWidth / 2.0, cY + offY), new Point2D.Double(cX + offX + fakeWidth / 2.0, cY + offY)};
            } else {
                pointList = new Point2D.Double[]{new Point2D.Double(cX + offX, cY + offY)};
            }
            polys[i] = new Poly(pointList);
            if (font == null) {
                polys[i].setStyle(Poly.Type.OPENED);
            } else {
                polys[i].setString(message);
                polys[i].setStyle(style);
                polys[i].setTextDescriptor(entryTD);
            }
            polys[i].setVariable(var);
            polys[i].setLayer(null);
            cY -= height;
        }
        return polys;
    }

    public Variable newVar(String name, Object value) {
        return this.newVar(ElectricObject.newKey(name), value);
    }

    public Variable newDisplayVar(Variable.Key key, Object value) {
        return this.newVar(key, value, true);
    }

    public Variable newVar(Variable.Key key, Object value) {
        return this.newVar(key, value, false);
    }

    public Variable newVar(Variable.Key key, Object value, boolean display) {
        ImmutableTextDescriptor td = null;
        td = this instanceof Cell ? TextDescriptor.cacheCellDescriptor.newTextDescriptor(display) : (this instanceof Export ? TextDescriptor.cacheExportDescriptor.newTextDescriptor(display) : (this instanceof NodeInst ? TextDescriptor.cacheNodeDescriptor.newTextDescriptor(display) : (this instanceof ArcInst ? TextDescriptor.cacheArcDescriptor.newTextDescriptor(display) : TextDescriptor.cacheAnnotationDescriptor.newTextDescriptor(display))));
        return this.newVar(key, value, td);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Variable newVar(Variable.Key key, Object value, TextDescriptor td) {
        Variable oldVar;
        if (this.isDeprecatedVariable(key)) {
            System.out.println("Deprecated variable " + key.getName() + " on " + this);
        }
        this.checkChanging();
        ElectricObject electricObject = this;
        synchronized (electricObject) {
            if (this.vars == null) {
                this.vars = new TreeMap();
            }
            oldVar = (Variable)this.vars.get(key);
        }
        if (oldVar != null) {
            this.lowLevelUnlinkVar(oldVar);
            if (this.isDatabaseObject()) {
                Undo.killVariable(this, oldVar);
            }
        }
        Variable v = new Variable(this, value, td, key);
        this.lowLevelLinkVar(v);
        if (this.isDatabaseObject()) {
            Undo.newVariable(this, v);
        }
        return v;
    }

    public Variable updateVar(String name, Object value) {
        return this.updateVar(ElectricObject.newKey(name), value);
    }

    public Variable updateVar(Variable.Key key, Object value) {
        Variable var = this.getVar(key);
        if (var == null) {
            return this.newVar(key, value);
        }
        Variable newVar = this.newVar(key, value, var.getTextDescriptor());
        if (newVar == null) {
            return null;
        }
        this.lowLevelModVar(var);
        return newVar;
    }

    public void setTextDescriptor(String varName, TextDescriptor td) {
        this.checkChanging();
        ImmutableTextDescriptor oldDescriptor = this.lowLevelSetTextDescriptor(varName, ImmutableTextDescriptor.newImmutableTextDescriptor(td));
        Undo.modifyTextDescript(this, varName, oldDescriptor);
    }

    public synchronized void setOff(String varName, double xd, double yd) {
        MutableTextDescriptor td = this.getMutableTextDescriptor(varName);
        if (td == null) {
            return;
        }
        td.setOff(xd, yd);
        this.setTextDescriptor(varName, td);
    }

    public void copyTextDescriptorFrom(ElectricObject other, String varName) {
        ImmutableTextDescriptor td = other.getTextDescriptor(varName);
        if (td == null) {
            return;
        }
        this.setTextDescriptor(varName, td);
    }

    public Variable renameVar(String name, String newName) {
        return this.renameVar(ElectricObject.findKey(name), newName);
    }

    public Variable renameVar(Variable.Key key, String newName) {
        Variable var = this.getVar(newName);
        if (var != null) {
            return null;
        }
        Variable oldvar = this.getVar(key);
        if (oldvar == null) {
            return null;
        }
        Variable newVar = this.newVar(ElectricObject.newKey(newName), oldvar.getObject(), oldvar.getTextDescriptor());
        if (newVar == null) {
            return null;
        }
        this.delVar(oldvar.getKey());
        return newVar;
    }

    public void delVar(Variable.Key key) {
        this.checkChanging();
        Variable v = this.getVar(key);
        if (v == null) {
            return;
        }
        this.lowLevelUnlinkVar(v);
        if (this.isDatabaseObject()) {
            Undo.killVariable(this, v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lowLevelLinkVar(Variable var) {
        ElectricObject electricObject = this;
        synchronized (electricObject) {
            this.vars.put(var.getKey(), var);
        }
        var.setLinked(true);
        this.checkPossibleVariableEffects(var.getKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lowLevelUnlinkVar(Variable var) {
        ElectricObject electricObject = this;
        synchronized (electricObject) {
            this.vars.remove(var.getKey());
        }
        var.setLinked(false);
        this.checkPossibleVariableEffects(var.getKey());
    }

    public void lowLevelModVar(Variable var) {
        this.checkPossibleVariableEffects(var.getKey());
    }

    public void setVar(Variable.Key key, Object value, int index) {
        this.checkChanging();
        Variable v = this.getVar(key);
        if (v == null) {
            return;
        }
        Object addr = v.getObject();
        if (addr instanceof Object[]) {
            Object[] arr = (Object[])addr;
            Object oldVal = arr[index];
            arr[index] = value;
            if (this.isDatabaseObject()) {
                Undo.modifyVariable(this, v, index, oldVal);
            }
        }
        this.lowLevelModVar(v);
    }

    public void insertInVar(Variable.Key key, int index, Object value) {
        this.checkChanging();
        Variable v = this.getVar(key);
        if (v == null) {
            return;
        }
        Object addr = v.getObject();
        if (addr instanceof Object[]) {
            v.lowLevelInsert(index, value);
            if (this.isDatabaseObject()) {
                Undo.insertVariable(this, v, index);
            }
        }
        this.lowLevelModVar(v);
    }

    public void deleteFromVar(Variable.Key key, int index) {
        this.checkChanging();
        Variable v = this.getVar(key);
        if (v == null) {
            return;
        }
        Object addr = v.getObject();
        if (addr instanceof Object[]) {
            Object oldVal = ((Object[])addr)[index];
            v.lowLevelDelete(index);
            if (this.isDatabaseObject()) {
                Undo.deleteVariable(this, v, index, oldVal);
            }
        }
        this.lowLevelModVar(v);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyVarsFrom(ElectricObject other) {
        this.checkChanging();
        Iterator it = other.getVariables();
        ElectricObject electricObject = this;
        synchronized (electricObject) {
            while (it.hasNext()) {
                Variable var = (Variable)it.next();
                Variable newVar = this.newVar(var.getKey(), var.getObject(), var.getTextDescriptor());
                if (newVar == null) continue;
            }
        }
    }

    public static String uniqueObjectName(String name, Cell cell, Class cls) {
        int minusMinusPos;
        if (cell.isUniqueName(name, cls, null)) {
            return name;
        }
        int plusPlusPos = name.indexOf("++");
        if (plusPlusPos >= 0) {
            int numStart;
            for (numStart = plusPlusPos; numStart > 0 && TextUtils.isDigit(name.charAt(numStart - 1)); --numStart) {
            }
            if (numStart < plusPlusPos) {
                int nextIndex = TextUtils.atoi(name.substring(numStart)) + 1;
                while (true) {
                    String newname;
                    if (cell.isUniqueName(newname = name.substring(0, numStart) + nextIndex + name.substring(plusPlusPos), cls, null)) {
                        return newname;
                    }
                    ++nextIndex;
                }
            }
        }
        if ((minusMinusPos = name.indexOf("--")) >= 0) {
            int numStart;
            for (numStart = minusMinusPos; numStart > 0 && TextUtils.isDigit(name.charAt(numStart - 1)); --numStart) {
            }
            if (numStart < minusMinusPos) {
                for (int nextIndex = TextUtils.atoi(name.substring(numStart)) - 1; nextIndex >= 0; --nextIndex) {
                    String newname = name.substring(0, numStart) + nextIndex + name.substring(minusMinusPos);
                    if (!cell.isUniqueName(newname, cls, null)) continue;
                    return newname;
                }
            }
        }
        char separateChar = '_';
        ArrayList<ArrayName> names = new ArrayList<ArrayName>();
        boolean inBracket = false;
        int len = name.length();
        int startOfBase = 0;
        int startOfIndex = -1;
        for (int i = 0; i < len; ++i) {
            char ch = name.charAt(i);
            if (ch == '[') {
                if (startOfIndex < 0) {
                    startOfIndex = i;
                }
                inBracket = true;
            }
            if (ch == ']') {
                inBracket = false;
            }
            if ((ch != ',' || inBracket) && i != len - 1) continue;
            if (i == len - 1) {
                ++i;
            }
            ArrayName an = new ArrayName();
            int endOfBase = startOfIndex;
            if (endOfBase < 0) {
                endOfBase = i;
            }
            an.baseName = name.substring(startOfBase, endOfBase);
            if (startOfIndex >= 0) {
                an.indexPart = name.substring(startOfIndex, i);
            }
            names.add(an);
            startOfBase = i + 1;
            startOfIndex = -1;
        }
        Iterator it = names.iterator();
        while (it.hasNext()) {
            int startPos;
            ArrayName an = (ArrayName)it.next();
            boolean indexAdjusted = false;
            String index = an.indexPart;
            if (index != null) {
                int startPos2;
                int possibleEnd = 0;
                int nameLen = index.length();
                int possibleStart = -1;
                int endPos = nameLen - 1;
                while ((startPos2 = index.lastIndexOf(91, endPos)) >= 0) {
                    int i = index.indexOf(44, startPos2);
                    if (i >= 0 && i < endPos) {
                        if (startPos2 <= 0 || index.charAt(startPos2 - 1) != ']') break;
                        endPos = startPos2 - 1;
                        continue;
                    }
                    i = index.indexOf(58, startPos2);
                    if (i >= 0 && i < endPos) {
                        String firstIndex = index.substring(startPos2 + 1, i);
                        String secondIndex = index.substring(i + 1, endPos);
                        if (TextUtils.isANumber(firstIndex) && TextUtils.isANumber(secondIndex)) {
                            String newIndex;
                            int startIndex = TextUtils.atoi(firstIndex);
                            int endIndex = TextUtils.atoi(secondIndex);
                            int spacing = Math.abs(endIndex - startIndex) + 1;
                            int nextIndex = 1;
                            while (true) {
                                newIndex = index.substring(0, startPos2) + "[" + (startIndex + spacing * nextIndex) + ":" + (endIndex + spacing * nextIndex) + index.substring(endPos);
                                if (cell.isUniqueName(an.baseName + newIndex, cls, null)) break;
                                ++nextIndex;
                            }
                            indexAdjusted = true;
                            an.indexPart = newIndex;
                            if (indexAdjusted) break;
                        }
                        if (startPos2 <= 0 || index.charAt(startPos2 - 1) != ']') break;
                        endPos = startPos2 - 1;
                        continue;
                    }
                    String bracketedExpression = index.substring(startPos2 + 1, endPos);
                    if (TextUtils.isANumber(bracketedExpression)) {
                        String newIndex;
                        int nextIndex = TextUtils.atoi(bracketedExpression) + 1;
                        while (true) {
                            newIndex = index.substring(0, startPos2) + "[" + nextIndex + index.substring(endPos);
                            if (cell.isUniqueName(an.baseName + newIndex, cls, null)) break;
                            ++nextIndex;
                        }
                        indexAdjusted = true;
                        an.indexPart = newIndex;
                        if (indexAdjusted) break;
                    }
                    if (possibleStart < 0) {
                        possibleStart = startPos2;
                        possibleEnd = endPos;
                    }
                    if (startPos2 <= 0 || index.charAt(startPos2 - 1) != ']') break;
                    endPos = startPos2 - 1;
                }
                if (!indexAdjusted && possibleStart >= 0) {
                    int i;
                    for (i = possibleEnd - 1; i > possibleStart && TextUtils.isDigit(index.charAt(i)); --i) {
                    }
                    int nextIndex = TextUtils.atoi(index.substring(i + 1)) + 1;
                    int startPos3 = i + 1;
                    if (index.charAt(startPos3 - 1) == separateChar) {
                        --startPos3;
                    }
                    while (true) {
                        String newIndex = index.substring(0, startPos3) + separateChar + nextIndex + index.substring(possibleEnd);
                        if (cell.isUniqueName(an.baseName + newIndex, cls, null)) {
                            indexAdjusted = true;
                            an.indexPart = newIndex;
                            break;
                        }
                        ++nextIndex;
                    }
                }
            }
            if (indexAdjusted) continue;
            String base = an.baseName;
            int endPos = base.length();
            String localSepString = String.valueOf(separateChar);
            for (startPos = base.length(); startPos > 0 && TextUtils.isDigit(base.charAt(startPos - 1)); --startPos) {
            }
            int nextIndex = 1;
            if (startPos >= endPos) {
                if (startPos > 0 && base.charAt(startPos - 1) == separateChar) {
                    --startPos;
                }
            } else {
                nextIndex = TextUtils.atoi(base.substring(startPos)) + 1;
                localSepString = "";
            }
            String prefix = base.substring(0, startPos) + localSepString;
            int uniqueIndex = cell.getUniqueNameIndex(prefix, cls, nextIndex);
            an.baseName = prefix + uniqueIndex + base.substring(endPos);
        }
        StringBuffer result = new StringBuffer();
        boolean first = true;
        Iterator it2 = names.iterator();
        while (it2.hasNext()) {
            if (first) {
                first = false;
            } else {
                result.append(",");
            }
            ArrayName an = (ArrayName)it2.next();
            result.append(an.baseName);
            if (an.indexPart == null) continue;
            result.append(an.indexPart);
        }
        return result.toString();
    }

    public boolean isDeprecatedVariable(Variable.Key key) {
        char chr;
        String name = key.getName();
        if (name.length() == 0) {
            return true;
        }
        return name.length() == 1 && !Character.isLetter(chr = name.charAt(0));
    }

    public synchronized Iterator getVariables() {
        if (this.vars == null) {
            return new ArrayList().iterator();
        }
        return new ArrayList(this.vars.values()).iterator();
    }

    public synchronized int getNumVariables() {
        if (this.vars == null) {
            return 0;
        }
        return this.vars.size();
    }

    public static synchronized Iterator getVariableKeys() {
        return varKeys.values().iterator();
    }

    public static synchronized int getNumVariableKeys() {
        return varKeys.keySet().size();
    }

    public void checkChanging() {
        Job.checkChanging();
    }

    public void checkExamine() {
        if (!this.isDatabaseObject()) {
            return;
        }
        Job.checkExamine();
    }

    protected boolean isDatabaseObject() {
        return true;
    }

    private static synchronized Variable.Key findKey(String name) {
        Variable.Key key = (Variable.Key)varKeys.get(name);
        if (key == null) {
            String lowCaseName = name.toLowerCase();
            if (!lowCaseName.equals(name)) {
                key = (Variable.Key)varLowCaseKeys.get(lowCaseName);
            }
            if (key != null) {
                System.out.println("WARNING: Variable search may become case-sensitive in future versions. Search: " + name + " found: " + key.getName());
                varKeys.put(name, key);
            }
        }
        return key;
    }

    public static synchronized Variable.Key newKey(String name) {
        Variable.Key key = ElectricObject.findKey(name);
        if (key != null) {
            return key;
        }
        key = new Variable.Key(name);
        varKeys.put(name, key);
        varLowCaseKeys.put(name.toLowerCase(), key);
        return key;
    }

    public Cell whichCell() {
        return null;
    }

    public void getInfo() {
        this.checkExamine();
        boolean firstvar = true;
        Iterator it = this.getVariables();
        while (it.hasNext()) {
            String par;
            Variable val = (Variable)it.next();
            Variable.Key key = val.getKey();
            if (val == null) continue;
            if (firstvar) {
                System.out.println("Variables:");
            }
            firstvar = false;
            Object addr = val.getObject();
            String string = par = val.isParam() ? "(param)" : "";
            if (addr instanceof Object[]) {
                Object[] ary = (Object[])addr;
                System.out.print("   " + key.getName() + "(" + ary.length + ") = [");
                for (int i = 0; i < ary.length; ++i) {
                    if (i > 4) {
                        System.out.print("...");
                        break;
                    }
                    if (ary[i] instanceof String) {
                        System.out.print("\"");
                    }
                    System.out.print(ary[i]);
                    if (ary[i] instanceof String) {
                        System.out.print("\"");
                    }
                    if (i >= ary.length - 1) continue;
                    System.out.print(", ");
                }
                System.out.println("] " + par);
                continue;
            }
            System.out.println("   " + key.getName() + "= " + addr + " " + par);
        }
    }

    public String toString() {
        return this.getClass().getName();
    }

    private static class ArrayName {
        private String baseName;
        private String indexPart;

        private ArrayName() {
        }
    }
}

