/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.plugins.j3d.utils;

import com.sun.j3d.utils.geometry.Cone;
import com.sun.j3d.utils.geometry.Cylinder;
import java.awt.Font;
import javax.media.j3d.Appearance;
import javax.media.j3d.Font3D;
import javax.media.j3d.FontExtrusion;
import javax.media.j3d.Geometry;
import javax.media.j3d.Group;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Text3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Vector3d;

public class J3DAxis
extends Group {
    private static Font3D font3D;
    public static final Vector3d axisX;
    public static final Vector3d axisY;
    public static final Vector3d axisZ;

    private void createAxis(double factor, Vector3d dir, Appearance app, String text) {
        Transform3D t = new Transform3D();
        float length = 0.1f;
        float diameter = length * 0.08f;
        Cylinder axis = new Cylinder(diameter, length, app);
        Transform3D cylinderTrans = new Transform3D();
        Transform3D coneTrans = new Transform3D();
        if (dir == axisX) {
            t.rotZ(-1.5707963267948966);
        } else if (dir == axisZ) {
            t.rotX(1.5707963267948966);
        }
        t.setScale(factor);
        TransformGroup axisTG = new TransformGroup(t);
        Vector3d cylinderLocation = new Vector3d(0.0, (double)(length / 2.0f), 0.0);
        cylinderTrans.setTranslation(cylinderLocation);
        TransformGroup cylinderG = new TransformGroup(cylinderTrans);
        cylinderG.addChild((Node)axis);
        axisTG.addChild((Node)cylinderG);
        Cone arrow = new Cone(1.5f * diameter, length / 3.0f, app);
        Vector3d coneLocation = new Vector3d(0.0, (double)length, 0.0);
        coneTrans.setTranslation(coneLocation);
        TransformGroup coneG = new TransformGroup(coneTrans);
        coneG.addChild((Node)arrow);
        axisTG.addChild((Node)coneG);
        Text3D axisText = new Text3D(font3D, text);
        Shape3D axisLabel = new Shape3D((Geometry)axisText, app);
        Transform3D textScale = new Transform3D();
        textScale.set(0.015);
        textScale.setTranslation(new Vector3d(0.0, 0.11, 0.0));
        TransformGroup axisLabelG = new TransformGroup(textScale);
        axisLabelG.addChild((Node)axisLabel);
        axisTG.addChild((Node)axisLabelG);
        this.addChild((Node)axisTG);
    }

    public J3DAxis(double factor, Appearance xApp, Appearance yApp, Appearance zApp, String defaultFont) {
        if (font3D == null) {
            font3D = new Font3D(new Font(defaultFont, 0, 2), new FontExtrusion());
        }
        this.createAxis(factor, axisX, xApp, "+X");
        this.createAxis(factor, axisY, yApp, "+Y");
        this.createAxis(factor, axisZ, zApp, "+Z");
    }

    static {
        axisX = new Vector3d(1.0, 0.0, 0.0);
        axisY = new Vector3d(0.0, 1.0, 0.0);
        axisZ = new Vector3d(0.0, 0.0, 1.0);
    }
}

