/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.extract;

import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.text.Pref;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.Listener;
import com.sun.electric.tool.extract.LayerCoverageJob;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.User;
import java.awt.geom.Rectangle2D;

public class LayerCoverage
extends Listener {
    protected static LayerCoverage tool = new LayerCoverage();
    private static final double defaultSize = 50000.0;
    private static Pref cacheDeltaX = Pref.makeDoublePref("DeltaX", LayerCoverage.tool.prefs, 50000.0);
    private static Pref cacheDeltaY;
    private static Pref cacheWidth;
    private static Pref cacheHeight;

    private LayerCoverage() {
        super("coverage");
    }

    public static double getDeltaX(Technology tech) {
        return cacheDeltaX.getDouble() / tech.getScale();
    }

    public static void setDeltaX(double delta, Technology tech) {
        cacheDeltaX.setDouble(delta * tech.getScale());
    }

    public static double getDeltaY(Technology tech) {
        return cacheDeltaY.getDouble() / tech.getScale();
    }

    public static void setDeltaY(double delta, Technology tech) {
        cacheDeltaY.setDouble(delta * tech.getScale());
    }

    public static double getWidth(Technology tech) {
        return cacheWidth.getDouble() / tech.getScale();
    }

    public static void setWidth(double w, Technology tech) {
        cacheWidth.setDouble(w * tech.getScale());
    }

    public static double getHeight(Technology tech) {
        return cacheHeight.getDouble() / tech.getScale();
    }

    public static void setHeight(double h, Technology tech) {
        cacheHeight.setDouble(h * tech.getScale());
    }

    static {
        cacheDeltaX.attachToObject(tool, "Tools/Coverage tab", "Delta along X to sweep bounding box");
        cacheDeltaY = Pref.makeDoublePref("DeltaY", LayerCoverage.tool.prefs, 50000.0);
        cacheDeltaY.attachToObject(tool, "Tools/Coverage tab", "Delta along Y to sweep bounding box");
        cacheWidth = Pref.makeDoublePref("Width", LayerCoverage.tool.prefs, 50000.0);
        cacheWidth.attachToObject(tool, "Tools/Coverage tab", "Bounding box width");
        cacheHeight = Pref.makeDoublePref("Height", LayerCoverage.tool.prefs, 50000.0);
        cacheHeight.attachToObject(tool, "Tools/Coverage tab", "Bounding box height");
    }

    public static class AreaCoverage
    extends Job {
        private Cell curCell;
        double deltaX;
        double deltaY;
        double width;
        double height;
        Highlighter highlighter;
        int mode;
        boolean foundError = false;

        public AreaCoverage(Cell cell, Highlighter highlighter, int mode, double width, double height, double deltaX, double deltaY) {
            super("Layer Coverage", User.getUserTool(), Job.Type.EXAMINE, null, null, Job.Priority.USER);
            this.curCell = cell;
            this.highlighter = highlighter;
            this.mode = mode;
            this.width = width;
            this.height = height;
            this.deltaX = deltaX;
            this.deltaY = deltaY;
            this.setReportExecutionFlag(true);
        }

        public boolean isOK() {
            return !this.foundError;
        }

        public boolean doIt() {
            ErrorLogger errorLogger = ErrorLogger.newInstance("Area Coverage");
            Rectangle2D bBoxOrig = this.curCell.getBounds();
            double maxY = bBoxOrig.getMaxY();
            double maxX = bBoxOrig.getMaxX();
            if (this.deltaX <= 0.0) {
                this.deltaX = bBoxOrig.getWidth();
            }
            if (this.deltaY <= 0.0) {
                this.deltaY = bBoxOrig.getHeight();
            }
            if (this.width <= 0.0) {
                this.width = bBoxOrig.getWidth();
            }
            if (this.height <= 0.0) {
                this.height = bBoxOrig.getHeight();
            }
            for (double posY = bBoxOrig.getMinY(); posY < maxY; posY += this.deltaY) {
                for (double posX = bBoxOrig.getMinX(); posX < maxX; posX += this.deltaX) {
                    Rectangle2D.Double box = new Rectangle2D.Double(posX, posY, this.width, this.height);
                    LayerCoverageJob.GeometryOnNetwork geoms = new LayerCoverageJob.GeometryOnNetwork(this.curCell, null, 1.0, true);
                    System.out.println("Calculating Coverage on cell '" + this.curCell.getName() + "' for area (" + DBMath.round(posX) + "," + DBMath.round(posY) + ") (" + DBMath.round(box.getMaxX()) + "," + DBMath.round(box.getMaxY()) + ")");
                    LayerCoverageJob job = new LayerCoverageJob(this, Job.Type.EXAMINE, this.curCell, 0, this.mode, this.highlighter, geoms, box);
                    ((Job)job).doIt();
                    if (this.getAborted() || job.getAborted()) {
                        this.foundError = true;
                        return false;
                    }
                    if (!geoms.analyzeCoverage(box, errorLogger)) continue;
                    this.foundError = true;
                }
            }
            errorLogger.termLogging(true);
            return true;
        }
    }
}

