/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.generator.layout.LayoutLib;
import java.util.HashMap;
import java.util.Iterator;

public class Tech {
    private static boolean isTsmc90;
    private static final String[] MOCMOS_LAYER_NAMES;
    private static final String[] TSMC90_LAYER_NAMES;
    private static String[] layerNms;
    private static int nbLay;
    private static ArcProto[] layers;
    private static PrimitiveNode[] vias;
    private static HashMap viaMap;
    private static Technology tech;
    private static double wellOverhangDiff;
    public static final String MOCMOS = "mocmos";
    public static final String TSMC90 = "tsmc90";
    public static ArcProto pdiff;
    public static ArcProto ndiff;
    public static ArcProto p1;
    public static ArcProto m1;
    public static ArcProto m2;
    public static ArcProto m3;
    public static ArcProto m4;
    public static ArcProto m5;
    public static ArcProto m6;
    public static ArcProto m7;
    public static ArcProto m8;
    public static ArcProto m9;
    public static PrimitiveNode ndpin;
    public static PrimitiveNode pdpin;
    public static PrimitiveNode p1pin;
    public static PrimitiveNode m1pin;
    public static PrimitiveNode m2pin;
    public static PrimitiveNode m3pin;
    public static PrimitiveNode m4pin;
    public static PrimitiveNode m5pin;
    public static PrimitiveNode m6pin;
    public static PrimitiveNode m7pin;
    public static PrimitiveNode m8pin;
    public static PrimitiveNode m9pin;
    public static PrimitiveNode nwm1;
    public static PrimitiveNode pwm1;
    public static PrimitiveNode nwm1Y;
    public static PrimitiveNode pwm1Y;
    public static PrimitiveNode ndm1;
    public static PrimitiveNode pdm1;
    public static PrimitiveNode p1m1;
    public static PrimitiveNode m1m2;
    public static PrimitiveNode m2m3;
    public static PrimitiveNode m3m4;
    public static PrimitiveNode m4m5;
    public static PrimitiveNode m5m6;
    public static PrimitiveNode m6m7;
    public static PrimitiveNode m7m8;
    public static PrimitiveNode m8m9;
    public static PrimitiveNode nmos;
    public static PrimitiveNode pmos;
    public static PrimitiveNode nwell;
    public static PrimitiveNode pwell;
    public static PrimitiveNode m1Node;
    public static PrimitiveNode m2Node;
    public static PrimitiveNode m3Node;
    public static PrimitiveNode m4Node;
    public static PrimitiveNode m5Node;
    public static PrimitiveNode m6Node;
    public static PrimitiveNode m7Node;
    public static PrimitiveNode m8Node;
    public static PrimitiveNode m9Node;
    public static PrimitiveNode p1Node;
    public static PrimitiveNode pdNode;
    public static PrimitiveNode ndNode;
    public static PrimitiveNode pselNode;
    public static PrimitiveNode nselNode;
    public static PrimitiveNode pwellNode;
    public static PrimitiveNode nwellNode;
    public static PrimitiveNode essentialBounds;
    public static PrimitiveNode facetCenter;
    public static ArcProto universalArc;

    public static double roundToGrid(double x) {
        return isTsmc90 ? x : Math.rint(x * 2.0) / 2.0;
    }

    public static MosInst newNmosInst(double x, double y, double w, double l, Cell parent) {
        return new MosInst(true, x, y, w, l, parent);
    }

    public static MosInst newPmosInst(double x, double y, double w, double l, Cell parent) {
        return new MosInst(false, x, y, w, l, parent);
    }

    private static void error(boolean pred, String msg) {
        LayoutLib.error(pred, msg);
    }

    public static void setTechnology(String techNm) {
        int i;
        Tech.error(!techNm.equals(MOCMOS) && !techNm.equals(TSMC90), "LayoutLib only supports two technologies: mocmos or tsmc90: " + techNm);
        isTsmc90 = techNm.equals(TSMC90);
        tech = Technology.findTechnology(techNm);
        layerNms = isTsmc90 ? TSMC90_LAYER_NAMES : MOCMOS_LAYER_NAMES;
        nbLay = layerNms.length;
        layers = new ArcProto[nbLay];
        vias = new PrimitiveNode[nbLay - 1];
        for (i = 0; i < nbLay; ++i) {
            Tech.layers[i] = tech.findArcProto(layerNms[i]);
            Tech.error(layers[i] == null, "No such layer: " + layerNms[i]);
        }
        p1 = layers[0];
        m1 = layers[1];
        m2 = layers[2];
        m3 = layers[3];
        m4 = layers[4];
        m5 = layers[5];
        m6 = layers[6];
        if (isTsmc90) {
            m7 = layers[7];
            m8 = layers[8];
            m9 = layers[9];
        }
        pdiff = tech.findArcProto("P-Active");
        ndiff = tech.findArcProto("N-Active");
        pdpin = pdiff.findOverridablePinProto();
        ndpin = ndiff.findOverridablePinProto();
        p1pin = p1.findOverridablePinProto();
        m1pin = m1.findOverridablePinProto();
        m2pin = m2.findOverridablePinProto();
        m3pin = m3.findOverridablePinProto();
        m4pin = m4.findOverridablePinProto();
        m5pin = m5.findOverridablePinProto();
        m6pin = m6.findOverridablePinProto();
        if (isTsmc90) {
            m7pin = m7.findOverridablePinProto();
            m8pin = m8.findOverridablePinProto();
            m9pin = m9.findOverridablePinProto();
        }
        for (i = 0; i < nbLay - 1; ++i) {
            Tech.vias[i] = Tech.findNode(PrimitiveNode.Function.CONTACT, new ArcProto[]{layers[i], layers[i + 1]}, tech);
            Tech.error(vias[i] == null, "No via for layer: " + layerNms[i]);
        }
        p1m1 = vias[0];
        m1m2 = vias[1];
        m2m3 = vias[2];
        m3m4 = vias[3];
        m4m5 = vias[4];
        m5m6 = vias[5];
        if (isTsmc90) {
            m6m7 = vias[6];
            m7m8 = vias[7];
            m8m9 = vias[8];
        }
        ndm1 = tech.findNodeProto("Metal-1-N-Active-Con");
        pdm1 = tech.findNodeProto("Metal-1-P-Active-Con");
        nwm1 = tech.findNodeProto("Metal-1-N-Well-Con");
        pwm1 = tech.findNodeProto("Metal-1-P-Well-Con");
        nwm1Y = tech.findNodeProto("Y-Metal-1-N-Well-Con");
        pwm1Y = tech.findNodeProto("Y-Metal-1-P-Well-Con");
        nmos = tech.findNodeProto("N-Transistor");
        pmos = tech.findNodeProto("P-Transistor");
        nwell = tech.findNodeProto("N-Well-Node");
        pwell = tech.findNodeProto("P-Well-Node");
        nwellNode = tech.findNodeProto("Metal-1-N-Well-Con");
        pwellNode = tech.findNodeProto("Metal-1-P-Well-Con");
        if (isTsmc90) {
            nwellNode = tech.findNodeProto("Y-Metal-1-N-Well-Con");
            pwellNode = tech.findNodeProto("Y-Metal-1-P-Well-Con");
        }
        m1Node = tech.findNodeProto("Metal-1-Node");
        m2Node = tech.findNodeProto("Metal-2-Node");
        m3Node = tech.findNodeProto("Metal-3-Node");
        m4Node = tech.findNodeProto("Metal-4-Node");
        m5Node = tech.findNodeProto("Metal-5-Node");
        m6Node = tech.findNodeProto("Metal-6-Node");
        m7Node = tech.findNodeProto("Metal-7-Node");
        m8Node = tech.findNodeProto("Metal-8-Node");
        m9Node = tech.findNodeProto("Metal-9-Node");
        p1Node = tech.findNodeProto("Polysilicon-1-Node");
        pdNode = tech.findNodeProto("P-Active-Node");
        ndNode = tech.findNodeProto("N-Active-Node");
        nselNode = tech.findNodeProto("N-Select-Node");
        pselNode = tech.findNodeProto("P-Select-Node");
        Technology generic = Technology.findTechnology("generic");
        essentialBounds = generic.findNodeProto("Essential-Bounds");
        facetCenter = generic.findNodeProto("Facet-Center");
        universalArc = generic.findArcProto("Universal");
        viaMap.put(new Integer(m1.hashCode() * m2.hashCode()), m1m2);
        viaMap.put(new Integer(m2.hashCode() * m3.hashCode()), m2m3);
        viaMap.put(new Integer(m3.hashCode() * m4.hashCode()), m3m4);
        viaMap.put(new Integer(m4.hashCode() * m5.hashCode()), m4m5);
        viaMap.put(new Integer(m5.hashCode() * m6.hashCode()), m5m6);
        if (isTsmc90) {
            viaMap.put(new Integer(m6.hashCode() * m7.hashCode()), m6m7);
            viaMap.put(new Integer(m7.hashCode() * m8.hashCode()), m7m8);
            viaMap.put(new Integer(m8.hashCode() * m9.hashCode()), m8m9);
        }
        viaMap.put(new Integer(ndiff.hashCode() * m1.hashCode()), ndm1);
        viaMap.put(new Integer(pdiff.hashCode() * m1.hashCode()), pdm1);
        viaMap.put(new Integer(p1.hashCode() * m1.hashCode()), p1m1);
    }

    public static boolean isTSMC90() {
        return isTsmc90;
    }

    public static PrimitiveNode getViaFor(ArcProto a1, ArcProto a2) {
        int code = a1.hashCode() * a2.hashCode();
        return (PrimitiveNode)viaMap.get(new Integer(code));
    }

    public static ArcProto closestLayer(PortProto port, ArcProto layer) {
        int h = Tech.layerHeight(layer);
        for (int dist = 0; dist < nbLay; ++dist) {
            ArcProto lay;
            int lookUp = h + dist;
            int lookDn = h - dist;
            if (lookUp < nbLay && port.connectsTo(lay = Tech.layerAtHeight(lookUp))) {
                return lay;
            }
            if (lookDn < 0 || !port.connectsTo(lay = Tech.layerAtHeight(lookDn))) continue;
            return lay;
        }
        Tech.error(true, "port can't connect to any layer?!!");
        return null;
    }

    public static ArcProto layerAtHeight(int layHeight) {
        return layers[layHeight];
    }

    public static int layerHeight(ArcProto p) {
        for (int i = 0; i < nbLay; ++i) {
            if (layers[i] != p) continue;
            return i;
        }
        Tech.error(true, "Can't find layer: " + p);
        return -1;
    }

    public static PrimitiveNode viaAbove(ArcProto lay) {
        return Tech.viaAbove(Tech.layerHeight(lay));
    }

    public static PrimitiveNode viaAbove(int layHeight) {
        return vias[layHeight];
    }

    public static PrimitiveNode viaBelow(ArcProto lay) {
        return Tech.viaBelow(Tech.layerHeight(lay));
    }

    public static PrimitiveNode viaBelow(int layHeight) {
        return vias[layHeight - 1];
    }

    public static PrimitiveNode findNode(PrimitiveNode.Function type, ArcProto[] arcs, Technology tech) {
        Iterator it = tech.getNodes();
        while (it.hasNext()) {
            PrimitiveNode pn = (PrimitiveNode)it.next();
            boolean found = true;
            if (pn.getFunction() != type) continue;
            for (int j = 0; j < arcs.length; ++j) {
                if (pn.connectsTo(arcs[j]) != null) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return pn;
        }
        return null;
    }

    static /* synthetic */ boolean access$000() {
        return isTsmc90;
    }

    static {
        MOCMOS_LAYER_NAMES = new String[]{"Polysilicon-1", "Metal-1", "Metal-2", "Metal-3", "Metal-4", "Metal-5", "Metal-6"};
        TSMC90_LAYER_NAMES = new String[]{"Polysilicon", "Metal-1", "Metal-2", "Metal-3", "Metal-4", "Metal-5", "Metal-6", "Metal-7", "Metal-8", "Metal-9"};
        viaMap = new HashMap();
    }

    public static class MosInst {
        private boolean isTsmc90 = Tech.access$000();
        private NodeInst mos;
        boolean ntype;

        protected MosInst(boolean ntype, double x, double y, double w, double l, Cell parent) {
            this.ntype = ntype;
            PrimitiveNode np = ntype ? nmos : pmos;
            double angle = this.isTsmc90 ? 0.0 : 90.0;
            double xSize = this.isTsmc90 ? l : w;
            double ySize = this.isTsmc90 ? w : l;
            this.mos = LayoutLib.newNodeInst(np, x, y, xSize, ySize, angle, parent);
        }

        private String mosTypeString() {
            return this.ntype ? "n-trans" : "p-trans";
        }

        private PortInst getPort(String portNm) {
            PortInst pi = this.mos.findPortInst(portNm);
            Tech.error(pi == null, "MosInst can't find port!");
            return pi;
        }

        public PortInst leftDiff() {
            String portNm = this.mosTypeString() + "-diff" + (this.isTsmc90 ? "-left" : "-top");
            return this.getPort(portNm);
        }

        public PortInst rightDiff() {
            String portNm = this.mosTypeString() + "-diff" + (this.isTsmc90 ? "-right" : "-bottom");
            return this.getPort(portNm);
        }

        public PortInst topPoly() {
            String portNm = this.mosTypeString() + "-poly" + (this.isTsmc90 ? "-top" : "-right");
            return this.getPort(portNm);
        }

        public PortInst botPoly() {
            String portNm = this.mosTypeString() + "-poly" + (this.isTsmc90 ? "-bottom" : "-left");
            return this.getPort(portNm);
        }
    }
}

