/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout.gates;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.tool.generator.layout.FoldedMos;
import com.sun.electric.tool.generator.layout.FoldedNmos;
import com.sun.electric.tool.generator.layout.FoldedPmos;
import com.sun.electric.tool.generator.layout.FoldsAndWidth;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.StdCellParams;
import com.sun.electric.tool.generator.layout.Tech;
import com.sun.electric.tool.generator.layout.TrackRouter;
import com.sun.electric.tool.generator.layout.TrackRouterH;

class Nand3_star {
    private static final double nmosTop = -9.0;
    private static final double pmosBot = 9.0;
    private static final double wellOverhangDiff = 6.0;
    private static final double inaY = -4.0;
    private static final double incY = 4.0;
    private static final double outHiY = 11.0;
    private static final double outLoY = -11.0;

    Nand3_star() {
    }

    private static void error(boolean pred, String msg) {
        LayoutLib.error(pred, msg);
    }

    static Cell makePart(double sz, String threshold, StdCellParams stdCell) {
        int i;
        int i2;
        sz = stdCell.roundSize(sz);
        Nand3_star.error(!threshold.equals("") && !threshold.equals("LT") && !threshold.equals("MLT"), "Nand3: threshold not \"\", \"MLT\", or \"LT\": " + threshold);
        String nm = "nand3" + threshold;
        double lamPerSz = threshold.equals("LT") ? 2.0 : (threshold.equals("MLT") ? 3.0 : 6.0);
        double minSz = 3.0 / lamPerSz;
        sz = stdCell.checkMinStrength(sz, minSz, nm);
        double spaceAvail = stdCell.getCellTop() - 8.5 - 9.0;
        double totWid = sz * lamPerSz * 3.0;
        FoldsAndWidth fwP = stdCell.calcFoldsAndWidth(spaceAvail, totWid, 3);
        Nand3_star.error(fwP == null, "can't make " + nm + " this small: " + sz);
        int nbStackedN = 3;
        spaceAvail = -9.0 - (stdCell.getCellBot() + 2.0 + 3.0 + 5.0 + 1.5);
        totWid = sz * 3.0 * (double)nbStackedN;
        FoldsAndWidth fwN = stdCell.calcFoldsAndWidth(spaceAvail, totWid, 1);
        Nand3_star.error(fwN == null, "can't make " + nm + " this small: " + sz);
        Cell nand = stdCell.findPart(nm, sz);
        if (nand != null) {
            return nand;
        }
        nand = stdCell.newPart(nm, sz);
        double inaX = 3.5;
        double inbX = inaX + 2.0 + 3.0 + 2.0;
        double jogbX = inbX + 2.0 + 3.0 + 2.0;
        double nmosX = jogbX + 2.0 + 3.0 + 2.0;
        double nmosY = -9.0 - fwN.physWid / 2.0;
        FoldedNmos nmos = new FoldedNmos(nmosX, nmosY, fwN.nbFolds, nbStackedN, fwN.gateWid, nand, stdCell);
        double pmosY = 9.0 + fwP.physWid / 2.0;
        FoldedMos[] pmoss = new FoldedMos[fwP.nbFolds / 3];
        for (int i3 = 0; i3 < pmoss.length; ++i3) {
            double pmosPitch = 36.0;
            double pmosX = nmosX - 3.5 + (double)i3 * pmosPitch;
            pmoss[i3] = new FoldedPmos(pmosX, pmosY, 3, 1, fwP.gateWid, nand, stdCell);
        }
        stdCell.wireVddGnd(nmos, StdCellParams.EVEN, nand);
        stdCell.wireVddGnd(pmoss, StdCellParams.EVEN, nand);
        TrackRouterH inc = new TrackRouterH(Tech.m1, 3.0, 4.0, nand);
        for (i2 = 0; i2 < nmos.nbGates(); i2 += 3) {
            if (i2 / 3 % 2 == 0) {
                ((TrackRouter)inc).connect(nmos.getGate(i2 + 2, 'T'), 4.0, -1.5);
                continue;
            }
            ((TrackRouter)inc).connect(nmos.getGate(i2, 'T'), -4.0, -1.5);
        }
        for (i2 = 0; i2 < pmoss.length; ++i2) {
            inc.connect(pmoss[i2].getGate(2, 'B'), 1.5);
        }
        double nmosRight = StdCellParams.getRightDiffX(nmos);
        double pmosRight = StdCellParams.getRightDiffX(pmoss);
        double incX = Math.max(nmosRight, pmosRight) + 2.0 + 3.0 + 2.0;
        LayoutLib.newExport(nand, "inc", PortCharacteristic.IN, Tech.m1, 4.0, incX, 4.0);
        inc.connect(nand.findExport("inc"));
        double gndBot = stdCell.getGndY() - stdCell.getGndWidth() / 2.0;
        double inbLoY = gndBot - 3.0 - 2.0;
        inbLoY = Math.min(inbLoY, -9.0 - fwN.physWid - 2.0 - 3.0 - 2.5);
        double spFromVdd = stdCell.getVddY() + stdCell.getVddWidth() / 2.0 + 3.0 + 2.0;
        double spFromPmos = 9.0 + fwP.physWid + 2.0 + 2.5;
        double inbHiY = Math.max(spFromVdd, spFromPmos);
        LayoutLib.newExport(nand, "inb", PortCharacteristic.IN, Tech.m1, 4.0, inbX, inbHiY);
        TrackRouterH inbHi = new TrackRouterH(Tech.m1, 3.0, inbHiY, nand);
        inbHi.connect(nand.findExport("inb"));
        for (int i4 = 0; i4 < pmoss.length; ++i4) {
            inbHi.connect(pmoss[i4].getGate(1, 'T'));
        }
        TrackRouterH inbLo = new TrackRouterH(Tech.m1, 3.0, inbLoY, nand);
        inbLo.connect(nand.findExport("inb"));
        for (int i5 = 0; i5 < nmos.nbGates(); i5 += 3) {
            inbLo.connect(nmos.getGate(i5 + 1, 'B'));
        }
        double inaLoY = -11.0;
        LayoutLib.newExport(nand, "ina", PortCharacteristic.IN, Tech.m1, 4.0, inaX, inaLoY);
        TrackRouterH inaLo = new TrackRouterH(Tech.m2, 3.0, inaLoY, nand);
        inaLo.connect(nand.findExport("ina"));
        PortInst jogb = LayoutLib.newNodeInst(Tech.m1pin, jogbX, inaLoY, 3.0, 3.0, 0.0, nand).getOnlyPortInst();
        inaLo.connect(jogb);
        TrackRouterH ina = new TrackRouterH(Tech.m1, 3.0, -4.0, nand);
        ina.connect(jogb);
        for (i = 0; i < nmos.nbGates(); i += 3) {
            if (i / 3 % 2 == 0) {
                ((TrackRouter)ina).connect(nmos.getGate(i + 0, 'T'), -4.0, -1.5);
                continue;
            }
            ((TrackRouter)ina).connect(nmos.getGate(i + 2, 'T'), 4.0, -1.5);
        }
        for (i = 0; i < pmoss.length; ++i) {
            ina.connect(pmoss[i].getGate(0, 'B'));
        }
        double outX = incX + 2.0 + 3.0 + 2.0;
        LayoutLib.newExport(nand, "out", PortCharacteristic.OUT, Tech.m1, 4.0, outX, 11.0);
        TrackRouterH outHi = new TrackRouterH(Tech.m2, 4.0, 11.0, nand);
        outHi.connect(nand.findExport("out"));
        for (int i6 = 0; i6 < pmoss.length; ++i6) {
            for (int j = 1; j < pmoss[i6].nbSrcDrns(); j += 2) {
                outHi.connect(pmoss[i6].getSrcDrn(j));
            }
        }
        TrackRouterH outLo = new TrackRouterH(Tech.m2, 4.0, -11.0, nand);
        outLo.connect(nand.findExport("out"));
        for (int i7 = 1; i7 < nmos.nbSrcDrns(); i7 += 2) {
            outLo.connect(nmos.getSrcDrn(i7));
        }
        double wellMinX = 0.0;
        double wellMaxX = outX + 2.0 + 1.5;
        stdCell.addNmosWell(wellMinX, wellMaxX, nand);
        stdCell.addPmosWell(wellMinX, wellMaxX, nand);
        stdCell.addEssentialBounds(wellMinX, wellMaxX, nand);
        stdCell.doNCC(nand, nm + "{sch}");
        return nand;
    }
}

