/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.processing;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.ncc.NccGlobals;
import com.sun.electric.tool.ncc.basic.NccCellAnnotations;
import com.sun.electric.tool.ncc.basic.NccUtils;
import com.sun.electric.tool.ncc.netlist.Port;
import com.sun.electric.tool.ncc.netlist.Wire;
import com.sun.electric.tool.ncc.processing.HierarchyInfo;
import com.sun.electric.tool.ncc.processing.SubcircuitInfo;
import com.sun.electric.tool.ncc.trees.Circuit;
import com.sun.electric.tool.ncc.trees.EquivRecord;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ExportChecker {
    private NccGlobals globals;
    private HashMap[] equivPortMaps;
    private NoPortNameMatches noPortNameMatches = new NoPortNameMatches();

    private Port[][] getPortsForEachCell() {
        int numCells = this.globals.getNumNetlistsBeingCompared();
        Port[][] portsPerCell = new Port[numCells][];
        EquivRecord portRec = this.globals.getPorts();
        if (portRec == null) {
            for (int i = 0; i < numCells; ++i) {
                portsPerCell[i] = new Port[0];
            }
        } else {
            this.globals.error(!portRec.isLeaf(), "globals ports must hold circuits");
            int cellNdx = 0;
            Iterator it = portRec.getCircuits();
            while (it.hasNext()) {
                Circuit ckt = (Circuit)it.next();
                portsPerCell[cellNdx] = new Port[ckt.numNetObjs()];
                int portNdx = 0;
                Iterator pit = ckt.getNetObjs();
                while (pit.hasNext()) {
                    portsPerCell[cellNdx][portNdx] = (Port)pit.next();
                    ++portNdx;
                }
                ++cellNdx;
            }
        }
        return portsPerCell;
    }

    private HashMap mapFromExportNameToPort(Port[] ports) {
        HashMap map = new HashMap();
        for (int portNdx = 0; portNdx < ports.length; ++portNdx) {
            Port p = ports[portNdx];
            Iterator itN = p.getExportNames();
            while (itN.hasNext()) {
                map.put(itN.next(), p);
            }
        }
        return map;
    }

    private void prln(String s) {
        System.out.println(s);
    }

    private void pr(String s) {
        System.out.print(s);
    }

    private void printOneToManyError(String design1, String exports1, String design2, Set exports2) {
        this.prln("  A single network in: " + design1 + " has Exports with names that " + "match multiple Exports in: " + design2);
        this.prln("  However, the " + design2 + " Exports are attached to more than one network.");
        this.prln("    The " + design1 + " Exports: " + exports1);
        Iterator it = exports2.iterator();
        while (it.hasNext()) {
            Port p2 = (Port)it.next();
            this.prln("      matches the " + design2 + " Exports: " + p2.exportNamesString());
        }
    }

    private boolean matchPortsByName(HashMap p1ToP2, Port[][] portsPerCell, String[] designNames, int ckt1, int ckt2) {
        boolean match = true;
        HashMap exportName2ToPort2 = this.mapFromExportNameToPort(portsPerCell[ckt2]);
        if (p1ToP2 == null) {
            p1ToP2 = new HashMap<Port, Port>();
        }
        Port[] ckt1Ports = portsPerCell[ckt1];
        for (int portNdx = 0; portNdx < ckt1Ports.length; ++portNdx) {
            Port p1 = ckt1Ports[portNdx];
            HashSet<Port> p2ports = new HashSet<Port>();
            Iterator itN = p1.getExportNames();
            while (itN.hasNext()) {
                String exportNm1 = (String)itN.next();
                Port p = (Port)exportName2ToPort2.get(exportNm1);
                if (p == null) continue;
                p2ports.add(p);
            }
            if (p2ports.size() == 0) {
                this.prln("  In " + designNames[ckt1] + " the network with Exports: " + p1.exportNamesString() + "    matches no Export with the same name in: " + designNames[ckt2]);
                this.noPortNameMatches.add(p1, ckt1, ckt2);
                match = false;
                continue;
            }
            if (p2ports.size() == 1) {
                p1ToP2.put(p1, (Port)p2ports.iterator().next());
                continue;
            }
            this.printOneToManyError(designNames[ckt1], p1.exportNamesString(), designNames[ckt2], p2ports);
            match = false;
        }
        return match;
    }

    private SubcircuitInfo getInfoForReferenceCell(Cell refCell, HierarchyInfo hierInfo) {
        SubcircuitInfo refInfo = hierInfo.getSubcircuitInfo(refCell);
        if (refInfo != null) {
            return refInfo;
        }
        Port[] refCktPorts = this.getFirstCktPorts();
        refInfo = new SubcircuitInfo(hierInfo.currentSubcircuitName(), hierInfo.currentSubcircuitID(), refCktPorts);
        hierInfo.addSubcircuitInfo(refCell, refInfo);
        return refInfo;
    }

    private Port[] getFirstCktPorts() {
        Port[][] portsPerCell = this.getPortsForEachCell();
        return portsPerCell[0];
    }

    private Map mapExportNameToPortIndex(SubcircuitInfo refCellInfo, Map equivPortMap) {
        HashMap exportNameToPortIndex = new HashMap();
        Port[] firstCktPorts = this.getFirstCktPorts();
        for (int i = 0; i < firstCktPorts.length; ++i) {
            Port firstCktPort = firstCktPorts[i];
            String firstCktPortName = (String)firstCktPort.getExportNames().next();
            int portNdx = refCellInfo.getPortIndex(firstCktPortName);
            Port equivPort = (Port)equivPortMap.get(firstCktPort);
            if (equivPort == null) continue;
            Iterator it = equivPort.getExportNames();
            while (it.hasNext()) {
                exportNameToPortIndex.put(it.next(), new Integer(portNdx));
            }
        }
        return exportNameToPortIndex;
    }

    private Circuit getNthCircuit(EquivRecord er, int nth) {
        LayoutLib.error(!er.isLeaf(), "only leaf EquivRecords have Circuits!");
        Iterator it = er.getCircuits();
        for (int i = 0; i < nth; ++i) {
            LayoutLib.error(!it.hasNext(), "EquivRec has no Circuit at index: " + nth);
            it.next();
        }
        LayoutLib.error(!it.hasNext(), "EquivRec has no Circuit at index: " + nth);
        return (Circuit)it.next();
    }

    private Object findMatchingPortOrWire(Port lonely, int nth) {
        Wire lonelyWire = lonely.getWire();
        Circuit lonelyCkt = lonelyWire.getParent();
        if (lonelyCkt.numNetObjs() != 1) {
            return null;
        }
        EquivRecord equivRecord = lonelyCkt.getParent();
        Circuit nthCircuit = this.getNthCircuit(equivRecord, nth);
        if (nthCircuit.numNetObjs() != 1) {
            return null;
        }
        Wire wire = (Wire)nthCircuit.getNetObjs().next();
        Port port = wire.getPort();
        return port != null ? port : wire;
    }

    private String getDescription(Object portOrWire) {
        if (portOrWire instanceof Wire) {
            return "network: " + ((Wire)portOrWire).getName();
        }
        LayoutLib.error(!(portOrWire instanceof Port), "not a Wire?");
        return "network with Exports: " + ((Port)portOrWire).exportNamesString();
    }

    private void markPortForRenaming(Port p, NccCellAnnotations ann) {
        Iterator it = p.getExportNames();
        while (it.hasNext()) {
            String name = (String)it.next();
            if (!ann.renameExport(name)) continue;
            p.setToBeRenamed();
            return;
        }
    }

    private void markPortsForRenaming(Cell cell, Port[] ports) {
        NccCellAnnotations ann = NccCellAnnotations.getAnnotations(cell);
        if (ann == null) {
            return;
        }
        for (int portNdx = 0; portNdx < ports.length; ++portNdx) {
            this.markPortForRenaming(ports[portNdx], ann);
        }
    }

    private void printNewPortNames(Port[] ports, Cell rootCell, int cktIndex) {
        boolean printedHeader = false;
        int otherCktIndex = cktIndex == 0 ? 1 : 0;
        for (int portNdx = 0; portNdx < ports.length; ++portNdx) {
            Port p = ports[portNdx];
            if (!p.getToBeRenamed()) continue;
            if (!printedHeader) {
                this.prln("  Attempting to find better names for Exports in Cell: " + NccUtils.fullName(rootCell));
                printedHeader = true;
            }
            Object o = this.findMatchingPortOrWire(p, otherCktIndex);
            this.prln("    " + p.exportNamesString() + " -> " + this.getDescription(o));
        }
    }

    private void printNewNamesForPortsThatTheUserWantsUsToRename() {
        Cell[] rootCells = this.globals.getRootCells();
        Port[][] portsPerCell = this.getPortsForEachCell();
        for (int cellNdx = 0; cellNdx < portsPerCell.length; ++cellNdx) {
            this.printNewPortNames(portsPerCell[cellNdx], rootCells[cellNdx], cellNdx);
        }
    }

    private void suggestMatchForPortsThatDontMatchByName() {
        String[] rootCellNames = this.globals.getRootCellNames();
        boolean printedHeader = false;
        NoPortNameMatch no = this.noPortNameMatches.removeFirst();
        while (no != null) {
            Object o;
            if (!no.port.getToBeRenamed() && (o = this.findMatchingPortOrWire(no.port, no.circuitNoMatchingPort)) != null) {
                if (!printedHeader) {
                    printedHeader = true;
                    this.prln("  The following list suggests possible matches for Exports that failed to match by name.");
                }
                this.prln("    in Cell " + rootCellNames[no.circuit] + " the network with Exports: " + no.port.exportNamesString() + " might match in Cell " + rootCellNames[no.circuitNoMatchingPort] + " the " + this.getDescription(o));
                if (o instanceof Port) {
                    this.noPortNameMatches.removeMismatches(no.port, no.circuit, (Port)o, no.circuitNoMatchingPort);
                }
            }
            no = this.noPortNameMatches.removeFirst();
        }
        if (printedHeader) {
            this.prln("");
        }
    }

    public ExportChecker(NccGlobals globals) {
        this.globals = globals;
    }

    public void markPortsForRenaming() {
        Cell[] rootCells = this.globals.getRootCells();
        Port[][] portsPerCell = this.getPortsForEachCell();
        for (int cellNdx = 0; cellNdx < portsPerCell.length; ++cellNdx) {
            this.markPortsForRenaming(rootCells[cellNdx], portsPerCell[cellNdx]);
        }
    }

    public boolean matchByName() {
        int numCkts = this.globals.getNumNetlistsBeingCompared();
        String[] rootCellNames = this.globals.getRootCellNames();
        Port[][] portsPerCell = this.getPortsForEachCell();
        this.equivPortMaps = new HashMap[numCkts];
        boolean match = true;
        for (int i = 1; i < numCkts; ++i) {
            match &= this.matchPortsByName(null, portsPerCell, rootCellNames, i, 0);
            HashMap p0ToPi = new HashMap();
            match &= this.matchPortsByName(p0ToPi, portsPerCell, rootCellNames, 0, i);
            this.equivPortMaps[i] = p0ToPi;
        }
        return match;
    }

    public void saveInfoNeededToMakeMeASubcircuit(HierarchyInfo hierInfo) {
        if (hierInfo == null) {
            return;
        }
        Cell[] rootCells = this.globals.getRootCells();
        Cell refCell = this.globals.getRootCells()[0];
        SubcircuitInfo refCellInfo = this.getInfoForReferenceCell(refCell, hierInfo);
        HashSet<Cell> doneCells = new HashSet<Cell>();
        doneCells.add(refCell);
        for (int i = 1; i < this.equivPortMaps.length; ++i) {
            if (doneCells.contains(rootCells[i])) continue;
            doneCells.add(rootCells[i]);
            Map exportNameToPortIndex = this.mapExportNameToPortIndex(refCellInfo, this.equivPortMaps[i]);
            SubcircuitInfo subInf = new SubcircuitInfo(refCellInfo, exportNameToPortIndex);
            hierInfo.addSubcircuitInfo(rootCells[i], subInf);
        }
    }

    public boolean ensureExportsWithMatchingNamesAreOnEquivalentNets() {
        boolean match = true;
        String[] rootCellNames = this.globals.getRootCellNames();
        for (int i = 1; i < this.equivPortMaps.length; ++i) {
            HashMap portToPort = this.equivPortMaps[i];
            Iterator it = portToPort.keySet().iterator();
            while (it.hasNext()) {
                EquivRecord ern;
                Port p0 = (Port)it.next();
                Port pn = (Port)portToPort.get(p0);
                if (p0.getToBeRenamed() || pn.getToBeRenamed()) continue;
                Wire w0 = p0.getWire();
                Wire wn = pn.getWire();
                EquivRecord er0 = w0.getParent().getParent();
                if (er0 == (ern = wn.getParent().getParent())) continue;
                this.prln("  Exports that match by name aren't on equivalent networks");
                this.prln("    Cell1: " + rootCellNames[0]);
                this.prln("    Exports1: " + p0.exportNamesString());
                this.prln("    Cell2: " + rootCellNames[i]);
                this.prln("    Exports2: " + pn.exportNamesString());
                Object portOrWire = this.findMatchingPortOrWire(p0, i);
                if (portOrWire != null) {
                    this.prln("    However the Cell1 network appears to match Cell2's: " + this.getDescription(portOrWire));
                }
                this.prln("");
                match = false;
            }
        }
        return match;
    }

    public void suggestPortMatchesBasedOnTopology() {
        this.printNewNamesForPortsThatTheUserWantsUsToRename();
        this.suggestMatchForPortsThatDontMatchByName();
    }

    private static class NoPortNameMatches {
        private List unmatched = new LinkedList();

        private NoPortNameMatches() {
        }

        public void add(Port port, int circuit, int circuitNoMatchingPort) {
            this.unmatched.add(new NoPortNameMatch(port, circuit, circuitNoMatchingPort));
        }

        public NoPortNameMatch removeFirst() {
            Iterator it = this.unmatched.iterator();
            if (!it.hasNext()) {
                return null;
            }
            NoPortNameMatch u = (NoPortNameMatch)it.next();
            it.remove();
            return u;
        }

        public void removeMismatches(Port port1, int circuit1, Port port2, int circuit2) {
            Iterator it = this.unmatched.iterator();
            while (it.hasNext()) {
                NoPortNameMatch u = (NoPortNameMatch)it.next();
                if ((u.port != port1 || u.circuitNoMatchingPort != circuit2) && (u.port != port2 || u.circuitNoMatchingPort != circuit1)) continue;
                it.remove();
            }
        }
    }

    private static class NoPortNameMatch {
        public final Port port;
        public final int circuit;
        public final int circuitNoMatchingPort;

        public NoPortNameMatch(Port port, int circuit, int circuitNoMatchingPort) {
            this.port = port;
            this.circuit = circuit;
            this.circuitNoMatchingPort = circuitNoMatchingPort;
        }
    }
}

