/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.menus;

import com.sun.electric.database.change.Undo;
import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.Geometric;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.FPGA;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.CircuitChanges;
import com.sun.electric.tool.user.Clipboard;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.Array;
import com.sun.electric.tool.user.dialogs.ArtworkLook;
import com.sun.electric.tool.user.dialogs.Attributes;
import com.sun.electric.tool.user.dialogs.Change;
import com.sun.electric.tool.user.dialogs.ChangeText;
import com.sun.electric.tool.user.dialogs.EditKeyBindings;
import com.sun.electric.tool.user.dialogs.FindText;
import com.sun.electric.tool.user.dialogs.GetInfoArc;
import com.sun.electric.tool.user.dialogs.GetInfoExport;
import com.sun.electric.tool.user.dialogs.GetInfoMulti;
import com.sun.electric.tool.user.dialogs.GetInfoNode;
import com.sun.electric.tool.user.dialogs.GetInfoOutline;
import com.sun.electric.tool.user.dialogs.GetInfoText;
import com.sun.electric.tool.user.dialogs.MoveBy;
import com.sun.electric.tool.user.dialogs.SelectObject;
import com.sun.electric.tool.user.dialogs.SpecialProperties;
import com.sun.electric.tool.user.dialogs.Spread;
import com.sun.electric.tool.user.menus.MenuBar;
import com.sun.electric.tool.user.menus.MenuCommands;
import com.sun.electric.tool.user.tecEdit.LibToTech;
import com.sun.electric.tool.user.tecEdit.Manipulate;
import com.sun.electric.tool.user.tecEdit.TechToLib;
import com.sun.electric.tool.user.ui.CurveListener;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.OutlineListener;
import com.sun.electric.tool.user.ui.SizeListener;
import com.sun.electric.tool.user.ui.ToolBar;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WaveformWindow;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class EditMenu {
    private static JMenuItem moveFull;
    private static JMenuItem moveHalf;
    private static JMenuItem moveQuarter;

    public static void setGridAligment(double ad) {
        if (ad == 1.0) {
            moveFull.setSelected(true);
        } else if (ad == 0.5) {
            moveHalf.setSelected(true);
        } else if (ad == 0.25) {
            moveQuarter.setSelected(true);
        }
    }

    protected static void addEditMenu(MenuBar menuBar) {
        int buckyBit = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        MenuBar.Menu editMenu = MenuBar.makeMenu("_Edit");
        menuBar.add(editMenu);
        editMenu.addMenuItem("Cu_t", KeyStroke.getKeyStroke(88, buckyBit), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Clipboard.cut();
            }
        });
        editMenu.addMenuItem("Cop_y", KeyStroke.getKeyStroke(67, buckyBit), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Clipboard.copy();
            }
        });
        editMenu.addMenuItem("_Paste", KeyStroke.getKeyStroke(86, buckyBit), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Clipboard.paste(false);
            }
        });
        editMenu.addMenuItem("Dup_licate", KeyStroke.getKeyStroke(77, buckyBit), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Clipboard.duplicate();
            }
        });
        editMenu.addSeparator();
        MenuBar.MenuItem undo = editMenu.addMenuItem("_Undo", KeyStroke.getKeyStroke(90, buckyBit), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditMenu.undoCommand();
            }
        });
        Undo.addPropertyChangeListener(new MenuCommands.MenuEnabler(undo, "UndoEnabled"));
        undo.setEnabled(Undo.getUndoEnabled());
        MenuBar.MenuItem redo = editMenu.addMenuItem("Re_do", KeyStroke.getKeyStroke(89, buckyBit), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditMenu.redoCommand();
            }
        });
        Undo.addPropertyChangeListener(new MenuCommands.MenuEnabler(redo, "RedoEnabled"));
        redo.setEnabled(Undo.getRedoEnabled());
        MenuBar.MenuItem repeatAction = editMenu.addMenuItem("Repeat Last Action", KeyStroke.getKeyStroke(150, 0), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditMenu.repeatLastCommand();
            }
        });
        editMenu.addSeparator();
        MenuBar.Menu rotateSubMenu = MenuBar.makeMenu("_Rotate");
        editMenu.add(rotateSubMenu);
        rotateSubMenu.addMenuItem("90 Degrees Clock_wise", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CircuitChanges.rotateObjects(2700);
            }
        });
        rotateSubMenu.addMenuItem("90 Degrees _Counterclockwise", KeyStroke.getKeyStroke(74, buckyBit), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CircuitChanges.rotateObjects(900);
            }
        });
        rotateSubMenu.addMenuItem("180 _Degrees", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CircuitChanges.rotateObjects(1800);
            }
        });
        rotateSubMenu.addMenuItem("_Other...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CircuitChanges.rotateObjects(0);
            }
        });
        MenuBar.Menu mirrorSubMenu = MenuBar.makeMenu("_Mirror");
        editMenu.add(mirrorSubMenu);
        mirrorSubMenu.addMenuItem("_Up <-> Down", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CircuitChanges.mirrorObjects(true);
            }
        });
        mirrorSubMenu.addMenuItem("_Left <-> Right", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CircuitChanges.mirrorObjects(false);
            }
        });
        MenuBar.Menu sizeSubMenu = MenuBar.makeMenu("Si_ze");
        editMenu.add(sizeSubMenu);
        sizeSubMenu.addMenuItem("_Interactively", KeyStroke.getKeyStroke(66, buckyBit), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SizeListener.sizeObjects();
            }
        });
        sizeSubMenu.addMenuItem("All Selected _Nodes...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SizeListener.sizeAllNodes();
            }
        });
        sizeSubMenu.addMenuItem("All Selected _Arcs...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SizeListener.sizeAllArcs();
            }
        });
        MenuBar.Menu moveSubMenu = MenuBar.makeMenu("Mo_ve");
        editMenu.add(moveSubMenu);
        moveSubMenu.addMenuItem("_Spread...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Spread.showSpreadDialog();
            }
        });
        moveSubMenu.addMenuItem("_Move Objects By...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MoveBy.showMoveByDialog();
            }
        });
        moveSubMenu.addMenuItem("_Align to Grid", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CircuitChanges.alignToGrid();
            }
        });
        moveSubMenu.addSeparator();
        moveSubMenu.addMenuItem("Align Horizontally to _Left", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CircuitChanges.alignNodes(true, 0);
            }
        });
        moveSubMenu.addMenuItem("Align Horizontally to _Right", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CircuitChanges.alignNodes(true, 1);
            }
        });
        moveSubMenu.addMenuItem("Align Horizontally to _Center", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CircuitChanges.alignNodes(true, 2);
            }
        });
        moveSubMenu.addSeparator();
        moveSubMenu.addMenuItem("Align Vertically to _Top", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CircuitChanges.alignNodes(false, 0);
            }
        });
        moveSubMenu.addMenuItem("Align Vertically to _Bottom", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CircuitChanges.alignNodes(false, 1);
            }
        });
        moveSubMenu.addMenuItem("Align _Vertically to Center", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CircuitChanges.alignNodes(false, 2);
            }
        });
        editMenu.addSeparator();
        MenuBar.MenuItem m = editMenu.addMenuItem("_Erase", KeyStroke.getKeyStroke(127, 0), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CircuitChanges.deleteSelected();
            }
        });
        menuBar.addDefaultKeyBinding(m, KeyStroke.getKeyStroke(8, 0), null);
        editMenu.addMenuItem("_Array...", KeyStroke.getKeyStroke(117, 0), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Array.showArrayDialog();
            }
        });
        editMenu.addMenuItem("C_hange...", KeyStroke.getKeyStroke(67, 0), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Change.showChangeDialog();
            }
        });
        editMenu.addSeparator();
        MenuBar.Menu editInfoSubMenu = MenuBar.makeMenu("In_fo");
        editMenu.add(editInfoSubMenu);
        editInfoSubMenu.addMenuItem("Show _Undo List", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditMenu.showUndoListCommand();
            }
        });
        MenuBar.Menu editPropertiesSubMenu = MenuBar.makeMenu("Propert_ies");
        editMenu.add(editPropertiesSubMenu);
        editPropertiesSubMenu.addMenuItem("_Object Properties...", KeyStroke.getKeyStroke(73, buckyBit), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditMenu.getInfoCommand(false);
            }
        });
        editPropertiesSubMenu.addMenuItem("_Attribute Properties...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Attributes.showDialog();
            }
        });
        editPropertiesSubMenu.addSeparator();
        editPropertiesSubMenu.addMenuItem("_See All Attributes on Node", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditMenu.seeAllParametersCommand();
            }
        });
        editPropertiesSubMenu.addMenuItem("_Hide All Attributes on Node", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditMenu.hideAllParametersCommand();
            }
        });
        editPropertiesSubMenu.addMenuItem("_Default Attribute Visibility", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditMenu.defaultParamVisibilityCommand();
            }
        });
        editPropertiesSubMenu.addMenuItem("Update Attributes Inheritance on _Node", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditMenu.updateInheritance(false);
            }
        });
        editPropertiesSubMenu.addMenuItem("Update Attributes Inheritance all _Libraries", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditMenu.updateInheritance(true);
            }
        });
        MenuBar.Menu arcSubMenu = MenuBar.makeMenu("Ar_c");
        editMenu.add(arcSubMenu);
        arcSubMenu.addMenuItem("_Rigid", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CircuitChanges.arcRigidCommand();
            }
        });
        arcSubMenu.addMenuItem("_Not Rigid", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CircuitChanges.arcNotRigidCommand();
            }
        });
        arcSubMenu.addMenuItem("_Fixed Angle", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CircuitChanges.arcFixedAngleCommand();
            }
        });
        arcSubMenu.addMenuItem("Not Fixed _Angle", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CircuitChanges.arcNotFixedAngleCommand();
            }
        });
        arcSubMenu.addSeparator();
        arcSubMenu.addMenuItem("Toggle _Directionality", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CircuitChanges.arcDirectionalCommand();
            }
        });
        arcSubMenu.addMenuItem("Toggle End Extension of _Head", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CircuitChanges.arcHeadExtendCommand();
            }
        });
        arcSubMenu.addMenuItem("Toggle End Extension of _Tail", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CircuitChanges.arcTailExtendCommand();
            }
        });
        arcSubMenu.addSeparator();
        arcSubMenu.addMenuItem("Insert _Jog In Arc", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditMenu.insertJogInArcCommand();
            }
        });
        arcSubMenu.addMenuItem("Rip _Bus", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CircuitChanges.ripBus();
            }
        });
        arcSubMenu.addSeparator();
        arcSubMenu.addMenuItem("_Curve through Cursor", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CurveListener.setCurvature(true);
            }
        });
        arcSubMenu.addMenuItem("Curve abo_ut Cursor", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CurveListener.setCurvature(false);
            }
        });
        arcSubMenu.addMenuItem("Re_move Curvature", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CurveListener.removeCurvature();
            }
        });
        MenuBar.Menu modeSubMenu = MenuBar.makeMenu("M_odes");
        editMenu.add(modeSubMenu);
        MenuBar.Menu modeSubMenuEdit = MenuBar.makeMenu("_Edit");
        modeSubMenu.add(modeSubMenuEdit);
        ButtonGroup editGroup = new ButtonGroup();
        JMenuItem cursorClickZoomWire = modeSubMenuEdit.addRadioButton("Click/Zoom/Wire", true, editGroup, KeyStroke.getKeyStroke(83, 0), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolBar.clickZoomWireCommand();
            }
        });
        ToolBar.CursorMode cm = ToolBar.getCursorMode();
        if (cm == ToolBar.CursorMode.CLICKZOOMWIRE) {
            cursorClickZoomWire.setSelected(true);
        }
        JMenuItem cursorPan = modeSubMenuEdit.addRadioButton("Toggle Pan", false, editGroup, KeyStroke.getKeyStroke(80, 0), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolBar.panCommand();
            }
        });
        JMenuItem cursorZoom = modeSubMenuEdit.addRadioButton("Toggle Zoom", false, editGroup, KeyStroke.getKeyStroke(90, 0), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolBar.zoomCommand();
            }
        });
        JMenuItem cursorOutline = modeSubMenuEdit.addRadioButton("Toggle Outline Edit", false, editGroup, KeyStroke.getKeyStroke(89, 0), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolBar.outlineEditCommand();
            }
        });
        JMenuItem cursorMeasure = modeSubMenuEdit.addRadioButton("Toggle Measure Distance", false, editGroup, KeyStroke.getKeyStroke(77, 0), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolBar.measureCommand();
            }
        });
        if (cm == ToolBar.CursorMode.PAN) {
            cursorPan.setSelected(true);
        }
        if (cm == ToolBar.CursorMode.ZOOM) {
            cursorZoom.setSelected(true);
        }
        if (cm == ToolBar.CursorMode.OUTLINE) {
            cursorOutline.setSelected(true);
        }
        if (cm == ToolBar.CursorMode.MEASURE) {
            cursorMeasure.setSelected(true);
        }
        MenuBar.Menu modeSubMenuMovement = MenuBar.makeMenu("_Movement");
        modeSubMenu.add(modeSubMenuMovement);
        ButtonGroup movementGroup = new ButtonGroup();
        moveFull = modeSubMenuMovement.addRadioButton("Full", true, movementGroup, KeyStroke.getKeyStroke(70, 0), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolBar.arrowDistanceCommand(ToolBar.ArrowDistance.FULL);
            }
        });
        moveHalf = modeSubMenuMovement.addRadioButton("Half", false, movementGroup, KeyStroke.getKeyStroke(72, 0), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolBar.arrowDistanceCommand(ToolBar.ArrowDistance.HALF);
            }
        });
        moveQuarter = modeSubMenuMovement.addRadioButton("Quarter", false, movementGroup, null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolBar.arrowDistanceCommand(ToolBar.ArrowDistance.QUARTER);
            }
        });
        EditMenu.setGridAligment(User.getAlignmentToGrid());
        MenuBar.Menu modeSubMenuSelect = MenuBar.makeMenu("_Select");
        modeSubMenu.add(modeSubMenuSelect);
        ButtonGroup selectGroup = new ButtonGroup();
        JMenuItem selectArea = modeSubMenuSelect.addRadioButton("Area", true, selectGroup, null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolBar.selectAreaCommand();
            }
        });
        JMenuItem selectObjects = modeSubMenuSelect.addRadioButton("Objects", false, selectGroup, null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolBar.selectObjectsCommand();
            }
        });
        ToolBar.SelectMode sm = ToolBar.getSelectMode();
        if (sm == ToolBar.SelectMode.AREA) {
            selectArea.setSelected(true);
        } else {
            selectObjects.setSelected(true);
        }
        modeSubMenuSelect.addCheckBox("Special Select", false, null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolBar.toggleSelectSpecialCommand(e);
            }
        });
        MenuBar.Menu textSubMenu = MenuBar.makeMenu("Te_xt");
        editMenu.add(textSubMenu);
        textSubMenu.addMenuItem("_Find Text...", KeyStroke.getKeyStroke(76, buckyBit), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FindText.findTextDialog();
            }
        });
        textSubMenu.addMenuItem("_Change Text Size...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ChangeText.changeTextDialog();
            }
        });
        textSubMenu.addMenuItem("_Increase All Text Size", KeyStroke.getKeyStroke(61, buckyBit), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditMenu.changeGlobalTextSize(1.25);
            }
        });
        textSubMenu.addMenuItem("_Decrease All Text Size", KeyStroke.getKeyStroke(45, buckyBit), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditMenu.changeGlobalTextSize(0.8);
            }
        });
        MenuBar.Menu cleanupSubMenu = MenuBar.makeMenu("Clea_nup Cell");
        editMenu.add(cleanupSubMenu);
        cleanupSubMenu.addMenuItem("Cleanup _Pins", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CircuitChanges.cleanupPinsCommand(false);
            }
        });
        cleanupSubMenu.addMenuItem("Cleanup Pins _Everywhere", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CircuitChanges.cleanupPinsCommand(true);
            }
        });
        cleanupSubMenu.addMenuItem("Show _Nonmanhattan", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CircuitChanges.showNonmanhattanCommand();
            }
        });
        cleanupSubMenu.addMenuItem("Show Pure _Layer Nodes", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CircuitChanges.showPureLayerCommand();
            }
        });
        cleanupSubMenu.addMenuItem("_Shorten Selected Arcs", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CircuitChanges.shortenArcsCommand();
            }
        });
        MenuBar.Menu specialSubMenu = MenuBar.makeMenu("Technolo_gy Specific");
        editMenu.add(specialSubMenu);
        specialSubMenu.addMenuItem("Toggle Port _Negation", KeyStroke.getKeyStroke(84, buckyBit), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CircuitChanges.toggleNegatedCommand();
            }
        });
        specialSubMenu.addMenuItem("_Artwork Appearance...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ArtworkLook.showArtworkLookDialog();
            }
        });
        specialSubMenu.addSeparator();
        MenuBar.Menu fpgaSubMenu = MenuBar.makeMenu("_FPGA");
        specialSubMenu.add(fpgaSubMenu);
        fpgaSubMenu.addMenuItem("Read _Architecture And Primitives...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FPGA.readArchitectureFile(true);
            }
        });
        fpgaSubMenu.addMenuItem("Read P_rimitives...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FPGA.readArchitectureFile(false);
            }
        });
        fpgaSubMenu.addSeparator();
        fpgaSubMenu.addMenuItem("Edit _Pips...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FPGA.programPips();
            }
        });
        fpgaSubMenu.addSeparator();
        fpgaSubMenu.addMenuItem("Show _No Wires", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FPGA.setWireDisplay(0);
            }
        });
        fpgaSubMenu.addMenuItem("Show A_ctive Wires", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FPGA.setWireDisplay(1);
            }
        });
        fpgaSubMenu.addMenuItem("Show All _Wires", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FPGA.setWireDisplay(2);
            }
        });
        fpgaSubMenu.addSeparator();
        fpgaSubMenu.addMenuItem("_Show Text", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FPGA.setTextDisplay(true);
            }
        });
        fpgaSubMenu.addMenuItem("_Hide Text", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FPGA.setTextDisplay(false);
            }
        });
        specialSubMenu.addSeparator();
        specialSubMenu.addMenuItem("Convert Technology to _Library for Editing...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TechToLib.makeLibFromTech();
            }
        });
        specialSubMenu.addMenuItem("Convert Library to _Technology...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LibToTech.makeTechFromLib();
            }
        });
        specialSubMenu.addSeparator();
        specialSubMenu.addMenuItem("_Identify Primitive Layers", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Manipulate.identifyLayers(false);
            }
        });
        specialSubMenu.addMenuItem("Identify _Ports", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Manipulate.identifyLayers(true);
            }
        });
        specialSubMenu.addSeparator();
        specialSubMenu.addMenuItem("Edit Library _Dependencies...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Manipulate.editLibraryDependencies();
            }
        });
        specialSubMenu.addSeparator();
        specialSubMenu.addMenuItem("Descri_be this Technology", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditMenu.describeTechnologyCommand();
            }
        });
        specialSubMenu.addMenuItem("Do_cument Current Technology", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Manipulate.describeTechnology(Technology.getCurrent());
            }
        });
        specialSubMenu.addSeparator();
        specialSubMenu.addMenuItem("Rena_me Current Technology...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CircuitChanges.renameCurrentTechnology();
            }
        });
        MenuBar.Menu selListSubMenu = MenuBar.makeMenu("_Selection");
        editMenu.add(selListSubMenu);
        selListSubMenu.addMenuItem("Sele_ct All", KeyStroke.getKeyStroke(65, buckyBit), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditMenu.selectAllCommand();
            }
        });
        selListSubMenu.addMenuItem("Select All Like _This", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditMenu.selectAllLikeThisCommand();
            }
        });
        selListSubMenu.addMenuItem("Select All _Easy", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditMenu.selectEasyCommand();
            }
        });
        selListSubMenu.addMenuItem("Select All _Hard", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditMenu.selectHardCommand();
            }
        });
        selListSubMenu.addMenuItem("Select Nothin_g", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditMenu.selectNothingCommand();
            }
        });
        selListSubMenu.addSeparator();
        selListSubMenu.addMenuItem("_Select Object...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SelectObject.selectObjectDialog();
            }
        });
        selListSubMenu.addMenuItem("Deselect All _Arcs", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditMenu.deselectAllArcsCommand();
            }
        });
        selListSubMenu.addSeparator();
        selListSubMenu.addMenuItem("Make Selected Eas_y", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditMenu.selectMakeEasyCommand();
            }
        });
        selListSubMenu.addMenuItem("Make Selected Har_d", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditMenu.selectMakeHardCommand();
            }
        });
        selListSubMenu.addSeparator();
        selListSubMenu.addMenuItem("P_ush Selection", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditWindow wnd = EditWindow.getCurrent();
                if (wnd == null) {
                    return;
                }
                wnd.getHighlighter().pushHighlight();
            }
        });
        selListSubMenu.addMenuItem("P_op Selection", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditWindow wnd = EditWindow.getCurrent();
                if (wnd == null) {
                    return;
                }
                wnd.getHighlighter().popHighlight();
            }
        });
        selListSubMenu.addSeparator();
        selListSubMenu.addMenuItem("Enclosed Ob_jects", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditMenu.selectEnclosedObjectsCommand();
            }
        });
        selListSubMenu.addSeparator();
        selListSubMenu.addMenuItem("Show Ne_xt Error", KeyStroke.getKeyStroke('>'), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditMenu.showNextErrorCommand();
            }
        });
        selListSubMenu.addMenuItem("Show Pre_vious Error", KeyStroke.getKeyStroke('<'), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditMenu.showPrevErrorCommand();
            }
        });
        selListSubMenu.addSeparator();
        selListSubMenu.addMenuItem("Add to Waveform in _New Panel", KeyStroke.getKeyStroke(65, 0), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditMenu.addToWaveformNewCommand();
            }
        });
        selListSubMenu.addMenuItem("Add to _Waveform in Current Panel", KeyStroke.getKeyStroke(79, 0), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditMenu.addToWaveformCurrentCommand();
            }
        });
    }

    public static void undoCommand() {
        new UndoCommand();
    }

    public static void redoCommand() {
        new RedoCommand();
    }

    public static void repeatLastCommand() {
        AbstractButton lastActivated = MenuBar.repeatLastCommandListener.getLastActivated();
        if (lastActivated != null) {
            lastActivated.doClick();
        }
    }

    public static void keyBindingsCommand() {
        TopLevel top = TopLevel.getCurrentJFrame();
        EditKeyBindings dialog = new EditKeyBindings(top.getTheMenuBar(), top, true);
        dialog.setVisible(true);
    }

    public static void getInfoCommand(boolean doubleClick) {
        EditWindow wnd = EditWindow.getCurrent();
        if (wnd == null) {
            return;
        }
        if (wnd.getHighlighter().getNumHighlights() == 0) {
            Cell c = WindowFrame.getCurrentCell();
            if (c != null) {
                c.getInfo();
            }
        } else {
            int arcCount = 0;
            int nodeCount = 0;
            int exportCount = 0;
            int textCount = 0;
            int graphicsCount = 0;
            NodeInst theNode = null;
            Iterator it = wnd.getHighlighter().getHighlights().iterator();
            while (it.hasNext()) {
                Highlight h = (Highlight)it.next();
                ElectricObject eobj = h.getElectricObject();
                if (h.getType() == Highlight.Type.EOBJ) {
                    if (eobj instanceof NodeInst || eobj instanceof PortInst) {
                        ++nodeCount;
                        if (eobj instanceof NodeInst) {
                            theNode = (NodeInst)eobj;
                            continue;
                        }
                        theNode = ((PortInst)eobj).getNodeInst();
                        continue;
                    }
                    if (!(eobj instanceof ArcInst)) continue;
                    ++arcCount;
                    continue;
                }
                if (h.getType() == Highlight.Type.TEXT) {
                    if (eobj instanceof Export) {
                        if (h.getVar() != null) {
                            ++textCount;
                            continue;
                        }
                        ++exportCount;
                        continue;
                    }
                    if (eobj instanceof NodeInst) {
                        theNode = (NodeInst)eobj;
                    }
                    ++textCount;
                    continue;
                }
                if (h.getType() == Highlight.Type.BBOX) {
                    ++graphicsCount;
                    continue;
                }
                if (h.getType() != Highlight.Type.LINE) continue;
                ++graphicsCount;
            }
            if (doubleClick && arcCount == 0 && exportCount == 0 && graphicsCount == 0 && nodeCount + textCount == 1 && theNode != null && SpecialProperties.doubleClickOnNode(wnd, theNode)) {
                return;
            }
            if (arcCount <= 1 && nodeCount <= 1 && exportCount <= 1 && textCount <= 1 && graphicsCount == 0) {
                if (arcCount == 1) {
                    GetInfoArc.showDialog();
                }
                if (nodeCount == 1) {
                    if (WindowFrame.getListener() == OutlineListener.theOne) {
                        GetInfoOutline.showOutlinePropertiesDialog();
                    } else {
                        GetInfoNode.showDialog();
                    }
                }
                if (exportCount == 1) {
                    if (doubleClick) {
                        GetInfoText.editTextInPlace();
                    } else {
                        GetInfoExport.showDialog();
                    }
                }
                if (textCount == 1) {
                    if (doubleClick) {
                        GetInfoText.editTextInPlace();
                    } else {
                        GetInfoText.showDialog();
                    }
                }
            } else {
                GetInfoMulti.showDialog();
            }
        }
    }

    public static void seeAllParametersCommand() {
        ParameterVisibility job = new ParameterVisibility(0, MenuCommands.getSelectedObjects(true, false));
    }

    public static void hideAllParametersCommand() {
        ParameterVisibility job = new ParameterVisibility(1, MenuCommands.getSelectedObjects(true, false));
    }

    public static void defaultParamVisibilityCommand() {
        ParameterVisibility job = new ParameterVisibility(2, MenuCommands.getSelectedObjects(true, false));
    }

    private static Variable findParameterSource(Variable var, NodeInst ni) {
        Cell np = (Cell)ni.getProto();
        Cell cnp = np.contentsView();
        if (cnp != null) {
            np = cnp;
        }
        Iterator it = np.getVariables();
        while (it.hasNext()) {
            Variable nVar = (Variable)it.next();
            if (var.getKey() != nVar.getKey()) continue;
            return nVar;
        }
        return null;
    }

    public static void updateInheritance(boolean allLibraries) {
        List highlighted = MenuCommands.getSelectedObjects(true, false);
        UpdateAttributes job = new UpdateAttributes(highlighted, allLibraries, 0);
    }

    public static void changeGlobalTextSize(double scale) {
        double curScale = User.getGlobalTextScale();
        if ((curScale *= scale) != 0.0) {
            User.setGlobalTextScale(curScale);
            EditWindow.repaintAllContents();
        }
    }

    public static void selectAllCommand() {
        EditMenu.doSelection(false, false);
    }

    public static void selectEasyCommand() {
        EditMenu.doSelection(true, false);
    }

    public static void selectHardCommand() {
        EditMenu.doSelection(false, true);
    }

    private static void doSelection(boolean mustBeEasy, boolean mustBeHard) {
        boolean hard;
        Cell curCell = WindowFrame.needCurCell();
        if (curCell == null) {
            return;
        }
        EditWindow wnd = EditWindow.getCurrent();
        if (wnd == null) {
            return;
        }
        Highlighter highlighter = wnd.getHighlighter();
        boolean cellsAreHard = !User.isEasySelectionOfCellInstances();
        highlighter.clear();
        Iterator it = curCell.getNodes();
        block0: while (it.hasNext()) {
            NodeInst ni = (NodeInst)it.next();
            if (ni.getProto() == Generic.tech.cellCenterNode && !mustBeEasy && !mustBeHard) continue;
            hard = ni.isHardSelect();
            if (ni.getProto() instanceof Cell && cellsAreHard) {
                hard = true;
            }
            if (mustBeEasy && hard || mustBeHard && !hard) continue;
            if (ni.isInvisiblePinWithText()) {
                Iterator vIt = ni.getVariables();
                while (vIt.hasNext()) {
                    Variable var = (Variable)vIt.next();
                    if (!var.isDisplay()) continue;
                    highlighter.addText(ni, curCell, var, null);
                    continue block0;
                }
                continue;
            }
            highlighter.addElectricObject(ni, curCell);
        }
        it = curCell.getArcs();
        while (it.hasNext()) {
            ArcInst ai = (ArcInst)it.next();
            hard = ai.isHardSelect();
            if (mustBeEasy && hard || mustBeHard && !hard) continue;
            highlighter.addElectricObject(ai, curCell);
        }
        it = curCell.getVariables();
        while (it.hasNext()) {
            Variable var = (Variable)it.next();
            if (!var.isAttribute()) continue;
            highlighter.addText(curCell, curCell, var, null);
        }
        highlighter.finished();
    }

    public static void selectAllLikeThisCommand() {
        Object isLikeThis;
        Cell curCell = WindowFrame.needCurCell();
        if (curCell == null) {
            return;
        }
        EditWindow wnd = EditWindow.getCurrent();
        if (wnd == null) {
            return;
        }
        Highlighter highlighter = wnd.getHighlighter();
        HashMap<Object, Geometric> likeThis = new HashMap<Object, Geometric>();
        List highlighted = highlighter.getHighlightedEObjs(true, true);
        Iterator it = highlighted.iterator();
        while (it.hasNext()) {
            Geometric geom = (Geometric)it.next();
            if (geom instanceof NodeInst) {
                NodeInst ni = (NodeInst)geom;
                likeThis.put(ni.getProto(), ni);
                continue;
            }
            ArcInst ai = (ArcInst)geom;
            likeThis.put(ai.getProto(), ai);
        }
        highlighter.clear();
        it = curCell.getNodes();
        block1: while (it.hasNext()) {
            NodeInst ni = (NodeInst)it.next();
            isLikeThis = likeThis.get(ni.getProto());
            if (isLikeThis == null) continue;
            if (ni.isInvisiblePinWithText()) {
                Iterator vIt = ni.getVariables();
                while (vIt.hasNext()) {
                    Variable var = (Variable)vIt.next();
                    if (!var.isDisplay()) continue;
                    highlighter.addText(ni, curCell, var, null);
                    continue block1;
                }
                continue;
            }
            highlighter.addElectricObject(ni, curCell);
        }
        it = curCell.getArcs();
        while (it.hasNext()) {
            ArcInst ai = (ArcInst)it.next();
            isLikeThis = likeThis.get(ai.getProto());
            if (isLikeThis == null) continue;
            highlighter.addElectricObject(ai, curCell);
        }
        highlighter.finished();
        System.out.println("Selected " + highlighter.getNumHighlights() + " objects");
    }

    public static void selectNothingCommand() {
        EditWindow wnd = EditWindow.getCurrent();
        if (wnd == null) {
            return;
        }
        wnd.getHighlighter().clear();
        wnd.getHighlighter().finished();
    }

    public static void deselectAllArcsCommand() {
        EditWindow wnd = EditWindow.getCurrent();
        if (wnd == null) {
            return;
        }
        Highlighter highlighter = wnd.getHighlighter();
        ArrayList<Highlight> newHighList = new ArrayList<Highlight>();
        Iterator it = highlighter.getHighlights().iterator();
        while (it.hasNext()) {
            Highlight h = (Highlight)it.next();
            if ((h.getType() == Highlight.Type.EOBJ || h.getType() == Highlight.Type.TEXT) && h.getElectricObject() instanceof ArcInst) continue;
            newHighList.add(h);
        }
        highlighter.clear();
        highlighter.setHighlightList(newHighList);
        highlighter.finished();
    }

    public static void selectMakeEasyCommand() {
        EditWindow wnd = EditWindow.getCurrent();
        if (wnd == null) {
            return;
        }
        List highlighted = wnd.getHighlighter().getHighlightedEObjs(true, true);
        new SetEasyHardSelect(true, highlighted);
    }

    public static void selectMakeHardCommand() {
        EditWindow wnd = EditWindow.getCurrent();
        if (wnd == null) {
            return;
        }
        List highlighted = wnd.getHighlighter().getHighlightedEObjs(true, true);
        new SetEasyHardSelect(false, highlighted);
    }

    public static void selectEnclosedObjectsCommand() {
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Highlighter highlighter = wnd.getHighlighter();
        Rectangle2D selection = highlighter.getHighlightedArea(wnd);
        highlighter.clear();
        if (selection != null) {
            highlighter.selectArea(wnd, selection.getMinX(), selection.getMaxX(), selection.getMinY(), selection.getMaxY(), false, ToolBar.getSelectSpecial());
        }
        highlighter.finished();
    }

    public static void showNextErrorCommand() {
        String msg = ErrorLogger.reportNextMessage();
        System.out.println(msg);
    }

    public static void showPrevErrorCommand() {
        String msg = ErrorLogger.reportPrevMessage();
        System.out.println(msg);
    }

    public static void addToWaveformNewCommand() {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (!(wf.getContent() instanceof EditWindow)) {
            return;
        }
        EditWindow wnd = (EditWindow)wf.getContent();
        WaveformWindow.Locator wwLoc = new WaveformWindow.Locator(wnd);
        WaveformWindow ww = wwLoc.getWaveformWindow();
        if (ww == null) {
            System.out.println("Cannot add selected signals to the waveform window: no waveform window is associated with this cell");
            return;
        }
        Set nets = wnd.getHighlighter().getHighlightedNetworks();
        ww.showSignals(nets, wwLoc.getContext(), true);
    }

    public static void addToWaveformCurrentCommand() {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (!(wf.getContent() instanceof EditWindow)) {
            return;
        }
        EditWindow wnd = (EditWindow)wf.getContent();
        WaveformWindow.Locator wwLoc = new WaveformWindow.Locator(wnd);
        WaveformWindow ww = wwLoc.getWaveformWindow();
        if (ww == null) {
            System.out.println("Cannot overlay selected signals to the waveform window: no waveform window is associated with this cell");
            return;
        }
        Set nets = wnd.getHighlighter().getHighlightedNetworks();
        ww.showSignals(nets, wwLoc.getContext(), false);
    }

    public static void insertJogInArcCommand() {
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        ArcInst ai = (ArcInst)wnd.getHighlighter().getOneElectricObject(ArcInst.class);
        if (ai == null) {
            return;
        }
        System.out.println("Select the position in the arc to place the jog");
        EventListener currentListener = WindowFrame.getListener();
        WindowFrame.setListener(new InsertJogInArcListener(wnd, ai, currentListener));
    }

    public static void showUndoListCommand() {
        Undo.showHistoryList();
    }

    public static void describeTechnologyCommand() {
        PrimitiveNode.Function fun;
        PrimitiveNode np;
        Technology tech = Technology.getCurrent();
        System.out.println("Technology " + tech.getTechName());
        System.out.println("    Full name: " + tech.getTechDesc());
        if (tech.isScaleRelevant()) {
            System.out.println("    Scale: 1 grid unit is " + tech.getScale() + " nanometers (" + tech.getScale() / 1000.0 + " microns)");
        }
        int arcCount = 0;
        Iterator it = tech.getArcs();
        while (it.hasNext()) {
            ArcProto ap = (ArcProto)it.next();
            if (ap.isNotUsed()) continue;
            ++arcCount;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("    Has " + arcCount + " arcs (wires):");
        Iterator it2 = tech.getArcs();
        while (it2.hasNext()) {
            ArcProto ap = (ArcProto)it2.next();
            if (ap.isNotUsed()) continue;
            sb.append(" " + ap.getName());
        }
        System.out.println(sb.toString());
        int pinCount = 0;
        int totalCount = 0;
        int pureCount = 0;
        int contactCount = 0;
        Iterator it3 = tech.getNodes();
        while (it3.hasNext()) {
            np = (PrimitiveNode)it3.next();
            if (np.isNotUsed()) continue;
            fun = np.getFunction();
            ++totalCount;
            if (fun == PrimitiveNode.Function.PIN) {
                ++pinCount;
                continue;
            }
            if (fun == PrimitiveNode.Function.CONTACT || fun == PrimitiveNode.Function.CONNECT) {
                ++contactCount;
                continue;
            }
            if (fun != PrimitiveNode.Function.NODE) continue;
            ++pureCount;
        }
        if (pinCount > 0) {
            sb = new StringBuffer();
            sb.append("    Has " + pinCount + " pin nodes for making bends in arcs:");
            it3 = tech.getNodes();
            while (it3.hasNext()) {
                np = (PrimitiveNode)it3.next();
                if (np.isNotUsed() || (fun = np.getFunction()) != PrimitiveNode.Function.PIN) continue;
                sb.append(" " + np.getName());
            }
            System.out.println(sb.toString());
        }
        if (contactCount > 0) {
            sb = new StringBuffer();
            sb.append("    Has " + contactCount + " contact nodes for joining different arcs:");
            it3 = tech.getNodes();
            while (it3.hasNext()) {
                np = (PrimitiveNode)it3.next();
                if (np.isNotUsed() || (fun = np.getFunction()) != PrimitiveNode.Function.CONTACT && fun != PrimitiveNode.Function.CONNECT) continue;
                sb.append(" " + np.getName());
            }
            System.out.println(sb.toString());
        }
        if (pinCount + contactCount + pureCount < totalCount) {
            sb = new StringBuffer();
            sb.append("    Has " + (totalCount - pinCount - contactCount - pureCount) + " regular nodes:");
            it3 = tech.getNodes();
            while (it3.hasNext()) {
                np = (PrimitiveNode)it3.next();
                if (np.isNotUsed() || (fun = np.getFunction()) == PrimitiveNode.Function.PIN || fun == PrimitiveNode.Function.CONTACT || fun == PrimitiveNode.Function.CONNECT || fun == PrimitiveNode.Function.NODE) continue;
                sb.append(" " + np.getName());
            }
            System.out.println(sb.toString());
        }
        if (pureCount > 0) {
            sb = new StringBuffer();
            sb.append("    Has " + pureCount + " pure-layer nodes for creating custom geometry:");
            it3 = tech.getNodes();
            while (it3.hasNext()) {
                np = (PrimitiveNode)it3.next();
                if (np.isNotUsed() || (fun = np.getFunction()) != PrimitiveNode.Function.NODE) continue;
                sb.append(" " + np.getName());
            }
            System.out.println(sb.toString());
        }
    }

    private static class InsertJogInArcListener
    implements MouseMotionListener,
    MouseListener,
    MouseWheelListener,
    KeyListener {
        private EditWindow wnd;
        private ArcInst ai;
        private EventListener currentListener;

        public InsertJogInArcListener(EditWindow wnd, ArcInst ai, EventListener currentListener) {
            this.wnd = wnd;
            this.ai = ai;
            this.currentListener = currentListener;
        }

        public void mousePressed(MouseEvent evt) {
        }

        public void mouseClicked(MouseEvent evt) {
        }

        public void mouseEntered(MouseEvent evt) {
        }

        public void mouseExited(MouseEvent evt) {
        }

        public void mouseDragged(MouseEvent evt) {
            this.mouseMoved(evt);
        }

        public void mouseReleased(MouseEvent evt) {
            Point2D insert = this.getInsertPoint(evt);
            InsertJogPoint job = new InsertJogPoint(this.ai, insert, this.wnd.getHighlighter());
            WindowFrame.setListener(this.currentListener);
        }

        public void mouseMoved(MouseEvent evt) {
            Point2D insert = this.getInsertPoint(evt);
            double x = insert.getX();
            double y = insert.getY();
            double width = (this.ai.getWidth() - this.ai.getProto().getWidthOffset()) / 2.0;
            Highlighter highlighter = this.wnd.getHighlighter();
            highlighter.clear();
            highlighter.addLine(new Point2D.Double(x - width, y - width), new Point2D.Double(x - width, y + width), this.ai.getParent());
            highlighter.addLine(new Point2D.Double(x - width, y + width), new Point2D.Double(x + width, y + width), this.ai.getParent());
            highlighter.addLine(new Point2D.Double(x + width, y + width), new Point2D.Double(x + width, y - width), this.ai.getParent());
            highlighter.addLine(new Point2D.Double(x + width, y - width), new Point2D.Double(x - width, y - width), this.ai.getParent());
            highlighter.finished();
            this.wnd.repaint();
        }

        private Point2D getInsertPoint(MouseEvent evt) {
            Point2D mouseDB = this.wnd.screenToDatabase(evt.getX(), evt.getY());
            EditWindow.gridAlign(mouseDB);
            Point2D insert = DBMath.closestPointToSegment(this.ai.getHeadLocation(), this.ai.getTailLocation(), mouseDB);
            return insert;
        }

        public void mouseWheelMoved(MouseWheelEvent e) {
        }

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
        }

        public void keyTyped(KeyEvent e) {
        }

        private static class InsertJogPoint
        extends Job {
            private ArcInst ai;
            private Point2D insert;
            private Highlighter highlighter;

            protected InsertJogPoint(ArcInst ai, Point2D insert, Highlighter highlighter) {
                super("Insert Jog in Arc", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
                this.ai = ai;
                this.insert = insert;
                this.highlighter = highlighter;
                this.startJob();
            }

            public boolean doIt() {
                if (CircuitChanges.cantEdit(this.ai.getParent(), null, true) != 0) {
                    return false;
                }
                ArcProto ap = this.ai.getProto();
                PrimitiveNode np = ap.findPinProto();
                if (np == null) {
                    return false;
                }
                NodeInst ni = NodeInst.makeInstance(np, this.insert, np.getDefWidth(), np.getDefHeight(), this.ai.getParent());
                if (ni == null) {
                    System.out.println("Cannot create pin " + np.describe(true));
                    return false;
                }
                NodeInst ni2 = NodeInst.makeInstance(np, this.insert, np.getDefWidth(), np.getDefHeight(), this.ai.getParent());
                if (ni2 == null) {
                    System.out.println("Cannot create pin " + np.describe(true));
                    return false;
                }
                PortInst pi = ni.getOnlyPortInst();
                PortInst pi2 = ni2.getOnlyPortInst();
                PortInst headPort = this.ai.getHeadPortInst();
                PortInst tailPort = this.ai.getTailPortInst();
                EPoint headPt = this.ai.getHeadLocation();
                EPoint tailPt = this.ai.getTailLocation();
                double width = this.ai.getWidth();
                boolean headNegated = this.ai.isHeadNegated();
                boolean tailNegated = this.ai.isTailNegated();
                String arcName = this.ai.getName();
                int angle = (this.ai.getAngle() + 900) % 3600;
                ArcInst newAi1 = ArcInst.makeInstance(ap, width, headPort, pi, headPt, this.insert, null);
                if (headNegated) {
                    newAi1.setHeadNegated(true);
                }
                ArcInst newAi2 = ArcInst.makeInstance(ap, width, pi, pi2, this.insert, this.insert, null);
                ArcInst newAi3 = ArcInst.makeInstance(ap, width, pi2, tailPort, this.insert, tailPt, null);
                if (tailNegated) {
                    newAi3.setTailNegated(true);
                }
                newAi1.copyTextDescriptorFrom(this.ai, ArcInst.ARC_NAME_TD);
                newAi3.copyTextDescriptorFrom(this.ai, ArcInst.ARC_NAME_TD);
                newAi1.setHeadNegated(this.ai.isHeadNegated());
                newAi3.setTailNegated(this.ai.isTailNegated());
                this.ai.kill();
                if (arcName != null) {
                    if (headPt.distance(this.insert) > tailPt.distance(this.insert)) {
                        newAi1.setName(arcName);
                    } else {
                        newAi3.setName(arcName);
                    }
                }
                newAi2.setAngle(angle);
                this.highlighter.clear();
                this.highlighter.addElectricObject(ni, this.ai.getParent());
                this.highlighter.finished();
                return true;
            }
        }
    }

    private static class SetEasyHardSelect
    extends Job {
        private boolean easy;
        private List highlighted;

        private SetEasyHardSelect(boolean easy, List highlighted) {
            super("Make Selected Objects Easy/Hard To Select", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.easy = easy;
            this.highlighted = highlighted;
            this.startJob();
        }

        public boolean doIt() {
            Iterator it = this.highlighted.iterator();
            while (it.hasNext()) {
                Geometric geom = (Geometric)it.next();
                if (geom instanceof NodeInst) {
                    NodeInst ni = (NodeInst)geom;
                    if (this.easy) {
                        ni.clearHardSelect();
                        continue;
                    }
                    ni.setHardSelect();
                    continue;
                }
                ArcInst ai = (ArcInst)geom;
                if (this.easy) {
                    ai.setHardSelect(false);
                    continue;
                }
                ai.setHardSelect(true);
            }
            return true;
        }
    }

    private static class UpdateAttributes
    extends Job {
        private List highlighted;
        private boolean allLibraries;
        private int whatToUpdate;

        UpdateAttributes(List highlighted, boolean allLibraries, int whatToUpdate) {
            super("Update Inheritance", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.highlighted = highlighted;
            this.allLibraries = allLibraries;
            this.whatToUpdate = whatToUpdate;
            this.startJob();
        }

        public boolean doIt() {
            int count = 0;
            if (this.allLibraries) {
                Iterator it = Library.getLibraries();
                while (it.hasNext()) {
                    Library lib = (Library)it.next();
                    Iterator it2 = lib.getCells();
                    while (it2.hasNext()) {
                        Cell c = (Cell)it2.next();
                        Iterator it3 = c.getNodes();
                        while (it3.hasNext()) {
                            NodeInst ni = (NodeInst)it3.next();
                            if (!(ni.getProto() instanceof Cell)) continue;
                            if (this.whatToUpdate == 0) {
                                this.updateInheritance(ni, (Cell)ni.getProto());
                                ++count;
                            }
                            if (this.whatToUpdate != 1) continue;
                            this.updateLocations(ni, (Cell)ni.getProto());
                            ++count;
                        }
                    }
                }
            } else {
                Iterator it = this.highlighted.iterator();
                while (it.hasNext()) {
                    NodeInst ni;
                    ElectricObject eobj = (ElectricObject)it.next();
                    if (!(eobj instanceof NodeInst) || !((ni = (NodeInst)eobj).getProto() instanceof Cell)) continue;
                    if (this.whatToUpdate == 0) {
                        this.updateInheritance(ni, (Cell)ni.getProto());
                        ++count;
                    }
                    if (this.whatToUpdate != 1) continue;
                    this.updateLocations(ni, (Cell)ni.getProto());
                    ++count;
                }
            }
            if (this.whatToUpdate == 0) {
                System.out.println("Updated Attribute Inheritance on " + count + " nodes");
            }
            if (this.whatToUpdate == 1) {
                System.out.println("Updated Attribute Locations on " + count + " nodes");
            }
            return true;
        }

        private void updateInheritance(NodeInst ni, Cell proto) {
            CircuitChanges.inheritAttributes(ni, true);
        }

        private void updateLocations(NodeInst ni, Cell proto) {
        }
    }

    private static class ParameterVisibility
    extends Job {
        private int how;
        private List selected;

        protected ParameterVisibility(int how, List selected) {
            super("Change Parameter Visibility", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.how = how;
            this.selected = selected;
            this.startJob();
        }

        public boolean doIt() {
            int changeCount = 0;
            List list = this.selected;
            Iterator it = list.iterator();
            while (it.hasNext()) {
                NodeInst ni = (NodeInst)it.next();
                if (!(ni.getProto() instanceof Cell)) continue;
                boolean changed = false;
                Iterator vIt = ni.getVariables();
                while (vIt.hasNext()) {
                    Variable var = (Variable)vIt.next();
                    Variable nVar = EditMenu.findParameterSource(var, ni);
                    if (nVar == null) continue;
                    switch (this.how) {
                        case 0: {
                            if (var.isDisplay()) break;
                            var.setDisplay(true);
                            changed = true;
                            break;
                        }
                        case 1: {
                            if (!var.isDisplay()) break;
                            var.setDisplay(false);
                            changed = true;
                            break;
                        }
                        case 2: {
                            if (nVar.getTextDescriptor().isInterior()) {
                                if (!var.isDisplay()) break;
                                var.setDisplay(false);
                                changed = true;
                                break;
                            }
                            if (var.isDisplay()) break;
                            var.setDisplay(true);
                            changed = true;
                        }
                    }
                }
                if (!changed) continue;
                Undo.redrawObject(ni);
                ++changeCount;
            }
            if (changeCount == 0) {
                System.out.println("No Parameter visibility changed");
            } else {
                System.out.println("Changed visibility on " + changeCount + " nodes");
            }
            return true;
        }
    }

    private static class RedoCommand
    extends Job {
        private RedoCommand() {
            super("Redo", User.getUserTool(), Job.Type.UNDO, Undo.upCell(true), null, Job.Priority.USER);
            this.startJob();
        }

        public boolean doIt() {
            if (!Undo.redoABatch()) {
                System.out.println("Redo failed!");
            }
            return true;
        }
    }

    private static class UndoCommand
    extends Job {
        private UndoCommand() {
            super("Undo", User.getUserTool(), Job.Type.UNDO, Undo.upCell(false), null, Job.Priority.USER);
            this.startJob();
        }

        public boolean doIt() {
            if (Undo.undoABatch() == null) {
                System.out.println("Undo failed!");
            }
            return true;
        }
    }
}

